"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isError = exports.inherit = exports.assertError = void 0;
function assertError(err) {
    if (!isError(err)) {
        throw new Error("Parameter was not an error");
    }
}
exports.assertError = assertError;
function inherit(ctor, superCtor) {
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
            value: ctor,
            enumerable: false,
            writable: true,
            configurable: true
        }
    });
}
exports.inherit = inherit;
function isError(err) {
    return objectToString(err) === "[object Error]" || err instanceof Error;
}
exports.isError = isError;
function objectToString(obj) {
    return Object.prototype.toString.call(obj);
}
