// Generated by gmmproc 2.74.0 -- DO NOT MODIFY!
#ifndef _GTKMM_URILAUNCHER_H
#define _GTKMM_URILAUNCHER_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>
#include <gtk/gtk.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API UriLauncher_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class Window;

 /** A %Gtk::UriLauncher object collects the arguments that are needed to open
  * a uri with an application.
 *
 * Depending on system configuration, user preferences and available APIs, this
 * may or may not show an app chooser dialog or launch the default application
 * right away.
 *
 * The operation is started with the launch() method. This API follows the GIO
 * async pattern, and the result can be obtained by calling launch_finish().
 *
 * To launch a file, use Gtk::FileLauncher.
 *
 * @newin{4,10}
 */

class GTKMM_API UriLauncher : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = UriLauncher;
  using CppClassType = UriLauncher_Class;
  using BaseObjectType = GtkUriLauncher;
  using BaseClassType = GtkUriLauncherClass;

  // noncopyable
  UriLauncher(const UriLauncher&) = delete;
  UriLauncher& operator=(const UriLauncher&) = delete;

private:  friend class UriLauncher_Class;
  static CppClassType urilauncher_class_;

protected:
  explicit UriLauncher(const Glib::ConstructParams& construct_params);
  explicit UriLauncher(GtkUriLauncher* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  UriLauncher(UriLauncher&& src) noexcept;
  UriLauncher& operator=(UriLauncher&& src) noexcept;

  ~UriLauncher() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkUriLauncher*       gobj()       { return reinterpret_cast<GtkUriLauncher*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkUriLauncher* gobj() const { return reinterpret_cast<GtkUriLauncher*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkUriLauncher* gobj_copy();

private:

     
protected:
  explicit UriLauncher(const Glib::ustring& uri);

public:
  /** Creates a new %Gtk::UriLauncher object.
   *
   * @newin{4,10}
   *
   * @param uri The uri to open, or an empty string to specify the uri later
   *            with set_uri().
   * @return The new %Gtk::UriLauncher.
   */
  
  static Glib::RefPtr<UriLauncher> create(const Glib::ustring& uri =  {});


  /** Gets the uri that will be opened.
   * 
   * @newin{4,10}
   * 
   * @return The uri.
   */
  Glib::ustring get_uri() const;
  
  /** Sets the uri that will be opened.
   * 
   * @newin{4,10}
   * 
   * @param uri The uri.
   */
  void set_uri(const Glib::ustring& uri);

  
  /** Launch an application to open the uri.
   * 
   * This may present an app chooser dialog to the user.
   * 
   * The @a slot will be called when the operation is completed.
   * It should call launch_finish() to obtain
   * the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void launch(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A launch() convenience overload.
  void launch(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;
  
  /** Finishes the launch() call and
   * returns the result.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return <tt>true</tt> if an application was launched,
   * or <tt>false</tt> and @a error is set.
   * 
   * @throws Gtk::DialogError
   * @throws Gio::Error
   */
  bool launch_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;

  /** The uri to launch.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_uri() ;

/** The uri to launch.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_uri() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::UriLauncher
   */
  GTKMM_API
  Glib::RefPtr<Gtk::UriLauncher> wrap(GtkUriLauncher* object, bool take_copy = false);
}


#endif /* _GTKMM_URILAUNCHER_H */

