/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Initial implementation, based on code taken and modified
 *     					   from org.eclipse.cdt.dsf.gdb.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.launching;

import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CMainTab;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.swt.widgets.Composite;

@SuppressWarnings({ "restriction", "deprecation" })
public class IssAttachCRunLaunchConfigurationTabGroup extends AbstractLaunchConfigurationTabGroup
{
	/*@Override*/ public void createTabs(ILaunchConfigurationDialog dialog, String mode)  {

		ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[] {
				new CMainTab() {
					@Override protected void createExeFileGroup(Composite parent, int colSpan) {
						super.createExeFileGroup(parent, colSpan);
					}
				},
				new AttachAppCDebuggerTab(SessionType.LOCAL, false),
				new SourceLookupTab(),
				new CommonTab() 
		};
		setTabs(tabs);
	}
}
