/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Intel Corporation - Initial implementation, based on code taken and modified
 *     					   from org.eclipse.cdt.dsf.gdb.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.ui.launching;

import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CDebuggerTab;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

@SuppressWarnings("restriction")
public class LocalAppCDebuggerTab extends CDebuggerTab {
	public static final String TAB_ID = "org.eclipse.cdt.dsf.iss.ui.localApplicationLaunch.debuggerTab"; //$NON-NLS-1$


	public LocalAppCDebuggerTab(SessionType sessionType, Boolean attach) {
		super(sessionType, attach);
	}

	@Override protected void loadDynamicDebugArea() {
		Composite dynamicTabHolder = getDynamicTabHolder();
		// Dispose of any current child widgets in the tab holder area
		Control[] children = dynamicTabHolder.getChildren();
		for (int i = 0; i < children.length; i++) {
			children[i].dispose();
		}
		String debuggerId = getIdForCurrentDebugger();

		setDynamicTab(new IssGdbDebuggerPage());

		setDebuggerId(debuggerId);

		ICDebuggerPage debuggerPage = getDynamicTab();
		if (debuggerPage == null) {
			return;
		}
		// Ask the dynamic UI to create its Control
		debuggerPage.setLaunchConfigurationDialog(getLaunchConfigurationDialog());
		debuggerPage.createControl(dynamicTabHolder);
		debuggerPage.getControl().setVisible(true);
		dynamicTabHolder.layout(true);
		contentsChanged();
	}

	@Override
	public String getId() {
		return TAB_ID;
	}
}
