/*******************************************************************************
 * Copyright (c) 2016 - 2020 Intel Corporation and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Michael Sturm (Intel Corporation) - initial implementation.
 *******************************************************************************/
package org.eclipse.cdt.dsf.iss.mi.service.command;

import org.eclipse.cdt.dsf.gdb.service.extensions.GDBControl_HEAD;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;

public class IssGDBControl extends GDBControl_HEAD implements IIssMICommandControl {

	private IssCommandFactory fCommandFactory;

	public IssGDBControl(DsfSession session, ILaunchConfiguration config, IssCommandFactory factory) {
		super(session, config, factory);

		fCommandFactory = factory;
	}

	@Override
	public IssCommandFactory getCommandFactory() {
		return fCommandFactory;
	}
}
