!===============================================================================
! Copyright 2020-2022 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!*
!
!*  Content:
!*            Arg example program text (OpenMP offload interface)
!*
!*******************************************************************************/

include "mkl_omp_offload.f90"
include "_vml_common_functions.f90"

! @brief Complex single precision function test begin
integer (kind=4) function test_float_complex(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=4)  :: as_float
    integer   (kind=4)  :: check_result_float_complex
    complex   (kind=4),allocatable :: varg1(:)
    real      (kind=4),allocatable :: vres1(:), vmres1(:), vref1(:)
    real      (kind=4),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    complex   (kind=4) cres1, cmres1, cref1
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN
    parameter (VLEN = 4)
    integer   (kind=4) test_arg1(2*VLEN)
    integer   (kind=4) test_ref1(VLEN)
    integer   (kind=4) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFF'/
    
    ! Arguments and reference results begin
    data test_arg1 / Z'C007309A', Z'40D9B85C', & ! -2.1123414      + i * 6.80375481     
                     Z'40BF006A', Z'40B52EFA', & ! 5.96880054      + i * 5.66198444     
                     Z'C0C1912F', Z'4103BA28', & ! -6.04897261     + i * 8.2329483      
                     Z'40ABAABC', Z'C052EA36'  / ! 5.3645916       + i * -3.2955451     
    data test_ref1 / Z'3FEF9810', & ! 1.87182808     
                     Z'3F424F70', & ! 0.75902462     
                     Z'400D15BA', & ! 2.20445108     
                     Z'BF0D065C'  / ! -0.550878286   
    ! Arguments and reference results end
    
    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = CMPLX(as_float(test_arg1(2*i-1)), as_float(test_arg1(2*i)), 4)
        vref1(i) = as_float(test_ref1(i))
        vres1(i) = as_float(nan_value)
        vmres1(i) = as_float(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = as_float(test_ref1(i))
            vresi1(i)  = 999
            vmresi1(i) = 999
        else
            vrefi1(i)  = 777
            vresi1(i)  = 777
            vmresi1(i) = 777
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp target variant dispatch
        tmode = vmlsetmode(vml_accuracy_mode(a))
        !$omp end target variant dispatch

        !$omp target data map(varg1,vres1)
        !$omp target variant dispatch use_device_ptr(varg1,vres1)
        call vcarg(VLEN, varg1, vres1)
        !$omp end target variant dispatch
        !$omp end target data
		
        !$omp target data map(varg1,vmres1)
        !$omp target variant dispatch use_device_ptr(varg1,vmres1)
        call vmcarg(VLEN, varg1, vmres1, vml_accuracy_mode(a))
        !$omp end target variant dispatch
        !$omp end target data

        !$omp target data map(varg1,vresi1)
        !$omp target variant dispatch use_device_ptr(varg1,vresi1)
        call vcargi(VLEN/2, varg1, 2, vresi1, 2)
        !$omp end target variant dispatch
        !$omp end target data
		
        !$omp target data map(varg1,vmresi1)
        !$omp target variant dispatch use_device_ptr(varg1,vmresi1)
        call vmcargi(VLEN/2, varg1, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target variant dispatch
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          cres1  = CMPLX(vres1(i),  0.0, 4)
          cmres1 = CMPLX(vmres1(i), 0.0, 4)
          cref1  = CMPLX(vref1(i),  0.0, 4)
          errs   = errs + check_result_float_complex(i, VML_ARG1C_RES1R, varg1(i), varg1(i), & 
                           cres1, cres1, cref1, cref1, "v"//funcname, a, ",  simple")
          errs   = errs + check_result_float_complex(i, VML_ARG1C_RES1R, varg1(i), varg1(i), & 
                           cmres1, cmres1, cref1, cref1, "vm"//funcname, a, ",  simple")
          cres1  = CMPLX(vresi1(i),  0.0, 4)
          cmres1 = CMPLX(vmresi1(i), 0.0, 4)
          cref1  = CMPLX(vrefi1(i),  0.0, 4)
          errs   = errs + check_result_float_complex(i, VML_ARG1C_RES1R, varg1(i), varg1(i), & 
                           cres1, cres1, cref1, cref1, "v"//funcname//"i", a, ", strided")
          errs   = errs + check_result_float_complex(i, VML_ARG1C_RES1R, varg1(i), varg1(i), & 
                           cmres1, cmres1, cref1, cref1, "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_float_complex = errs

end function
! @brief Complex single precision function test end

! @brief Complex double precision function test begin
integer (kind=4) function test_double_complex(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=8) :: as_double
    integer   (kind=4) :: check_result_double_complex
    complex   (kind=8),allocatable :: varg1(:)
    real      (kind=8),allocatable :: vres1(:), vmres1(:), vref1(:)
    real      (kind=8),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    complex   (kind=8) cres1, cmres1, cref1
    integer   (kind=4) i, a, errs
    integer   (kind=8) VLEN
    parameter (VLEN = 4)
    integer   (kind=8) test_arg1(2*VLEN)
    integer   (kind=8) test_ref1(VLEN)
    integer   (kind=8) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFFFFFFFFFF'/
    
    ! Arguments and reference results begin
    data test_arg1 / Z'C000E6134801CC26', Z'401B370B60E66E18', & ! -2.11234146361813924      + i * 6.80375434309419092      
                     Z'4017E00D485FC01A', Z'4016A5DF421D4BBE', & ! 5.96880066952146571       + i * 5.66198447517211711      
                     Z'C0183225E080644C', Z'40207744D998EE8A', & ! -6.04897261413232101      + i * 8.23294715873568705      
                     Z'4015755793FAEAB0', Z'C00A5D46A314BA8E'  / ! 5.36459189623808186       + i * -3.2955448857022196      
    data test_ref1 / Z'3FFDF301F34F7D84', & ! 1.87182803195159497      
                     Z'3FE849EDFE3CD242', & ! 0.759024616773395389     
                     Z'4001A2B74AD9EB88', & ! 2.20445116498507687      
                     Z'BFE1A0CB535C972B'  / ! -0.550878203216347173    
    ! Arguments and reference results end
    
    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = CMPLX(as_double(test_arg1(2*i-1)), as_double(test_arg1(2*i)), 8)
        vref1(i) = as_double(test_ref1(i))
        vres1(i) = as_double(nan_value)
        vmres1(i) = as_double(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = as_double(test_ref1(i))
            vresi1(i)  = 999
            vmresi1(i) = 999
        else
            vrefi1(i)  = 777
            vresi1(i)  = 777
            vmresi1(i) = 777
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp target variant dispatch
        tmode = vmlsetmode(vml_accuracy_mode(a))
        !$omp end target variant dispatch

        !$omp target data map(varg1,vres1)
        !$omp target variant dispatch use_device_ptr(varg1,vres1)
        call vzarg(VLEN, varg1, vres1)
        !$omp end target variant dispatch
        !$omp end target data
		
        !$omp target data map(varg1,vmres1)
        !$omp target variant dispatch use_device_ptr(varg1,vmres1)
        call vmzarg(VLEN, varg1, vmres1, vml_accuracy_mode(a))
        !$omp end target variant dispatch
        !$omp end target data

        !$omp target data map(varg1,vresi1)
        !$omp target variant dispatch use_device_ptr(varg1,vresi1)
        call vzargi(VLEN/2, varg1, 2, vresi1, 2)
        !$omp end target variant dispatch
        !$omp end target data
		
        !$omp target data map(varg1,vmresi1)
        !$omp target variant dispatch use_device_ptr(varg1,vmresi1)
        call vmzargi(VLEN/2, varg1, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target variant dispatch
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          cres1  = CMPLX(vres1(i),  0D0, 8)
          cmres1 = CMPLX(vmres1(i), 0D0, 8)
          cref1  = CMPLX(vref1(i),  0D0, 8)
          errs   = errs + check_result_double_complex(i, VML_ARG1C_RES1R, varg1(i), varg1(i), & 
                            cres1, cres1, cref1, cref1, "v"//funcname, a, ",  simple")
          errs   = errs + check_result_double_complex(i, VML_ARG1C_RES1R, varg1(i), varg1(i), & 
                            cmres1, cmres1, cref1, cref1, "vm"//funcname//"i", a, ",  simple")
          cres1  = CMPLX(vresi1(i),  0D0, 8)
          cmres1 = CMPLX(vmresi1(i), 0D0, 8)
          cref1  = CMPLX(vrefi1(i),  0D0, 8)
          errs   = errs + check_result_double_complex(i, VML_ARG1C_RES1R, varg1(i), varg1(i), & 
                            cres1, cres1, cref1, cref1, "v"//funcname, a, ", strided")
          errs   = errs + check_result_double_complex(i, VML_ARG1C_RES1R, varg1(i), varg1(i), & 
                            cmres1, cmres1, cref1, cref1, "vm"//funcname//"i", a, ", strided")
        enddo
    enddo
    
    test_double_complex = errs

end function
! @brief Complex double precision function test end

! @brief Main test program begin
program arg_example

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    integer   (kind=4) :: blend_int32
    integer   (kind=4) :: test_float_complex
    integer   (kind=4) :: test_double_complex
    integer   (kind=4) errs, total_errs
    character (len = *), parameter :: funcname = "arg"
    
    total_errs = 0

    data FLOAT_MAXULP /FLOAT_MAXULP_HA,FLOAT_MAXULP_LA,FLOAT_MAXULP_EP/
    data COMPLEX_FLOAT_MAXULP /FLOAT_COMPLEX_MAXULP_HA,FLOAT_COMPLEX_MAXULP_LA,FLOAT_COMPLEX_MAXULP_EP/
    data DOUBLE_MAXULP /DOUBLE_MAXULP_HA,DOUBLE_MAXULP_LA,DOUBLE_MAXULP_EP/
    data COMPLEX_DOUBLE_MAXULP /DOUBLE_COMPLEX_MAXULP_HA,DOUBLE_COMPLEX_MAXULP_LA,DOUBLE_COMPLEX_MAXULP_EP/

    write (*, 111) funcname
    111 format ('Running ', A, ' functions:')

    ! Single precision complex test run begin
    write (*, 115) TAB, funcname
    115 format(A, 'Running ',  A, ' with single precision complex data type:')
    errs = test_float_complex(funcname)    
    total_errs = total_errs + errs
    write (*, 116) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    116 format(A, A, ' single precision complex result: ', A)
    ! Single precision complex test run end

    ! Complex double precision test run begin
    write (*, 119) TAB, funcname
    119 format(A, 'Running ',  A, ' with double precision complex data type:')
    errs = test_double_complex(funcname)    
    total_errs = total_errs + errs
    write (*, 120) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    120 format(A, A, ' double precision complex result: ', A)
    ! Complex double precision  test run end

    write (*, 121) funcname, TEST_RESULT(blend_int32((total_errs>0),2,1))
    121 format(A, ' function result: ', A)

end program
! @brief Main test program end
