!===============================================================================
! Copyright 2005-2022 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!  Content:
!       Intel(R) oneMKL LAPACK77 interface as prototypes for
!       Intel(R) oneMKL LAPACK95 interfaces
!
!*******************************************************************************


MODULE F77_LAPACK

INTERFACE F77_ILAENV
  PURE INTEGER FUNCTION ILAENV(ISPEC,NAME,OPTS,N1,N2,N3,N4)
    INTEGER, INTENT(IN) :: ISPEC
    CHARACTER(LEN=1), INTENT(IN) :: NAME
    CHARACTER(LEN=1), INTENT(IN) :: OPTS
    INTEGER, INTENT(IN) :: N1
    INTEGER, INTENT(IN) :: N2
    INTEGER, INTENT(IN) :: N3
    INTEGER, INTENT(IN) :: N4
  END FUNCTION ILAENV
END INTERFACE F77_ILAENV

INTERFACE F77_XERBLA
  PURE SUBROUTINE XERBLA(NAME,INFO)
    CHARACTER(LEN=*), INTENT(IN) :: NAME
    INTEGER, INTENT(IN) :: INFO
  END SUBROUTINE XERBLA
END INTERFACE F77_XERBLA

INTERFACE F77_GETRF
  PURE SUBROUTINE SGETRF(M,N,A,LDA,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SGETRF
  PURE SUBROUTINE DGETRF(M,N,A,LDA,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DGETRF
  PURE SUBROUTINE CGETRF(M,N,A,LDA,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CGETRF
  PURE SUBROUTINE ZGETRF(M,N,A,LDA,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZGETRF
END INTERFACE F77_GETRF

INTERFACE F77_MKL_GETRFNPI
  PURE SUBROUTINE MKL_SGETRFNPI(M,N,NFACT,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NFACT
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE MKL_SGETRFNPI
  PURE SUBROUTINE MKL_DGETRFNPI(M,N,NFACT,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NFACT
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE MKL_DGETRFNPI
  PURE SUBROUTINE MKL_CGETRFNPI(M,N,NFACT,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NFACT
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE MKL_CGETRFNPI
  PURE SUBROUTINE MKL_ZGETRFNPI(M,N,NFACT,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NFACT
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE MKL_ZGETRFNPI
END INTERFACE F77_MKL_GETRFNPI

INTERFACE F77_GBTRF
  PURE SUBROUTINE SGBTRF(M,N,KL,KU,AB,LDAB,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE SGBTRF
  PURE SUBROUTINE DGBTRF(M,N,KL,KU,AB,LDAB,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE DGBTRF
  PURE SUBROUTINE CGBTRF(M,N,KL,KU,AB,LDAB,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE CGBTRF
  PURE SUBROUTINE ZGBTRF(M,N,KL,KU,AB,LDAB,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE ZGBTRF
END INTERFACE F77_GBTRF

INTERFACE F77_MKL_TPPACK
  PURE SUBROUTINE MKL_STPPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(OUT) :: AP(LDA,*)
    INTEGER, INTENT(IN) :: I
    INTEGER, INTENT(IN) :: J
    INTEGER, INTENT(IN) :: ROWS
    INTEGER, INTENT(IN) :: COLS
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(OUT) :: INFO
  END SUBROUTINE MKL_STPPACK
  PURE SUBROUTINE MKL_DTPPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(OUT) :: AP(LDA,*)
    INTEGER, INTENT(IN) :: I
    INTEGER, INTENT(IN) :: J
    INTEGER, INTENT(IN) :: ROWS
    INTEGER, INTENT(IN) :: COLS
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(OUT) :: INFO
  END SUBROUTINE MKL_DTPPACK
  PURE SUBROUTINE MKL_CTPPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(OUT) :: AP(LDA,*)
    INTEGER, INTENT(IN) :: I
    INTEGER, INTENT(IN) :: J
    INTEGER, INTENT(IN) :: ROWS
    INTEGER, INTENT(IN) :: COLS
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(OUT) :: INFO
  END SUBROUTINE MKL_CTPPACK
  PURE SUBROUTINE MKL_ZTPPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(OUT) :: AP(LDA,*)
    INTEGER, INTENT(IN) :: I
    INTEGER, INTENT(IN) :: J
    INTEGER, INTENT(IN) :: ROWS
    INTEGER, INTENT(IN) :: COLS
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(OUT) :: INFO
  END SUBROUTINE MKL_ZTPPACK
END INTERFACE F77_MKL_TPPACK

INTERFACE F77_MKL_TPUNPACK
  PURE SUBROUTINE MKL_STPUNPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: AP(LDA,*)
    INTEGER, INTENT(IN) :: I
    INTEGER, INTENT(IN) :: J
    INTEGER, INTENT(IN) :: ROWS
    INTEGER, INTENT(IN) :: COLS
    REAL(WP), INTENT(OUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(OUT) :: INFO
  END SUBROUTINE MKL_STPUNPACK
  PURE SUBROUTINE MKL_DTPUNPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: AP(LDA,*)
    INTEGER, INTENT(IN) :: I
    INTEGER, INTENT(IN) :: J
    INTEGER, INTENT(IN) :: ROWS
    INTEGER, INTENT(IN) :: COLS
    REAL(WP), INTENT(OUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(OUT) :: INFO
  END SUBROUTINE MKL_DTPUNPACK
  PURE SUBROUTINE MKL_CTPUNPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: AP(LDA,*)
    INTEGER, INTENT(IN) :: I
    INTEGER, INTENT(IN) :: J
    INTEGER, INTENT(IN) :: ROWS
    INTEGER, INTENT(IN) :: COLS
    COMPLEX(WP), INTENT(OUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(OUT) :: INFO
  END SUBROUTINE MKL_CTPUNPACK
  PURE SUBROUTINE MKL_ZTPUNPACK(UPLO,TRANS,N,AP,I,J,ROWS,COLS,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: AP(LDA,*)
    INTEGER, INTENT(IN) :: I
    INTEGER, INTENT(IN) :: J
    INTEGER, INTENT(IN) :: ROWS
    INTEGER, INTENT(IN) :: COLS
    COMPLEX(WP), INTENT(OUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(OUT) :: INFO
  END SUBROUTINE MKL_ZTPUNPACK
END INTERFACE F77_MKL_TPUNPACK

INTERFACE F77_GTTRF
  PURE SUBROUTINE SGTTRF(N,DL,D,DU,DU2,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: DU(*)
    REAL(WP), INTENT(OUT) :: DU2(*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SGTTRF
  PURE SUBROUTINE DGTTRF(N,DL,D,DU,DU2,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: DU(*)
    REAL(WP), INTENT(OUT) :: DU2(*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DGTTRF
  PURE SUBROUTINE CGTTRF(N,DL,D,DU,DU2,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: DU(*)
    COMPLEX(WP), INTENT(OUT) :: DU2(*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CGTTRF
  PURE SUBROUTINE ZGTTRF(N,DL,D,DU,DU2,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: DU(*)
    COMPLEX(WP), INTENT(OUT) :: DU2(*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZGTTRF
END INTERFACE F77_GTTRF

INTERFACE F77_DTTRFB
  PURE SUBROUTINE SDTTRFB(N,DL,D,DU,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SDTTRFB
  PURE SUBROUTINE DDTTRFB(N,DL,D,DU,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DDTTRFB
  PURE SUBROUTINE CDTTRFB(N,DL,D,DU,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CDTTRFB
  PURE SUBROUTINE ZDTTRFB(N,DL,D,DU,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZDTTRFB
END INTERFACE F77_DTTRFB

INTERFACE F77_POTRF
  PURE SUBROUTINE SPOTRF(UPLO,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SPOTRF
  PURE SUBROUTINE DPOTRF(UPLO,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DPOTRF
  PURE SUBROUTINE CPOTRF(UPLO,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CPOTRF
  PURE SUBROUTINE ZPOTRF(UPLO,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZPOTRF
END INTERFACE F77_POTRF

INTERFACE F77_PPTRF
  PURE SUBROUTINE SPPTRF(UPLO,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SPPTRF
  PURE SUBROUTINE DPPTRF(UPLO,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DPPTRF
  PURE SUBROUTINE CPPTRF(UPLO,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CPPTRF
  PURE SUBROUTINE ZPPTRF(UPLO,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZPPTRF
END INTERFACE F77_PPTRF

INTERFACE F77_PBTRF
  PURE SUBROUTINE SPBTRF(UPLO,N,KD,AB,LDAB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE SPBTRF
  PURE SUBROUTINE DPBTRF(UPLO,N,KD,AB,LDAB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE DPBTRF
  PURE SUBROUTINE CPBTRF(UPLO,N,KD,AB,LDAB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE CPBTRF
  PURE SUBROUTINE ZPBTRF(UPLO,N,KD,AB,LDAB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE ZPBTRF
END INTERFACE F77_PBTRF

INTERFACE F77_PTTRF
  PURE SUBROUTINE SPTTRF(N,D,E,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SPTTRF
  PURE SUBROUTINE DPTTRF(N,D,E,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DPTTRF
  PURE SUBROUTINE CPTTRF(N,D,E,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: E(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CPTTRF
  PURE SUBROUTINE ZPTTRF(N,D,E,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: E(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZPTTRF
END INTERFACE F77_PTTRF

INTERFACE F77_SYTRF
  PURE SUBROUTINE SSYTRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SSYTRF
  PURE SUBROUTINE DSYTRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DSYTRF
  PURE SUBROUTINE CSYTRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CSYTRF
  PURE SUBROUTINE ZSYTRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZSYTRF
END INTERFACE F77_SYTRF

INTERFACE F77_SYTRF_ROOK
  PURE SUBROUTINE SSYTRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SSYTRF_ROOK
  PURE SUBROUTINE DSYTRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DSYTRF_ROOK
  PURE SUBROUTINE CSYTRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CSYTRF_ROOK
  PURE SUBROUTINE ZSYTRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZSYTRF_ROOK
END INTERFACE F77_SYTRF_ROOK

INTERFACE F77_HETRF
  PURE SUBROUTINE CHETRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CHETRF
  PURE SUBROUTINE ZHETRF(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZHETRF
END INTERFACE F77_HETRF

INTERFACE F77_HETRF_ROOK
  PURE SUBROUTINE CHETRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CHETRF_ROOK
  PURE SUBROUTINE ZHETRF_ROOK(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZHETRF_ROOK
END INTERFACE F77_HETRF_ROOK

INTERFACE F77_SPTRF
  PURE SUBROUTINE SSPTRF(UPLO,N,AP,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SSPTRF
  PURE SUBROUTINE DSPTRF(UPLO,N,AP,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DSPTRF
  PURE SUBROUTINE CSPTRF(UPLO,N,AP,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CSPTRF
  PURE SUBROUTINE ZSPTRF(UPLO,N,AP,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZSPTRF
END INTERFACE F77_SPTRF

INTERFACE F77_HPTRF
  PURE SUBROUTINE CHPTRF(UPLO,N,AP,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CHPTRF
  PURE SUBROUTINE ZHPTRF(UPLO,N,AP,IPIV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZHPTRF
END INTERFACE F77_HPTRF

INTERFACE F77_GETRS
  PURE SUBROUTINE SGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGETRS
  PURE SUBROUTINE DGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGETRS
  PURE SUBROUTINE CGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGETRS
  PURE SUBROUTINE ZGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGETRS
END INTERFACE F77_GETRS

INTERFACE F77_GBTRS
  PURE SUBROUTINE SGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGBTRS
  PURE SUBROUTINE DGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGBTRS
  PURE SUBROUTINE CGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGBTRS
  PURE SUBROUTINE ZGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGBTRS
END INTERFACE F77_GBTRS

INTERFACE F77_GTTRS
  PURE SUBROUTINE SGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGTTRS
  PURE SUBROUTINE DGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGTTRS
  PURE SUBROUTINE CGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGTTRS
  PURE SUBROUTINE ZGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGTTRS
END INTERFACE F77_GTTRS

INTERFACE F77_DTTRSB
  PURE SUBROUTINE SDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SDTTRSB
  PURE SUBROUTINE DDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DDTTRSB
  PURE SUBROUTINE CDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CDTTRSB
  PURE SUBROUTINE ZDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZDTTRSB
END INTERFACE F77_DTTRSB

INTERFACE F77_POTRS
  PURE SUBROUTINE SPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPOTRS
  PURE SUBROUTINE DPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPOTRS
  PURE SUBROUTINE CPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPOTRS
  PURE SUBROUTINE ZPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPOTRS
END INTERFACE F77_POTRS

INTERFACE F77_PPTRS
  PURE SUBROUTINE SPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPPTRS
  PURE SUBROUTINE DPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPPTRS
  PURE SUBROUTINE CPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPPTRS
  PURE SUBROUTINE ZPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPPTRS
END INTERFACE F77_PPTRS

INTERFACE F77_PBTRS
  PURE SUBROUTINE SPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPBTRS
  PURE SUBROUTINE DPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPBTRS
  PURE SUBROUTINE CPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPBTRS
  PURE SUBROUTINE ZPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPBTRS
END INTERFACE F77_PBTRS

INTERFACE F77_PTTRS
  PURE SUBROUTINE SPTTRS(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPTTRS
  PURE SUBROUTINE DPTTRS(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPTTRS
  PURE SUBROUTINE CPTTRS(UPLO,N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPTTRS
  PURE SUBROUTINE ZPTTRS(UPLO,N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPTTRS
END INTERFACE F77_PTTRS

INTERFACE F77_SYTRS
  PURE SUBROUTINE SSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SSYTRS
  PURE SUBROUTINE DSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DSYTRS
  PURE SUBROUTINE CSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CSYTRS
  PURE SUBROUTINE ZSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZSYTRS
END INTERFACE F77_SYTRS

INTERFACE F77_SYTRS_ROOK
  PURE SUBROUTINE SSYTRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SSYTRS_ROOK
  PURE SUBROUTINE DSYTRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DSYTRS_ROOK
  PURE SUBROUTINE CSYTRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CSYTRS_ROOK
  PURE SUBROUTINE ZSYTRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZSYTRS_ROOK
END INTERFACE F77_SYTRS_ROOK

INTERFACE F77_HETRS
  PURE SUBROUTINE CHETRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CHETRS
  PURE SUBROUTINE ZHETRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZHETRS
END INTERFACE F77_HETRS

INTERFACE F77_HETRS_ROOK
  PURE SUBROUTINE CHETRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CHETRS_ROOK
  PURE SUBROUTINE ZHETRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZHETRS_ROOK
END INTERFACE F77_HETRS_ROOK

INTERFACE F77_SPTRS
  PURE SUBROUTINE SSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SSPTRS
  PURE SUBROUTINE DSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DSPTRS
  PURE SUBROUTINE CSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CSPTRS
  PURE SUBROUTINE ZSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZSPTRS
END INTERFACE F77_SPTRS

INTERFACE F77_HPTRS
  PURE SUBROUTINE CHPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CHPTRS
  PURE SUBROUTINE ZHPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZHPTRS
END INTERFACE F77_HPTRS

INTERFACE F77_TRTRS
  PURE SUBROUTINE STRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE STRTRS
  PURE SUBROUTINE DTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DTRTRS
  PURE SUBROUTINE CTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CTRTRS
  PURE SUBROUTINE ZTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZTRTRS
END INTERFACE F77_TRTRS

INTERFACE F77_TPTRS
  PURE SUBROUTINE STPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE STPTRS
  PURE SUBROUTINE DTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DTPTRS
  PURE SUBROUTINE CTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CTPTRS
  PURE SUBROUTINE ZTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZTPTRS
END INTERFACE F77_TPTRS

INTERFACE F77_TBTRS
  PURE SUBROUTINE STBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE STBTRS
  PURE SUBROUTINE DTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DTBTRS
  PURE SUBROUTINE CTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CTBTRS
  PURE SUBROUTINE ZTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZTBTRS
END INTERFACE F77_TBTRS

INTERFACE F77_GECON
  PURE SUBROUTINE SGECON(NORM,N,A,LDA,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGECON
  PURE SUBROUTINE DGECON(NORM,N,A,LDA,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGECON
  PURE SUBROUTINE CGECON(NORM,N,A,LDA,ANORM,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGECON
  PURE SUBROUTINE ZGECON(NORM,N,A,LDA,ANORM,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGECON
END INTERFACE F77_GECON

INTERFACE F77_GBCON
  PURE SUBROUTINE SGBCON(NORM,N,KL,KU,AB,LDAB,IPIV,ANORM,RCOND,WORK,    &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGBCON
  PURE SUBROUTINE DGBCON(NORM,N,KL,KU,AB,LDAB,IPIV,ANORM,RCOND,WORK,    &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGBCON
  PURE SUBROUTINE CGBCON(NORM,N,KL,KU,AB,LDAB,IPIV,ANORM,RCOND,WORK,    &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGBCON
  PURE SUBROUTINE ZGBCON(NORM,N,KL,KU,AB,LDAB,IPIV,ANORM,RCOND,WORK,    &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGBCON
END INTERFACE F77_GBCON

INTERFACE F77_GTCON
  PURE SUBROUTINE SGTCON(NORM,N,DL,D,DU,DU2,IPIV,ANORM,RCOND,WORK,IWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGTCON
  PURE SUBROUTINE DGTCON(NORM,N,DL,D,DU,DU2,IPIV,ANORM,RCOND,WORK,IWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGTCON
  PURE SUBROUTINE CGTCON(NORM,N,DL,D,DU,DU2,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CGTCON
  PURE SUBROUTINE ZGTCON(NORM,N,DL,D,DU,DU2,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZGTCON
END INTERFACE F77_GTCON

INTERFACE F77_POCON
  PURE SUBROUTINE SPOCON(UPLO,N,A,LDA,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPOCON
  PURE SUBROUTINE DPOCON(UPLO,N,A,LDA,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPOCON
  PURE SUBROUTINE CPOCON(UPLO,N,A,LDA,ANORM,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPOCON
  PURE SUBROUTINE ZPOCON(UPLO,N,A,LDA,ANORM,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPOCON
END INTERFACE F77_POCON

INTERFACE F77_PPCON
  PURE SUBROUTINE SPPCON(UPLO,N,AP,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPPCON
  PURE SUBROUTINE DPPCON(UPLO,N,AP,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPPCON
  PURE SUBROUTINE CPPCON(UPLO,N,AP,ANORM,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPPCON
  PURE SUBROUTINE ZPPCON(UPLO,N,AP,ANORM,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPPCON
END INTERFACE F77_PPCON

INTERFACE F77_PBCON
  PURE SUBROUTINE SPBCON(UPLO,N,KD,AB,LDAB,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPBCON
  PURE SUBROUTINE DPBCON(UPLO,N,KD,AB,LDAB,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPBCON
  PURE SUBROUTINE CPBCON(UPLO,N,KD,AB,LDAB,ANORM,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPBCON
  PURE SUBROUTINE ZPBCON(UPLO,N,KD,AB,LDAB,ANORM,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPBCON
END INTERFACE F77_PBCON

INTERFACE F77_PTCON
  PURE SUBROUTINE SPTCON(N,D,E,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SPTCON
  PURE SUBROUTINE DPTCON(N,D,E,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DPTCON
  PURE SUBROUTINE CPTCON(N,D,E,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CPTCON
  PURE SUBROUTINE ZPTCON(N,D,E,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZPTCON
END INTERFACE F77_PTCON

INTERFACE F77_SYCON
  PURE SUBROUTINE SSYCON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSYCON
  PURE SUBROUTINE DSYCON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSYCON
  PURE SUBROUTINE CSYCON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CSYCON
  PURE SUBROUTINE ZSYCON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZSYCON
END INTERFACE F77_SYCON

INTERFACE F77_SYCON_ROOK
  PURE SUBROUTINE SSYCON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,IWORK, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSYCON_ROOK
  PURE SUBROUTINE DSYCON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,IWORK, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSYCON_ROOK
  PURE SUBROUTINE CSYCON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CSYCON_ROOK
  PURE SUBROUTINE ZSYCON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZSYCON_ROOK
END INTERFACE F77_SYCON_ROOK

INTERFACE F77_HECON
  PURE SUBROUTINE CHECON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CHECON
  PURE SUBROUTINE ZHECON(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZHECON
END INTERFACE F77_HECON

INTERFACE F77_HECON_ROOK
  PURE SUBROUTINE CHECON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CHECON_ROOK
  PURE SUBROUTINE ZHECON_ROOK(UPLO,N,A,LDA,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZHECON_ROOK
END INTERFACE F77_HECON_ROOK

INTERFACE F77_SPCON
  PURE SUBROUTINE SSPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSPCON
  PURE SUBROUTINE DSPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSPCON
  PURE SUBROUTINE CSPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CSPCON
  PURE SUBROUTINE ZSPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZSPCON
END INTERFACE F77_SPCON

INTERFACE F77_HPCON
  PURE SUBROUTINE CHPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CHPCON
  PURE SUBROUTINE ZHPCON(UPLO,N,AP,IPIV,ANORM,RCOND,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: ANORM
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZHPCON
END INTERFACE F77_HPCON

INTERFACE F77_TRCON
  PURE SUBROUTINE STRCON(NORM,UPLO,DIAG,N,A,LDA,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STRCON
  PURE SUBROUTINE DTRCON(NORM,UPLO,DIAG,N,A,LDA,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTRCON
  PURE SUBROUTINE CTRCON(NORM,UPLO,DIAG,N,A,LDA,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTRCON
  PURE SUBROUTINE ZTRCON(NORM,UPLO,DIAG,N,A,LDA,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTRCON
END INTERFACE F77_TRCON

INTERFACE F77_TPCON
  PURE SUBROUTINE STPCON(NORM,UPLO,DIAG,N,AP,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STPCON
  PURE SUBROUTINE DTPCON(NORM,UPLO,DIAG,N,AP,RCOND,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTPCON
  PURE SUBROUTINE CTPCON(NORM,UPLO,DIAG,N,AP,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTPCON
  PURE SUBROUTINE ZTPCON(NORM,UPLO,DIAG,N,AP,RCOND,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTPCON
END INTERFACE F77_TPCON

INTERFACE F77_TBCON
  PURE SUBROUTINE STBCON(NORM,UPLO,DIAG,N,KD,AB,LDAB,RCOND,WORK,IWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STBCON
  PURE SUBROUTINE DTBCON(NORM,UPLO,DIAG,N,KD,AB,LDAB,RCOND,WORK,IWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTBCON
  PURE SUBROUTINE CTBCON(NORM,UPLO,DIAG,N,KD,AB,LDAB,RCOND,WORK,RWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTBCON
  PURE SUBROUTINE ZTBCON(NORM,UPLO,DIAG,N,KD,AB,LDAB,RCOND,WORK,RWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: RCOND
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    CHARACTER(LEN=1), INTENT(IN) :: NORM
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTBCON
END INTERFACE F77_TBCON

INTERFACE F77_GERFS
  PURE SUBROUTINE SGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,   &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGERFS
  PURE SUBROUTINE DGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,   &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGERFS
  PURE SUBROUTINE CGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,   &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGERFS
  PURE SUBROUTINE ZGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,   &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGERFS
END INTERFACE F77_GERFS

INTERFACE F77_GBRFS
  PURE SUBROUTINE SGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,   &
     &                              LDB,X,LDX,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: AFB(LDAFB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGBRFS
  PURE SUBROUTINE DGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,   &
     &                              LDB,X,LDX,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: AFB(LDAFB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGBRFS
  PURE SUBROUTINE CGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,   &
     &                              LDB,X,LDX,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: AFB(LDAFB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGBRFS
  PURE SUBROUTINE ZGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,   &
     &                              LDB,X,LDX,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: AFB(LDAFB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGBRFS
END INTERFACE F77_GBRFS

INTERFACE F77_GTRFS
  PURE SUBROUTINE SGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,&
     &                                  X,LDX,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DLF(*)
    REAL(WP), INTENT(IN) :: DF(*)
    REAL(WP), INTENT(IN) :: DUF(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGTRFS
  PURE SUBROUTINE DGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,&
     &                                  X,LDX,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DLF(*)
    REAL(WP), INTENT(IN) :: DF(*)
    REAL(WP), INTENT(IN) :: DUF(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGTRFS
  PURE SUBROUTINE CGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,&
     &                                  X,LDX,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DLF(*)
    COMPLEX(WP), INTENT(IN) :: DF(*)
    COMPLEX(WP), INTENT(IN) :: DUF(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGTRFS
  PURE SUBROUTINE ZGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,&
     &                                  X,LDX,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DLF(*)
    COMPLEX(WP), INTENT(IN) :: DF(*)
    COMPLEX(WP), INTENT(IN) :: DUF(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGTRFS
END INTERFACE F77_GTRFS

INTERFACE F77_PORFS
  PURE SUBROUTINE SPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPORFS
  PURE SUBROUTINE DPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPORFS
  PURE SUBROUTINE CPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPORFS
  PURE SUBROUTINE ZPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPORFS
END INTERFACE F77_PORFS

INTERFACE F77_PPRFS
  PURE SUBROUTINE SPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK, &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: AFP(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPPRFS
  PURE SUBROUTINE DPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK, &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: AFP(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPPRFS
  PURE SUBROUTINE CPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK, &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPPRFS
  PURE SUBROUTINE ZPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK, &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPPRFS
END INTERFACE F77_PPRFS

INTERFACE F77_PBRFS
  PURE SUBROUTINE SPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,  &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: AFB(LDAFB,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPBRFS
  PURE SUBROUTINE DPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,  &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: AFB(LDAFB,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPBRFS
  PURE SUBROUTINE CPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,  &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: AFB(LDAFB,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPBRFS
  PURE SUBROUTINE ZPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,  &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: AFB(LDAFB,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPBRFS
END INTERFACE F77_PBRFS

INTERFACE F77_PTRFS
  PURE SUBROUTINE SPTRFS(N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DF(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: EF(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SPTRFS
  PURE SUBROUTINE DPTRFS(N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DF(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: EF(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DPTRFS
  PURE SUBROUTINE CPTRFS(UPLO,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,   &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DF(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(IN) :: EF(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPTRFS
  PURE SUBROUTINE ZPTRFS(UPLO,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,   &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DF(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(IN) :: EF(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPTRFS
END INTERFACE F77_PTRFS

INTERFACE F77_SYRFS
  PURE SUBROUTINE SSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSYRFS
  PURE SUBROUTINE DSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSYRFS
  PURE SUBROUTINE CSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CSYRFS
  PURE SUBROUTINE ZSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZSYRFS
END INTERFACE F77_SYRFS

INTERFACE F77_HERFS
  PURE SUBROUTINE CHERFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHERFS
  PURE SUBROUTINE ZHERFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHERFS
END INTERFACE F77_HERFS

INTERFACE F77_SPRFS
  PURE SUBROUTINE SSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSPRFS
  PURE SUBROUTINE DSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSPRFS
  PURE SUBROUTINE CSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CSPRFS
  PURE SUBROUTINE ZSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZSPRFS
END INTERFACE F77_SPRFS

INTERFACE F77_HPRFS
  PURE SUBROUTINE CHPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHPRFS
  PURE SUBROUTINE ZHPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHPRFS
END INTERFACE F77_HPRFS

INTERFACE F77_TRRFS
  PURE SUBROUTINE STRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR, &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STRRFS
  PURE SUBROUTINE DTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR, &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTRRFS
  PURE SUBROUTINE CTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR, &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTRRFS
  PURE SUBROUTINE ZTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR, &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTRRFS
END INTERFACE F77_TRRFS

INTERFACE F77_TPRFS
  PURE SUBROUTINE STPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STPRFS
  PURE SUBROUTINE DTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTPRFS
  PURE SUBROUTINE CTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTPRFS
  PURE SUBROUTINE ZTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTPRFS
END INTERFACE F77_TPRFS

INTERFACE F77_TBRFS
  PURE SUBROUTINE STBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX, &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STBRFS
  PURE SUBROUTINE DTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX, &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTBRFS
  PURE SUBROUTINE CTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX, &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTBRFS
  PURE SUBROUTINE ZTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX, &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(IN) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTBRFS
END INTERFACE F77_TBRFS

INTERFACE F77_GETRI
  PURE SUBROUTINE SGETRI(N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGETRI
  PURE SUBROUTINE DGETRI(N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGETRI
  PURE SUBROUTINE CGETRI(N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGETRI
  PURE SUBROUTINE ZGETRI(N,A,LDA,IPIV,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGETRI
END INTERFACE F77_GETRI

INTERFACE F77_POTRI
  PURE SUBROUTINE SPOTRI(UPLO,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SPOTRI
  PURE SUBROUTINE DPOTRI(UPLO,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DPOTRI
  PURE SUBROUTINE CPOTRI(UPLO,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CPOTRI
  PURE SUBROUTINE ZPOTRI(UPLO,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZPOTRI
END INTERFACE F77_POTRI

INTERFACE F77_PPTRI
  PURE SUBROUTINE SPPTRI(UPLO,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SPPTRI
  PURE SUBROUTINE DPPTRI(UPLO,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DPPTRI
  PURE SUBROUTINE CPPTRI(UPLO,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CPPTRI
  PURE SUBROUTINE ZPPTRI(UPLO,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZPPTRI
END INTERFACE F77_PPTRI

INTERFACE F77_SYTRI
  PURE SUBROUTINE SSYTRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSYTRI
  PURE SUBROUTINE DSYTRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSYTRI
  PURE SUBROUTINE CSYTRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CSYTRI
  PURE SUBROUTINE ZSYTRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZSYTRI
END INTERFACE F77_SYTRI

INTERFACE F77_SYTRI_ROOK
  PURE SUBROUTINE SSYTRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSYTRI_ROOK
  PURE SUBROUTINE DSYTRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSYTRI_ROOK
  PURE SUBROUTINE CSYTRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CSYTRI_ROOK
  PURE SUBROUTINE ZSYTRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZSYTRI_ROOK
END INTERFACE F77_SYTRI_ROOK

INTERFACE F77_HETRI
  PURE SUBROUTINE CHETRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CHETRI
  PURE SUBROUTINE ZHETRI(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZHETRI
END INTERFACE F77_HETRI

INTERFACE F77_HETRI_ROOK
  PURE SUBROUTINE CHETRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CHETRI_ROOK
  PURE SUBROUTINE ZHETRI_ROOK(UPLO,N,A,LDA,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZHETRI_ROOK
END INTERFACE F77_HETRI_ROOK

INTERFACE F77_SPTRI
  PURE SUBROUTINE SSPTRI(UPLO,N,AP,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSPTRI
  PURE SUBROUTINE DSPTRI(UPLO,N,AP,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSPTRI
  PURE SUBROUTINE CSPTRI(UPLO,N,AP,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CSPTRI
  PURE SUBROUTINE ZSPTRI(UPLO,N,AP,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZSPTRI
END INTERFACE F77_SPTRI

INTERFACE F77_HPTRI
  PURE SUBROUTINE CHPTRI(UPLO,N,AP,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CHPTRI
  PURE SUBROUTINE ZHPTRI(UPLO,N,AP,IPIV,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZHPTRI
END INTERFACE F77_HPTRI

INTERFACE F77_TRTRI
  PURE SUBROUTINE STRTRI(UPLO,DIAG,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE STRTRI
  PURE SUBROUTINE DTRTRI(UPLO,DIAG,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DTRTRI
  PURE SUBROUTINE CTRTRI(UPLO,DIAG,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CTRTRI
  PURE SUBROUTINE ZTRTRI(UPLO,DIAG,N,A,LDA,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZTRTRI
END INTERFACE F77_TRTRI

INTERFACE F77_TPTRI
  PURE SUBROUTINE STPTRI(UPLO,DIAG,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE STPTRI
  PURE SUBROUTINE DTPTRI(UPLO,DIAG,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DTPTRI
  PURE SUBROUTINE CTPTRI(UPLO,DIAG,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CTPTRI
  PURE SUBROUTINE ZTPTRI(UPLO,DIAG,N,AP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZTPTRI
END INTERFACE F77_TPTRI

INTERFACE F77_GEEQU
  PURE SUBROUTINE SGEEQU(M,N,A,LDA,R,C,ROWCND,COLCND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: R(*)
    REAL(WP), INTENT(OUT) :: C(*)
    REAL(WP), INTENT(OUT) :: ROWCND
    REAL(WP), INTENT(OUT) :: COLCND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SGEEQU
  PURE SUBROUTINE DGEEQU(M,N,A,LDA,R,C,ROWCND,COLCND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: R(*)
    REAL(WP), INTENT(OUT) :: C(*)
    REAL(WP), INTENT(OUT) :: ROWCND
    REAL(WP), INTENT(OUT) :: COLCND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DGEEQU
  PURE SUBROUTINE CGEEQU(M,N,A,LDA,R,C,ROWCND,COLCND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: R(*)
    REAL(WP), INTENT(OUT) :: C(*)
    REAL(WP), INTENT(OUT) :: ROWCND
    REAL(WP), INTENT(OUT) :: COLCND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CGEEQU
  PURE SUBROUTINE ZGEEQU(M,N,A,LDA,R,C,ROWCND,COLCND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: R(*)
    REAL(WP), INTENT(OUT) :: C(*)
    REAL(WP), INTENT(OUT) :: ROWCND
    REAL(WP), INTENT(OUT) :: COLCND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZGEEQU
END INTERFACE F77_GEEQU

INTERFACE F77_GBEQU
  PURE SUBROUTINE SGBEQU(M,N,KL,KU,AB,LDAB,R,C,ROWCND,COLCND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: R(*)
    REAL(WP), INTENT(OUT) :: C(*)
    INTEGER, INTENT(IN) :: KL
    REAL(WP), INTENT(OUT) :: ROWCND
    REAL(WP), INTENT(OUT) :: COLCND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE SGBEQU
  PURE SUBROUTINE DGBEQU(M,N,KL,KU,AB,LDAB,R,C,ROWCND,COLCND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: R(*)
    REAL(WP), INTENT(OUT) :: C(*)
    INTEGER, INTENT(IN) :: KL
    REAL(WP), INTENT(OUT) :: ROWCND
    REAL(WP), INTENT(OUT) :: COLCND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE DGBEQU
  PURE SUBROUTINE CGBEQU(M,N,KL,KU,AB,LDAB,R,C,ROWCND,COLCND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: R(*)
    REAL(WP), INTENT(OUT) :: C(*)
    INTEGER, INTENT(IN) :: KL
    REAL(WP), INTENT(OUT) :: ROWCND
    REAL(WP), INTENT(OUT) :: COLCND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE CGBEQU
  PURE SUBROUTINE ZGBEQU(M,N,KL,KU,AB,LDAB,R,C,ROWCND,COLCND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: R(*)
    REAL(WP), INTENT(OUT) :: C(*)
    INTEGER, INTENT(IN) :: KL
    REAL(WP), INTENT(OUT) :: ROWCND
    REAL(WP), INTENT(OUT) :: COLCND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE ZGBEQU
END INTERFACE F77_GBEQU

INTERFACE F77_POEQU
  PURE SUBROUTINE SPOEQU(N,A,LDA,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SPOEQU
  PURE SUBROUTINE DPOEQU(N,A,LDA,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DPOEQU
  PURE SUBROUTINE CPOEQU(N,A,LDA,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CPOEQU
  PURE SUBROUTINE ZPOEQU(N,A,LDA,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZPOEQU
END INTERFACE F77_POEQU

INTERFACE F77_PPEQU
  PURE SUBROUTINE SPPEQU(UPLO,N,AP,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SPPEQU
  PURE SUBROUTINE DPPEQU(UPLO,N,AP,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DPPEQU
  PURE SUBROUTINE CPPEQU(UPLO,N,AP,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CPPEQU
  PURE SUBROUTINE ZPPEQU(UPLO,N,AP,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZPPEQU
END INTERFACE F77_PPEQU

INTERFACE F77_PBEQU
  PURE SUBROUTINE SPBEQU(UPLO,N,KD,AB,LDAB,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE SPBEQU
  PURE SUBROUTINE DPBEQU(UPLO,N,KD,AB,LDAB,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE DPBEQU
  PURE SUBROUTINE CPBEQU(UPLO,N,KD,AB,LDAB,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE CPBEQU
  PURE SUBROUTINE ZPBEQU(UPLO,N,KD,AB,LDAB,S,SCOND,AMAX,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SCOND
    REAL(WP), INTENT(OUT) :: AMAX
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
  END SUBROUTINE ZPBEQU
END INTERFACE F77_PBEQU

INTERFACE F77_GESV
  PURE SUBROUTINE SGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGESV
  PURE SUBROUTINE DGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGESV
  PURE SUBROUTINE CGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGESV
  PURE SUBROUTINE ZGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGESV
END INTERFACE F77_GESV

INTERFACE F77_GESVX
  PURE SUBROUTINE SGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,&
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGESVX
  PURE SUBROUTINE DGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,&
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGESVX
  PURE SUBROUTINE CGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,&
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE CGESVX
  PURE SUBROUTINE ZGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,&
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE ZGESVX
END INTERFACE F77_GESVX

INTERFACE F77_GBSV
  PURE SUBROUTINE SGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGBSV
  PURE SUBROUTINE DGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGBSV
  PURE SUBROUTINE CGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGBSV
  PURE SUBROUTINE ZGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGBSV
END INTERFACE F77_GBSV

INTERFACE F77_GBSVX
  PURE SUBROUTINE SGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,&
     &            EQUED,R,C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    INTEGER, INTENT(IN) :: KL
    REAL(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGBSVX
  PURE SUBROUTINE DGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,&
     &            EQUED,R,C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    INTEGER, INTENT(IN) :: KL
    REAL(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGBSVX
  PURE SUBROUTINE CGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,&
     &            EQUED,R,C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    INTEGER, INTENT(IN) :: KL
    COMPLEX(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE CGBSVX
  PURE SUBROUTINE ZGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,&
     &            EQUED,R,C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    INTEGER, INTENT(IN) :: KL
    COMPLEX(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE ZGBSVX
END INTERFACE F77_GBSVX

INTERFACE F77_GTSV
  PURE SUBROUTINE SGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGTSV
  PURE SUBROUTINE DGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGTSV
  PURE SUBROUTINE CGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGTSV
  PURE SUBROUTINE ZGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGTSV
END INTERFACE F77_GTSV

INTERFACE F77_GTSVX
  PURE SUBROUTINE SGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    REAL(WP), INTENT(INOUT) :: DLF(*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    REAL(WP), INTENT(INOUT) :: DUF(*)
    REAL(WP), INTENT(INOUT) :: DU2(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGTSVX
  PURE SUBROUTINE DGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    REAL(WP), INTENT(INOUT) :: DLF(*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    REAL(WP), INTENT(INOUT) :: DUF(*)
    REAL(WP), INTENT(INOUT) :: DU2(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGTSVX
  PURE SUBROUTINE CGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    COMPLEX(WP), INTENT(INOUT) :: DLF(*)
    COMPLEX(WP), INTENT(INOUT) :: DF(*)
    COMPLEX(WP), INTENT(INOUT) :: DUF(*)
    COMPLEX(WP), INTENT(INOUT) :: DU2(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGTSVX
  PURE SUBROUTINE ZGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    COMPLEX(WP), INTENT(INOUT) :: DLF(*)
    COMPLEX(WP), INTENT(INOUT) :: DF(*)
    COMPLEX(WP), INTENT(INOUT) :: DUF(*)
    COMPLEX(WP), INTENT(INOUT) :: DU2(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGTSVX
END INTERFACE F77_GTSVX

INTERFACE F77_DTSVB
  PURE SUBROUTINE SDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SDTSVB
  PURE SUBROUTINE DDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DDTSVB
  PURE SUBROUTINE CDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CDTSVB
  PURE SUBROUTINE ZDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZDTSVB
END INTERFACE F77_DTSVB

INTERFACE F77_POSV
  PURE SUBROUTINE SPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPOSV
  PURE SUBROUTINE DPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPOSV
  PURE SUBROUTINE CPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPOSV
  PURE SUBROUTINE ZPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPOSV
END INTERFACE F77_POSV

INTERFACE F77_POSVX
  PURE SUBROUTINE SPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,&
     &                              LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPOSVX
  PURE SUBROUTINE DPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,&
     &                              LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPOSVX
  PURE SUBROUTINE CPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,&
     &                              LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPOSVX
  PURE SUBROUTINE ZPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,&
     &                              LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPOSVX
END INTERFACE F77_POSVX

INTERFACE F77_PPSV
  PURE SUBROUTINE SPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPPSV
  PURE SUBROUTINE DPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPPSV
  PURE SUBROUTINE CPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPPSV
  PURE SUBROUTINE ZPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPPSV
END INTERFACE F77_PPSV

INTERFACE F77_PPSVX
  PURE SUBROUTINE SPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,   &
     &                                  RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFP(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPPSVX
  PURE SUBROUTINE DPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,   &
     &                                  RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFP(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPPSVX
  PURE SUBROUTINE CPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,   &
     &                                  RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPPSVX
  PURE SUBROUTINE ZPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,   &
     &                                  RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPPSVX
END INTERFACE F77_PPSVX

INTERFACE F77_PBSV
  PURE SUBROUTINE SPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPBSV
  PURE SUBROUTINE DPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPBSV
  PURE SUBROUTINE CPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPBSV
  PURE SUBROUTINE ZPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPBSV
END INTERFACE F77_PBSV

INTERFACE F77_PBSVX
  PURE SUBROUTINE SPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPBSVX
  PURE SUBROUTINE DPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPBSVX
  PURE SUBROUTINE CPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: IWORK(*)
  END SUBROUTINE CPBSVX
  PURE SUBROUTINE ZPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZPBSVX
END INTERFACE F77_PBSVX

INTERFACE F77_PTSV
  PURE SUBROUTINE SPTSV(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPTSV
  PURE SUBROUTINE DPTSV(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPTSV
  PURE SUBROUTINE CPTSV(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPTSV
  PURE SUBROUTINE ZPTSV(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPTSV
END INTERFACE F77_PTSV

INTERFACE F77_PTSVX
  PURE SUBROUTINE SPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,  &
     &                                                   BERR,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    REAL(WP), INTENT(INOUT) :: EF(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SPTSVX
  PURE SUBROUTINE DPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,  &
     &                                                   BERR,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    REAL(WP), INTENT(INOUT) :: EF(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DPTSVX
  PURE SUBROUTINE CPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,  &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    COMPLEX(WP), INTENT(INOUT) :: EF(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPTSVX
  PURE SUBROUTINE ZPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,  &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    COMPLEX(WP), INTENT(INOUT) :: EF(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPTSVX
END INTERFACE F77_PTSVX

INTERFACE F77_SYSV
  PURE SUBROUTINE SSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SSYSV
  PURE SUBROUTINE DSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DSYSV
  PURE SUBROUTINE CSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CSYSV
  PURE SUBROUTINE ZSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZSYSV
END INTERFACE F77_SYSV

INTERFACE F77_SYSV_ROOK
  PURE SUBROUTINE SSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SSYSV_ROOK
  PURE SUBROUTINE DSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DSYSV_ROOK
  PURE SUBROUTINE CSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CSYSV_ROOK
  PURE SUBROUTINE ZSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZSYSV_ROOK
END INTERFACE F77_SYSV_ROOK

INTERFACE F77_SYSVX
  PURE SUBROUTINE SSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSYSVX
  PURE SUBROUTINE DSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSYSVX
  PURE SUBROUTINE CSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CSYSVX
  PURE SUBROUTINE ZSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZSYSVX
END INTERFACE F77_SYSVX

INTERFACE F77_HESVX
  PURE SUBROUTINE CHESVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHESVX
  PURE SUBROUTINE ZHESVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHESVX
END INTERFACE F77_HESVX

INTERFACE F77_HESV
  PURE SUBROUTINE CHESV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CHESV
  PURE SUBROUTINE ZHESV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZHESV
END INTERFACE F77_HESV

INTERFACE F77_HESV_ROOK
  PURE SUBROUTINE CHESV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CHESV_ROOK
  PURE SUBROUTINE ZHESV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZHESV_ROOK
END INTERFACE F77_HESV_ROOK

INTERFACE F77_SPSV
  PURE SUBROUTINE SSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SSPSV
  PURE SUBROUTINE DSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DSPSV
  PURE SUBROUTINE CSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CSPSV
  PURE SUBROUTINE ZSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZSPSV
END INTERFACE F77_SPSV

INTERFACE F77_SPSVX
  PURE SUBROUTINE SSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSPSVX
  PURE SUBROUTINE DSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSPSVX
  PURE SUBROUTINE CSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CSPSVX
  PURE SUBROUTINE ZSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZSPSVX
END INTERFACE F77_SPSVX

INTERFACE F77_HPSVX
  PURE SUBROUTINE CHPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHPSVX
  PURE SUBROUTINE ZHPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHPSVX
END INTERFACE F77_HPSVX

INTERFACE F77_HPSV
  PURE SUBROUTINE CHPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CHPSV
  PURE SUBROUTINE ZHPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZHPSV
END INTERFACE F77_HPSV

INTERFACE F77_GEQRF
  PURE SUBROUTINE SGEQRF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGEQRF
  PURE SUBROUTINE DGEQRF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGEQRF
  PURE SUBROUTINE CGEQRF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGEQRF
  PURE SUBROUTINE ZGEQRF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGEQRF
END INTERFACE F77_GEQRF

INTERFACE F77_GEQPF
  PURE SUBROUTINE SGEQPF(M,N,A,LDA,JPVT,TAU,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SGEQPF
  PURE SUBROUTINE DGEQPF(M,N,A,LDA,JPVT,TAU,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DGEQPF
  PURE SUBROUTINE CGEQPF(M,N,A,LDA,JPVT,TAU,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(INOUT) :: JPVT(*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGEQPF
  PURE SUBROUTINE ZGEQPF(M,N,A,LDA,JPVT,TAU,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(INOUT) :: JPVT(*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGEQPF
END INTERFACE F77_GEQPF

INTERFACE F77_GEQP3
  PURE SUBROUTINE SGEQP3(M,N,A,LDA,JPVT,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGEQP3
  PURE SUBROUTINE DGEQP3(M,N,A,LDA,JPVT,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGEQP3
  PURE SUBROUTINE CGEQP3(M,N,A,LDA,JPVT,TAU,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(INOUT) :: JPVT(*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGEQP3
  PURE SUBROUTINE ZGEQP3(M,N,A,LDA,JPVT,TAU,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    INTEGER, INTENT(INOUT) :: JPVT(*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGEQP3
END INTERFACE F77_GEQP3

INTERFACE F77_ORGQR
  PURE SUBROUTINE SORGQR(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORGQR
  PURE SUBROUTINE DORGQR(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORGQR
END INTERFACE F77_ORGQR

INTERFACE F77_ORMQR
  PURE SUBROUTINE SORMQR(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORMQR
  PURE SUBROUTINE DORMQR(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORMQR
END INTERFACE F77_ORMQR

INTERFACE F77_UNGQR
  PURE SUBROUTINE CUNGQR(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNGQR
  PURE SUBROUTINE ZUNGQR(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNGQR
END INTERFACE F77_UNGQR

INTERFACE F77_UNMQR
  PURE SUBROUTINE CUNMQR(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNMQR
  PURE SUBROUTINE ZUNMQR(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNMQR
END INTERFACE F77_UNMQR

INTERFACE F77_GELQF
  PURE SUBROUTINE SGELQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGELQF
  PURE SUBROUTINE DGELQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGELQF
  PURE SUBROUTINE CGELQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGELQF
  PURE SUBROUTINE ZGELQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGELQF
END INTERFACE F77_GELQF

INTERFACE F77_ORGLQ
  PURE SUBROUTINE SORGLQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORGLQ
  PURE SUBROUTINE DORGLQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORGLQ
END INTERFACE F77_ORGLQ

INTERFACE F77_ORMLQ
  PURE SUBROUTINE SORMLQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORMLQ
  PURE SUBROUTINE DORMLQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORMLQ
END INTERFACE F77_ORMLQ

INTERFACE F77_UNGLQ
  PURE SUBROUTINE CUNGLQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNGLQ
  PURE SUBROUTINE ZUNGLQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNGLQ
END INTERFACE F77_UNGLQ

INTERFACE F77_UNMLQ
  PURE SUBROUTINE CUNMLQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNMLQ
  PURE SUBROUTINE ZUNMLQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNMLQ
END INTERFACE F77_UNMLQ

INTERFACE F77_GEQLF
  PURE SUBROUTINE SGEQLF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGEQLF
  PURE SUBROUTINE DGEQLF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGEQLF
  PURE SUBROUTINE CGEQLF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGEQLF
  PURE SUBROUTINE ZGEQLF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGEQLF
END INTERFACE F77_GEQLF

INTERFACE F77_ORGQL
  PURE SUBROUTINE SORGQL(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORGQL
  PURE SUBROUTINE DORGQL(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORGQL
END INTERFACE F77_ORGQL

INTERFACE F77_UNGQL
  PURE SUBROUTINE CUNGQL(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNGQL
  PURE SUBROUTINE ZUNGQL(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNGQL
END INTERFACE F77_UNGQL

INTERFACE F77_ORMQL
  PURE SUBROUTINE SORMQL(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORMQL
  PURE SUBROUTINE DORMQL(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORMQL
END INTERFACE F77_ORMQL

INTERFACE F77_UNMQL
  PURE SUBROUTINE CUNMQL(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNMQL
  PURE SUBROUTINE ZUNMQL(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNMQL
END INTERFACE F77_UNMQL

INTERFACE F77_GERQF
  PURE SUBROUTINE SGERQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGERQF
  PURE SUBROUTINE DGERQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGERQF
  PURE SUBROUTINE CGERQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGERQF
  PURE SUBROUTINE ZGERQF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGERQF
END INTERFACE F77_GERQF

INTERFACE F77_ORGRQ
  PURE SUBROUTINE SORGRQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORGRQ
  PURE SUBROUTINE DORGRQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORGRQ
END INTERFACE F77_ORGRQ

INTERFACE F77_UNGRQ
  PURE SUBROUTINE CUNGRQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNGRQ
  PURE SUBROUTINE ZUNGRQ(M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNGRQ
END INTERFACE F77_UNGRQ

INTERFACE F77_ORMRQ
  PURE SUBROUTINE SORMRQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORMRQ
  PURE SUBROUTINE DORMRQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORMRQ
END INTERFACE F77_ORMRQ

INTERFACE F77_UNMRQ
  PURE SUBROUTINE CUNMRQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNMRQ
  PURE SUBROUTINE ZUNMRQ(SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNMRQ
END INTERFACE F77_UNMRQ

INTERFACE F77_TZRZF
  PURE SUBROUTINE STZRZF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE STZRZF
  PURE SUBROUTINE DTZRZF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DTZRZF
  PURE SUBROUTINE CTZRZF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CTZRZF
  PURE SUBROUTINE ZTZRZF(M,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZTZRZF
END INTERFACE F77_TZRZF

INTERFACE F77_ORMRZ
  PURE SUBROUTINE SORMRZ(SIDE,TRANS,M,N,K,L,A,LDA,TAU,C,LDC,WORK,LWORK, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    INTEGER, INTENT(IN) :: L
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORMRZ
  PURE SUBROUTINE DORMRZ(SIDE,TRANS,M,N,K,L,A,LDA,TAU,C,LDC,WORK,LWORK, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    INTEGER, INTENT(IN) :: L
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORMRZ
END INTERFACE F77_ORMRZ

INTERFACE F77_UNMRZ
  PURE SUBROUTINE CUNMRZ(SIDE,TRANS,M,N,K,L,A,LDA,TAU,C,LDC,WORK,LWORK, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    INTEGER, INTENT(IN) :: L
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNMRZ
  PURE SUBROUTINE ZUNMRZ(SIDE,TRANS,M,N,K,L,A,LDA,TAU,C,LDC,WORK,LWORK, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    INTEGER, INTENT(IN) :: L
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNMRZ
END INTERFACE F77_UNMRZ

INTERFACE F77_GGQRF
  PURE SUBROUTINE SGGQRF(N,M,P,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: TAUA(*)
    REAL(WP), INTENT(OUT) :: TAUB(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGGQRF
  PURE SUBROUTINE DGGQRF(N,M,P,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: TAUA(*)
    REAL(WP), INTENT(OUT) :: TAUB(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGGQRF
  PURE SUBROUTINE CGGQRF(N,M,P,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: TAUA(*)
    COMPLEX(WP), INTENT(OUT) :: TAUB(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGGQRF
  PURE SUBROUTINE ZGGQRF(N,M,P,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: TAUA(*)
    COMPLEX(WP), INTENT(OUT) :: TAUB(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGGQRF
END INTERFACE F77_GGQRF

INTERFACE F77_GGRQF
  PURE SUBROUTINE SGGRQF(M,P,N,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: TAUA(*)
    REAL(WP), INTENT(OUT) :: TAUB(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGGRQF
  PURE SUBROUTINE DGGRQF(M,P,N,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: TAUA(*)
    REAL(WP), INTENT(OUT) :: TAUB(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGGRQF
  PURE SUBROUTINE CGGRQF(M,P,N,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: TAUA(*)
    COMPLEX(WP), INTENT(OUT) :: TAUB(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGGRQF
  PURE SUBROUTINE ZGGRQF(M,P,N,A,LDA,TAUA,B,LDB,TAUB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: TAUA(*)
    COMPLEX(WP), INTENT(OUT) :: TAUB(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGGRQF
END INTERFACE F77_GGRQF

INTERFACE F77_GEBRD
  PURE SUBROUTINE SGEBRD(M,N,A,LDA,D,E,TAUQ,TAUP,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    REAL(WP), INTENT(OUT) :: TAUQ(*)
    REAL(WP), INTENT(OUT) :: TAUP(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGEBRD
  PURE SUBROUTINE DGEBRD(M,N,A,LDA,D,E,TAUQ,TAUP,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    REAL(WP), INTENT(OUT) :: TAUQ(*)
    REAL(WP), INTENT(OUT) :: TAUP(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGEBRD
  PURE SUBROUTINE CGEBRD(M,N,A,LDA,D,E,TAUQ,TAUP,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    COMPLEX(WP), INTENT(OUT) :: TAUQ(*)
    COMPLEX(WP), INTENT(OUT) :: TAUP(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGEBRD
  PURE SUBROUTINE ZGEBRD(M,N,A,LDA,D,E,TAUQ,TAUP,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    COMPLEX(WP), INTENT(OUT) :: TAUQ(*)
    COMPLEX(WP), INTENT(OUT) :: TAUP(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGEBRD
END INTERFACE F77_GEBRD

INTERFACE F77_GBBRD
  PURE SUBROUTINE SGBBRD(VECT,M,N,NCC,KL,KU,AB,LDAB,D,E,Q,LDQ,PT,LDPT,C,&
     &                                                    LDC,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(OUT) :: PT(LDPT,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NCC
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDPT
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SGBBRD
  PURE SUBROUTINE DGBBRD(VECT,M,N,NCC,KL,KU,AB,LDAB,D,E,Q,LDQ,PT,LDPT,C,&
     &                                                    LDC,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(OUT) :: PT(LDPT,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NCC
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDPT
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DGBBRD
  PURE SUBROUTINE CGBBRD(VECT,M,N,NCC,KL,KU,AB,LDAB,D,E,Q,LDQ,PT,LDPT,C,&
     &                                              LDC,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    COMPLEX(WP), INTENT(OUT) :: PT(LDPT,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NCC
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDPT
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGBBRD
  PURE SUBROUTINE ZGBBRD(VECT,M,N,NCC,KL,KU,AB,LDAB,D,E,Q,LDQ,PT,LDPT,C,&
     &                                              LDC,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    COMPLEX(WP), INTENT(OUT) :: PT(LDPT,*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NCC
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDPT
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGBBRD
END INTERFACE F77_GBBRD

INTERFACE F77_ORGBR
  PURE SUBROUTINE SORGBR(VECT,M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORGBR
  PURE SUBROUTINE DORGBR(VECT,M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORGBR
END INTERFACE F77_ORGBR

INTERFACE F77_ORMBR
  PURE SUBROUTINE SORMBR(VECT,SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,    &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORMBR
  PURE SUBROUTINE DORMBR(VECT,SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,    &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORMBR
END INTERFACE F77_ORMBR

INTERFACE F77_UNGBR
  PURE SUBROUTINE CUNGBR(VECT,M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNGBR
  PURE SUBROUTINE ZUNGBR(VECT,M,N,K,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNGBR
END INTERFACE F77_UNGBR

INTERFACE F77_UNMBR
  PURE SUBROUTINE CUNMBR(VECT,SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,    &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNMBR
  PURE SUBROUTINE ZUNMBR(VECT,SIDE,TRANS,M,N,K,A,LDA,TAU,C,LDC,WORK,    &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNMBR
END INTERFACE F77_UNMBR

INTERFACE F77_BDSQR
  PURE SUBROUTINE SBDSQR(UPLO,N,NCVT,NRU,NCC,D,E,VT,LDVT,U,LDU,C,LDC,   &
     &                                                        WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: VT(LDVT,*)
    REAL(WP), INTENT(INOUT) :: U(LDU,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NCVT
    INTEGER, INTENT(IN) :: NRU
    INTEGER, INTENT(IN) :: NCC
    INTEGER, INTENT(IN) :: LDVT
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SBDSQR
  PURE SUBROUTINE DBDSQR(UPLO,N,NCVT,NRU,NCC,D,E,VT,LDVT,U,LDU,C,LDC,   &
     &                                                        WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: VT(LDVT,*)
    REAL(WP), INTENT(INOUT) :: U(LDU,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NCVT
    INTEGER, INTENT(IN) :: NRU
    INTEGER, INTENT(IN) :: NCC
    INTEGER, INTENT(IN) :: LDVT
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DBDSQR
  PURE SUBROUTINE CBDSQR(UPLO,N,NCVT,NRU,NCC,D,E,VT,LDVT,U,LDU,C,LDC,   &
     &                                                        WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: VT(LDVT,*)
    COMPLEX(WP), INTENT(INOUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NCVT
    INTEGER, INTENT(IN) :: NRU
    INTEGER, INTENT(IN) :: NCC
    INTEGER, INTENT(IN) :: LDVT
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CBDSQR
  PURE SUBROUTINE ZBDSQR(UPLO,N,NCVT,NRU,NCC,D,E,VT,LDVT,U,LDU,C,LDC,   &
     &                                                        WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: VT(LDVT,*)
    COMPLEX(WP), INTENT(INOUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NCVT
    INTEGER, INTENT(IN) :: NRU
    INTEGER, INTENT(IN) :: NCC
    INTEGER, INTENT(IN) :: LDVT
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZBDSQR
END INTERFACE F77_BDSQR

INTERFACE F77_BDSDC
  PURE SUBROUTINE SBDSDC(UPLO,COMPQ,N,D,E,U,LDU,VT,LDVT,Q,IQ,WORK,IWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: VT(LDVT,*)
    REAL(WP), INTENT(OUT) :: Q(*)
    INTEGER, INTENT(OUT) :: IQ(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SBDSDC
  PURE SUBROUTINE DBDSDC(UPLO,COMPQ,N,D,E,U,LDU,VT,LDVT,Q,IQ,WORK,IWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: VT(LDVT,*)
    REAL(WP), INTENT(OUT) :: Q(*)
    INTEGER, INTENT(OUT) :: IQ(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DBDSDC
END INTERFACE F77_BDSDC

INTERFACE F77_SYTRD
  PURE SUBROUTINE SSYTRD(UPLO,N,A,LDA,D,E,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SSYTRD
  PURE SUBROUTINE DSYTRD(UPLO,N,A,LDA,D,E,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DSYTRD
END INTERFACE F77_SYTRD

INTERFACE F77_ORGTR
  PURE SUBROUTINE SORGTR(UPLO,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORGTR
  PURE SUBROUTINE DORGTR(UPLO,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORGTR
END INTERFACE F77_ORGTR

INTERFACE F77_ORMTR
  PURE SUBROUTINE SORMTR(SIDE,UPLO,TRANS,M,N,A,LDA,TAU,C,LDC,WORK,LWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORMTR
  PURE SUBROUTINE DORMTR(SIDE,UPLO,TRANS,M,N,A,LDA,TAU,C,LDC,WORK,LWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORMTR
END INTERFACE F77_ORMTR

INTERFACE F77_HETRD
  PURE SUBROUTINE CHETRD(UPLO,N,A,LDA,D,E,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CHETRD
  PURE SUBROUTINE ZHETRD(UPLO,N,A,LDA,D,E,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZHETRD
END INTERFACE F77_HETRD

INTERFACE F77_UNGTR
  PURE SUBROUTINE CUNGTR(UPLO,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNGTR
  PURE SUBROUTINE ZUNGTR(UPLO,N,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNGTR
END INTERFACE F77_UNGTR

INTERFACE F77_UNMTR
  PURE SUBROUTINE CUNMTR(SIDE,UPLO,TRANS,M,N,A,LDA,TAU,C,LDC,WORK,LWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNMTR
  PURE SUBROUTINE ZUNMTR(SIDE,UPLO,TRANS,M,N,A,LDA,TAU,C,LDC,WORK,LWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNMTR
END INTERFACE F77_UNMTR

INTERFACE F77_SPTRD
  PURE SUBROUTINE SSPTRD(UPLO,N,AP,D,E,TAU,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
  END SUBROUTINE SSPTRD
  PURE SUBROUTINE DSPTRD(UPLO,N,AP,D,E,TAU,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
  END SUBROUTINE DSPTRD
END INTERFACE F77_SPTRD

INTERFACE F77_OPGTR
  PURE SUBROUTINE SOPGTR(UPLO,N,AP,TAU,Q,LDQ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SOPGTR
  PURE SUBROUTINE DOPGTR(UPLO,N,AP,TAU,Q,LDQ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DOPGTR
END INTERFACE F77_OPGTR

INTERFACE F77_OPMTR
  PURE SUBROUTINE SOPMTR(SIDE,UPLO,TRANS,M,N,AP,TAU,C,LDC,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SOPMTR
  PURE SUBROUTINE DOPMTR(SIDE,UPLO,TRANS,M,N,AP,TAU,C,LDC,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DOPMTR
END INTERFACE F77_OPMTR

INTERFACE F77_HPTRD
  PURE SUBROUTINE CHPTRD(UPLO,N,AP,D,E,TAU,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
  END SUBROUTINE CHPTRD
  PURE SUBROUTINE ZHPTRD(UPLO,N,AP,D,E,TAU,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
  END SUBROUTINE ZHPTRD
END INTERFACE F77_HPTRD

INTERFACE F77_UPGTR
  PURE SUBROUTINE CUPGTR(UPLO,N,AP,TAU,Q,LDQ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CUPGTR
  PURE SUBROUTINE ZUPGTR(UPLO,N,AP,TAU,Q,LDQ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZUPGTR
END INTERFACE F77_UPGTR

INTERFACE F77_UPMTR
  PURE SUBROUTINE CUPMTR(SIDE,UPLO,TRANS,M,N,AP,TAU,C,LDC,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CUPMTR
  PURE SUBROUTINE ZUPMTR(SIDE,UPLO,TRANS,M,N,AP,TAU,C,LDC,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZUPMTR
END INTERFACE F77_UPMTR

INTERFACE F77_SBTRD
  PURE SUBROUTINE SSBTRD(VECT,UPLO,N,KD,AB,LDAB,D,E,Q,LDQ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSBTRD
  PURE SUBROUTINE DSBTRD(VECT,UPLO,N,KD,AB,LDAB,D,E,Q,LDQ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSBTRD
END INTERFACE F77_SBTRD

INTERFACE F77_HBTRD
  PURE SUBROUTINE CHBTRD(VECT,UPLO,N,KD,AB,LDAB,D,E,Q,LDQ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CHBTRD
  PURE SUBROUTINE ZHBTRD(VECT,UPLO,N,KD,AB,LDAB,D,E,Q,LDQ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    REAL(WP), INTENT(OUT) :: D(*)
    REAL(WP), INTENT(OUT) :: E(*)
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZHBTRD
END INTERFACE F77_HBTRD

INTERFACE F77_STERF
  PURE SUBROUTINE SSTERF(N,D,E,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SSTERF
  PURE SUBROUTINE DSTERF(N,D,E,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DSTERF
END INTERFACE F77_STERF

INTERFACE F77_STEQR
  PURE SUBROUTINE SSTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSTEQR
  PURE SUBROUTINE DSTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSTEQR
  PURE SUBROUTINE CSTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CSTEQR
  PURE SUBROUTINE ZSTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZSTEQR
END INTERFACE F77_STEQR

INTERFACE F77_STEDC
  PURE SUBROUTINE SSTEDC(COMPZ,N,D,E,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSTEDC
  PURE SUBROUTINE DSTEDC(COMPZ,N,D,E,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSTEDC
  PURE SUBROUTINE CSTEDC(COMPZ,N,D,E,Z,LDZ,WORK,LWORK,RWORK,LRWORK,     &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CSTEDC
  PURE SUBROUTINE ZSTEDC(COMPZ,N,D,E,Z,LDZ,WORK,LWORK,RWORK,LRWORK,     &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZSTEDC
END INTERFACE F77_STEDC

INTERFACE F77_STEGR
  PURE SUBROUTINE SSTEGR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ, &
     &                              ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: W(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSTEGR
  PURE SUBROUTINE DSTEGR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ, &
     &                              ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: W(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSTEGR
  PURE SUBROUTINE CSTEGR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ, &
     &                              ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CSTEGR
  PURE SUBROUTINE ZSTEGR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ, &
     &                              ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZSTEGR
END INTERFACE F77_STEGR

INTERFACE F77_PTEQR
  PURE SUBROUTINE SPTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SPTEQR
  PURE SUBROUTINE DPTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DPTEQR
  PURE SUBROUTINE CPTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CPTEQR
  PURE SUBROUTINE ZPTEQR(COMPZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZPTEQR
END INTERFACE F77_PTEQR

INTERFACE F77_STEBZ
  PURE SUBROUTINE SSTEBZ(RANGE,ORDER,N,VL,VU,IL,IU,ABSTOL,D,E,M,NSPLIT, &
     &                                  W,IBLOCK,ISPLIT,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: NSPLIT
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(OUT) :: IBLOCK(*)
    INTEGER, INTENT(OUT) :: ISPLIT(*)
    CHARACTER(LEN=1), INTENT(IN) :: ORDER
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSTEBZ
  PURE SUBROUTINE DSTEBZ(RANGE,ORDER,N,VL,VU,IL,IU,ABSTOL,D,E,M,NSPLIT, &
     &                                  W,IBLOCK,ISPLIT,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: NSPLIT
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(OUT) :: IBLOCK(*)
    INTEGER, INTENT(OUT) :: ISPLIT(*)
    CHARACTER(LEN=1), INTENT(IN) :: ORDER
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSTEBZ
END INTERFACE F77_STEBZ

INTERFACE F77_STEIN
  PURE SUBROUTINE SSTEIN(N,D,E,M,W,IBLOCK,ISPLIT,Z,LDZ,WORK,IWORK,      &
     &                                                      IFAILV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: W(*)
    INTEGER, INTENT(IN) :: IBLOCK(*)
    INTEGER, INTENT(IN) :: ISPLIT(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: IFAILV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSTEIN
  PURE SUBROUTINE DSTEIN(N,D,E,M,W,IBLOCK,ISPLIT,Z,LDZ,WORK,IWORK,      &
     &                                                      IFAILV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: W(*)
    INTEGER, INTENT(IN) :: IBLOCK(*)
    INTEGER, INTENT(IN) :: ISPLIT(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: IFAILV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSTEIN
  PURE SUBROUTINE CSTEIN(N,D,E,M,W,IBLOCK,ISPLIT,Z,LDZ,WORK,IWORK,      &
     &                                                      IFAILV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: W(*)
    INTEGER, INTENT(IN) :: IBLOCK(*)
    INTEGER, INTENT(IN) :: ISPLIT(*)
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: IFAILV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CSTEIN
  PURE SUBROUTINE ZSTEIN(N,D,E,M,W,IBLOCK,ISPLIT,Z,LDZ,WORK,IWORK,      &
     &                                                      IFAILV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: W(*)
    INTEGER, INTENT(IN) :: IBLOCK(*)
    INTEGER, INTENT(IN) :: ISPLIT(*)
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: IFAILV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZSTEIN
END INTERFACE F77_STEIN

INTERFACE F77_DISNA
  PURE SUBROUTINE SDISNA(JOB,M,N,D,SEP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(OUT) :: SEP(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SDISNA
  PURE SUBROUTINE DDISNA(JOB,M,N,D,SEP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(OUT) :: SEP(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DDISNA
END INTERFACE F77_DISNA

INTERFACE F77_SYGST
  PURE SUBROUTINE SSYGST(ITYPE,UPLO,N,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SSYGST
  PURE SUBROUTINE DSYGST(ITYPE,UPLO,N,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DSYGST
END INTERFACE F77_SYGST

INTERFACE F77_HEGST
  PURE SUBROUTINE CHEGST(ITYPE,UPLO,N,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CHEGST
  PURE SUBROUTINE ZHEGST(ITYPE,UPLO,N,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZHEGST
END INTERFACE F77_HEGST

INTERFACE F77_SPGST
  PURE SUBROUTINE SSPGST(ITYPE,UPLO,N,AP,BP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(IN) :: BP(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SSPGST
  PURE SUBROUTINE DSPGST(ITYPE,UPLO,N,AP,BP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(IN) :: BP(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DSPGST
END INTERFACE F77_SPGST

INTERFACE F77_HPGST
  PURE SUBROUTINE CHPGST(ITYPE,UPLO,N,AP,BP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: BP(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CHPGST
  PURE SUBROUTINE ZHPGST(ITYPE,UPLO,N,AP,BP,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: BP(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZHPGST
END INTERFACE F77_HPGST

INTERFACE F77_SBGST
  PURE SUBROUTINE SSBGST(VECT,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,X,LDX,WORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSBGST
  PURE SUBROUTINE DSBGST(VECT,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,X,LDX,WORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSBGST
END INTERFACE F77_SBGST

INTERFACE F77_HBGST
  PURE SUBROUTINE CHBGST(VECT,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,X,LDX,WORK,  &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: BB(LDBB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHBGST
  PURE SUBROUTINE ZHBGST(VECT,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,X,LDX,WORK,  &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: BB(LDBB,*)
    COMPLEX(WP), INTENT(OUT) :: X(LDX,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: VECT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHBGST
END INTERFACE F77_HBGST

INTERFACE F77_PBSTF
  PURE SUBROUTINE SPBSTF(UPLO,N,KB,BB,LDBB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: BB(LDBB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDBB
  END SUBROUTINE SPBSTF
  PURE SUBROUTINE DPBSTF(UPLO,N,KB,BB,LDBB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: BB(LDBB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDBB
  END SUBROUTINE DPBSTF
  PURE SUBROUTINE CPBSTF(UPLO,N,KB,BB,LDBB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: BB(LDBB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDBB
  END SUBROUTINE CPBSTF
  PURE SUBROUTINE ZPBSTF(UPLO,N,KB,BB,LDBB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: BB(LDBB,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDBB
  END SUBROUTINE ZPBSTF
END INTERFACE F77_PBSTF

INTERFACE F77_GEHRD
  PURE SUBROUTINE SGEHRD(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGEHRD
  PURE SUBROUTINE DGEHRD(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGEHRD
  PURE SUBROUTINE CGEHRD(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGEHRD
  PURE SUBROUTINE ZGEHRD(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: TAU(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGEHRD
END INTERFACE F77_GEHRD

INTERFACE F77_ORGHR
  PURE SUBROUTINE SORGHR(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORGHR
  PURE SUBROUTINE DORGHR(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORGHR
END INTERFACE F77_ORGHR

INTERFACE F77_ORMHR
  PURE SUBROUTINE SORMHR(SIDE,TRANS,M,N,ILO,IHI,A,LDA,TAU,C,LDC,WORK,   &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SORMHR
  PURE SUBROUTINE DORMHR(SIDE,TRANS,M,N,ILO,IHI,A,LDA,TAU,C,LDC,WORK,   &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DORMHR
END INTERFACE F77_ORMHR

INTERFACE F77_UNGHR
  PURE SUBROUTINE CUNGHR(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNGHR
  PURE SUBROUTINE ZUNGHR(N,ILO,IHI,A,LDA,TAU,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNGHR
END INTERFACE F77_UNGHR

INTERFACE F77_UNMHR
  PURE SUBROUTINE CUNMHR(SIDE,TRANS,M,N,ILO,IHI,A,LDA,TAU,C,LDC,WORK,   &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CUNMHR
  PURE SUBROUTINE ZUNMHR(SIDE,TRANS,M,N,ILO,IHI,A,LDA,TAU,C,LDC,WORK,   &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZUNMHR
END INTERFACE F77_UNMHR

INTERFACE F77_GEBAL
  PURE SUBROUTINE SGEBAL(JOB,N,A,LDA,ILO,IHI,SCALE,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: SCALE(*)
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SGEBAL
  PURE SUBROUTINE DGEBAL(JOB,N,A,LDA,ILO,IHI,SCALE,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: SCALE(*)
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DGEBAL
  PURE SUBROUTINE CGEBAL(JOB,N,A,LDA,ILO,IHI,SCALE,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: SCALE(*)
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CGEBAL
  PURE SUBROUTINE ZGEBAL(JOB,N,A,LDA,ILO,IHI,SCALE,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: SCALE(*)
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZGEBAL
END INTERFACE F77_GEBAL

INTERFACE F77_GEBAK
  PURE SUBROUTINE SGEBAK(JOB,SIDE,N,ILO,IHI,SCALE,M,V,LDV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: V(LDV,*)
    REAL(WP), INTENT(IN) :: SCALE(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDV
  END SUBROUTINE SGEBAK
  PURE SUBROUTINE DGEBAK(JOB,SIDE,N,ILO,IHI,SCALE,M,V,LDV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: V(LDV,*)
    REAL(WP), INTENT(IN) :: SCALE(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDV
  END SUBROUTINE DGEBAK
  PURE SUBROUTINE CGEBAK(JOB,SIDE,N,ILO,IHI,SCALE,M,V,LDV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
    REAL(WP), INTENT(IN) :: SCALE(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDV
  END SUBROUTINE CGEBAK
  PURE SUBROUTINE ZGEBAK(JOB,SIDE,N,ILO,IHI,SCALE,M,V,LDV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
    REAL(WP), INTENT(IN) :: SCALE(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDV
  END SUBROUTINE ZGEBAK
END INTERFACE F77_GEBAK

INTERFACE F77_HSEQR
  PURE SUBROUTINE SHSEQR(JOB,COMPZ,N,ILO,IHI,H,LDH,WR,WI,Z,LDZ,WORK,    &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: H(LDH,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SHSEQR
  PURE SUBROUTINE DHSEQR(JOB,COMPZ,N,ILO,IHI,H,LDH,WR,WI,Z,LDZ,WORK,    &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: H(LDH,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DHSEQR
  PURE SUBROUTINE CHSEQR(JOB,COMPZ,N,ILO,IHI,H,LDH,W,Z,LDZ,WORK,LWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: H(LDH,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CHSEQR
  PURE SUBROUTINE ZHSEQR(JOB,COMPZ,N,ILO,IHI,H,LDH,W,Z,LDZ,WORK,LWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: H(LDH,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZHSEQR
END INTERFACE F77_HSEQR

INTERFACE F77_HSEIN
  PURE SUBROUTINE SHSEIN(JOB,EIGSRC,INITV,SELECT,N,H,LDH,WR,WI,VL,LDVL, &
     &                             VR,LDVR,MM,M,WORK,IFAILL,IFAILR,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: H(LDH,*)
    REAL(WP), INTENT(INOUT) :: WR(*)
    REAL(WP), INTENT(IN) :: WI(*)
    LOGICAL, INTENT(INOUT) :: SELECT(*)
    REAL(WP), INTENT(INOUT) :: VL(LDVL,*)
    REAL(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: IFAILL(*)
    INTEGER, INTENT(OUT) :: IFAILR(*)
    CHARACTER(LEN=1), INTENT(IN) :: INITV
    CHARACTER(LEN=1), INTENT(IN) :: EIGSRC
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SHSEIN
  PURE SUBROUTINE DHSEIN(JOB,EIGSRC,INITV,SELECT,N,H,LDH,WR,WI,VL,LDVL, &
     &                             VR,LDVR,MM,M,WORK,IFAILL,IFAILR,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: H(LDH,*)
    REAL(WP), INTENT(INOUT) :: WR(*)
    REAL(WP), INTENT(IN) :: WI(*)
    LOGICAL, INTENT(INOUT) :: SELECT(*)
    REAL(WP), INTENT(INOUT) :: VL(LDVL,*)
    REAL(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: IFAILL(*)
    INTEGER, INTENT(OUT) :: IFAILR(*)
    CHARACTER(LEN=1), INTENT(IN) :: INITV
    CHARACTER(LEN=1), INTENT(IN) :: EIGSRC
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DHSEIN
  PURE SUBROUTINE CHSEIN(JOB,EIGSRC,INITV,SELECT,N,H,LDH,W,VL,LDVL,VR,  &
     &                          LDVR,MM,M,WORK,RWORK,IFAILL,IFAILR,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: H(LDH,*)
    COMPLEX(WP), INTENT(INOUT) :: W(*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: IFAILL(*)
    INTEGER, INTENT(OUT) :: IFAILR(*)
    CHARACTER(LEN=1), INTENT(IN) :: INITV
    CHARACTER(LEN=1), INTENT(IN) :: EIGSRC
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHSEIN
  PURE SUBROUTINE ZHSEIN(JOB,EIGSRC,INITV,SELECT,N,H,LDH,W,VL,LDVL,VR,  &
     &                          LDVR,MM,M,WORK,RWORK,IFAILL,IFAILR,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: H(LDH,*)
    COMPLEX(WP), INTENT(INOUT) :: W(*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: IFAILL(*)
    INTEGER, INTENT(OUT) :: IFAILR(*)
    CHARACTER(LEN=1), INTENT(IN) :: INITV
    CHARACTER(LEN=1), INTENT(IN) :: EIGSRC
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHSEIN
END INTERFACE F77_HSEIN

INTERFACE F77_TREVC
  PURE SUBROUTINE STREVC(SIDE,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,MM, &
     &                                                      M,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: T(LDT,*)
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    LOGICAL, INTENT(INOUT) :: SELECT(*)
    REAL(WP), INTENT(INOUT) :: VL(LDVL,*)
    REAL(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE STREVC
  PURE SUBROUTINE DTREVC(SIDE,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,MM, &
     &                                                      M,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: T(LDT,*)
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    LOGICAL, INTENT(INOUT) :: SELECT(*)
    REAL(WP), INTENT(INOUT) :: VL(LDVL,*)
    REAL(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DTREVC
  PURE SUBROUTINE CTREVC(SIDE,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,MM, &
     &                                                M,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: T(LDT,*)
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTREVC
  PURE SUBROUTINE ZTREVC(SIDE,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,MM, &
     &                                                M,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: T(LDT,*)
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTREVC
END INTERFACE F77_TREVC

INTERFACE F77_TRSNA
  PURE SUBROUTINE STRSNA(JOB,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,S,   &
     &                                  SEP,MM,M,WORK,LDWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: T(LDT,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SEP(*)
    REAL(WP), INTENT(IN) :: VL(LDVL,*)
    REAL(WP), INTENT(IN) :: VR(LDVR,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(IN) :: WORK(LDWORK,*)
    INTEGER, INTENT(IN) :: LDWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STRSNA
  PURE SUBROUTINE DTRSNA(JOB,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,S,   &
     &                                  SEP,MM,M,WORK,LDWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: T(LDT,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SEP(*)
    REAL(WP), INTENT(IN) :: VL(LDVL,*)
    REAL(WP), INTENT(IN) :: VR(LDVR,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(IN) :: WORK(LDWORK,*)
    INTEGER, INTENT(IN) :: LDWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTRSNA
  PURE SUBROUTINE CTRSNA(JOB,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,S,   &
     &                                  SEP,MM,M,WORK,LDWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: T(LDT,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SEP(*)
    COMPLEX(WP), INTENT(IN) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(IN) :: VR(LDVR,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(IN) :: WORK(LDWORK,*)
    INTEGER, INTENT(IN) :: LDWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTRSNA
  PURE SUBROUTINE ZTRSNA(JOB,HOWMNY,SELECT,N,T,LDT,VL,LDVL,VR,LDVR,S,   &
     &                                  SEP,MM,M,WORK,LDWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: T(LDT,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: SEP(*)
    COMPLEX(WP), INTENT(IN) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(IN) :: VR(LDVR,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(IN) :: WORK(LDWORK,*)
    INTEGER, INTENT(IN) :: LDWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTRSNA
END INTERFACE F77_TRSNA

INTERFACE F77_TREXC
  PURE SUBROUTINE STREXC(COMPQ,N,T,LDT,Q,LDQ,IFST,ILST,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: T(LDT,*)
    INTEGER, INTENT(INOUT) :: IFST
    INTEGER, INTENT(INOUT) :: ILST
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE STREXC
  PURE SUBROUTINE DTREXC(COMPQ,N,T,LDT,Q,LDQ,IFST,ILST,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: T(LDT,*)
    INTEGER, INTENT(INOUT) :: IFST
    INTEGER, INTENT(INOUT) :: ILST
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DTREXC
  PURE SUBROUTINE CTREXC(COMPQ,N,T,LDT,Q,LDQ,IFST,ILST,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: T(LDT,*)
    INTEGER, INTENT(IN) :: IFST
    INTEGER, INTENT(IN) :: ILST
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
  END SUBROUTINE CTREXC
  PURE SUBROUTINE ZTREXC(COMPQ,N,T,LDT,Q,LDQ,IFST,ILST,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: T(LDT,*)
    INTEGER, INTENT(IN) :: IFST
    INTEGER, INTENT(IN) :: ILST
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
  END SUBROUTINE ZTREXC
END INTERFACE F77_TREXC

INTERFACE F77_TRSEN
  PURE SUBROUTINE STRSEN(JOB,COMPQ,SELECT,N,T,LDT,Q,LDQ,WR,WI,M,S,SEP,  &
     &                                     WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: T(LDT,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    INTEGER, INTENT(OUT) :: M
    REAL(WP), INTENT(OUT) :: S
    REAL(WP), INTENT(OUT) :: SEP
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE STRSEN
  PURE SUBROUTINE DTRSEN(JOB,COMPQ,SELECT,N,T,LDT,Q,LDQ,WR,WI,M,S,SEP,  &
     &                                     WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: T(LDT,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    INTEGER, INTENT(OUT) :: M
    REAL(WP), INTENT(OUT) :: S
    REAL(WP), INTENT(OUT) :: SEP
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DTRSEN
  PURE SUBROUTINE CTRSEN(JOB,COMPQ,SELECT,N,T,LDT,Q,LDQ,W,M,S,SEP,WORK, &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: T(LDT,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(OUT) :: M
    REAL(WP), INTENT(OUT) :: S
    REAL(WP), INTENT(OUT) :: SEP
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CTRSEN
  PURE SUBROUTINE ZTRSEN(JOB,COMPQ,SELECT,N,T,LDT,Q,LDQ,W,M,S,SEP,WORK, &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: T(LDT,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(OUT) :: M
    REAL(WP), INTENT(OUT) :: S
    REAL(WP), INTENT(OUT) :: SEP
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZTRSEN
END INTERFACE F77_TRSEN

INTERFACE F77_TRSYL
  PURE SUBROUTINE STRSYL(TRANA,TRANB,ISGN,M,N,A,LDA,B,LDB,C,LDC,SCALE,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(OUT) :: SCALE
    CHARACTER(LEN=1), INTENT(IN) :: TRANA
    CHARACTER(LEN=1), INTENT(IN) :: TRANB
    INTEGER, INTENT(IN) :: ISGN
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE STRSYL
  PURE SUBROUTINE DTRSYL(TRANA,TRANB,ISGN,M,N,A,LDA,B,LDB,C,LDC,SCALE,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(OUT) :: SCALE
    CHARACTER(LEN=1), INTENT(IN) :: TRANA
    CHARACTER(LEN=1), INTENT(IN) :: TRANB
    INTEGER, INTENT(IN) :: ISGN
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE DTRSYL
  PURE SUBROUTINE CTRSYL(TRANA,TRANB,ISGN,M,N,A,LDA,B,LDB,C,LDC,SCALE,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(OUT) :: SCALE
    CHARACTER(LEN=1), INTENT(IN) :: TRANA
    CHARACTER(LEN=1), INTENT(IN) :: TRANB
    INTEGER, INTENT(IN) :: ISGN
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CTRSYL
  PURE SUBROUTINE ZTRSYL(TRANA,TRANB,ISGN,M,N,A,LDA,B,LDB,C,LDC,SCALE,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(OUT) :: SCALE
    CHARACTER(LEN=1), INTENT(IN) :: TRANA
    CHARACTER(LEN=1), INTENT(IN) :: TRANB
    INTEGER, INTENT(IN) :: ISGN
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZTRSYL
END INTERFACE F77_TRSYL

INTERFACE F77_GGHRD
  PURE SUBROUTINE SGGHRD(COMPQ,COMPZ,N,ILO,IHI,A,LDA,B,LDB,Q,LDQ,Z,LDZ, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
  END SUBROUTINE SGGHRD
  PURE SUBROUTINE DGGHRD(COMPQ,COMPZ,N,ILO,IHI,A,LDA,B,LDB,Q,LDQ,Z,LDZ, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
  END SUBROUTINE DGGHRD
  PURE SUBROUTINE CGGHRD(COMPQ,COMPZ,N,ILO,IHI,A,LDA,B,LDB,Q,LDQ,Z,LDZ, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
  END SUBROUTINE CGGHRD
  PURE SUBROUTINE ZGGHRD(COMPQ,COMPZ,N,ILO,IHI,A,LDA,B,LDB,Q,LDQ,Z,LDZ, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
  END SUBROUTINE ZGGHRD
END INTERFACE F77_GGHRD

INTERFACE F77_GGBAL
  PURE SUBROUTINE SGGBAL(JOB,N,A,LDA,B,LDB,ILO,IHI,LSCALE,RSCALE,WORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: LSCALE(*)
    REAL(WP), INTENT(OUT) :: RSCALE(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SGGBAL
  PURE SUBROUTINE DGGBAL(JOB,N,A,LDA,B,LDB,ILO,IHI,LSCALE,RSCALE,WORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: LSCALE(*)
    REAL(WP), INTENT(OUT) :: RSCALE(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DGGBAL
  PURE SUBROUTINE CGGBAL(JOB,N,A,LDA,B,LDB,ILO,IHI,LSCALE,RSCALE,WORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: LSCALE(*)
    REAL(WP), INTENT(OUT) :: RSCALE(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CGGBAL
  PURE SUBROUTINE ZGGBAL(JOB,N,A,LDA,B,LDB,ILO,IHI,LSCALE,RSCALE,WORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: LSCALE(*)
    REAL(WP), INTENT(OUT) :: RSCALE(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZGGBAL
END INTERFACE F77_GGBAL

INTERFACE F77_GGBAK
  PURE SUBROUTINE SGGBAK(JOB,SIDE,N,ILO,IHI,LSCALE,RSCALE,M,V,LDV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: V(LDV,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(IN) :: LSCALE(*)
    REAL(WP), INTENT(IN) :: RSCALE(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDV
  END SUBROUTINE SGGBAK
  PURE SUBROUTINE DGGBAK(JOB,SIDE,N,ILO,IHI,LSCALE,RSCALE,M,V,LDV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: V(LDV,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(IN) :: LSCALE(*)
    REAL(WP), INTENT(IN) :: RSCALE(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDV
  END SUBROUTINE DGGBAK
  PURE SUBROUTINE CGGBAK(JOB,SIDE,N,ILO,IHI,LSCALE,RSCALE,M,V,LDV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(IN) :: LSCALE(*)
    REAL(WP), INTENT(IN) :: RSCALE(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDV
  END SUBROUTINE CGGBAK
  PURE SUBROUTINE ZGGBAK(JOB,SIDE,N,ILO,IHI,LSCALE,RSCALE,M,V,LDV,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(IN) :: LSCALE(*)
    REAL(WP), INTENT(IN) :: RSCALE(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: LDV
  END SUBROUTINE ZGGBAK
END INTERFACE F77_GGBAK

INTERFACE F77_HGEQZ
  PURE SUBROUTINE SHGEQZ(JOB,COMPQ,COMPZ,N,ILO,IHI,H,LDH,T,LDT,ALPHAR,  &
     &                          ALPHAI,BETA,Q,LDQ,Z,LDZ,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: H(LDH,*)
    REAL(WP), INTENT(INOUT) :: T(LDT,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SHGEQZ
  PURE SUBROUTINE DHGEQZ(JOB,COMPQ,COMPZ,N,ILO,IHI,H,LDH,T,LDT,ALPHAR,  &
     &                          ALPHAI,BETA,Q,LDQ,Z,LDZ,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: H(LDH,*)
    REAL(WP), INTENT(INOUT) :: T(LDT,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DHGEQZ
  PURE SUBROUTINE CHGEQZ(JOB,COMPQ,COMPZ,N,ILO,IHI,H,LDH,T,LDT,ALPHA,   &
     &                           BETA,Q,LDQ,Z,LDZ,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: H(LDH,*)
    COMPLEX(WP), INTENT(INOUT) :: T(LDT,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHGEQZ
  PURE SUBROUTINE ZHGEQZ(JOB,COMPQ,COMPZ,N,ILO,IHI,H,LDH,T,LDT,ALPHA,   &
     &                           BETA,Q,LDQ,Z,LDZ,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: H(LDH,*)
    COMPLEX(WP), INTENT(INOUT) :: T(LDT,*)
    INTEGER, INTENT(IN) :: ILO
    INTEGER, INTENT(IN) :: IHI
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: COMPQ
    CHARACTER(LEN=1), INTENT(IN) :: COMPZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDH
    INTEGER, INTENT(IN) :: LDT
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHGEQZ
END INTERFACE F77_HGEQZ

INTERFACE F77_TGEVC
  PURE SUBROUTINE STGEVC(SIDE,HOWMNY,SELECT,N,S,LDS,P,LDP,VL,LDVL,VR,   &
     &                                              LDVR,MM,M,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: S(LDS,*)
    REAL(WP), INTENT(IN) :: P(LDP,*)
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    LOGICAL, INTENT(IN) :: SELECT(*)
    REAL(WP), INTENT(INOUT) :: VL(LDVL,*)
    REAL(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDS
    INTEGER, INTENT(IN) :: LDP
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE STGEVC
  PURE SUBROUTINE DTGEVC(SIDE,HOWMNY,SELECT,N,S,LDS,P,LDP,VL,LDVL,VR,   &
     &                                              LDVR,MM,M,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: S(LDS,*)
    REAL(WP), INTENT(IN) :: P(LDP,*)
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    LOGICAL, INTENT(IN) :: SELECT(*)
    REAL(WP), INTENT(INOUT) :: VL(LDVL,*)
    REAL(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDS
    INTEGER, INTENT(IN) :: LDP
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DTGEVC
  PURE SUBROUTINE CTGEVC(SIDE,HOWMNY,SELECT,N,S,LDS,P,LDP,VL,LDVL,VR,   &
     &                                        LDVR,MM,M,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: S(LDS,*)
    COMPLEX(WP), INTENT(IN) :: P(LDP,*)
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDS
    INTEGER, INTENT(IN) :: LDP
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTGEVC
  PURE SUBROUTINE ZTGEVC(SIDE,HOWMNY,SELECT,N,S,LDS,P,LDP,VL,LDVL,VR,   &
     &                                        LDVR,MM,M,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: S(LDS,*)
    COMPLEX(WP), INTENT(IN) :: P(LDP,*)
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(INOUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(INOUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDS
    INTEGER, INTENT(IN) :: LDP
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTGEVC
END INTERFACE F77_TGEVC

INTERFACE F77_TGEXC
  PURE SUBROUTINE STGEXC(WANTQ,WANTZ,N,A,LDA,B,LDB,Q,LDQ,Z,LDZ,IFST,    &
     &                                             ILST,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(INOUT) :: IFST
    INTEGER, INTENT(INOUT) :: ILST
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    LOGICAL, INTENT(IN) :: WANTQ
    LOGICAL, INTENT(IN) :: WANTZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE STGEXC
  PURE SUBROUTINE DTGEXC(WANTQ,WANTZ,N,A,LDA,B,LDB,Q,LDQ,Z,LDZ,IFST,    &
     &                                             ILST,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(INOUT) :: IFST
    INTEGER, INTENT(INOUT) :: ILST
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    LOGICAL, INTENT(IN) :: WANTQ
    LOGICAL, INTENT(IN) :: WANTZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DTGEXC
  PURE SUBROUTINE CTGEXC(WANTQ,WANTZ,N,A,LDA,B,LDB,Q,LDQ,Z,LDZ,IFST,    &
     &                                                        ILST,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(INOUT) :: IFST
    INTEGER, INTENT(INOUT) :: ILST
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    LOGICAL, INTENT(IN) :: WANTQ
    LOGICAL, INTENT(IN) :: WANTZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
  END SUBROUTINE CTGEXC
  PURE SUBROUTINE ZTGEXC(WANTQ,WANTZ,N,A,LDA,B,LDB,Q,LDQ,Z,LDZ,IFST,    &
     &                                                        ILST,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(INOUT) :: IFST
    INTEGER, INTENT(INOUT) :: ILST
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    LOGICAL, INTENT(IN) :: WANTQ
    LOGICAL, INTENT(IN) :: WANTZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
  END SUBROUTINE ZTGEXC
END INTERFACE F77_TGEXC

INTERFACE F77_TGSEN
  PURE SUBROUTINE STGSEN(IJOB,WANTQ,WANTZ,SELECT,N,A,LDA,B,LDB,ALPHAR,  &
     & ALPHAI,BETA,Q,LDQ,Z,LDZ,M,PL,PR,DIF,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(IN) :: IJOB
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    REAL(WP), INTENT(OUT) :: PL
    REAL(WP), INTENT(OUT) :: PR
    REAL(WP), INTENT(OUT) :: DIF(2)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    LOGICAL, INTENT(IN) :: WANTQ
    LOGICAL, INTENT(IN) :: WANTZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE STGSEN
  PURE SUBROUTINE DTGSEN(IJOB,WANTQ,WANTZ,SELECT,N,A,LDA,B,LDB,ALPHAR,  &
     & ALPHAI,BETA,Q,LDQ,Z,LDZ,M,PL,PR,DIF,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(IN) :: IJOB
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    REAL(WP), INTENT(INOUT) :: Z(LDZ,*)
    REAL(WP), INTENT(OUT) :: PL
    REAL(WP), INTENT(OUT) :: PR
    REAL(WP), INTENT(OUT) :: DIF(2)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    LOGICAL, INTENT(IN) :: WANTQ
    LOGICAL, INTENT(IN) :: WANTZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DTGSEN
  PURE SUBROUTINE CTGSEN(IJOB,WANTQ,WANTZ,SELECT,N,A,LDA,B,LDB,ALPHA,   &
     &        BETA,Q,LDQ,Z,LDZ,M,PL,PR,DIF,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(IN) :: IJOB
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    REAL(WP), INTENT(OUT) :: PL
    REAL(WP), INTENT(OUT) :: PR
    REAL(WP), INTENT(OUT) :: DIF(2)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    LOGICAL, INTENT(IN) :: WANTQ
    LOGICAL, INTENT(IN) :: WANTZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CTGSEN
  PURE SUBROUTINE ZTGSEN(IJOB,WANTQ,WANTZ,SELECT,N,A,LDA,B,LDB,ALPHA,   &
     &        BETA,Q,LDQ,Z,LDZ,M,PL,PR,DIF,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(IN) :: IJOB
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    COMPLEX(WP), INTENT(INOUT) :: Z(LDZ,*)
    REAL(WP), INTENT(OUT) :: PL
    REAL(WP), INTENT(OUT) :: PR
    REAL(WP), INTENT(OUT) :: DIF(2)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    LOGICAL, INTENT(IN) :: WANTQ
    LOGICAL, INTENT(IN) :: WANTZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZTGSEN
END INTERFACE F77_TGSEN

INTERFACE F77_TGSYL
  PURE SUBROUTINE STGSYL(TRANS,IJOB,M,N,A,LDA,B,LDB,C,LDC,D,LDD,E,LDE,F,&
     &                              LDF,SCALE,DIF,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(IN) :: D(LDD,*)
    REAL(WP), INTENT(IN) :: E(LDE,*)
    REAL(WP), INTENT(INOUT) :: F(LDF,*)
    INTEGER, INTENT(IN) :: IJOB
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: SCALE
    REAL(WP), INTENT(OUT) :: DIF
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
    INTEGER, INTENT(IN) :: LDD
    INTEGER, INTENT(IN) :: LDE
    INTEGER, INTENT(IN) :: LDF
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STGSYL
  PURE SUBROUTINE DTGSYL(TRANS,IJOB,M,N,A,LDA,B,LDB,C,LDC,D,LDD,E,LDE,F,&
     &                              LDF,SCALE,DIF,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    REAL(WP), INTENT(IN) :: D(LDD,*)
    REAL(WP), INTENT(IN) :: E(LDE,*)
    REAL(WP), INTENT(INOUT) :: F(LDF,*)
    INTEGER, INTENT(IN) :: IJOB
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: SCALE
    REAL(WP), INTENT(OUT) :: DIF
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
    INTEGER, INTENT(IN) :: LDD
    INTEGER, INTENT(IN) :: LDE
    INTEGER, INTENT(IN) :: LDF
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTGSYL
  PURE SUBROUTINE CTGSYL(TRANS,IJOB,M,N,A,LDA,B,LDB,C,LDC,D,LDD,E,LDE,F,&
     &                              LDF,SCALE,DIF,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    COMPLEX(WP), INTENT(IN) :: D(LDD,*)
    COMPLEX(WP), INTENT(IN) :: E(LDE,*)
    COMPLEX(WP), INTENT(INOUT) :: F(LDF,*)
    INTEGER, INTENT(IN) :: IJOB
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: SCALE
    REAL(WP), INTENT(OUT) :: DIF
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
    INTEGER, INTENT(IN) :: LDD
    INTEGER, INTENT(IN) :: LDE
    INTEGER, INTENT(IN) :: LDF
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CTGSYL
  PURE SUBROUTINE ZTGSYL(TRANS,IJOB,M,N,A,LDA,B,LDB,C,LDC,D,LDD,E,LDE,F,&
     &                              LDF,SCALE,DIF,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    COMPLEX(WP), INTENT(IN) :: D(LDD,*)
    COMPLEX(WP), INTENT(IN) :: E(LDE,*)
    COMPLEX(WP), INTENT(INOUT) :: F(LDF,*)
    INTEGER, INTENT(IN) :: IJOB
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: SCALE
    REAL(WP), INTENT(OUT) :: DIF
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
    INTEGER, INTENT(IN) :: LDD
    INTEGER, INTENT(IN) :: LDE
    INTEGER, INTENT(IN) :: LDF
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZTGSYL
END INTERFACE F77_TGSYL

INTERFACE F77_TGSNA
  PURE SUBROUTINE STGSNA(JOB,HOWMNY,SELECT,N,A,LDA,B,LDB,VL,LDVL,VR,    &
     &                            LDVR,S,DIF,MM,M,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: DIF(*)
    REAL(WP), INTENT(IN) :: VL(LDVL,*)
    REAL(WP), INTENT(IN) :: VR(LDVR,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STGSNA
  PURE SUBROUTINE DTGSNA(JOB,HOWMNY,SELECT,N,A,LDA,B,LDB,VL,LDVL,VR,    &
     &                            LDVR,S,DIF,MM,M,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: DIF(*)
    REAL(WP), INTENT(IN) :: VL(LDVL,*)
    REAL(WP), INTENT(IN) :: VR(LDVR,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTGSNA
  PURE SUBROUTINE CTGSNA(JOB,HOWMNY,SELECT,N,A,LDA,B,LDB,VL,LDVL,VR,    &
     &                            LDVR,S,DIF,MM,M,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: DIF(*)
    COMPLEX(WP), INTENT(IN) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(IN) :: VR(LDVR,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CTGSNA
  PURE SUBROUTINE ZTGSNA(JOB,HOWMNY,SELECT,N,A,LDA,B,LDB,VL,LDVL,VR,    &
     &                            LDVR,S,DIF,MM,M,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: DIF(*)
    COMPLEX(WP), INTENT(IN) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(IN) :: VR(LDVR,*)
    LOGICAL, INTENT(IN) :: SELECT(*)
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOB
    CHARACTER(LEN=1), INTENT(IN) :: HOWMNY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    INTEGER, INTENT(IN) :: MM
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZTGSNA
END INTERFACE F77_TGSNA

INTERFACE F77_GGSVP
  PURE SUBROUTINE SGGSVP(JOBU,JOBV,JOBQ,M,P,N,A,LDA,B,LDB,TOLA,TOLB,K,L,&
     &                            U,LDU,V,LDV,Q,LDQ,IWORK,TAU,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: TOLA
    REAL(WP), INTENT(IN) :: TOLB
    INTEGER, INTENT(OUT) :: K
    INTEGER, INTENT(OUT) :: L
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: V(LDV,*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: IWORK(*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SGGSVP
  PURE SUBROUTINE DGGSVP(JOBU,JOBV,JOBQ,M,P,N,A,LDA,B,LDB,TOLA,TOLB,K,L,&
     &                            U,LDU,V,LDV,Q,LDQ,IWORK,TAU,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: TOLA
    REAL(WP), INTENT(IN) :: TOLB
    INTEGER, INTENT(OUT) :: K
    INTEGER, INTENT(OUT) :: L
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: V(LDV,*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: IWORK(*)
    REAL(WP), INTENT(IN) :: TAU(*)
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DGGSVP
  PURE SUBROUTINE CGGSVP(JOBU,JOBV,JOBQ,M,P,N,A,LDA,B,LDB,TOLA,TOLB,K,L,&
     &                      U,LDU,V,LDV,Q,LDQ,IWORK,RWORK,TAU,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: TOLA
    REAL(WP), INTENT(IN) :: TOLB
    INTEGER, INTENT(OUT) :: K
    INTEGER, INTENT(OUT) :: L
    COMPLEX(WP), INTENT(OUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(OUT) :: V(LDV,*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: IWORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CGGSVP
  PURE SUBROUTINE ZGGSVP(JOBU,JOBV,JOBQ,M,P,N,A,LDA,B,LDB,TOLA,TOLB,K,L,&
     &                      U,LDU,V,LDV,Q,LDQ,IWORK,RWORK,TAU,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: TOLA
    REAL(WP), INTENT(IN) :: TOLB
    INTEGER, INTENT(OUT) :: K
    INTEGER, INTENT(OUT) :: L
    COMPLEX(WP), INTENT(OUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(OUT) :: V(LDV,*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: IWORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    COMPLEX(WP), INTENT(IN) :: TAU(*)
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZGGSVP
END INTERFACE F77_GGSVP

INTERFACE F77_TGSJA
  PURE SUBROUTINE STGSJA(JOBU,JOBV,JOBQ,M,P,N,K,L,A,LDA,B,LDB,TOLA,TOLB,&
     &                    ALPHA,BETA,U,LDU,V,LDV,Q,LDQ,WORK,NCYCLE,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: TOLA
    REAL(WP), INTENT(IN) :: TOLB
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: L
    REAL(WP), INTENT(INOUT) :: U(LDU,*)
    REAL(WP), INTENT(INOUT) :: V(LDV,*)
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    REAL(WP), INTENT(OUT) :: ALPHA(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(OUT) :: NCYCLE
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE STGSJA
  PURE SUBROUTINE DTGSJA(JOBU,JOBV,JOBQ,M,P,N,K,L,A,LDA,B,LDB,TOLA,TOLB,&
     &                    ALPHA,BETA,U,LDU,V,LDV,Q,LDQ,WORK,NCYCLE,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: TOLA
    REAL(WP), INTENT(IN) :: TOLB
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: L
    REAL(WP), INTENT(INOUT) :: U(LDU,*)
    REAL(WP), INTENT(INOUT) :: V(LDV,*)
    REAL(WP), INTENT(INOUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    REAL(WP), INTENT(OUT) :: ALPHA(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(OUT) :: NCYCLE
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DTGSJA
  PURE SUBROUTINE CTGSJA(JOBU,JOBV,JOBQ,M,P,N,K,L,A,LDA,B,LDB,TOLA,TOLB,&
     &                    ALPHA,BETA,U,LDU,V,LDV,Q,LDQ,WORK,NCYCLE,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: TOLA
    REAL(WP), INTENT(IN) :: TOLB
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: L
    COMPLEX(WP), INTENT(INOUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    REAL(WP), INTENT(OUT) :: ALPHA(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(OUT) :: NCYCLE
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE CTGSJA
  PURE SUBROUTINE ZTGSJA(JOBU,JOBV,JOBQ,M,P,N,K,L,A,LDA,B,LDB,TOLA,TOLB,&
     &                    ALPHA,BETA,U,LDU,V,LDV,Q,LDQ,WORK,NCYCLE,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(IN) :: TOLA
    REAL(WP), INTENT(IN) :: TOLB
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: L
    COMPLEX(WP), INTENT(INOUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(INOUT) :: V(LDV,*)
    COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    REAL(WP), INTENT(OUT) :: ALPHA(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(OUT) :: NCYCLE
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE ZTGSJA
END INTERFACE F77_TGSJA

INTERFACE F77_GELS
  PURE SUBROUTINE SGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGELS
  PURE SUBROUTINE DGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGELS
  PURE SUBROUTINE CGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGELS
  PURE SUBROUTINE ZGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGELS
END INTERFACE F77_GELS

INTERFACE F77_GELSY
  PURE SUBROUTINE SGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,     &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGELSY
  PURE SUBROUTINE DGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,     &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGELSY
  PURE SUBROUTINE CGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,     &
     &                                                 LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGELSY
  PURE SUBROUTINE ZGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,     &
     &                                                 LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGELSY
END INTERFACE F77_GELSY

INTERFACE F77_GELSS
  PURE SUBROUTINE SGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGELSS
  PURE SUBROUTINE DGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGELSS
  PURE SUBROUTINE CGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGELSS
  PURE SUBROUTINE ZGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGELSS
END INTERFACE F77_GELSS

INTERFACE F77_GELSD
  PURE SUBROUTINE SGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGELSD
  PURE SUBROUTINE DGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGELSD
  PURE SUBROUTINE CGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                 RWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CGELSD
  PURE SUBROUTINE ZGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                 RWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZGELSD
END INTERFACE F77_GELSD

INTERFACE F77_GGLSE
  PURE SUBROUTINE SGGLSE(M,N,P,A,LDA,B,LDB,C,D,X,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGGLSE
  PURE SUBROUTINE DGGLSE(M,N,P,A,LDA,B,LDB,C,D,X,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGGLSE
  PURE SUBROUTINE CGGLSE(M,N,P,A,LDA,B,LDB,C,D,X,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGGLSE
  PURE SUBROUTINE ZGGLSE(M,N,P,A,LDA,B,LDB,C,D,X,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGGLSE
END INTERFACE F77_GGLSE

INTERFACE F77_GGGLM
  PURE SUBROUTINE SGGGLM(N,M,P,A,LDA,B,LDB,D,X,Y,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(OUT) :: Y(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGGGLM
  PURE SUBROUTINE DGGGLM(N,M,P,A,LDA,B,LDB,D,X,Y,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(OUT) :: Y(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGGGLM
  PURE SUBROUTINE CGGGLM(N,M,P,A,LDA,B,LDB,D,X,Y,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    COMPLEX(WP), INTENT(OUT) :: Y(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGGGLM
  PURE SUBROUTINE ZGGGLM(N,M,P,A,LDA,B,LDB,D,X,Y,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    COMPLEX(WP), INTENT(OUT) :: Y(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGGGLM
END INTERFACE F77_GGGLM

INTERFACE F77_SYEV
  PURE SUBROUTINE SSYEV(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SSYEV
  PURE SUBROUTINE DSYEV(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DSYEV
END INTERFACE F77_SYEV

INTERFACE F77_HEEV
  PURE SUBROUTINE CHEEV(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHEEV
  PURE SUBROUTINE ZHEEV(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHEEV
END INTERFACE F77_HEEV

INTERFACE F77_SYEVD
  PURE SUBROUTINE SSYEVD(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,IWORK,LIWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSYEVD
  PURE SUBROUTINE DSYEVD(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,IWORK,LIWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSYEVD
END INTERFACE F77_SYEVD

INTERFACE F77_HEEVD
  PURE SUBROUTINE CHEEVD(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,RWORK,LRWORK,   &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CHEEVD
  PURE SUBROUTINE ZHEEVD(JOBZ,UPLO,N,A,LDA,W,WORK,LWORK,RWORK,LRWORK,   &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZHEEVD
END INTERFACE F77_HEEVD

INTERFACE F77_SYEVX
  PURE SUBROUTINE SSYEVX(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,&
     &                                Z,LDZ,WORK,LWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSYEVX
  PURE SUBROUTINE DSYEVX(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,&
     &                                Z,LDZ,WORK,LWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSYEVX
END INTERFACE F77_SYEVX

INTERFACE F77_HEEVX
  PURE SUBROUTINE CHEEVX(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,&
     &                          Z,LDZ,WORK,LWORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CHEEVX
  PURE SUBROUTINE ZHEEVX(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,&
     &                          Z,LDZ,WORK,LWORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZHEEVX
END INTERFACE F77_HEEVX

INTERFACE F77_SYEVR
  PURE SUBROUTINE SSYEVR(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,&
     &                        Z,LDZ,ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSYEVR
  PURE SUBROUTINE DSYEVR(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,&
     &                        Z,LDZ,ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSYEVR
END INTERFACE F77_SYEVR

INTERFACE F77_HEEVR
  PURE SUBROUTINE CHEEVR(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,&
     &           Z,LDZ,ISUPPZ,WORK,LWORK,RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CHEEVR
  PURE SUBROUTINE ZHEEVR(JOBZ,RANGE,UPLO,N,A,LDA,VL,VU,IL,IU,ABSTOL,M,W,&
     &           Z,LDZ,ISUPPZ,WORK,LWORK,RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZHEEVR
END INTERFACE F77_HEEVR

INTERFACE F77_SPEV
  PURE SUBROUTINE SSPEV(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSPEV
  PURE SUBROUTINE DSPEV(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSPEV
END INTERFACE F77_SPEV

INTERFACE F77_HPEV
  PURE SUBROUTINE CHPEV(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHPEV
  PURE SUBROUTINE ZHPEV(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHPEV
END INTERFACE F77_HPEV

INTERFACE F77_SPEVD
  PURE SUBROUTINE SSPEVD(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,LWORK,IWORK,LIWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSPEVD
  PURE SUBROUTINE DSPEVD(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,LWORK,IWORK,LIWORK,&
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSPEVD
END INTERFACE F77_SPEVD

INTERFACE F77_HPEVD
  PURE SUBROUTINE CHPEVD(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,LWORK,RWORK,LRWORK,&
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CHPEVD
  PURE SUBROUTINE ZHPEVD(JOBZ,UPLO,N,AP,W,Z,LDZ,WORK,LWORK,RWORK,LRWORK,&
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZHPEVD
END INTERFACE F77_HPEVD

INTERFACE F77_SPEVX
  PURE SUBROUTINE SSPEVX(JOBZ,RANGE,UPLO,N,AP,VL,VU,IL,IU,ABSTOL,M,W,Z, &
     &                                        LDZ,WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSPEVX
  PURE SUBROUTINE DSPEVX(JOBZ,RANGE,UPLO,N,AP,VL,VU,IL,IU,ABSTOL,M,W,Z, &
     &                                        LDZ,WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSPEVX
END INTERFACE F77_SPEVX

INTERFACE F77_HPEVX
  PURE SUBROUTINE CHPEVX(JOBZ,RANGE,UPLO,N,AP,VL,VU,IL,IU,ABSTOL,M,W,Z, &
     &                                  LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CHPEVX
  PURE SUBROUTINE ZHPEVX(JOBZ,RANGE,UPLO,N,AP,VL,VU,IL,IU,ABSTOL,M,W,Z, &
     &                                  LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZHPEVX
END INTERFACE F77_HPEVX

INTERFACE F77_SBEV
  PURE SUBROUTINE SSBEV(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSBEV
  PURE SUBROUTINE DSBEV(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSBEV
END INTERFACE F77_SBEV

INTERFACE F77_HBEV
  PURE SUBROUTINE CHBEV(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHBEV
  PURE SUBROUTINE ZHBEV(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHBEV
END INTERFACE F77_HBEV

INTERFACE F77_SBEVD
  PURE SUBROUTINE SSBEVD(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,LWORK,     &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSBEVD
  PURE SUBROUTINE DSBEVD(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,LWORK,     &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSBEVD
END INTERFACE F77_SBEVD

INTERFACE F77_HBEVD
  PURE SUBROUTINE CHBEVD(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,LWORK,     &
     &                                   RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CHBEVD
  PURE SUBROUTINE ZHBEVD(JOBZ,UPLO,N,KD,AB,LDAB,W,Z,LDZ,WORK,LWORK,     &
     &                                   RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZHBEVD
END INTERFACE F77_HBEVD

INTERFACE F77_SBEVX
  PURE SUBROUTINE SSBEVX(JOBZ,RANGE,UPLO,N,KD,AB,LDAB,Q,LDQ,VL,VU,IL,IU,&
     &                           ABSTOL,M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSBEVX
  PURE SUBROUTINE DSBEVX(JOBZ,RANGE,UPLO,N,KD,AB,LDAB,Q,LDQ,VL,VU,IL,IU,&
     &                           ABSTOL,M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSBEVX
END INTERFACE F77_SBEVX

INTERFACE F77_HBEVX
  PURE SUBROUTINE CHBEVX(JOBZ,RANGE,UPLO,N,KD,AB,LDAB,Q,LDQ,VL,VU,IL,IU,&
     &                     ABSTOL,M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CHBEVX
  PURE SUBROUTINE ZHBEVX(JOBZ,RANGE,UPLO,N,KD,AB,LDAB,Q,LDQ,VL,VU,IL,IU,&
     &                     ABSTOL,M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZHBEVX
END INTERFACE F77_HBEVX

INTERFACE F77_STEV
  PURE SUBROUTINE SSTEV(JOBZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSTEV
  PURE SUBROUTINE DSTEV(JOBZ,N,D,E,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSTEV
END INTERFACE F77_STEV

INTERFACE F77_STEVD
  PURE SUBROUTINE SSTEVD(JOBZ,N,D,E,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSTEVD
  PURE SUBROUTINE DSTEVD(JOBZ,N,D,E,Z,LDZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSTEVD
END INTERFACE F77_STEVD

INTERFACE F77_STEVX
  PURE SUBROUTINE SSTEVX(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ, &
     &                                            WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: W(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSTEVX
  PURE SUBROUTINE DSTEVX(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ, &
     &                                            WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: W(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSTEVX
END INTERFACE F77_STEVX

INTERFACE F77_STEVR
  PURE SUBROUTINE SSTEVR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ, &
     &                              ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: W(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSTEVR
  PURE SUBROUTINE DSTEVR(JOBZ,RANGE,N,D,E,VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ, &
     &                              ISUPPZ,WORK,LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(OUT) :: W(*)
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: ISUPPZ(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSTEVR
END INTERFACE F77_STEVR

INTERFACE F77_GEES
  PURE SUBROUTINE SGEES(JOBVS,SORT,SELECT,N,A,LDA,SDIM,WR,WI,VS,LDVS,   &
     &                                            WORK,LWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    REAL(WP), INTENT(OUT) :: VS(LDVS,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(WR,WI)
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP), INTENT(IN) :: WR,WI
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVS
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVS
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE SGEES
  PURE SUBROUTINE DGEES(JOBVS,SORT,SELECT,N,A,LDA,SDIM,WR,WI,VS,LDVS,   &
     &                                            WORK,LWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    REAL(WP), INTENT(OUT) :: VS(LDVS,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(WR,WI)
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP), INTENT(IN) :: WR,WI
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVS
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVS
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE DGEES
  PURE SUBROUTINE CGEES(JOBVS,SORT,SELECT,N,A,LDA,SDIM,W,VS,LDVS,WORK,  &
     &                                           LWORK,RWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: VS(LDVS,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(W)
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP), INTENT(IN) :: W
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVS
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVS
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE CGEES
  PURE SUBROUTINE ZGEES(JOBVS,SORT,SELECT,N,A,LDA,SDIM,W,VS,LDVS,WORK,  &
     &                                           LWORK,RWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: VS(LDVS,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(W)
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP), INTENT(IN) :: W
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVS
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVS
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE ZGEES
END INTERFACE F77_GEES

INTERFACE F77_GEESX
  PURE SUBROUTINE SGEESX(JOBVS,SORT,SELECT,SENSE,N,A,LDA,SDIM,WR,WI,VS, &
     &            LDVS,RCONDE,RCONDV,WORK,LWORK,IWORK,LIWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    REAL(WP), INTENT(OUT) :: VS(LDVS,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(WR,WI)
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP), INTENT(IN) :: WR,WI
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    REAL(WP), INTENT(OUT) :: RCONDE
    REAL(WP), INTENT(OUT) :: RCONDV
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVS
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVS
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE SGEESX
  PURE SUBROUTINE DGEESX(JOBVS,SORT,SELECT,SENSE,N,A,LDA,SDIM,WR,WI,VS, &
     &            LDVS,RCONDE,RCONDV,WORK,LWORK,IWORK,LIWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    REAL(WP), INTENT(OUT) :: VS(LDVS,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(WR,WI)
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP), INTENT(IN) :: WR,WI
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    REAL(WP), INTENT(OUT) :: RCONDE
    REAL(WP), INTENT(OUT) :: RCONDV
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVS
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVS
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE DGEESX
  PURE SUBROUTINE CGEESX(JOBVS,SORT,SELECT,SENSE,N,A,LDA,SDIM,W,VS,LDVS,&
     &                        RCONDE,RCONDV,WORK,LWORK,RWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: VS(LDVS,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(W)
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP), INTENT(IN) :: W
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    REAL(WP), INTENT(OUT) :: RCONDE
    REAL(WP), INTENT(OUT) :: RCONDV
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVS
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVS
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE CGEESX
  PURE SUBROUTINE ZGEESX(JOBVS,SORT,SELECT,SENSE,N,A,LDA,SDIM,W,VS,LDVS,&
     &                        RCONDE,RCONDV,WORK,LWORK,RWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: VS(LDVS,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(W)
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP), INTENT(IN) :: W
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    REAL(WP), INTENT(OUT) :: RCONDE
    REAL(WP), INTENT(OUT) :: RCONDV
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVS
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVS
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE ZGEESX
END INTERFACE F77_GEESX

INTERFACE F77_GEEV
  PURE SUBROUTINE SGEEV(JOBVL,JOBVR,N,A,LDA,WR,WI,VL,LDVL,VR,LDVR,WORK, &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    REAL(WP), INTENT(OUT) :: VL(LDVL,*)
    REAL(WP), INTENT(OUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGEEV
  PURE SUBROUTINE DGEEV(JOBVL,JOBVR,N,A,LDA,WR,WI,VL,LDVL,VR,LDVR,WORK, &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    REAL(WP), INTENT(OUT) :: VL(LDVL,*)
    REAL(WP), INTENT(OUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGEEV
  PURE SUBROUTINE CGEEV(JOBVL,JOBVR,N,A,LDA,W,VL,LDVL,VR,LDVR,WORK,     &
     &                                                 LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(OUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGEEV
  PURE SUBROUTINE ZGEEV(JOBVL,JOBVR,N,A,LDA,W,VL,LDVL,VR,LDVR,WORK,     &
     &                                                 LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(OUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGEEV
END INTERFACE F77_GEEV

INTERFACE F77_GEEVX
  PURE SUBROUTINE SGEEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,WR,WI,VL,LDVL,&
     &  VR,LDVR,ILO,IHI,SCALE,ABNRM,RCONDE,RCONDV,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    REAL(WP), INTENT(OUT) :: VL(LDVL,*)
    REAL(WP), INTENT(OUT) :: VR(LDVR,*)
    CHARACTER(LEN=1), INTENT(IN) :: BALANC
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: SCALE(*)
    REAL(WP), INTENT(OUT) :: ABNRM
    REAL(WP), INTENT(OUT) :: RCONDE(*)
    REAL(WP), INTENT(OUT) :: RCONDV(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGEEVX
  PURE SUBROUTINE DGEEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,WR,WI,VL,LDVL,&
     &  VR,LDVR,ILO,IHI,SCALE,ABNRM,RCONDE,RCONDV,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: WR(*)
    REAL(WP), INTENT(OUT) :: WI(*)
    REAL(WP), INTENT(OUT) :: VL(LDVL,*)
    REAL(WP), INTENT(OUT) :: VR(LDVR,*)
    CHARACTER(LEN=1), INTENT(IN) :: BALANC
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: SCALE(*)
    REAL(WP), INTENT(OUT) :: ABNRM
    REAL(WP), INTENT(OUT) :: RCONDE(*)
    REAL(WP), INTENT(OUT) :: RCONDV(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGEEVX
  PURE SUBROUTINE CGEEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,W,VL,LDVL,VR, &
     &     LDVR,ILO,IHI,SCALE,ABNRM,RCONDE,RCONDV,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(OUT) :: VR(LDVR,*)
    CHARACTER(LEN=1), INTENT(IN) :: BALANC
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: SCALE(*)
    REAL(WP), INTENT(OUT) :: ABNRM
    REAL(WP), INTENT(OUT) :: RCONDE(*)
    REAL(WP), INTENT(OUT) :: RCONDV(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGEEVX
  PURE SUBROUTINE ZGEEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,W,VL,LDVL,VR, &
     &     LDVR,ILO,IHI,SCALE,ABNRM,RCONDE,RCONDV,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(OUT) :: W(*)
    COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(OUT) :: VR(LDVR,*)
    CHARACTER(LEN=1), INTENT(IN) :: BALANC
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: SCALE(*)
    REAL(WP), INTENT(OUT) :: ABNRM
    REAL(WP), INTENT(OUT) :: RCONDE(*)
    REAL(WP), INTENT(OUT) :: RCONDV(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGEEVX
END INTERFACE F77_GEEVX

INTERFACE F77_GESVD
  PURE SUBROUTINE SGESVD(JOBU,JOBVT,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,     &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: VT(LDVT,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBVT
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGESVD
  PURE SUBROUTINE DGESVD(JOBU,JOBVT,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,     &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: VT(LDVT,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBVT
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGESVD
  PURE SUBROUTINE CGESVD(JOBU,JOBVT,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,     &
     &                                                 LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    COMPLEX(WP), INTENT(OUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(OUT) :: VT(LDVT,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBVT
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGESVD
  PURE SUBROUTINE ZGESVD(JOBU,JOBVT,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,     &
     &                                                 LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    COMPLEX(WP), INTENT(OUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(OUT) :: VT(LDVT,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBVT
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGESVD
END INTERFACE F77_GESVD

INTERFACE F77_GESDD
  PURE SUBROUTINE SGESDD(JOBZ,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,     &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: VT(LDVT,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGESDD
  PURE SUBROUTINE DGESDD(JOBZ,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,     &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: VT(LDVT,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGESDD
  PURE SUBROUTINE CGESDD(JOBZ,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,     &
     &                                                 RWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    COMPLEX(WP), INTENT(OUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(OUT) :: VT(LDVT,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CGESDD
  PURE SUBROUTINE ZGESDD(JOBZ,M,N,A,LDA,S,U,LDU,VT,LDVT,WORK,LWORK,     &
     &                                                 RWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(OUT) :: S(*)
    COMPLEX(WP), INTENT(OUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(OUT) :: VT(LDVT,*)
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDVT
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZGESDD
END INTERFACE F77_GESDD

INTERFACE F77_GGSVD
  PURE SUBROUTINE SGGSVD(JOBU,JOBV,JOBQ,M,N,P,K,L,A,LDA,B,LDB,ALPHA,    &
     &                           BETA,U,LDU,V,LDV,Q,LDQ,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHA(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(OUT) :: K
    INTEGER, INTENT(OUT) :: L
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: V(LDV,*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: IWORK(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SGGSVD
  PURE SUBROUTINE DGGSVD(JOBU,JOBV,JOBQ,M,N,P,K,L,A,LDA,B,LDB,ALPHA,    &
     &                           BETA,U,LDU,V,LDV,Q,LDQ,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHA(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(OUT) :: K
    INTEGER, INTENT(OUT) :: L
    REAL(WP), INTENT(OUT) :: U(LDU,*)
    REAL(WP), INTENT(OUT) :: V(LDV,*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: IWORK(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DGGSVD
  PURE SUBROUTINE CGGSVD(JOBU,JOBV,JOBQ,M,N,P,K,L,A,LDA,B,LDB,ALPHA,    &
     &                     BETA,U,LDU,V,LDV,Q,LDQ,WORK,RWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHA(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(OUT) :: K
    INTEGER, INTENT(OUT) :: L
    COMPLEX(WP), INTENT(OUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(OUT) :: V(LDV,*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: IWORK(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGGSVD
  PURE SUBROUTINE ZGGSVD(JOBU,JOBV,JOBQ,M,N,P,K,L,A,LDA,B,LDB,ALPHA,    &
     &                     BETA,U,LDU,V,LDV,Q,LDQ,WORK,RWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHA(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    INTEGER, INTENT(OUT) :: K
    INTEGER, INTENT(OUT) :: L
    COMPLEX(WP), INTENT(OUT) :: U(LDU,*)
    COMPLEX(WP), INTENT(OUT) :: V(LDV,*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    INTEGER, INTENT(OUT) :: IWORK(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBU
    CHARACTER(LEN=1), INTENT(IN) :: JOBV
    CHARACTER(LEN=1), INTENT(IN) :: JOBQ
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: P
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDU
    INTEGER, INTENT(IN) :: LDV
    INTEGER, INTENT(IN) :: LDQ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGGSVD
END INTERFACE F77_GGSVD

INTERFACE F77_SYGV
  PURE SUBROUTINE SSYGV(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SSYGV
  PURE SUBROUTINE DSYGV(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DSYGV
END INTERFACE F77_SYGV

INTERFACE F77_HEGV
  PURE SUBROUTINE CHEGV(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,     &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHEGV
  PURE SUBROUTINE ZHEGV(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,     &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHEGV
END INTERFACE F77_HEGV

INTERFACE F77_SYGVD
  PURE SUBROUTINE SSYGVD(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,    &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSYGVD
  PURE SUBROUTINE DSYGVD(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,    &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSYGVD
END INTERFACE F77_SYGVD

INTERFACE F77_HEGVD
  PURE SUBROUTINE CHEGVD(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,    &
     &                                   RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CHEGVD
  PURE SUBROUTINE ZHEGVD(ITYPE,JOBZ,UPLO,N,A,LDA,B,LDB,W,WORK,LWORK,    &
     &                                   RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZHEGVD
END INTERFACE F77_HEGVD

INTERFACE F77_SYGVX
  PURE SUBROUTINE SSYGVX(ITYPE,JOBZ,RANGE,UPLO,N,A,LDA,B,LDB,VL,VU,IL,  &
     &                  IU,ABSTOL,M,W,Z,LDZ,WORK,LWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSYGVX
  PURE SUBROUTINE DSYGVX(ITYPE,JOBZ,RANGE,UPLO,N,A,LDA,B,LDB,VL,VU,IL,  &
     &                  IU,ABSTOL,M,W,Z,LDZ,WORK,LWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSYGVX
END INTERFACE F77_SYGVX

INTERFACE F77_HEGVX
  PURE SUBROUTINE CHEGVX(ITYPE,JOBZ,RANGE,UPLO,N,A,LDA,B,LDB,VL,VU,IL,  &
     &            IU,ABSTOL,M,W,Z,LDZ,WORK,LWORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CHEGVX
  PURE SUBROUTINE ZHEGVX(ITYPE,JOBZ,RANGE,UPLO,N,A,LDA,B,LDB,VL,VU,IL,  &
     &            IU,ABSTOL,M,W,Z,LDZ,WORK,LWORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZHEGVX
END INTERFACE F77_HEGVX

INTERFACE F77_SPGV
  PURE SUBROUTINE SSPGV(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSPGV
  PURE SUBROUTINE DSPGV(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSPGV
END INTERFACE F77_SPGV

INTERFACE F77_HPGV
  PURE SUBROUTINE CHPGV(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHPGV
  PURE SUBROUTINE ZHPGV(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHPGV
END INTERFACE F77_HPGV

INTERFACE F77_SPGVD
  PURE SUBROUTINE SSPGVD(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,LWORK,    &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSPGVD
  PURE SUBROUTINE DSPGVD(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,LWORK,    &
     &                                                IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSPGVD
END INTERFACE F77_SPGVD

INTERFACE F77_HPGVD
  PURE SUBROUTINE CHPGVD(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,LWORK,    &
     &                                   RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CHPGVD
  PURE SUBROUTINE ZHPGVD(ITYPE,JOBZ,UPLO,N,AP,BP,W,Z,LDZ,WORK,LWORK,    &
     &                                   RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZHPGVD
END INTERFACE F77_HPGVD

INTERFACE F77_SPGVX
  PURE SUBROUTINE SSPGVX(ITYPE,JOBZ,RANGE,UPLO,N,AP,BP,VL,VU,IL,IU,     &
     &                           ABSTOL,M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSPGVX
  PURE SUBROUTINE DSPGVX(ITYPE,JOBZ,RANGE,UPLO,N,AP,BP,VL,VU,IL,IU,     &
     &                           ABSTOL,M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSPGVX
END INTERFACE F77_SPGVX

INTERFACE F77_HPGVX
  PURE SUBROUTINE CHPGVX(ITYPE,JOBZ,RANGE,UPLO,N,AP,BP,VL,VU,IL,IU,     &
     &                     ABSTOL,M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CHPGVX
  PURE SUBROUTINE ZHPGVX(ITYPE,JOBZ,RANGE,UPLO,N,AP,BP,VL,VU,IL,IU,     &
     &                     ABSTOL,M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: BP(*)
    REAL(WP), INTENT(OUT) :: W(*)
    INTEGER, INTENT(IN) :: ITYPE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZHPGVX
END INTERFACE F77_HPGVX

INTERFACE F77_SBGV
  PURE SUBROUTINE SSBGV(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SSBGV
  PURE SUBROUTINE DSBGV(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK, &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DSBGV
END INTERFACE F77_SBGV

INTERFACE F77_HBGV
  PURE SUBROUTINE CHBGV(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK, &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHBGV
  PURE SUBROUTINE ZHBGV(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK, &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHBGV
END INTERFACE F77_HBGV

INTERFACE F77_SBGVD
  PURE SUBROUTINE SSBGVD(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,&
     &                                          LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE SSBGVD
  PURE SUBROUTINE DSBGVD(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,&
     &                                          LWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE DSBGVD
END INTERFACE F77_SBGVD

INTERFACE F77_HBGVD
  PURE SUBROUTINE CHBGVD(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,&
     &                             LWORK,RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE CHBGVD
  PURE SUBROUTINE ZHBGVD(JOBZ,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,W,Z,LDZ,WORK,&
     &                             LWORK,RWORK,LRWORK,IWORK,LIWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
    INTEGER, INTENT(IN) :: LRWORK
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
  END SUBROUTINE ZHBGVD
END INTERFACE F77_HBGVD

INTERFACE F77_SBGVX
  PURE SUBROUTINE SSBGVX(JOBZ,RANGE,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,Q,LDQ, &
     &               VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(INOUT) :: IWORK(*)
  END SUBROUTINE SSBGVX
  PURE SUBROUTINE DSBGVX(JOBZ,RANGE,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,Q,LDQ, &
     &               VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    REAL(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(INOUT) :: IWORK(*)
  END SUBROUTINE DSBGVX
END INTERFACE F77_SBGVX

INTERFACE F77_HBGVX
  PURE SUBROUTINE CHBGVX(JOBZ,RANGE,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,Q,LDQ, &
     &         VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CHBGVX
  PURE SUBROUTINE ZHBGVX(JOBZ,RANGE,UPLO,N,KA,KB,AB,LDAB,BB,LDBB,Q,LDQ, &
     &         VL,VU,IL,IU,ABSTOL,M,W,Z,LDZ,WORK,RWORK,IWORK,IFAIL,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: BB(LDBB,*)
    REAL(WP), INTENT(OUT) :: W(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(OUT) :: Z(LDZ,*)
    REAL(WP), INTENT(IN) :: VL
    REAL(WP), INTENT(IN) :: VU
    INTEGER, INTENT(IN) :: IL
    INTEGER, INTENT(IN) :: IU
    INTEGER, INTENT(OUT) :: M
    INTEGER, INTENT(OUT) :: IFAIL(*)
    COMPLEX(WP), INTENT(OUT) :: Q(LDQ,*)
    REAL(WP), INTENT(IN) :: ABSTOL
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBZ
    CHARACTER(LEN=1), INTENT(IN) :: RANGE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KA
    INTEGER, INTENT(IN) :: KB
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDBB
    INTEGER, INTENT(IN) :: LDQ
    INTEGER, INTENT(IN) :: LDZ
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZHBGVX
END INTERFACE F77_HBGVX

INTERFACE F77_GGES
  PURE SUBROUTINE SGGES(JOBVSL,JOBVSR,SORT,SELECT,N,A,LDA,B,LDB,SDIM,   &
     &     ALPHAR,ALPHAI,BETA,VSL,LDVSL,VSR,LDVSR,WORK,LWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(OUT) :: VSL(LDVSL,*)
    REAL(WP), INTENT(OUT) :: VSR(LDVSR,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(ALPHAR,ALPHAI,BETA)
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP), INTENT(IN) :: ALPHAR,ALPHAI,BETA
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSR
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVSL
    INTEGER, INTENT(IN) :: LDVSR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE SGGES
  PURE SUBROUTINE DGGES(JOBVSL,JOBVSR,SORT,SELECT,N,A,LDA,B,LDB,SDIM,   &
     &     ALPHAR,ALPHAI,BETA,VSL,LDVSL,VSR,LDVSR,WORK,LWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(OUT) :: VSL(LDVSL,*)
    REAL(WP), INTENT(OUT) :: VSR(LDVSR,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(ALPHAR,ALPHAI,BETA)
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP), INTENT(IN) :: ALPHAR,ALPHAI,BETA
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSR
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVSL
    INTEGER, INTENT(IN) :: LDVSR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE DGGES
  PURE SUBROUTINE CGGES(JOBVSL,JOBVSR,SORT,SELECT,N,A,LDA,B,LDB,SDIM,   &
     &       ALPHA,BETA,VSL,LDVSL,VSR,LDVSR,WORK,LWORK,RWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(OUT) :: VSL(LDVSL,*)
    COMPLEX(WP), INTENT(OUT) :: VSR(LDVSR,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(ALPHA,BETA)
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP), INTENT(IN) :: ALPHA,BETA
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSR
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVSL
    INTEGER, INTENT(IN) :: LDVSR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE CGGES
  PURE SUBROUTINE ZGGES(JOBVSL,JOBVSR,SORT,SELECT,N,A,LDA,B,LDB,SDIM,   &
     &       ALPHA,BETA,VSL,LDVSL,VSR,LDVSR,WORK,LWORK,RWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(OUT) :: VSL(LDVSL,*)
    COMPLEX(WP), INTENT(OUT) :: VSR(LDVSR,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(ALPHA,BETA)
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP), INTENT(IN) :: ALPHA,BETA
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSR
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVSL
    INTEGER, INTENT(IN) :: LDVSR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE ZGGES
END INTERFACE F77_GGES

INTERFACE F77_GGESX
  PURE SUBROUTINE SGGESX(JOBVSL,JOBVSR,SORT,SELECT,SENSE,N,A,LDA,B,LDB, &
     &  SDIM,ALPHAR,ALPHAI,BETA,VSL,LDVSL,VSR,LDVSR,RCONDE,RCONDV,WORK, &
     &                                    LWORK,IWORK,LIWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(OUT) :: VSL(LDVSL,*)
    REAL(WP), INTENT(OUT) :: VSR(LDVSR,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(ALPHAR,ALPHAI,BETA)
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP), INTENT(IN) :: ALPHAR,ALPHAI,BETA
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    REAL(WP), INTENT(OUT) :: RCONDE(2)
    REAL(WP), INTENT(OUT) :: RCONDV(2)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSR
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVSL
    INTEGER, INTENT(IN) :: LDVSR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE SGGESX
  PURE SUBROUTINE DGGESX(JOBVSL,JOBVSR,SORT,SELECT,SENSE,N,A,LDA,B,LDB, &
     &  SDIM,ALPHAR,ALPHAI,BETA,VSL,LDVSL,VSR,LDVSR,RCONDE,RCONDV,WORK, &
     &                                    LWORK,IWORK,LIWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(OUT) :: VSL(LDVSL,*)
    REAL(WP), INTENT(OUT) :: VSR(LDVSR,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(ALPHAR,ALPHAI,BETA)
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP), INTENT(IN) :: ALPHAR,ALPHAI,BETA
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    REAL(WP), INTENT(OUT) :: RCONDE(2)
    REAL(WP), INTENT(OUT) :: RCONDV(2)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSR
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVSL
    INTEGER, INTENT(IN) :: LDVSR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE DGGESX
  PURE SUBROUTINE CGGESX(JOBVSL,JOBVSR,SORT,SELECT,SENSE,N,A,LDA,B,LDB, &
     &    SDIM,ALPHA,BETA,VSL,LDVSL,VSR,LDVSR,RCONDE,RCONDV,WORK,LWORK, &
     &                                    RWORK,IWORK,LIWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(OUT) :: VSL(LDVSL,*)
    COMPLEX(WP), INTENT(OUT) :: VSR(LDVSR,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(ALPHA,BETA)
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP), INTENT(IN) :: ALPHA,BETA
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    REAL(WP), INTENT(OUT) :: RCONDE(2)
    REAL(WP), INTENT(OUT) :: RCONDV(2)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSR
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVSL
    INTEGER, INTENT(IN) :: LDVSR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE CGGESX
  PURE SUBROUTINE ZGGESX(JOBVSL,JOBVSR,SORT,SELECT,SENSE,N,A,LDA,B,LDB, &
     &    SDIM,ALPHA,BETA,VSL,LDVSL,VSR,LDVSR,RCONDE,RCONDV,WORK,LWORK, &
     &                                    RWORK,IWORK,LIWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(OUT) :: VSL(LDVSL,*)
    COMPLEX(WP), INTENT(OUT) :: VSR(LDVSR,*)
    INTERFACE
      PURE LOGICAL FUNCTION SELECT(ALPHA,BETA)
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP), INTENT(IN) :: ALPHA,BETA
      END FUNCTION SELECT
    END INTERFACE
    INTEGER, INTENT(OUT) :: SDIM
    REAL(WP), INTENT(OUT) :: RCONDE(2)
    REAL(WP), INTENT(OUT) :: RCONDV(2)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVSR
    CHARACTER(LEN=1), INTENT(IN) :: SORT
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVSL
    INTEGER, INTENT(IN) :: LDVSR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(INOUT) :: IWORK(*)
    INTEGER, INTENT(IN) :: LIWORK
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE ZGGESX
END INTERFACE F77_GGESX

INTERFACE F77_GGEV
  PURE SUBROUTINE SGGEV(JOBVL,JOBVR,N,A,LDA,B,LDB,ALPHAR,ALPHAI,BETA,VL,&
     &                                     LDVL,VR,LDVR,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(OUT) :: VL(LDVL,*)
    REAL(WP), INTENT(OUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGGEV
  PURE SUBROUTINE DGGEV(JOBVL,JOBVR,N,A,LDA,B,LDB,ALPHAR,ALPHAI,BETA,VL,&
     &                                     LDVL,VR,LDVR,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(OUT) :: VL(LDVL,*)
    REAL(WP), INTENT(OUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGGEV
  PURE SUBROUTINE CGGEV(JOBVL,JOBVR,N,A,LDA,B,LDB,ALPHA,BETA,VL,LDVL,VR,&
     &                                       LDVR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(OUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE CGGEV
  PURE SUBROUTINE ZGGEV(JOBVL,JOBVR,N,A,LDA,B,LDB,ALPHA,BETA,VL,LDVL,VR,&
     &                                       LDVR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(OUT) :: VR(LDVR,*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE ZGGEV
END INTERFACE F77_GGEV

INTERFACE F77_GGEVX
  PURE SUBROUTINE SGGEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,B,LDB,ALPHAR, &
     &   ALPHAI,BETA,VL,LDVL,VR,LDVR,ILO,IHI,LSCALE,RSCALE,ABNRM,BBNRM, &
     &                        RCONDE,RCONDV,WORK,LWORK,IWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(OUT) :: VL(LDVL,*)
    REAL(WP), INTENT(OUT) :: VR(LDVR,*)
    CHARACTER(LEN=1), INTENT(IN) :: BALANC
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: LSCALE(*)
    REAL(WP), INTENT(OUT) :: RSCALE(*)
    REAL(WP), INTENT(OUT) :: ABNRM
    REAL(WP), INTENT(OUT) :: BBNRM
    REAL(WP), INTENT(OUT) :: RCONDE(*)
    REAL(WP), INTENT(OUT) :: RCONDV(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE SGGEVX
  PURE SUBROUTINE DGGEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,B,LDB,ALPHAR, &
     &   ALPHAI,BETA,VL,LDVL,VR,LDVR,ILO,IHI,LSCALE,RSCALE,ABNRM,BBNRM, &
     &                        RCONDE,RCONDV,WORK,LWORK,IWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    REAL(WP), INTENT(OUT) :: ALPHAR(*)
    REAL(WP), INTENT(OUT) :: ALPHAI(*)
    REAL(WP), INTENT(OUT) :: BETA(*)
    REAL(WP), INTENT(OUT) :: VL(LDVL,*)
    REAL(WP), INTENT(OUT) :: VR(LDVR,*)
    CHARACTER(LEN=1), INTENT(IN) :: BALANC
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: LSCALE(*)
    REAL(WP), INTENT(OUT) :: RSCALE(*)
    REAL(WP), INTENT(OUT) :: ABNRM
    REAL(WP), INTENT(OUT) :: BBNRM
    REAL(WP), INTENT(OUT) :: RCONDE(*)
    REAL(WP), INTENT(OUT) :: RCONDV(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE DGGEVX
  PURE SUBROUTINE CGGEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,B,LDB,ALPHA,  &
     &   BETA,VL,LDVL,VR,LDVR,ILO,IHI,LSCALE,RSCALE,ABNRM,BBNRM,RCONDE, &
     &                         RCONDV,WORK,LWORK,RWORK,IWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(OUT) :: VR(LDVR,*)
    CHARACTER(LEN=1), INTENT(IN) :: BALANC
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: LSCALE(*)
    REAL(WP), INTENT(OUT) :: RSCALE(*)
    REAL(WP), INTENT(OUT) :: ABNRM
    REAL(WP), INTENT(OUT) :: BBNRM
    REAL(WP), INTENT(OUT) :: RCONDE(*)
    REAL(WP), INTENT(OUT) :: RCONDV(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE CGGEVX
  PURE SUBROUTINE ZGGEVX(BALANC,JOBVL,JOBVR,SENSE,N,A,LDA,B,LDB,ALPHA,  &
     &   BETA,VL,LDVL,VR,LDVR,ILO,IHI,LSCALE,RSCALE,ABNRM,BBNRM,RCONDE, &
     &                         RCONDV,WORK,LWORK,RWORK,IWORK,BWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    COMPLEX(WP), INTENT(OUT) :: ALPHA(*)
    COMPLEX(WP), INTENT(OUT) :: BETA(*)
    COMPLEX(WP), INTENT(OUT) :: VL(LDVL,*)
    COMPLEX(WP), INTENT(OUT) :: VR(LDVR,*)
    CHARACTER(LEN=1), INTENT(IN) :: BALANC
    INTEGER, INTENT(OUT) :: ILO
    INTEGER, INTENT(OUT) :: IHI
    REAL(WP), INTENT(OUT) :: LSCALE(*)
    REAL(WP), INTENT(OUT) :: RSCALE(*)
    REAL(WP), INTENT(OUT) :: ABNRM
    REAL(WP), INTENT(OUT) :: BBNRM
    REAL(WP), INTENT(OUT) :: RCONDE(*)
    REAL(WP), INTENT(OUT) :: RCONDV(*)
    INTEGER, INTENT(OUT) :: INFO
    CHARACTER(LEN=1), INTENT(IN) :: JOBVL
    CHARACTER(LEN=1), INTENT(IN) :: JOBVR
    CHARACTER(LEN=1), INTENT(IN) :: SENSE
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDVL
    INTEGER, INTENT(IN) :: LDVR
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
    LOGICAL, INTENT(IN) :: BWORK(*)
  END SUBROUTINE ZGGEVX
END INTERFACE F77_GGEVX

INTERFACE F77_SYCONV
        PURE SUBROUTINE SSYCONV(UPLO, WAY, N, A, LDA, IPIV, E, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                REAL(WP), INTENT(INOUT) :: A(LDA,*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                CHARACTER(LEN=1), INTENT(IN) :: WAY
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                REAL(WP), INTENT(OUT) :: E(*)
        END SUBROUTINE SSYCONV
        PURE SUBROUTINE DSYCONV(UPLO, WAY, N, A, LDA, IPIV, E, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                REAL(WP), INTENT(INOUT) :: A(LDA,*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                CHARACTER(LEN=1), INTENT(IN) :: WAY
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                REAL(WP), INTENT(OUT) :: E(*)
        END SUBROUTINE DSYCONV
        PURE SUBROUTINE CSYCONV(UPLO, WAY, N, A, LDA, IPIV, E, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                CHARACTER(LEN=1), INTENT(IN) :: WAY
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(OUT) :: E(*)
        END SUBROUTINE CSYCONV
        PURE SUBROUTINE ZSYCONV(UPLO, WAY, N, A, LDA, IPIV, E, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                CHARACTER(LEN=1), INTENT(IN) :: WAY
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(OUT) :: E(*)
        END SUBROUTINE ZSYCONV
END INTERFACE F77_SYCONV

INTERFACE F77_SYSWAPR
        PURE SUBROUTINE SSYSWAPR(UPLO, N, A, I1, I2)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                REAL(WP), INTENT(INOUT) :: A(N,*)
                INTEGER, INTENT(IN) :: I1
                INTEGER, INTENT(IN) :: I2
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(IN) :: N
        END SUBROUTINE SSYSWAPR
        PURE SUBROUTINE DSYSWAPR(UPLO, N, A, I1, I2)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                REAL(WP), INTENT(INOUT) :: A(N,*)
                INTEGER, INTENT(IN) :: I1
                INTEGER, INTENT(IN) :: I2
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(IN) :: N
        END SUBROUTINE DSYSWAPR
        PURE SUBROUTINE CSYSWAPR(UPLO, N, A, I1, I2)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(INOUT) :: A(N,*)
                INTEGER, INTENT(IN) :: I1
                INTEGER, INTENT(IN) :: I2
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(IN) :: N
        END SUBROUTINE CSYSWAPR
        PURE SUBROUTINE ZSYSWAPR(UPLO, N, A, I1, I2)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(INOUT) :: A(N,*)
                INTEGER, INTENT(IN) :: I1
                INTEGER, INTENT(IN) :: I2
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(IN) :: N
        END SUBROUTINE ZSYSWAPR
END INTERFACE F77_SYSWAPR

INTERFACE F77_HESWAPR
        PURE SUBROUTINE CHESWAPR(UPLO, N, A, I1, I2)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(INOUT) :: A(N,*)
                INTEGER, INTENT(IN) :: I1
                INTEGER, INTENT(IN) :: I2
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(IN) :: N
        END SUBROUTINE CHESWAPR
        PURE SUBROUTINE ZHESWAPR(UPLO, N, A, I1, I2)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(INOUT) :: A(N,*)
                INTEGER, INTENT(IN) :: I1
                INTEGER, INTENT(IN) :: I2
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(IN) :: N
        END SUBROUTINE ZHESWAPR
END INTERFACE F77_HESWAPR

INTERFACE F77_SYTRI2
        PURE SUBROUTINE SSYTRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                REAL(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE SSYTRI2
        PURE SUBROUTINE DSYTRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                REAL(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE DSYTRI2
        PURE SUBROUTINE CSYTRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE CSYTRI2
        PURE SUBROUTINE ZSYTRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE ZSYTRI2
END INTERFACE F77_SYTRI2

INTERFACE F77_SYTRI2X
        PURE SUBROUTINE SSYTRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                REAL(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(IN) :: NB
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                REAL(WP), INTENT(IN) :: WORK(N+NB+1,*)
        END SUBROUTINE SSYTRI2X
        PURE SUBROUTINE DSYTRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                REAL(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(IN) :: NB
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                REAL(WP), INTENT(IN) :: WORK(N+NB+1,*)
        END SUBROUTINE DSYTRI2X
        PURE SUBROUTINE CSYTRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(IN) :: NB
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(IN) :: WORK(N+NB+1,*)
        END SUBROUTINE CSYTRI2X
        PURE SUBROUTINE ZSYTRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(IN) :: NB
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(IN) :: WORK(N+NB+1,*)
        END SUBROUTINE ZSYTRI2X
END INTERFACE F77_SYTRI2X

INTERFACE F77_SYTRS2
        PURE SUBROUTINE SSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                REAL(WP), INTENT(IN) :: A(LDA,*)
                REAL(WP), INTENT(INOUT) :: B(LDB,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                REAL(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE SSYTRS2
        PURE SUBROUTINE DSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                REAL(WP), INTENT(IN) :: A(LDA,*)
                REAL(WP), INTENT(INOUT) :: B(LDB,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                REAL(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE DSYTRS2
        PURE SUBROUTINE CSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(IN) :: A(LDA,*)
                COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                COMPLEX(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE CSYTRS2
        PURE SUBROUTINE ZSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(IN) :: A(LDA,*)
                COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                COMPLEX(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE ZSYTRS2
END INTERFACE F77_SYTRS2

INTERFACE F77_HETRS2
        PURE SUBROUTINE CHETRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(IN) :: A(LDA,*)
                COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                COMPLEX(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE CHETRS2
        PURE SUBROUTINE ZHETRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(IN) :: A(LDA,*)
                COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                COMPLEX(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE ZHETRS2
END INTERFACE F77_HETRS2

INTERFACE F77_LAPMR
        PURE SUBROUTINE SLAPMR(FORWRD, M, N, X, LDX, K)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                REAL(WP), INTENT(INOUT) :: X(LDX,*)
                LOGICAL, INTENT(IN) :: FORWRD
                INTEGER, INTENT(INOUT) :: K(*)
                INTEGER, INTENT(IN) :: LDX
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: M
        END SUBROUTINE SLAPMR
        PURE SUBROUTINE DLAPMR(FORWRD, M, N, X, LDX, K)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                REAL(WP), INTENT(INOUT) :: X(LDX,*)
                LOGICAL, INTENT(IN) :: FORWRD
                INTEGER, INTENT(INOUT) :: K(*)
                INTEGER, INTENT(IN) :: LDX
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: M
        END SUBROUTINE DLAPMR
        PURE SUBROUTINE CLAPMR(FORWRD, M, N, X, LDX, K)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
                LOGICAL, INTENT(IN) :: FORWRD
                INTEGER, INTENT(INOUT) :: K(*)
                INTEGER, INTENT(IN) :: LDX
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: M
        END SUBROUTINE CLAPMR
        PURE SUBROUTINE ZLAPMR(FORWRD, M, N, X, LDX, K)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(INOUT) :: X(LDX,*)
                LOGICAL, INTENT(IN) :: FORWRD
                INTEGER, INTENT(INOUT) :: K(*)
                INTEGER, INTENT(IN) :: LDX
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: M
        END SUBROUTINE ZLAPMR
END INTERFACE F77_LAPMR

INTERFACE F77_LARTGP
        PURE SUBROUTINE SLARTGP( F, G, CS, SN, R )
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                REAL(WP), INTENT(IN) :: F
                REAL(WP), INTENT(IN) :: G
                REAL(WP), INTENT(OUT) :: CS
                REAL(WP), INTENT(OUT) :: SN
                REAL(WP), INTENT(OUT) :: R
        END SUBROUTINE SLARTGP
        PURE SUBROUTINE DLARTGP( F, G, CS, SN, R )
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                REAL(WP), INTENT(IN) :: F
                REAL(WP), INTENT(IN) :: G
                REAL(WP), INTENT(OUT) :: CS
                REAL(WP), INTENT(OUT) :: SN
                REAL(WP), INTENT(OUT) :: R
        END SUBROUTINE DLARTGP
END INTERFACE F77_LARTGP

INTERFACE F77_LARTGS
        PURE SUBROUTINE SLARTGS( X, Y, SIGMA, CS, SN )
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                REAL(WP), INTENT(IN) :: X
                REAL(WP), INTENT(IN) :: Y
                REAL(WP), INTENT(IN) :: SIGMA
                REAL(WP), INTENT(OUT) :: SN
                REAL(WP), INTENT(OUT) :: CS
        END SUBROUTINE SLARTGS
        PURE SUBROUTINE DLARTGS( X, Y, SIGMA, CS, SN )
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                REAL(WP), INTENT(IN) :: X
                REAL(WP), INTENT(IN) :: Y
                REAL(WP), INTENT(IN) :: SIGMA
                REAL(WP), INTENT(OUT) :: SN
                REAL(WP), INTENT(OUT) :: CS
        END SUBROUTINE DLARTGS
END INTERFACE F77_LARTGS

INTERFACE F77_UNBDB
        PURE SUBROUTINE CUNBDB(TRANS, SIGNS, M, P, Q, X11, LDX11, X12, &
     &                         LDX12, X21, LDX21, X22, LDX22, THETA, PHI, &
     &                         TAUP1, TAUP2, TAUQ1, TAUQ2, WORK, LWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                INTEGER, INTENT(IN) :: M
                COMPLEX(WP), INTENT(INOUT) :: X11(LDX11,*)
                COMPLEX(WP), INTENT(INOUT) :: X12(LDX12,*)
                COMPLEX(WP), INTENT(INOUT) :: X21(LDX21,*)
                COMPLEX(WP), INTENT(INOUT) :: X22(LDX22,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                REAL(WP), INTENT(OUT) :: PHI(*)
                COMPLEX(WP), INTENT(OUT) :: TAUP1(*)
                COMPLEX(WP), INTENT(OUT) :: TAUP2(*)
                COMPLEX(WP), INTENT(OUT) :: TAUQ1(*)
                COMPLEX(WP), INTENT(OUT) :: TAUQ2(*)
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                CHARACTER(LEN=1), INTENT(IN) :: SIGNS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX12
                INTEGER, INTENT(IN) :: LDX21
                INTEGER, INTENT(IN) :: LDX22
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE CUNBDB
        PURE SUBROUTINE ZUNBDB(TRANS, SIGNS, M, P, Q, X11, LDX11, X12, &
     &                         LDX12, X21, LDX21, X22, LDX22, THETA, PHI, &
     &                         TAUP1, TAUP2, TAUQ1, TAUQ2, WORK, LWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                INTEGER, INTENT(IN) :: M
                COMPLEX(WP), INTENT(INOUT) :: X11(LDX11,*)
                COMPLEX(WP), INTENT(INOUT) :: X12(LDX12,*)
                COMPLEX(WP), INTENT(INOUT) :: X21(LDX21,*)
                COMPLEX(WP), INTENT(INOUT) :: X22(LDX22,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                REAL(WP), INTENT(OUT) :: PHI(*)
                COMPLEX(WP), INTENT(OUT) :: TAUP1(*)
                COMPLEX(WP), INTENT(OUT) :: TAUP2(*)
                COMPLEX(WP), INTENT(OUT) :: TAUQ1(*)
                COMPLEX(WP), INTENT(OUT) :: TAUQ2(*)
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                CHARACTER(LEN=1), INTENT(IN) :: SIGNS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX12
                INTEGER, INTENT(IN) :: LDX21
                INTEGER, INTENT(IN) :: LDX22
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE ZUNBDB
END INTERFACE F77_UNBDB

INTERFACE F77_UNCSD
        PURE SUBROUTINE CUNCSD(JOBU1, JOBU2, JOBV1T, JOBV2T, TRANS, &
     &                         SIGNS, M, P, Q, X11, LDX11, X12,LDX12, &
     &                         X21, LDX21, X22, LDX22, THETA,U1, LDU1, &
     &                         U2, LDU2, V1T, LDV1T, V2T,LDV2T, WORK, &
     &                         LWORK, RWORK, LRWORK,IWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                INTEGER, INTENT(IN) :: M
                COMPLEX(WP), INTENT(INOUT) :: X11(LDX11,*)
                COMPLEX(WP), INTENT(INOUT) :: X12(LDX12,*)
                COMPLEX(WP), INTENT(INOUT) :: X21(LDX21,*)
                COMPLEX(WP), INTENT(INOUT) :: X22(LDX22,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                COMPLEX(WP), INTENT(OUT) :: U1(LDU1,*)
                COMPLEX(WP), INTENT(OUT) :: U2(LDU2,*)
                COMPLEX(WP), INTENT(OUT) :: V1T(LDV1T,*)
                COMPLEX(WP), INTENT(OUT) :: V2T(LDV2T,*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                CHARACTER(LEN=1), INTENT(IN) :: JOBV2T
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                CHARACTER(LEN=1), INTENT(IN) :: SIGNS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDV2T
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX12
                INTEGER, INTENT(IN) :: LDX21
                INTEGER, INTENT(IN) :: LDX22
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
                REAL(WP), INTENT(INOUT) :: RWORK(*)
                INTEGER, INTENT(IN) :: LRWORK
                INTEGER, INTENT(INOUT) :: IWORK(*)
        END SUBROUTINE CUNCSD
        PURE SUBROUTINE ZUNCSD(JOBU1, JOBU2, JOBV1T, JOBV2T, TRANS, &
     &                         SIGNS, M, P, Q, X11, LDX11, X12,LDX12, &
     &                         X21, LDX21, X22, LDX22, THETA,U1, LDU1, &
     &                         U2, LDU2, V1T, LDV1T, V2T,LDV2T, WORK, &
     &                         LWORK, RWORK, LRWORK,IWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                INTEGER, INTENT(IN) :: M
                COMPLEX(WP), INTENT(INOUT) :: X11(LDX11,*)
                COMPLEX(WP), INTENT(INOUT) :: X12(LDX12,*)
                COMPLEX(WP), INTENT(INOUT) :: X21(LDX21,*)
                COMPLEX(WP), INTENT(INOUT) :: X22(LDX22,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                COMPLEX(WP), INTENT(OUT) :: U1(LDU1,*)
                COMPLEX(WP), INTENT(OUT) :: U2(LDU2,*)
                COMPLEX(WP), INTENT(OUT) :: V1T(LDV1T,*)
                COMPLEX(WP), INTENT(OUT) :: V2T(LDV2T,*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                CHARACTER(LEN=1), INTENT(IN) :: JOBV2T
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                CHARACTER(LEN=1), INTENT(IN) :: SIGNS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDV2T
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX12
                INTEGER, INTENT(IN) :: LDX21
                INTEGER, INTENT(IN) :: LDX22
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
                REAL(WP), INTENT(INOUT) :: RWORK(*)
                INTEGER, INTENT(IN) :: LRWORK
                INTEGER, INTENT(INOUT) :: IWORK(*)
        END SUBROUTINE ZUNCSD
END INTERFACE F77_UNCSD

INTERFACE F77_UNCSD2BY1
        PURE SUBROUTINE CUNCSD2BY1(JOBU1, JOBU2, JOBV1T,                &
     &                         M, P, Q, X11, LDX11,                     &
     &                         X21, LDX21, THETA,U1, LDU1,              &
     &                         U2, LDU2, V1T, LDV1T, WORK,              &
     &                         LWORK, RWORK, LRWORK,IWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                INTEGER, INTENT(IN) :: M
                COMPLEX(WP), INTENT(INOUT) :: X11(LDX11,*)
                COMPLEX(WP), INTENT(INOUT) :: X21(LDX21,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                COMPLEX(WP), INTENT(OUT) :: U1(LDU1,*)
                COMPLEX(WP), INTENT(OUT) :: U2(LDU2,*)
                COMPLEX(WP), INTENT(OUT) :: V1T(LDV1T,*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX21
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
                REAL(WP), INTENT(INOUT) :: RWORK(*)
                INTEGER, INTENT(IN) :: LRWORK
                INTEGER, INTENT(INOUT) :: IWORK(*)
        END SUBROUTINE CUNCSD2BY1
        PURE SUBROUTINE ZUNCSD2BY1(JOBU1, JOBU2, JOBV1T,                &
     &                         M, P, Q, X11, LDX11,                     &
     &                         X21, LDX21, THETA,U1, LDU1,              &
     &                         U2, LDU2, V1T, LDV1T, WORK,              &
     &                         LWORK, RWORK, LRWORK,IWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                INTEGER, INTENT(IN) :: M
                COMPLEX(WP), INTENT(INOUT) :: X11(LDX11,*)
                COMPLEX(WP), INTENT(INOUT) :: X21(LDX21,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                COMPLEX(WP), INTENT(OUT) :: U1(LDU1,*)
                COMPLEX(WP), INTENT(OUT) :: U2(LDU2,*)
                COMPLEX(WP), INTENT(OUT) :: V1T(LDV1T,*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX21
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
                REAL(WP), INTENT(INOUT) :: RWORK(*)
                INTEGER, INTENT(IN) :: LRWORK
                INTEGER, INTENT(INOUT) :: IWORK(*)
        END SUBROUTINE ZUNCSD2BY1
END INTERFACE F77_UNCSD2BY1

INTERFACE F77_ORBDB
        PURE SUBROUTINE SORBDB(TRANS, SIGNS, M, P, Q, X11, LDX11, X12, &
     &                         LDX12, X21, LDX21, X22, LDX22, THETA, PHI, &
     &                         TAUP1, TAUP2, TAUQ1, TAUQ2, WORK, LWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: X11(LDX11,*)
                REAL(WP), INTENT(INOUT) :: X12(LDX12,*)
                REAL(WP), INTENT(INOUT) :: X21(LDX21,*)
                REAL(WP), INTENT(INOUT) :: X22(LDX22,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                REAL(WP), INTENT(OUT) :: PHI(*)
                REAL(WP), INTENT(OUT) :: TAUP1(*)
                REAL(WP), INTENT(OUT) :: TAUP2(*)
                REAL(WP), INTENT(OUT) :: TAUQ1(*)
                REAL(WP), INTENT(OUT) :: TAUQ2(*)
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                CHARACTER(LEN=1), INTENT(IN) :: SIGNS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX12
                INTEGER, INTENT(IN) :: LDX21
                INTEGER, INTENT(IN) :: LDX22
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                REAL(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE SORBDB
        PURE SUBROUTINE DORBDB(TRANS, SIGNS, M, P, Q, X11, LDX11, X12, &
     &                         LDX12, X21, LDX21, X22, LDX22, THETA, PHI, &
     &                         TAUP1, TAUP2, TAUQ1, TAUQ2, WORK, LWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: X11(LDX11,*)
                REAL(WP), INTENT(INOUT) :: X12(LDX12,*)
                REAL(WP), INTENT(INOUT) :: X21(LDX21,*)
                REAL(WP), INTENT(INOUT) :: X22(LDX22,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                REAL(WP), INTENT(OUT) :: PHI(*)
                REAL(WP), INTENT(OUT) :: TAUP1(*)
                REAL(WP), INTENT(OUT) :: TAUP2(*)
                REAL(WP), INTENT(OUT) :: TAUQ1(*)
                REAL(WP), INTENT(OUT) :: TAUQ2(*)
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                CHARACTER(LEN=1), INTENT(IN) :: SIGNS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX12
                INTEGER, INTENT(IN) :: LDX21
                INTEGER, INTENT(IN) :: LDX22
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                REAL(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE DORBDB
END INTERFACE F77_ORBDB

INTERFACE F77_ORCSD
        PURE SUBROUTINE SORCSD(JOBU1, JOBU2, JOBV1T, JOBV2T, TRANS, &
     &                         SIGNS, M, P, Q, X11, LDX11, X12,LDX12, &
     &                         X21, LDX21, X22, LDX22, THETA,U1, LDU1, &
     &                         U2, LDU2, V1T, LDV1T, V2T,LDV2T, WORK, &
     &                         LWORK, IWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: X11(LDX11,*)
                REAL(WP), INTENT(INOUT) :: X12(LDX12,*)
                REAL(WP), INTENT(INOUT) :: X21(LDX21,*)
                REAL(WP), INTENT(INOUT) :: X22(LDX22,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                REAL(WP), INTENT(OUT) :: U1(LDU1,*)
                REAL(WP), INTENT(OUT) :: U2(LDU2,*)
                REAL(WP), INTENT(OUT) :: V1T(LDV1T,*)
                REAL(WP), INTENT(OUT) :: V2T(LDV2T,*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                CHARACTER(LEN=1), INTENT(IN) :: JOBV2T
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                CHARACTER(LEN=1), INTENT(IN) :: SIGNS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDV2T
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX12
                INTEGER, INTENT(IN) :: LDX21
                INTEGER, INTENT(IN) :: LDX22
                REAL(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
                INTEGER, INTENT(INOUT) :: IWORK(*)
        END SUBROUTINE SORCSD
        PURE SUBROUTINE DORCSD(JOBU1, JOBU2, JOBV1T, JOBV2T, TRANS, &
     &                         SIGNS, M, P, Q, X11, LDX11, X12,LDX12, &
     &                         X21, LDX21, X22, LDX22, THETA,U1, LDU1, &
     &                         U2, LDU2, V1T, LDV1T, V2T,LDV2T, WORK, &
     &                         LWORK, IWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: X11(LDX11,*)
                REAL(WP), INTENT(INOUT) :: X12(LDX12,*)
                REAL(WP), INTENT(INOUT) :: X21(LDX21,*)
                REAL(WP), INTENT(INOUT) :: X22(LDX22,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                REAL(WP), INTENT(OUT) :: U1(LDU1,*)
                REAL(WP), INTENT(OUT) :: U2(LDU2,*)
                REAL(WP), INTENT(OUT) :: V1T(LDV1T,*)
                REAL(WP), INTENT(OUT) :: V2T(LDV2T,*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                CHARACTER(LEN=1), INTENT(IN) :: JOBV2T
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                CHARACTER(LEN=1), INTENT(IN) :: SIGNS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDV2T
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX12
                INTEGER, INTENT(IN) :: LDX21
                INTEGER, INTENT(IN) :: LDX22
                REAL(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
                INTEGER, INTENT(INOUT) :: IWORK(*)
        END SUBROUTINE DORCSD
END INTERFACE F77_ORCSD

INTERFACE F77_ORCSD2BY1
        PURE SUBROUTINE SORCSD2BY1(JOBU1, JOBU2, JOBV1T,                &
     &                         M, P, Q, X11, LDX11,                     &
     &                         X21, LDX21, THETA,U1, LDU1,              &
     &                         U2, LDU2, V1T, LDV1T, WORK,              &
     &                         LWORK, IWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: X11(LDX11,*)
                REAL(WP), INTENT(INOUT) :: X21(LDX21,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                REAL(WP), INTENT(OUT) :: U1(LDU1,*)
                REAL(WP), INTENT(OUT) :: U2(LDU2,*)
                REAL(WP), INTENT(OUT) :: V1T(LDV1T,*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX21
                REAL(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
                INTEGER, INTENT(INOUT) :: IWORK(*)
        END SUBROUTINE SORCSD2BY1
        PURE SUBROUTINE DORCSD2BY1(JOBU1, JOBU2, JOBV1T,                &
     &                         M, P, Q, X11, LDX11,                     &
     &                         X21, LDX21, THETA,U1, LDU1,              &
     &                         U2, LDU2, V1T, LDV1T, WORK,              &
     &                         LWORK, IWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: X11(LDX11,*)
                REAL(WP), INTENT(INOUT) :: X21(LDX21,*)
                REAL(WP), INTENT(OUT) :: THETA(*)
                REAL(WP), INTENT(OUT) :: U1(LDU1,*)
                REAL(WP), INTENT(OUT) :: U2(LDU2,*)
                REAL(WP), INTENT(OUT) :: V1T(LDV1T,*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDX11
                INTEGER, INTENT(IN) :: LDX21
                REAL(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
                INTEGER, INTENT(INOUT) :: IWORK(*)
        END SUBROUTINE DORCSD2BY1
END INTERFACE F77_ORCSD2BY1

INTERFACE F77_BBCSD
        PURE SUBROUTINE SBBCSD(JOBU1, JOBU2, JOBV1T, JOBV2T, TRANS, M, &
     &                         P, Q, THETA, PHI, U1, LDU1, U2, LDU2, V1T, &
     &                         LDV1T, V2T, LDV2T, B11D, B11E, B12D, B12E, &
     &                         B21D, B21E, B22D, B22E, WORK, LWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: THETA(*)
                REAL(WP), INTENT(INOUT) :: PHI(*)
                REAL(WP), INTENT(INOUT) :: U1(LDU1,*)
                REAL(WP), INTENT(INOUT) :: U2(LDU2,*)
                REAL(WP), INTENT(INOUT) :: V1T(LDV1T,*)
                REAL(WP), INTENT(INOUT) :: V2T(LDV2T,*)
                REAL(WP), INTENT(OUT) :: B11D(*)
                REAL(WP), INTENT(OUT) :: B11E(*)
                REAL(WP), INTENT(OUT) :: B12D(*)
                REAL(WP), INTENT(OUT) :: B12E(*)
                REAL(WP), INTENT(OUT) :: B21D(*)
                REAL(WP), INTENT(OUT) :: B21E(*)
                REAL(WP), INTENT(OUT) :: B22D(*)
                REAL(WP), INTENT(OUT) :: B22E(*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                CHARACTER(LEN=1), INTENT(IN) :: JOBV2T
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDV2T
                REAL(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE SBBCSD
        PURE SUBROUTINE DBBCSD(JOBU1, JOBU2, JOBV1T, JOBV2T, TRANS, M, &
     &                         P, Q, THETA, PHI, U1, LDU1, U2, LDU2, V1T, &
     &                         LDV1T, V2T, LDV2T, B11D, B11E, B12D, B12E, &
     &                         B21D, B21E, B22D, B22E, WORK, LWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: THETA(*)
                REAL(WP), INTENT(INOUT) :: PHI(*)
                REAL(WP), INTENT(INOUT) :: U1(LDU1,*)
                REAL(WP), INTENT(INOUT) :: U2(LDU2,*)
                REAL(WP), INTENT(INOUT) :: V1T(LDV1T,*)
                REAL(WP), INTENT(INOUT) :: V2T(LDV2T,*)
                REAL(WP), INTENT(OUT) :: B11D(*)
                REAL(WP), INTENT(OUT) :: B11E(*)
                REAL(WP), INTENT(OUT) :: B12D(*)
                REAL(WP), INTENT(OUT) :: B12E(*)
                REAL(WP), INTENT(OUT) :: B21D(*)
                REAL(WP), INTENT(OUT) :: B21E(*)
                REAL(WP), INTENT(OUT) :: B22D(*)
                REAL(WP), INTENT(OUT) :: B22E(*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                CHARACTER(LEN=1), INTENT(IN) :: JOBV2T
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDV2T
                REAL(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE DBBCSD
        PURE SUBROUTINE CBBCSD(JOBU1, JOBU2, JOBV1T, JOBV2T, TRANS, M, &
     &                         P, Q, THETA, PHI, U1, LDU1, U2, LDU2, V1T, &
     &                         LDV1T, V2T, LDV2T, B11D, B11E, B12D, B12E, &
     &                         B21D, B21E, B22D, B22E, RWORK, LRWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: THETA(*)
                REAL(WP), INTENT(INOUT) :: PHI(*)
                COMPLEX(WP), INTENT(INOUT) :: U1(LDU1,*)
                COMPLEX(WP), INTENT(INOUT) :: U2(LDU2,*)
                COMPLEX(WP), INTENT(INOUT) :: V1T(LDV1T,*)
                COMPLEX(WP), INTENT(INOUT) :: V2T(LDV2T,*)
                REAL(WP), INTENT(OUT) :: B11D(*)
                REAL(WP), INTENT(OUT) :: B11E(*)
                REAL(WP), INTENT(OUT) :: B12D(*)
                REAL(WP), INTENT(OUT) :: B12E(*)
                REAL(WP), INTENT(OUT) :: B21D(*)
                REAL(WP), INTENT(OUT) :: B21E(*)
                REAL(WP), INTENT(OUT) :: B22D(*)
                REAL(WP), INTENT(OUT) :: B22E(*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                CHARACTER(LEN=1), INTENT(IN) :: JOBV2T
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDV2T
                REAL(WP), INTENT(INOUT) :: RWORK(*)
                INTEGER, INTENT(IN) :: LRWORK
        END SUBROUTINE CBBCSD
        PURE SUBROUTINE ZBBCSD(JOBU1, JOBU2, JOBV1T, JOBV2T, TRANS, M, &
     &                         P, Q, THETA, PHI, U1, LDU1, U2, LDU2, V1T, &
     &                         LDV1T, V2T, LDV2T, B11D, B11E, B12D, B12E, &
     &                         B21D, B21E, B22D, B22E, RWORK, LRWORK, INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                INTEGER, INTENT(IN) :: M
                REAL(WP), INTENT(INOUT) :: THETA(*)
                REAL(WP), INTENT(INOUT) :: PHI(*)
                COMPLEX(WP), INTENT(INOUT) :: U1(LDU1,*)
                COMPLEX(WP), INTENT(INOUT) :: U2(LDU2,*)
                COMPLEX(WP), INTENT(INOUT) :: V1T(LDV1T,*)
                COMPLEX(WP), INTENT(INOUT) :: V2T(LDV2T,*)
                REAL(WP), INTENT(OUT) :: B11D(*)
                REAL(WP), INTENT(OUT) :: B11E(*)
                REAL(WP), INTENT(OUT) :: B12D(*)
                REAL(WP), INTENT(OUT) :: B12E(*)
                REAL(WP), INTENT(OUT) :: B21D(*)
                REAL(WP), INTENT(OUT) :: B21E(*)
                REAL(WP), INTENT(OUT) :: B22D(*)
                REAL(WP), INTENT(OUT) :: B22E(*)
                CHARACTER(LEN=1), INTENT(IN) :: JOBU1
                CHARACTER(LEN=1), INTENT(IN) :: JOBU2
                CHARACTER(LEN=1), INTENT(IN) :: JOBV1T
                CHARACTER(LEN=1), INTENT(IN) :: JOBV2T
                CHARACTER(LEN=1), INTENT(IN) :: TRANS
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: P
                INTEGER, INTENT(IN) :: Q
                INTEGER, INTENT(IN) :: LDU1
                INTEGER, INTENT(IN) :: LDU2
                INTEGER, INTENT(IN) :: LDV1T
                INTEGER, INTENT(IN) :: LDV2T
                REAL(WP), INTENT(INOUT) :: RWORK(*)
                INTEGER, INTENT(IN) :: LRWORK
        END SUBROUTINE ZBBCSD
END INTERFACE F77_BBCSD

INTERFACE F77_HETRI2
        PURE SUBROUTINE CHETRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE CHETRI2
        PURE SUBROUTINE ZHETRI2(UPLO,N,A,LDA,IPIV,WORK,LWORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(INOUT) :: WORK(*)
                INTEGER, INTENT(IN) :: LWORK
        END SUBROUTINE ZHETRI2
END INTERFACE F77_HETRI2

INTERFACE F77_HETRI2X
        PURE SUBROUTINE CHETRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(IN) :: NB
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(IN) :: WORK(N+NB+1,*)
        END SUBROUTINE CHETRI2X
        PURE SUBROUTINE ZHETRI2X(UPLO,N,A,LDA,IPIV,WORK,NB,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
                INTEGER, INTENT(IN) :: IPIV(*)
                INTEGER, INTENT(IN) :: NB
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: LDA
                COMPLEX(WP), INTENT(IN) :: WORK(N+NB+1,*)
        END SUBROUTINE ZHETRI2X
END INTERFACE F77_HETRI2X

INTERFACE F77_GEQRT
    PURE SUBROUTINE DGEQRT( M, N, NB, A, LDA, T, LDT, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: NB
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
        REAL(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE DGEQRT
    PURE SUBROUTINE CGEQRT( M, N, NB, A, LDA, T, LDT, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: NB
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
        COMPLEX(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE CGEQRT
    PURE SUBROUTINE ZGEQRT( M, N, NB, A, LDA, T, LDT, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: NB
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
        COMPLEX(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE ZGEQRT
    PURE SUBROUTINE SGEQRT( M, N, NB, A, LDA, T, LDT, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: NB
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
        REAL(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE SGEQRT
END INTERFACE F77_GEQRT

INTERFACE F77_GEQRT2
    PURE SUBROUTINE DGEQRT2( M, N, A, LDA, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
    END SUBROUTINE DGEQRT2
    PURE SUBROUTINE CGEQRT2( M, N, A, LDA, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
    END SUBROUTINE CGEQRT2
    PURE SUBROUTINE ZGEQRT2( M, N, A, LDA, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
    END SUBROUTINE ZGEQRT2
    PURE SUBROUTINE SGEQRT2( M, N, A, LDA, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
    END SUBROUTINE SGEQRT2
END INTERFACE F77_GEQRT2

INTERFACE F77_GEQRT3
    PURE SUBROUTINE DGEQRT3( M, N, A, LDA, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
    END SUBROUTINE DGEQRT3
    PURE SUBROUTINE CGEQRT3( M, N, A, LDA, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
    END SUBROUTINE CGEQRT3
    PURE SUBROUTINE ZGEQRT3( M, N, A, LDA, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
    END SUBROUTINE ZGEQRT3
    PURE SUBROUTINE SGEQRT3( M, N, A, LDA, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
    END SUBROUTINE SGEQRT3
END INTERFACE F77_GEQRT3

INTERFACE F77_GEMQRT
    PURE SUBROUTINE DGEMQRT( SIDE, TRANS, M, N, K, NB, V, LDV, T, LDT, C, LDC, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP),INTENT(IN) :: V(LDV,*)
        REAL(WP),INTENT(IN) :: T(LDT,*)
        REAL(WP),INTENT(INOUT) :: C(LDC,*)
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: LDC
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: NB
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: N
        REAL(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE DGEMQRT
    PURE SUBROUTINE CGEMQRT( SIDE, TRANS, M, N, K, NB, V, LDV, T, LDT, C, LDC, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP),INTENT(IN) :: V(LDV,*)
        COMPLEX(WP),INTENT(IN) :: T(LDT,*)
        COMPLEX(WP),INTENT(INOUT) :: C(LDC,*)
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: LDC
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: NB
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: N
        COMPLEX(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE CGEMQRT
    PURE SUBROUTINE ZGEMQRT( SIDE, TRANS, M, N, K, NB, V, LDV, T, LDT, C, LDC, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP),INTENT(IN) :: V(LDV,*)
        COMPLEX(WP),INTENT(IN) :: T(LDT,*)
        COMPLEX(WP),INTENT(INOUT) :: C(LDC,*)
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: LDC
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: NB
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: N
        COMPLEX(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE ZGEMQRT
    PURE SUBROUTINE SGEMQRT( SIDE, TRANS, M, N, K, NB, V, LDV, T, LDT, C, LDC, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP),INTENT(IN) :: V(LDV,*)
        REAL(WP),INTENT(IN) :: T(LDT,*)
        REAL(WP),INTENT(INOUT) :: C(LDC,*)
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: LDC
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: NB
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: N
        REAL(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE SGEMQRT
END INTERFACE F77_GEMQRT

INTERFACE F77_TPQRT
    PURE SUBROUTINE DTPQRT( M, N, L, NB, A, LDA, B, LDB, T, LDT, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(INOUT) :: B(LDB,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: NB
        REAL(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE DTPQRT
    PURE SUBROUTINE CTPQRT( M, N, L, NB, A, LDA, B, LDB, T, LDT, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(INOUT) :: B(LDB,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: NB
        COMPLEX(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE CTPQRT
    PURE SUBROUTINE ZTPQRT( M, N, L, NB, A, LDA, B, LDB, T, LDT, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(INOUT) :: B(LDB,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: NB
        COMPLEX(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE ZTPQRT
    PURE SUBROUTINE STPQRT( M, N, L, NB, A, LDA, B, LDB, T, LDT, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(INOUT) :: B(LDB,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: NB
        REAL(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE STPQRT
END INTERFACE F77_TPQRT

INTERFACE F77_TPQRT2
    PURE SUBROUTINE DTPQRT2( M, N, L, A, LDA, B, LDB, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(INOUT) :: B(LDB,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDT
    END SUBROUTINE DTPQRT2
    PURE SUBROUTINE CTPQRT2( M, N, L, A, LDA, B, LDB, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(INOUT) :: B(LDB,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDT
    END SUBROUTINE CTPQRT2
    PURE SUBROUTINE ZTPQRT2( M, N, L, A, LDA, B, LDB, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(INOUT) :: B(LDB,*)
        COMPLEX(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDT
    END SUBROUTINE ZTPQRT2
    PURE SUBROUTINE STPQRT2( M, N, L, A, LDA, B, LDB, T, LDT, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(INOUT) :: B(LDB,*)
        REAL(WP),INTENT(OUT) :: T(LDT,*)
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: LDT
    END SUBROUTINE STPQRT2
END INTERFACE F77_TPQRT2

INTERFACE F77_TPRFB
    PURE SUBROUTINE DTPRFB( SIDE, TRANS, DIRECT, STOREV, M, N, K, L, V, LDV, T, LDT, A, LDA, B, LDB, WORK, LDWORK )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP),INTENT(IN) :: T(LDT,*)
        REAL(WP),INTENT(IN) :: V(LDV,*)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(INOUT) :: B(LDB,*)
        CHARACTER(LEN=1),INTENT(IN) :: DIRECT
        CHARACTER(LEN=1),INTENT(IN) :: STOREV
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: M
        REAL(WP),INTENT(IN) :: WORK(LDWORK,*)
        INTEGER,INTENT(IN) :: LDWORK
    END SUBROUTINE DTPRFB
    PURE SUBROUTINE CTPRFB( SIDE, TRANS, DIRECT, STOREV, M, N, K, L, V, LDV, T, LDT, A, LDA, B, LDB, WORK, LDWORK )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP),INTENT(IN) :: T(LDT,*)
        COMPLEX(WP),INTENT(IN) :: V(LDV,*)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(INOUT) :: B(LDB,*)
        CHARACTER(LEN=1),INTENT(IN) :: DIRECT
        CHARACTER(LEN=1),INTENT(IN) :: STOREV
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: M
        COMPLEX(WP),INTENT(IN) :: WORK(LDWORK,*)
        INTEGER,INTENT(IN) :: LDWORK
    END SUBROUTINE CTPRFB
    PURE SUBROUTINE ZTPRFB( SIDE, TRANS, DIRECT, STOREV, M, N, K, L, V, LDV, T, LDT, A, LDA, B, LDB, WORK, LDWORK )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP),INTENT(IN) :: T(LDT,*)
        COMPLEX(WP),INTENT(IN) :: V(LDV,*)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(INOUT) :: B(LDB,*)
        CHARACTER(LEN=1),INTENT(IN) :: DIRECT
        CHARACTER(LEN=1),INTENT(IN) :: STOREV
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: M
        COMPLEX(WP),INTENT(IN) :: WORK(LDWORK,*)
        INTEGER,INTENT(IN) :: LDWORK
    END SUBROUTINE ZTPRFB
    PURE SUBROUTINE STPRFB( SIDE, TRANS, DIRECT, STOREV, M, N, K, L, V, LDV, T, LDT, A, LDA, B, LDB, WORK, LDWORK )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP),INTENT(IN) :: T(LDT,*)
        REAL(WP),INTENT(IN) :: V(LDV,*)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(INOUT) :: B(LDB,*)
        CHARACTER(LEN=1),INTENT(IN) :: DIRECT
        CHARACTER(LEN=1),INTENT(IN) :: STOREV
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: M
        REAL(WP),INTENT(IN) :: WORK(LDWORK,*)
        INTEGER,INTENT(IN) :: LDWORK
    END SUBROUTINE STPRFB
END INTERFACE F77_TPRFB

INTERFACE F77_TPMQRT
    PURE SUBROUTINE DTPMQRT( SIDE, TRANS, M, N, K, L, NB, V, LDV, T, LDT, A, LDA, B, LDB, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        REAL(WP),INTENT(IN) :: V(LDA,*)
        REAL(WP),INTENT(IN) :: T(LDT,*)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(INOUT) :: B(LDB,*)
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: NB
        REAL(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE DTPMQRT
    PURE SUBROUTINE CTPMQRT( SIDE, TRANS, M, N, K, L, NB, V, LDV, T, LDT, A, LDA, B, LDB, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        COMPLEX(WP),INTENT(IN) :: V(LDA,*)
        COMPLEX(WP),INTENT(IN) :: T(LDT,*)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(INOUT) :: B(LDB,*)
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: NB
        COMPLEX(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE CTPMQRT
    PURE SUBROUTINE ZTPMQRT( SIDE, TRANS, M, N, K, L, NB, V, LDV, T, LDT, A, LDA, B, LDB, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0D0)
        COMPLEX(WP),INTENT(IN) :: V(LDA,*)
        COMPLEX(WP),INTENT(IN) :: T(LDT,*)
        COMPLEX(WP),INTENT(INOUT) :: A(LDA,*)
        COMPLEX(WP),INTENT(INOUT) :: B(LDB,*)
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: NB
        COMPLEX(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE ZTPMQRT
    PURE SUBROUTINE STPMQRT( SIDE, TRANS, M, N, K, L, NB, V, LDV, T, LDT, A, LDA, B, LDB, WORK, INFO )
        INTEGER, PARAMETER :: WP = KIND(1.0E0)
        REAL(WP),INTENT(IN) :: V(LDA,*)
        REAL(WP),INTENT(IN) :: T(LDT,*)
        REAL(WP),INTENT(INOUT) :: A(LDA,*)
        REAL(WP),INTENT(INOUT) :: B(LDB,*)
        CHARACTER(LEN=1),INTENT(IN) :: TRANS
        CHARACTER(LEN=1),INTENT(IN) :: SIDE
        INTEGER,INTENT(OUT) :: INFO
        INTEGER,INTENT(IN) :: LDA
        INTEGER,INTENT(IN) :: LDV
        INTEGER,INTENT(IN) :: LDB
        INTEGER,INTENT(IN) :: LDT
        INTEGER,INTENT(IN) :: N
        INTEGER,INTENT(IN) :: K
        INTEGER,INTENT(IN) :: L
        INTEGER,INTENT(IN) :: M
        INTEGER,INTENT(IN) :: NB
        REAL(WP),INTENT(IN) :: WORK(*)
    END SUBROUTINE STPMQRT
END INTERFACE F77_TPMQRT

END MODULE F77_LAPACK






MODULE F77_LAPACK1

! This module is generated automatically from "prototype" interfaces of lapack77!

! This is "incorrect" interfaces.
! They are obtained by reducing of 1 dimension for any matrix/vector with NRHS size

INTERFACE F77_GETRS
  PURE SUBROUTINE SGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGETRS
  PURE SUBROUTINE DGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGETRS
  PURE SUBROUTINE CGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGETRS
  PURE SUBROUTINE ZGETRS(TRANS,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGETRS
END INTERFACE F77_GETRS

INTERFACE F77_GBTRS
  PURE SUBROUTINE SGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGBTRS
  PURE SUBROUTINE DGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGBTRS
  PURE SUBROUTINE CGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGBTRS
  PURE SUBROUTINE ZGBTRS(TRANS,N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGBTRS
END INTERFACE F77_GBTRS

INTERFACE F77_GTTRS
  PURE SUBROUTINE SGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGTTRS
  PURE SUBROUTINE DGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGTTRS
  PURE SUBROUTINE CGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGTTRS
  PURE SUBROUTINE ZGTTRS(TRANS,N,NRHS,DL,D,DU,DU2,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGTTRS
END INTERFACE F77_GTTRS

INTERFACE F77_DTTRSB
  PURE SUBROUTINE SDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SDTTRSB
  PURE SUBROUTINE DDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DDTTRSB
  PURE SUBROUTINE CDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CDTTRSB
  PURE SUBROUTINE ZDTTRSB(TRANS,N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZDTTRSB
END INTERFACE F77_DTTRSB

INTERFACE F77_POTRS
  PURE SUBROUTINE SPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPOTRS
  PURE SUBROUTINE DPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPOTRS
  PURE SUBROUTINE CPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPOTRS
  PURE SUBROUTINE ZPOTRS(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPOTRS
END INTERFACE F77_POTRS

INTERFACE F77_PPTRS
  PURE SUBROUTINE SPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPPTRS
  PURE SUBROUTINE DPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPPTRS
  PURE SUBROUTINE CPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPPTRS
  PURE SUBROUTINE ZPPTRS(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPPTRS
END INTERFACE F77_PPTRS

INTERFACE F77_PBTRS
  PURE SUBROUTINE SPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPBTRS
  PURE SUBROUTINE DPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPBTRS
  PURE SUBROUTINE CPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPBTRS
  PURE SUBROUTINE ZPBTRS(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPBTRS
END INTERFACE F77_PBTRS

INTERFACE F77_PTTRS
  PURE SUBROUTINE SPTTRS(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPTTRS
  PURE SUBROUTINE DPTTRS(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPTTRS
  PURE SUBROUTINE CPTTRS(UPLO,N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPTTRS
  PURE SUBROUTINE ZPTTRS(UPLO,N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPTTRS
END INTERFACE F77_PTTRS

INTERFACE F77_SYTRS
  PURE SUBROUTINE SSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SSYTRS
  PURE SUBROUTINE DSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DSYTRS
  PURE SUBROUTINE CSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CSYTRS
  PURE SUBROUTINE ZSYTRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZSYTRS
END INTERFACE F77_SYTRS

INTERFACE F77_SYTRS_ROOK
  PURE SUBROUTINE SSYTRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SSYTRS_ROOK
  PURE SUBROUTINE DSYTRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DSYTRS_ROOK
  PURE SUBROUTINE CSYTRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CSYTRS_ROOK
  PURE SUBROUTINE ZSYTRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZSYTRS_ROOK
END INTERFACE F77_SYTRS_ROOK

INTERFACE F77_HETRS
  PURE SUBROUTINE CHETRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CHETRS
  PURE SUBROUTINE ZHETRS(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZHETRS
END INTERFACE F77_HETRS

INTERFACE F77_HETRS_ROOK
  PURE SUBROUTINE CHETRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CHETRS_ROOK
  PURE SUBROUTINE ZHETRS_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZHETRS_ROOK
END INTERFACE F77_HETRS_ROOK

INTERFACE F77_SPTRS
  PURE SUBROUTINE SSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SSPTRS
  PURE SUBROUTINE DSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DSPTRS
  PURE SUBROUTINE CSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CSPTRS
  PURE SUBROUTINE ZSPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZSPTRS
END INTERFACE F77_SPTRS

INTERFACE F77_HPTRS
  PURE SUBROUTINE CHPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CHPTRS
  PURE SUBROUTINE ZHPTRS(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZHPTRS
END INTERFACE F77_HPTRS

INTERFACE F77_TRTRS
  PURE SUBROUTINE STRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE STRTRS
  PURE SUBROUTINE DTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DTRTRS
  PURE SUBROUTINE CTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CTRTRS
  PURE SUBROUTINE ZTRTRS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZTRTRS
END INTERFACE F77_TRTRS

INTERFACE F77_TPTRS
  PURE SUBROUTINE STPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE STPTRS
  PURE SUBROUTINE DTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DTPTRS
  PURE SUBROUTINE CTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CTPTRS
  PURE SUBROUTINE ZTPTRS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZTPTRS
END INTERFACE F77_TPTRS

INTERFACE F77_TBTRS
  PURE SUBROUTINE STBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE STBTRS
  PURE SUBROUTINE DTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DTBTRS
  PURE SUBROUTINE CTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CTBTRS
  PURE SUBROUTINE ZTBTRS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZTBTRS
END INTERFACE F77_TBTRS

INTERFACE F77_GERFS
  PURE SUBROUTINE SGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,   &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGERFS
  PURE SUBROUTINE DGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,   &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGERFS
  PURE SUBROUTINE CGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,   &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGERFS
  PURE SUBROUTINE ZGERFS(TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,   &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGERFS
END INTERFACE F77_GERFS

INTERFACE F77_GBRFS
  PURE SUBROUTINE SGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,   &
     &                              LDB,X,LDX,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: AFB(LDAFB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGBRFS
  PURE SUBROUTINE DGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,   &
     &                              LDB,X,LDX,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: AFB(LDAFB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGBRFS
  PURE SUBROUTINE CGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,   &
     &                              LDB,X,LDX,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: AFB(LDAFB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGBRFS
  PURE SUBROUTINE ZGBRFS(TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,B,   &
     &                              LDB,X,LDX,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: AFB(LDAFB,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    INTEGER, INTENT(IN) :: KL
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGBRFS
END INTERFACE F77_GBRFS

INTERFACE F77_GTRFS
  PURE SUBROUTINE SGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,&
     &                                  X,LDX,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DLF(*)
    REAL(WP), INTENT(IN) :: DF(*)
    REAL(WP), INTENT(IN) :: DUF(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGTRFS
  PURE SUBROUTINE DGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,&
     &                                  X,LDX,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: DLF(*)
    REAL(WP), INTENT(IN) :: DF(*)
    REAL(WP), INTENT(IN) :: DUF(*)
    REAL(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGTRFS
  PURE SUBROUTINE CGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,&
     &                                  X,LDX,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DLF(*)
    COMPLEX(WP), INTENT(IN) :: DF(*)
    COMPLEX(WP), INTENT(IN) :: DUF(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGTRFS
  PURE SUBROUTINE ZGTRFS(TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV,B,LDB,&
     &                                  X,LDX,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: DLF(*)
    COMPLEX(WP), INTENT(IN) :: DF(*)
    COMPLEX(WP), INTENT(IN) :: DUF(*)
    COMPLEX(WP), INTENT(IN) :: DU2(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGTRFS
END INTERFACE F77_GTRFS

INTERFACE F77_PORFS
  PURE SUBROUTINE SPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPORFS
  PURE SUBROUTINE DPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPORFS
  PURE SUBROUTINE CPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPORFS
  PURE SUBROUTINE ZPORFS(UPLO,N,NRHS,A,LDA,AF,LDAF,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPORFS
END INTERFACE F77_PORFS

INTERFACE F77_PPRFS
  PURE SUBROUTINE SPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK, &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: AFP(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPPRFS
  PURE SUBROUTINE DPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK, &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: AFP(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPPRFS
  PURE SUBROUTINE CPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK, &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPPRFS
  PURE SUBROUTINE ZPPRFS(UPLO,N,NRHS,AP,AFP,B,LDB,X,LDX,FERR,BERR,WORK, &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPPRFS
END INTERFACE F77_PPRFS

INTERFACE F77_PBRFS
  PURE SUBROUTINE SPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,  &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: AFB(LDAFB,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPBRFS
  PURE SUBROUTINE DPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,  &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: AFB(LDAFB,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPBRFS
  PURE SUBROUTINE CPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,  &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: AFB(LDAFB,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPBRFS
  PURE SUBROUTINE ZPBRFS(UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,B,LDB,X,LDX,  &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: AFB(LDAFB,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPBRFS
END INTERFACE F77_PBRFS

INTERFACE F77_PTRFS
  PURE SUBROUTINE SPTRFS(N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DF(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: EF(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SPTRFS
  PURE SUBROUTINE DPTRFS(N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,WORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DF(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: EF(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DPTRFS
  PURE SUBROUTINE CPTRFS(UPLO,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,   &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DF(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(IN) :: EF(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPTRFS
  PURE SUBROUTINE ZPTRFS(UPLO,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,FERR,BERR,   &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DF(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(IN) :: EF(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPTRFS
END INTERFACE F77_PTRFS

INTERFACE F77_SYRFS
  PURE SUBROUTINE SSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSYRFS
  PURE SUBROUTINE DSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSYRFS
  PURE SUBROUTINE CSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CSYRFS
  PURE SUBROUTINE ZSYRFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZSYRFS
END INTERFACE F77_SYRFS

INTERFACE F77_HERFS
  PURE SUBROUTINE CHERFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHERFS
  PURE SUBROUTINE ZHERFS(UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,LDX,    &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: AF(LDAF,*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHERFS
END INTERFACE F77_HERFS

INTERFACE F77_SPRFS
  PURE SUBROUTINE SSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSPRFS
  PURE SUBROUTINE DSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSPRFS
  PURE SUBROUTINE CSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CSPRFS
  PURE SUBROUTINE ZSPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZSPRFS
END INTERFACE F77_SPRFS

INTERFACE F77_HPRFS
  PURE SUBROUTINE CHPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHPRFS
  PURE SUBROUTINE ZHPRFS(UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,FERR,BERR, &
     &                                                  WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: AFP(*)
    INTEGER, INTENT(IN) :: IPIV(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHPRFS
END INTERFACE F77_HPRFS

INTERFACE F77_TRRFS
  PURE SUBROUTINE STRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR, &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STRRFS
  PURE SUBROUTINE DTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR, &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTRRFS
  PURE SUBROUTINE CTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR, &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTRRFS
  PURE SUBROUTINE ZTRRFS(UPLO,TRANS,DIAG,N,NRHS,A,LDA,B,LDB,X,LDX,FERR, &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTRRFS
END INTERFACE F77_TRRFS

INTERFACE F77_TPRFS
  PURE SUBROUTINE STPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STPRFS
  PURE SUBROUTINE DTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTPRFS
  PURE SUBROUTINE CTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTPRFS
  PURE SUBROUTINE ZTPRFS(UPLO,TRANS,DIAG,N,NRHS,AP,B,LDB,X,LDX,FERR,    &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTPRFS
END INTERFACE F77_TPRFS

INTERFACE F77_TBRFS
  PURE SUBROUTINE STBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX, &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE STBRFS
  PURE SUBROUTINE DTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX, &
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AB(LDAB,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DTBRFS
  PURE SUBROUTINE CTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX, &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CTBRFS
  PURE SUBROUTINE ZTBRFS(UPLO,TRANS,DIAG,N,KD,NRHS,AB,LDAB,B,LDB,X,LDX, &
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZTBRFS
END INTERFACE F77_TBRFS

INTERFACE F77_GESV
  PURE SUBROUTINE SGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGESV
  PURE SUBROUTINE DGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGESV
  PURE SUBROUTINE CGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGESV
  PURE SUBROUTINE ZGESV(N,NRHS,A,LDA,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGESV
END INTERFACE F77_GESV

INTERFACE F77_GESVX
  PURE SUBROUTINE SGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,&
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGESVX
  PURE SUBROUTINE DGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,&
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGESVX
  PURE SUBROUTINE CGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,&
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE CGESVX
  PURE SUBROUTINE ZGESVX(FACT,TRANS,N,NRHS,A,LDA,AF,LDAF,IPIV,EQUED,R,C,&
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE ZGESVX
END INTERFACE F77_GESVX

INTERFACE F77_GBSV
  PURE SUBROUTINE SGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGBSV
  PURE SUBROUTINE DGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGBSV
  PURE SUBROUTINE CGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGBSV
  PURE SUBROUTINE ZGBSV(N,KL,KU,NRHS,AB,LDAB,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGBSV
END INTERFACE F77_GBSV

INTERFACE F77_GBSVX
  PURE SUBROUTINE SGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,&
     &            EQUED,R,C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: KL
    REAL(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGBSVX
  PURE SUBROUTINE DGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,&
     &            EQUED,R,C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: KL
    REAL(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGBSVX
  PURE SUBROUTINE CGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,&
     &            EQUED,R,C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: KL
    COMPLEX(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE CGBSVX
  PURE SUBROUTINE ZGBSVX(FACT,TRANS,N,KL,KU,NRHS,AB,LDAB,AFB,LDAFB,IPIV,&
     &            EQUED,R,C,B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: KL
    COMPLEX(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: R(*)
    REAL(WP), INTENT(INOUT) :: C(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(INOUT) :: RWORK(*)
  END SUBROUTINE ZGBSVX
END INTERFACE F77_GBSVX

INTERFACE F77_GTSV
  PURE SUBROUTINE SGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SGTSV
  PURE SUBROUTINE DGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DGTSV
  PURE SUBROUTINE CGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CGTSV
  PURE SUBROUTINE ZGTSV(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZGTSV
END INTERFACE F77_GTSV

INTERFACE F77_GTSVX
  PURE SUBROUTINE SGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: DLF(*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    REAL(WP), INTENT(INOUT) :: DUF(*)
    REAL(WP), INTENT(INOUT) :: DU2(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGTSVX
  PURE SUBROUTINE DGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: DL(*)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: DLF(*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    REAL(WP), INTENT(INOUT) :: DUF(*)
    REAL(WP), INTENT(INOUT) :: DU2(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGTSVX
  PURE SUBROUTINE CGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: DLF(*)
    COMPLEX(WP), INTENT(INOUT) :: DF(*)
    COMPLEX(WP), INTENT(INOUT) :: DUF(*)
    COMPLEX(WP), INTENT(INOUT) :: DU2(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGTSVX
  PURE SUBROUTINE ZGTSVX(FACT,TRANS,N,NRHS,DL,D,DU,DLF,DF,DUF,DU2,IPIV, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: DL(*)
    COMPLEX(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: DLF(*)
    COMPLEX(WP), INTENT(INOUT) :: DF(*)
    COMPLEX(WP), INTENT(INOUT) :: DUF(*)
    COMPLEX(WP), INTENT(INOUT) :: DU2(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGTSVX
END INTERFACE F77_GTSVX

INTERFACE F77_DTSVB
  PURE SUBROUTINE SDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SDTSVB
  PURE SUBROUTINE DDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: DL(*)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(IN) :: DU(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DDTSVB
  PURE SUBROUTINE CDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CDTSVB
  PURE SUBROUTINE ZDTSVB(N,NRHS,DL,D,DU,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: DL(*)
    COMPLEX(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(IN) :: DU(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZDTSVB
END INTERFACE F77_DTSVB

INTERFACE F77_POSV
  PURE SUBROUTINE SPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPOSV
  PURE SUBROUTINE DPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPOSV
  PURE SUBROUTINE CPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPOSV
  PURE SUBROUTINE ZPOSV(UPLO,N,NRHS,A,LDA,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPOSV
END INTERFACE F77_POSV

INTERFACE F77_POSVX
  PURE SUBROUTINE SPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,&
     &                              LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPOSVX
  PURE SUBROUTINE DPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,&
     &                              LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPOSVX
  PURE SUBROUTINE CPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,&
     &                              LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPOSVX
  PURE SUBROUTINE ZPOSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,EQUED,S,B,LDB,X,&
     &                              LDX,RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPOSVX
END INTERFACE F77_POSVX

INTERFACE F77_PPSV
  PURE SUBROUTINE SPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPPSV
  PURE SUBROUTINE DPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPPSV
  PURE SUBROUTINE CPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPPSV
  PURE SUBROUTINE ZPPSV(UPLO,N,NRHS,AP,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPPSV
END INTERFACE F77_PPSV

INTERFACE F77_PPSVX
  PURE SUBROUTINE SPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,   &
     &                                  RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFP(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPPSVX
  PURE SUBROUTINE DPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,   &
     &                                  RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFP(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPPSVX
  PURE SUBROUTINE CPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,   &
     &                                  RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPPSVX
  PURE SUBROUTINE ZPPSVX(FACT,UPLO,N,NRHS,AP,AFP,EQUED,S,B,LDB,X,LDX,   &
     &                                  RCOND,FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPPSVX
END INTERFACE F77_PPSVX

INTERFACE F77_PBSV
  PURE SUBROUTINE SPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPBSV
  PURE SUBROUTINE DPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPBSV
  PURE SUBROUTINE CPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPBSV
  PURE SUBROUTINE ZPBSV(UPLO,N,KD,NRHS,AB,LDAB,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPBSV
END INTERFACE F77_PBSV

INTERFACE F77_PBSVX
  PURE SUBROUTINE SPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SPBSVX
  PURE SUBROUTINE DPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AB(LDAB,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DPBSVX
  PURE SUBROUTINE CPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: IWORK(*)
  END SUBROUTINE CPBSVX
  PURE SUBROUTINE ZPBSVX(FACT,UPLO,N,KD,NRHS,AB,LDAB,AFB,LDAFB,EQUED,S, &
     &                      B,LDB,X,LDX,RCOND,FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AB(LDAB,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFB(LDAFB,*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    CHARACTER(LEN=1), INTENT(INOUT) :: EQUED
    REAL(WP), INTENT(INOUT) :: S(*)
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KD
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDAB
    INTEGER, INTENT(IN) :: LDAFB
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZPBSVX
END INTERFACE F77_PBSVX

INTERFACE F77_PTSV
  PURE SUBROUTINE SPTSV(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SPTSV
  PURE SUBROUTINE DPTSV(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    REAL(WP), INTENT(INOUT) :: E(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DPTSV
  PURE SUBROUTINE CPTSV(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CPTSV
  PURE SUBROUTINE ZPTSV(N,NRHS,D,E,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D(*)
    COMPLEX(WP), INTENT(INOUT) :: E(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZPTSV
END INTERFACE F77_PTSV

INTERFACE F77_PTSVX
  PURE SUBROUTINE SPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,  &
     &                                                   BERR,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    REAL(WP), INTENT(INOUT) :: EF(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE SPTSVX
  PURE SUBROUTINE DPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,  &
     &                                                   BERR,WORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    REAL(WP), INTENT(IN) :: E(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    REAL(WP), INTENT(INOUT) :: EF(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
  END SUBROUTINE DPTSVX
  PURE SUBROUTINE CPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,  &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    COMPLEX(WP), INTENT(INOUT) :: EF(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CPTSVX
  PURE SUBROUTINE ZPTSVX(FACT,N,NRHS,D,E,DF,EF,B,LDB,X,LDX,RCOND,FERR,  &
     &                                             BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: D(*)
    COMPLEX(WP), INTENT(IN) :: E(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: DF(*)
    COMPLEX(WP), INTENT(INOUT) :: EF(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZPTSVX
END INTERFACE F77_PTSVX

INTERFACE F77_SYSV
  PURE SUBROUTINE SSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SSYSV
  PURE SUBROUTINE DSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DSYSV
  PURE SUBROUTINE CSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CSYSV
  PURE SUBROUTINE ZSYSV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZSYSV
END INTERFACE F77_SYSV

INTERFACE F77_SYSV_ROOK
  PURE SUBROUTINE SSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SSYSV_ROOK
  PURE SUBROUTINE DSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DSYSV_ROOK
  PURE SUBROUTINE CSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CSYSV_ROOK
  PURE SUBROUTINE ZSYSV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,   &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZSYSV_ROOK
END INTERFACE F77_SYSV_ROOK

INTERFACE F77_SYSVX
  PURE SUBROUTINE SSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSYSVX
  PURE SUBROUTINE DSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSYSVX
  PURE SUBROUTINE CSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CSYSVX
  PURE SUBROUTINE ZSYSVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZSYSVX
END INTERFACE F77_SYSVX

INTERFACE F77_HESVX
  PURE SUBROUTINE CHESVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHESVX
  PURE SUBROUTINE ZHESVX(FACT,UPLO,N,NRHS,A,LDA,AF,LDAF,IPIV,B,LDB,X,   &
     &                        LDX,RCOND,FERR,BERR,WORK,LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AF(LDAF,*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDAF
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHESVX
END INTERFACE F77_HESVX

INTERFACE F77_HESV
  PURE SUBROUTINE CHESV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CHESV
  PURE SUBROUTINE ZHESV(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZHESV
END INTERFACE F77_HESV

INTERFACE F77_HESV_ROOK
  PURE SUBROUTINE CHESV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CHESV_ROOK
  PURE SUBROUTINE ZHESV_ROOK(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZHESV_ROOK
END INTERFACE F77_HESV_ROOK

INTERFACE F77_SPSV
  PURE SUBROUTINE SSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE SSPSV
  PURE SUBROUTINE DSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DSPSV
  PURE SUBROUTINE CSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CSPSV
  PURE SUBROUTINE ZSPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZSPSV
END INTERFACE F77_SPSV

INTERFACE F77_SPSVX
  PURE SUBROUTINE SSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SSPSVX
  PURE SUBROUTINE DSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: B(*)
    REAL(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    REAL(WP), INTENT(IN) :: WORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DSPSVX
  PURE SUBROUTINE CSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CSPSVX
  PURE SUBROUTINE ZSPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZSPSVX
END INTERFACE F77_SPSVX

INTERFACE F77_HPSVX
  PURE SUBROUTINE CHPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CHPSVX
  PURE SUBROUTINE ZHPSVX(FACT,UPLO,N,NRHS,AP,AFP,IPIV,B,LDB,X,LDX,RCOND,&
     &                                        FERR,BERR,WORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: B(*)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(INOUT) :: AFP(*)
    INTEGER, INTENT(INOUT) :: IPIV(*)
    CHARACTER(LEN=1), INTENT(IN) :: FACT
    REAL(WP), INTENT(OUT) :: FERR(*)
    REAL(WP), INTENT(OUT) :: BERR(*)
    REAL(WP), INTENT(OUT) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDX
    COMPLEX(WP), INTENT(IN) :: WORK(*)
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZHPSVX
END INTERFACE F77_HPSVX

INTERFACE F77_HPSV
  PURE SUBROUTINE CHPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CHPSV
  PURE SUBROUTINE ZHPSV(UPLO,N,NRHS,AP,IPIV,B,LDB,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    INTEGER, INTENT(OUT) :: IPIV(*)
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZHPSV
END INTERFACE F77_HPSV

INTERFACE F77_GELS
  PURE SUBROUTINE SGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGELS
  PURE SUBROUTINE DGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGELS
  PURE SUBROUTINE CGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE CGELS
  PURE SUBROUTINE ZGELS(TRANS,M,N,NRHS,A,LDA,B,LDB,WORK,LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE ZGELS
END INTERFACE F77_GELS

INTERFACE F77_GELSY
  PURE SUBROUTINE SGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,     &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGELSY
  PURE SUBROUTINE DGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,     &
     &                                                       LWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGELSY
  PURE SUBROUTINE CGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,     &
     &                                                 LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGELSY
  PURE SUBROUTINE ZGELSY(M,N,NRHS,A,LDA,B,LDB,JPVT,RCOND,RANK,WORK,     &
     &                                                 LWORK,RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    INTEGER, INTENT(INOUT) :: JPVT(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGELSY
END INTERFACE F77_GELSY

INTERFACE F77_GELSS
  PURE SUBROUTINE SGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE SGELSS
  PURE SUBROUTINE DGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                             INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
  END SUBROUTINE DGELSS
  PURE SUBROUTINE CGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE CGELSS
  PURE SUBROUTINE ZGELSS(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                       RWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
  END SUBROUTINE ZGELSS
END INTERFACE F77_GELSS

INTERFACE F77_GELSD
  PURE SUBROUTINE SGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE SGELSD
  PURE SUBROUTINE DGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                       IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    REAL(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE DGELSD
  PURE SUBROUTINE CGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                 RWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE CGELSD
  PURE SUBROUTINE ZGELSD(M,N,NRHS,A,LDA,B,LDB,S,RCOND,RANK,WORK,LWORK,  &
     &                                                 RWORK,IWORK,INFO)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(*)
    INTEGER, INTENT(OUT) :: RANK
    REAL(WP), INTENT(OUT) :: S(*)
    REAL(WP), INTENT(IN) :: RCOND
    INTEGER, INTENT(OUT) :: INFO
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: NRHS
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    COMPLEX(WP), INTENT(INOUT) :: WORK(*)
    INTEGER, INTENT(IN) :: LWORK
    REAL(WP), INTENT(IN) :: RWORK(*)
    INTEGER, INTENT(IN) :: IWORK(*)
  END SUBROUTINE ZGELSD
END INTERFACE F77_GELSD

INTERFACE F77_SYTRS2
        PURE SUBROUTINE SSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                REAL(WP), INTENT(IN) :: A(LDA,*)
                REAL(WP), INTENT(INOUT) :: B(*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                REAL(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE SSYTRS2
        PURE SUBROUTINE DSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                REAL(WP), INTENT(IN) :: A(LDA,*)
                REAL(WP), INTENT(INOUT) :: B(*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                REAL(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE DSYTRS2
        PURE SUBROUTINE CSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(IN) :: A(LDA,*)
                COMPLEX(WP), INTENT(INOUT) :: B(*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                COMPLEX(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE CSYTRS2
        PURE SUBROUTINE ZSYTRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(IN) :: A(LDA,*)
                COMPLEX(WP), INTENT(INOUT) :: B(*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                COMPLEX(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE ZSYTRS2
END INTERFACE F77_SYTRS2

INTERFACE F77_HETRS2
        PURE SUBROUTINE CHETRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0E0)
                COMPLEX(WP), INTENT(IN) :: A(LDA,*)
                COMPLEX(WP), INTENT(INOUT) :: B(*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                COMPLEX(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE CHETRS2
        PURE SUBROUTINE ZHETRS2(UPLO,N,NRHS,A,LDA,IPIV,B,LDB,WORK,INFO)
                INTEGER, PARAMETER :: WP = KIND(1.0D0)
                COMPLEX(WP), INTENT(IN) :: A(LDA,*)
                COMPLEX(WP), INTENT(INOUT) :: B(*)
                INTEGER, INTENT(IN) :: IPIV(*)
                CHARACTER(LEN=1), INTENT(IN) :: UPLO
                INTEGER, INTENT(OUT) :: INFO
                INTEGER, INTENT(IN) :: N
                INTEGER, INTENT(IN) :: NRHS
                INTEGER, INTENT(IN) :: LDA
                INTEGER, INTENT(IN) :: LDB
                COMPLEX(WP), INTENT(IN) :: WORK(*)
        END SUBROUTINE ZHETRS2
END INTERFACE F77_HETRS2

END MODULE F77_LAPACK1
