/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.CountryPane;
import eu.hansolo.fx.countries.CountryPaneBuilder;
import eu.hansolo.fx.countries.PropertyManager;
import eu.hansolo.fx.countries.tools.CLocation;
import eu.hansolo.fx.countries.tools.CLocationBuilder;
import eu.hansolo.fx.countries.tools.Connection;
import eu.hansolo.fx.countries.tools.ConnectionBuilder;
import eu.hansolo.fx.countries.tools.ConnectionPartType;
import eu.hansolo.fx.countries.tools.Helper;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.PoiBuilder;
import eu.hansolo.toolboxfx.geom.PoiSize;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class DemoCountryPane
extends Application {
    public static final String VERSION = PropertyManager.INSTANCE.getVersionNumber();
    private Country country;
    private CountryPane countryPane;

    public void init() {
        this.country = Country.DE;
        ArrayList<Poi> pois = new ArrayList<Poi>();
        ArrayList<Point> heatmapSpots = new ArrayList<Point>();
        CLocation fmo = ((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)CLocationBuilder.create().name("FMO")).latitude(52.1307)).longitude(7.6941)).connectionPartType(ConnectionPartType.SOURCE)).build();
        CLocation muc = ((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)CLocationBuilder.create().name("MUC")).latitude(48.351)).longitude(11.7764)).connectionPartType(ConnectionPartType.TARGET)).build();
        Connection fmoToMuc = ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)ConnectionBuilder.create(fmo, muc).arrowsVisible(true)).lineWidth(2.0)).stroke(Color.CYAN)).build();
        Poi muenster = ((PoiBuilder)((PoiBuilder)((PoiBuilder)((PoiBuilder)((PoiBuilder)((PoiBuilder)PoiBuilder.create().lat(51.91183747470598)).lon(7.633806255269727)).name("M\u00fcnster")).image(Country.DE.getFlag().getImage())).svgPath("M9.998,0.004l2.24,6.908l7.252,0l-5.867,4.27l2.241,6.909l-5.866,-4.27l-5.867,4.27l2.241,-6.909l-5.867,-4.27l7.252,0l2.241,-6.908Z")).svgPathDim(new Dimension2D(20.0, 20.0))).build();
        Helper.getCities().stream().filter(city -> city.country() == this.country).filter(city -> city.population() > 300000L).forEach(city -> {
            Poi poi = ((PoiBuilder)((PoiBuilder)((PoiBuilder)((PoiBuilder)((PoiBuilder)PoiBuilder.create().lat(city.lat())).lon(city.lon())).name(city.name())).fill(Color.RED)).pointSize(PoiSize.NORMAL)).build();
            pois.add(poi);
            heatmapSpots.add(new Point(city.lon(), city.lat()));
        });
        this.countryPane = ((CountryPaneBuilder)((CountryPaneBuilder)((CountryPaneBuilder)((CountryPaneBuilder)((CountryPaneBuilder)((CountryPaneBuilder)((CountryPaneBuilder)((CountryPaneBuilder)CountryPaneBuilder.create(this.country).pois(pois)).poisVisible(true)).poiTextVisible(true)).heatmapVisible(true)).heatmapSpots(heatmapSpots)).heatmapSpotRadius(10.0)).connections(List.of(fmoToMuc))).overlayVisible(true)).build();
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.countryPane});
        pane.setPrefSize(400.0, 400.0);
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("CountryPane Version: " + VERSION);
        stage.setScene(scene);
        stage.show();
        stage.centerOnScreen();
    }

    public void stop() {
        Platform.exit();
        System.exit(0);
    }

    public static void main(String[] args2) {
        DemoCountryPane.launch((String[])args2);
    }
}

