/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class RadialPercentageTileSkin
extends TileSkin {
    private static final double ANGLE_RANGE = 360.0;
    private double size;
    private double chartSize;
    private Arc barBackground;
    private Arc bar;
    private Arc proportionBar;
    private Line separator;
    private Text titleText;
    private Text text;
    private Text percentageValueText;
    private Text percentageUnitText;
    private TextFlow percentageFlow;
    private Text descriptionText;
    private Text unitText;
    private TextFlow valueUnitFlow;
    private double minValue;
    private double range;
    private double angleStep;
    private double referenceValue;
    private String formatString;
    private Locale locale;
    private double sum;
    private List<ChartData> dataList;
    private ChartDataEventListener chartEventListener;
    private ListChangeListener<ChartData> chartDataListener;
    private InvalidationListener currentValueListener;

    public RadialPercentageTileSkin(Tile TILE) {
        super(TILE);
        this.setBar(TILE.getCurrentValue());
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.minValue = this.tile.getMinValue();
        this.range = this.tile.getRange();
        this.sectionsVisible = this.tile.getSectionsVisible();
        this.sections = this.tile.getSections();
        this.formatString = "%." + Integer.toString(this.tile.getDecimals()) + "f";
        this.locale = this.tile.getLocale();
        this.dataList = this.tile.getChartData();
        this.sum = this.dataList.stream().mapToDouble(ChartData::getValue).sum();
        this.angleStep = 360.0 / this.sum;
        this.referenceValue = this.tile.getReferenceValue() < this.maxValue ? this.maxValue : this.tile.getReferenceValue();
        this.chartEventListener = e -> this.setProportionBar();
        this.tile.getChartData().forEach(chartData -> chartData.addChartDataEventListener(this.chartEventListener));
        this.chartDataListener = c -> {
            this.dataList = this.tile.getChartData();
            this.sum = this.dataList.stream().mapToDouble(ChartData::getValue).sum();
            this.setProportionBar();
        };
        this.currentValueListener = o -> this.setBar(this.tile.getCurrentValue());
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.barBackground = new Arc(125.0, 125.0, 117.0, 117.0, 90.0, 360.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(25.0);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 117.0, 117.0, 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)this.tile.getBarColor());
        this.bar.setStrokeWidth(25.0);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.proportionBar = new Arc(125.0, 125.0, 117.0, 117.0, 90.0, 0.0);
        this.proportionBar.setType(ArcType.OPEN);
        this.proportionBar.setStroke((Paint)this.tile.getBarColor());
        this.proportionBar.setStrokeWidth(3.75);
        this.proportionBar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.proportionBar.setFill(null);
        this.separator = new Line(125.0, 1.0, 125.0, 41.667500000000004);
        this.separator.setStroke((Paint)this.tile.getBackgroundColor());
        this.separator.setFill((Paint)Color.TRANSPARENT);
        this.percentageValueText = new Text(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        this.percentageValueText.setFont(Fonts.latoRegular(68.33250000000001));
        this.percentageValueText.setFill((Paint)this.tile.getValueColor());
        this.percentageValueText.setTextOrigin(VPos.CENTER);
        this.percentageUnitText = new Text(this.tile.getUnit());
        this.percentageUnitText = new Text("%");
        this.percentageUnitText.setFont(Fonts.latoLight(20.0));
        this.percentageUnitText.setFill((Paint)this.tile.getUnitColor());
        this.percentageFlow = new TextFlow(new Node[]{this.percentageValueText, this.percentageUnitText});
        this.percentageFlow.setTextAlignment(TextAlignment.CENTER);
        this.descriptionText = new Text(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        this.descriptionText.setFont(Fonts.latoRegular(68.33250000000001));
        this.descriptionText.setFill((Paint)this.tile.getValueColor());
        this.descriptionText.setTextOrigin(VPos.CENTER);
        Helper.enableNode((Node)this.descriptionText, this.tile.isValueVisible());
        this.unitText = new Text(this.tile.getUnit());
        this.unitText = new Text("%");
        this.unitText.setFont(Fonts.latoLight(20.0));
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(new Node[]{this.descriptionText, this.unitText});
        this.valueUnitFlow.setTextAlignment(TextAlignment.CENTER);
        this.getPane().getChildren().addAll((Object[])new Node[]{this.barBackground, this.proportionBar, this.bar, this.separator, this.titleText, this.text, this.percentageFlow, this.valueUnitFlow});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().addListener(this.chartDataListener);
        this.tile.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.referenceValue = this.tile.getReferenceValue() < this.maxValue ? this.maxValue : this.tile.getReferenceValue();
            this.angleStep = 360.0 / this.range;
            this.sum = this.dataList.stream().mapToDouble(ChartData::getValue).sum();
            this.sections = this.tile.getSections();
            this.redraw();
            this.setBar(this.tile.getCurrentValue());
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.descriptionText, this.tile.isValueVisible());
        }
    }

    private void setBar(double VALUE) {
        if (this.minValue > 0.0) {
            this.bar.setLength((this.minValue - VALUE) * this.angleStep);
        } else {
            this.bar.setLength(-VALUE * this.angleStep);
        }
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.percentageValueText.setText(this.decimalFormat.format(VALUE / this.sum * 100.0));
        } else {
            this.percentageValueText.setText(String.format(this.locale, this.formatString, VALUE / this.sum * 100.0));
        }
        this.setProportionBar();
    }

    private void setProportionBar() {
        this.sum = this.dataList.stream().mapToDouble(ChartData::getValue).sum();
        this.proportionBar.setLength(-this.sum * 360.0 / this.referenceValue);
    }

    @Override
    public void dispose() {
        this.tile.currentValueProperty().removeListener(this.currentValueListener);
        this.tile.getChartData().removeListener(this.chartDataListener);
        this.tile.getChartData().forEach(chartData -> chartData.removeChartDataEventListener(this.chartEventListener));
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.percentageUnitText.isVisible() ? this.chartSize * 0.7 : this.chartSize * 0.8;
        double fontSize = this.chartSize * 0.2;
        this.percentageValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.percentageValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageValueText, maxWidth, fontSize);
        }
        fontSize = this.chartSize * 0.08;
        this.percentageUnitText.setFont(Fonts.latoLight(fontSize));
        if (this.percentageUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageUnitText, maxWidth, fontSize);
        }
        maxWidth = this.unitText.isVisible() ? this.chartSize * 0.3 : this.chartSize * 0.4;
        fontSize = this.chartSize * 0.075;
        this.descriptionText.setFont(Fonts.latoRegular(fontSize));
        if (this.descriptionText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.descriptionText, maxWidth, fontSize);
        }
        fontSize = this.chartSize * 0.04;
        this.unitText.setFont(Fonts.latoLight(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resize() {
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            double chartWidth = this.contentBounds.getWidth();
            double chartHeight = this.contentBounds.getHeight();
            this.chartSize = chartWidth < chartHeight ? chartWidth : chartHeight;
            double y = this.height * 0.15 + (this.height * (this.tile.isTextVisible() ? 0.75 : 0.85) - this.chartSize) * 0.5;
            double radius = this.chartSize * 0.4135;
            this.barBackground.setCenterX(this.contentCenterX);
            this.barBackground.setCenterY(this.contentCenterY);
            this.barBackground.setRadiusX(radius);
            this.barBackground.setRadiusY(radius);
            this.barBackground.setStrokeWidth(this.chartSize * 0.015);
            this.proportionBar.setCenterX(this.contentCenterX);
            this.proportionBar.setCenterY(this.contentCenterY);
            this.proportionBar.setRadiusX(this.chartSize * 0.456);
            this.proportionBar.setRadiusY(this.chartSize * 0.456);
            this.proportionBar.setStrokeWidth(this.chartSize * 0.015);
            this.bar.setCenterX(this.contentCenterX);
            this.bar.setCenterY(this.contentCenterY);
            this.bar.setRadiusX(radius);
            this.bar.setRadiusY(radius);
            this.bar.setStrokeWidth(this.chartSize * 0.1);
            this.separator.setStartX(this.contentCenterX);
            this.separator.setStartY(y + this.chartSize * 0.0365);
            this.separator.setEndX(this.contentCenterX);
            this.separator.setEndY(y + this.chartSize * 0.1365);
            this.resizeStaticText();
            this.resizeDynamicText();
            this.percentageFlow.setPrefWidth(this.contentBounds.getWidth());
            this.percentageFlow.relocate(this.contentBounds.getX(), this.bar.getCenterY() - this.chartSize * 0.2);
            this.valueUnitFlow.setPrefWidth(this.width * 0.6);
            this.valueUnitFlow.relocate(this.width * 0.2, this.bar.getCenterY() + this.chartSize * 0.06);
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.locale = this.tile.getLocale();
        this.formatString = "%." + Integer.toString(this.tile.getDecimals()) + "f";
        this.sectionsVisible = this.tile.getSectionsVisible();
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        LinearGradient gradient = new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.NO_CYCLE, this.tile.getGradientStops());
        this.bar.setStroke((Paint)(this.tile.isFillWithGradient() ? gradient : this.tile.getBarColor()));
        this.proportionBar.setStroke((Paint)(this.tile.isFillWithGradient() ? gradient : this.tile.getBarColor()));
        this.percentageValueText.setFill((Paint)this.tile.getValueColor());
        this.percentageUnitText.setFill((Paint)this.tile.getUnitColor());
        this.descriptionText.setFill((Paint)this.tile.getDescriptionColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.separator.setStroke((Paint)this.tile.getBackgroundColor());
        this.titleText.setText(this.tile.getTitle());
        this.descriptionText.setText(this.tile.getDescription());
        this.text.setText(this.tile.getText());
        this.unitText.setText(this.tile.getUnit());
        this.referenceValue = this.tile.getReferenceValue() < this.maxValue ? this.maxValue : this.tile.getReferenceValue();
        this.resizeStaticText();
        this.resizeDynamicText();
    }
}

