/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.properties;

import eu.hansolo.toolbox.evt.type.PropertyChangeEvt;
import eu.hansolo.toolbox.properties.ReadOnlyFloatProperty;

public class FloatProperty
extends ReadOnlyFloatProperty {
    protected ReadOnlyFloatProperty propertyBoundTo = null;
    protected boolean bound = false;

    public FloatProperty() {
        this((Object)null, (String)null, 0.0f);
    }

    public FloatProperty(float value) {
        this((Object)null, (String)null, value);
    }

    public FloatProperty(String name, float value) {
        this((Object)null, name, value);
    }

    public FloatProperty(Object bean, String name, float value) {
        super(bean, name, value);
    }

    public void setValue(Float value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(float value) {
        this.setValue(Float.valueOf(value));
    }

    protected void setValue(Float value, FloatProperty property) {
        this.willChange((Float)this.value, value);
        Float oldValue = (Float)this.value;
        this.value = value;
        if (null == property && null != this.propertyToUpdate) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new PropertyChangeEvt<Object>(this, PropertyChangeEvt.CHANGED, oldValue, this.value));
        this.didChange(oldValue, (Float)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((Float)this.getInitialValue());
    }

    public void setInitialValue(Float initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyFloatProperty property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(FloatProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(FloatProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

