/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx;

import eu.hansolo.toolbox.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;

public class GradientLookup {
    private Map<Double, Stop> stops = new TreeMap<Double, Stop>();

    public GradientLookup() {
        this(new Stop[0]);
    }

    public GradientLookup(Stop ... STOPS) {
        this(Arrays.asList(STOPS));
    }

    public GradientLookup(List<Stop> STOPS) {
        for (Stop stop : STOPS) {
            this.stops.put(stop.getOffset(), stop);
        }
        this.init();
    }

    private void init() {
        if (this.stops.isEmpty()) {
            return;
        }
        double minFraction = Collections.min(this.stops.keySet());
        double maxFraction = Collections.max(this.stops.keySet());
        if (Double.compare(minFraction, 0.0) > 0) {
            this.stops.put(0.0, new Stop(0.0, this.stops.get(minFraction).getColor()));
        }
        if (Double.compare(maxFraction, 1.0) < 0) {
            this.stops.put(1.0, new Stop(1.0, this.stops.get(maxFraction).getColor()));
        }
    }

    public Color getColorAt(double POSITION_OF_COLOR) {
        Color COLOR;
        if (this.stops.isEmpty()) {
            return Color.BLACK;
        }
        int SIZE2 = this.stops.size();
        double POSITION = Helper.clamp(0.0, 1.0, POSITION_OF_COLOR);
        if (SIZE2 == 1) {
            Map ONE_ENTRY = (Map)((Object)this.stops.entrySet().iterator().next());
            COLOR = this.stops.get(ONE_ENTRY.keySet().iterator().next()).getColor();
        } else {
            Stop lowerBound = this.stops.get(0.0);
            Stop upperBound = this.stops.get(1.0);
            int counter = 0;
            for (Double fraction : this.stops.keySet()) {
                if (counter != SIZE2 - 1 && Double.compare(fraction, POSITION) == 0) {
                    lowerBound = this.stops.get(fraction);
                } else if (Double.compare(fraction, POSITION) < 0) {
                    lowerBound = this.stops.get(fraction);
                } else if (Double.compare(fraction, POSITION) > 0) {
                    upperBound = this.stops.get(fraction);
                    break;
                }
                ++counter;
            }
            COLOR = this.interpolateColor(lowerBound, upperBound, POSITION);
        }
        return COLOR;
    }

    public List<Stop> getStops() {
        return new ArrayList<Stop>(this.stops.values());
    }

    public void setStops(Stop ... STOPS) {
        this.setStops(Arrays.asList(STOPS));
    }

    public void setStops(List<Stop> STOPS) {
        this.stops.clear();
        for (Stop stop : STOPS) {
            this.stops.put(stop.getOffset(), stop);
        }
        this.init();
    }

    public Stop getStopAt(double POSITION_OF_STOP) {
        if (this.stops.isEmpty()) {
            throw new IllegalArgumentException("GradientStop stops should not be empty");
        }
        double POSITION = Helper.clamp(0.0, 1.0, POSITION_OF_STOP);
        Stop stop = null;
        double distance = Math.abs(this.stops.get(0.0).getOffset() - POSITION);
        for (Map.Entry<Double, Stop> entry : this.stops.entrySet()) {
            double cdistance = Math.abs(entry.getKey() - POSITION);
            if (!(cdistance < distance)) continue;
            stop = this.stops.get(entry.getKey());
            distance = cdistance;
        }
        return stop;
    }

    public List<Stop> getStopsBetween(double MIN_OFFSET, double MAX_OFFSET) {
        ArrayList<Stop> selectedStops = new ArrayList<Stop>();
        for (Map.Entry<Double, Stop> entry : this.stops.entrySet()) {
            if (!(entry.getValue().getOffset() >= MIN_OFFSET) || !(entry.getValue().getOffset() <= MAX_OFFSET)) continue;
            selectedStops.add(entry.getValue());
        }
        return selectedStops;
    }

    private Color interpolateColor(Stop LOWER_BOUND, Stop UPPER_BOUND, double POSITION) {
        double POS = (POSITION - LOWER_BOUND.getOffset()) / (UPPER_BOUND.getOffset() - LOWER_BOUND.getOffset());
        double DELTA_RED = (UPPER_BOUND.getColor().getRed() - LOWER_BOUND.getColor().getRed()) * POS;
        double DELTA_GREEN = (UPPER_BOUND.getColor().getGreen() - LOWER_BOUND.getColor().getGreen()) * POS;
        double DELTA_BLUE = (UPPER_BOUND.getColor().getBlue() - LOWER_BOUND.getColor().getBlue()) * POS;
        double DELTA_OPACITY = (UPPER_BOUND.getColor().getOpacity() - LOWER_BOUND.getColor().getOpacity()) * POS;
        double red = Helper.clamp(0.0, 1.0, LOWER_BOUND.getColor().getRed() + DELTA_RED);
        double green = Helper.clamp(0.0, 1.0, LOWER_BOUND.getColor().getGreen() + DELTA_GREEN);
        double blue = Helper.clamp(0.0, 1.0, LOWER_BOUND.getColor().getBlue() + DELTA_BLUE);
        double opacity = Helper.clamp(0.0, 1.0, LOWER_BOUND.getColor().getOpacity() + DELTA_OPACITY);
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }
}

