/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten.reader;

import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.filmlisten.reader.IDateFilter;
import mediathek.tool.datum.DateUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmediathek/filmlisten/reader/DateFilter;", "Lmediathek/filmlisten/reader/IDateFilter;", "listeFilme", "Lmediathek/daten/ListeFilme;", "days", "", "(Lmediathek/daten/ListeFilme;J)V", "cutoffDate", "Ljava/time/LocalDate;", "filter", "", "film", "Lmediathek/daten/DatenFilm;", "isBeforeOrEqual", "", "date", "compareToDate", "MediathekView"})
public final class DateFilter
implements IDateFilter {
    @NotNull
    private final ListeFilme listeFilme;
    @NotNull
    private final LocalDate cutoffDate;

    public DateFilter(@NotNull ListeFilme listeFilme, long days) {
        Intrinsics.checkNotNullParameter(listeFilme, "listeFilme");
        this.listeFilme = listeFilme;
        LocalDate localDate = LocalDate.now().minusDays(days);
        Intrinsics.checkNotNullExpressionValue(localDate, "now().minusDays(days)");
        this.cutoffDate = localDate;
    }

    private final boolean isBeforeOrEqual(LocalDate date, LocalDate compareToDate) {
        return !compareToDate.isAfter(date);
    }

    @Override
    public void filter(@NotNull DatenFilm film) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(film, "film");
                LocalDate localDate = DateUtil.convertToLocalDate(film.getDatumFilm());
                if (film.isLivestream()) break block2;
                Intrinsics.checkNotNullExpressionValue(localDate, "localDate");
                if (!this.isBeforeOrEqual(localDate, this.cutoffDate)) break block3;
            }
            this.listeFilme.add(film);
        }
    }
}

