/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.FilmResolution;
import mediathek.daten.ListePset;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FileDialogs;
import mediathek.tool.FileUtils;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogAddDownload
extends JDialog {
    private DatenPset pSet;
    private DatenDownload datenDownload;
    private final DatenFilm datenFilm;
    private String orgPfad = "";
    private final Optional<FilmResolution.Enum> requestedResolution;
    private String dateiGroesse_HQ = "";
    private String dateiGroesse_Hoch = "";
    private String dateiGroesse_Klein = "";
    private boolean nameGeaendert;
    private boolean stopBeob;
    private JTextComponent cbPathTextComponent;
    private static final Logger logger = LogManager.getLogger();
    private final ListePset listeSpeichern = Daten.listePset.getListeSpeichern();
    private ListenableFuture<String> hqFuture;
    private ListenableFuture<String> hochFuture;
    private ListenableFuture<String> kleinFuture;
    private static final String TITLED_BORDER_STRING = "Download-Qualit\u00e4t";
    private boolean highQualityMandated;
    private JButton jButtonAbbrechen;
    private JButton jButtonDelHistory;
    private JButton jButtonOk;
    private JButton jButtonZiel;
    private JCheckBox jCheckBoxInfodatei;
    private JCheckBox jCheckBoxPfadSpeichern;
    private JCheckBox jCheckBoxStarten;
    private JCheckBox jCheckBoxSubtitle;
    private JComboBox<String> jComboBoxPfad;
    private JComboBox<String> jComboBoxPset;
    private JPanel jPanelSize;
    private JRadioButton jRadioButtonAufloesungHd;
    private JRadioButton jRadioButtonAufloesungHoch;
    private JRadioButton jRadioButtonAufloesungKlein;
    private JTextField jTextFieldName;
    private JTextField jTextFieldSender;

    public DialogAddDownload(@NotNull Frame parent, @NotNull DatenFilm film, @Nullable DatenPset pSet, @NotNull Optional<FilmResolution.Enum> requestedResolution) {
        super(parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.jButtonOk);
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.requestedResolution = requestedResolution;
        this.datenFilm = film;
        this.pSet = pSet;
        this.setupUI();
        this.packIt();
        this.setLocationRelativeTo(parent);
    }

    private void setupUI() {
        this.launchResolutionFutures();
        this.jCheckBoxStarten.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN)));
        this.jCheckBoxStarten.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN, String.valueOf(this.jCheckBoxStarten.isSelected())));
        this.setupZielButton();
        this.jButtonOk.addActionListener(e -> {
            if (this.check()) {
                DialogAddDownload.saveComboPfad(this.jComboBoxPfad, this.orgPfad);
                this.saveDownload();
            }
        });
        this.jButtonAbbrechen.addActionListener(e -> this.dispose());
        this.setupPSetComboBox();
        this.setupSenderTextField();
        this.setupNameTextField();
        this.setupPathTextComponent();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogAddDownload.this.setNameFilm();
            }
        };
        this.jRadioButtonAufloesungHd.addActionListener(listener);
        this.jRadioButtonAufloesungHd.setEnabled(!this.datenFilm.getUrlHighQuality().isEmpty());
        this.jRadioButtonAufloesungKlein.addActionListener(listener);
        this.jRadioButtonAufloesungKlein.setEnabled(!this.datenFilm.getUrlLowQuality().isEmpty());
        this.jRadioButtonAufloesungHoch.addActionListener(listener);
        this.jRadioButtonAufloesungHoch.setSelected(true);
        this.setupDeleteHistoryButton();
        this.setupPfadSpeichernCheckBox();
        this.waitForFileSizeFutures();
        this.setupResolutionButtons();
        this.calculateAndCheckDiskSpace();
        this.nameGeaendert = false;
    }

    private void packIt() {
        int w = this.getWidth();
        this.pack();
        this.setSize(w, this.getHeight());
    }

    private void launchResolutionFutures() {
        ListeningExecutorService decoratedPool = Daten.getInstance().getDecoratedPool();
        this.hqFuture = decoratedPool.submit(() -> {
            String url = this.datenFilm.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY);
            return this.datenFilm.getDateigroesse(url);
        });
        Futures.addCallback(this.hqFuture, new FutureCallback<String>(){

            @Override
            public void onSuccess(String result) {
                SwingUtilities.invokeLater(() -> {
                    if (DialogAddDownload.this.jRadioButtonAufloesungHd.isEnabled()) {
                        DialogAddDownload.this.dateiGroesse_HQ = result;
                        if (!DialogAddDownload.this.dateiGroesse_HQ.isEmpty()) {
                            String text = DialogAddDownload.this.jRadioButtonAufloesungHd.getText();
                            DialogAddDownload.this.jRadioButtonAufloesungHd.setText(text + "   [ " + DialogAddDownload.this.dateiGroesse_HQ + " MB ]");
                        }
                    }
                });
            }

            @Override
            public void onFailure(@NotNull Throwable t) {
                SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.dateiGroesse_HQ = "";
                    logger.error("Failed to retrieve HD resolution", t);
                });
            }
        }, decoratedPool);
        this.hochFuture = decoratedPool.submit(() -> {
            String url = this.datenFilm.getUrlNormalQuality();
            return this.datenFilm.getDateigroesse(url);
        });
        Futures.addCallback(this.hochFuture, new FutureCallback<String>(){

            @Override
            public void onSuccess(String result) {
                SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.dateiGroesse_Hoch = result;
                    if (!DialogAddDownload.this.dateiGroesse_Hoch.isEmpty()) {
                        String text = DialogAddDownload.this.jRadioButtonAufloesungHoch.getText();
                        DialogAddDownload.this.jRadioButtonAufloesungHoch.setText(text + "   [ " + DialogAddDownload.this.dateiGroesse_Hoch + " MB ]");
                    }
                });
            }

            @Override
            public void onFailure(@NotNull Throwable t) {
                SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.dateiGroesse_Hoch = "";
                    logger.error("Failed to retrieve Hoch resolution", t);
                });
            }
        }, decoratedPool);
        this.kleinFuture = decoratedPool.submit(() -> {
            String url = this.datenFilm.getUrlFuerAufloesung(FilmResolution.Enum.LOW);
            return this.datenFilm.getDateigroesse(url);
        });
        Futures.addCallback(this.kleinFuture, new FutureCallback<String>(){

            @Override
            public void onSuccess(String result) {
                SwingUtilities.invokeLater(() -> {
                    if (DialogAddDownload.this.jRadioButtonAufloesungKlein.isEnabled()) {
                        DialogAddDownload.this.dateiGroesse_Klein = result;
                        if (!DialogAddDownload.this.dateiGroesse_Klein.isEmpty()) {
                            String text = DialogAddDownload.this.jRadioButtonAufloesungKlein.getText();
                            DialogAddDownload.this.jRadioButtonAufloesungKlein.setText(text + "   [ " + DialogAddDownload.this.dateiGroesse_Klein + " MB ]");
                        }
                    }
                });
            }

            @Override
            public void onFailure(@NotNull Throwable t) {
                SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.dateiGroesse_Klein = "";
                    logger.error("Failed to retrieve Klein resolution", t);
                });
            }
        }, decoratedPool);
    }

    private void setupPSetComboBox() {
        if (this.listeSpeichern.size() == 1) {
            this.jComboBoxPset.setEnabled(false);
        }
        this.jComboBoxPset.setModel(new DefaultComboBoxModel<String>(this.listeSpeichern.getObjectDataCombo()));
        if (this.pSet != null) {
            this.jComboBoxPset.setSelectedItem(this.pSet.arr[0]);
        } else {
            this.pSet = (DatenPset)this.listeSpeichern.get(this.jComboBoxPset.getSelectedIndex());
        }
        this.jComboBoxPset.addActionListener(e -> this.setupResolutionButtons());
    }

    private void setupSenderTextField() {
        this.jTextFieldSender.setText(" " + this.datenFilm.getSender() + ":   " + this.datenFilm.getTitle());
        this.jTextFieldSender.setBackground(UIManager.getColor("Label.background"));
    }

    private void setupNameTextField() {
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                if (!DialogAddDownload.this.stopBeob) {
                    DialogAddDownload.this.nameGeaendert = true;
                    if (!DialogAddDownload.this.jTextFieldName.getText().equals(FilenameUtils.checkDateiname(DialogAddDownload.this.jTextFieldName.getText(), false))) {
                        DialogAddDownload.this.jTextFieldName.setBackground(MVColor.DOWNLOAD_FEHLER.color);
                    } else {
                        DialogAddDownload.this.jTextFieldName.setBackground(UIManager.getDefaults().getColor("TextField.background"));
                    }
                }
            }
        });
    }

    private void setupPathTextComponent() {
        this.cbPathTextComponent = (JTextComponent)this.jComboBoxPfad.getEditor().getEditorComponent();
        this.cbPathTextComponent.setOpaque(true);
        this.cbPathTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                if (!DialogAddDownload.this.stopBeob) {
                    DialogAddDownload.this.nameGeaendert = true;
                    if (!SystemUtils.IS_OS_WINDOWS) {
                        String s2 = DialogAddDownload.this.cbPathTextComponent.getText();
                        if (!s2.equals(FilenameUtils.checkDateiname(s2, true))) {
                            DialogAddDownload.this.jComboBoxPfad.getEditor().getEditorComponent().setBackground(MVColor.DOWNLOAD_FEHLER.color);
                        } else {
                            DialogAddDownload.this.jComboBoxPfad.getEditor().getEditorComponent().setBackground(Color.WHITE);
                        }
                    }
                    DialogAddDownload.this.calculateAndCheckDiskSpace();
                }
            }
        });
    }

    private void setupZielButton() {
        this.jButtonZiel.setIcon(IconFontSwing.buildIcon(FontAwesome.FOLDER_OPEN_O, 16.0f));
        this.jButtonZiel.setText("");
        this.jButtonZiel.addActionListener(l -> {
            File directory;
            String initialDirectory = "";
            if (!Objects.requireNonNull(this.jComboBoxPfad.getSelectedItem()).toString().isEmpty()) {
                initialDirectory = this.jComboBoxPfad.getSelectedItem().toString();
            }
            if ((directory = FileDialogs.chooseDirectoryLocation(MediathekGui.ui(), "Film speichern", initialDirectory)) != null) {
                String selectedDirectory = directory.getAbsolutePath();
                this.jComboBoxPfad.addItem(selectedDirectory);
                this.jComboBoxPfad.setSelectedItem(selectedDirectory);
            }
        });
    }

    private void setupDeleteHistoryButton() {
        this.jButtonDelHistory.setIcon(IconFontSwing.buildIcon(FontAwesome.TRASH_O, 16.0f));
        this.jButtonDelHistory.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, "");
            this.jComboBoxPfad.setModel(new DefaultComboBoxModel<String>(new String[]{this.orgPfad}));
        });
    }

    private void waitForFileSizeFutures() {
        try {
            this.hqFuture.get();
            this.hochFuture.get();
            this.kleinFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error occured while waiting for file size futures", (Throwable)e);
        }
    }

    private void setupPfadSpeichernCheckBox() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.jCheckBoxPfadSpeichern.setSelected(config.getBoolean("download.path.last_used.show", true));
        this.jCheckBoxPfadSpeichern.addActionListener(e -> config.setProperty("download.path.last_used.show", this.jCheckBoxPfadSpeichern.isSelected()));
    }

    private void setNameFilm() {
        if (!this.nameGeaendert) {
            this.stopBeob = true;
            this.datenDownload = new DatenDownload(this.pSet, this.datenFilm, 2, null, "", "", this.getFilmResolution().toString());
            if (this.datenDownload.arr[29].isEmpty()) {
                this.jTextFieldName.setEnabled(false);
                this.jComboBoxPfad.setEnabled(false);
                this.jButtonZiel.setEnabled(false);
                this.jTextFieldName.setText("");
                this.jComboBoxPfad.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
            } else {
                this.jTextFieldName.setEnabled(true);
                this.jComboBoxPfad.setEnabled(true);
                this.jButtonZiel.setEnabled(true);
                this.jTextFieldName.setText(this.datenDownload.arr[29]);
                DialogAddDownload.setModelPfad(this.datenDownload.arr[30], this.jComboBoxPfad);
                this.orgPfad = this.datenDownload.arr[30];
            }
            this.stopBeob = false;
        }
    }

    private long getFreeDiskSpace(String strPath) {
        long usableSpace = 0L;
        if (!strPath.isEmpty()) {
            try {
                Path path;
                if (Files.notExists(path, new LinkOption[0])) {
                    for (path = Paths.get(strPath, new String[0]); Files.notExists(path, new LinkOption[0]) && path != null; path = path.getParent()) {
                    }
                }
                if (path == null) {
                    usableSpace = 0L;
                } else {
                    FileStore fileStore = Files.getFileStore(path);
                    usableSpace = fileStore.getUsableSpace();
                }
            }
            catch (Exception ex) {
                logger.error("getFreeDiskSpace Failed", (Throwable)ex);
            }
        }
        return usableSpace;
    }

    private void calculateAndCheckDiskSpace() {
        this.jRadioButtonAufloesungHd.setForeground(Color.black);
        this.jRadioButtonAufloesungHoch.setForeground(Color.black);
        this.jRadioButtonAufloesungKlein.setForeground(Color.black);
        try {
            TitledBorder filmBorder = (TitledBorder)this.jPanelSize.getBorder();
            long usableSpace = this.getFreeDiskSpace(this.cbPathTextComponent.getText());
            if (usableSpace > 0L) {
                filmBorder.setTitle("Download-Qualit\u00e4t [ Freier Speicherplatz: " + FileUtils.humanReadableByteCountBinary(usableSpace) + " ]");
            } else {
                filmBorder.setTitle(TITLED_BORDER_STRING);
            }
            this.jPanelSize.repaint();
            if ((usableSpace /= 1000000L) > 0L) {
                int size;
                if (!this.dateiGroesse_HQ.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_HQ)) > usableSpace) {
                    this.jRadioButtonAufloesungHd.setForeground(Color.red);
                }
                if (!this.dateiGroesse_Hoch.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_Hoch)) > usableSpace) {
                    this.jRadioButtonAufloesungHoch.setForeground(Color.red);
                }
                if (!this.dateiGroesse_Klein.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_Klein)) > usableSpace) {
                    this.jRadioButtonAufloesungKlein.setForeground(Color.red);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setModelPfad(String pfad, JComboBox<String> jcb) {
        ArrayList<String> pfade = new ArrayList<String>();
        boolean showLastUsedPath = ApplicationConfiguration.getConfiguration().getBoolean("download.path.last_used.show", true);
        if (!showLastUsedPath && !pfad.isEmpty()) {
            pfade.add(pfad);
        }
        if (!MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN).isEmpty()) {
            String[] p;
            for (String s2 : p = MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN).split("<>")) {
                if (pfade.contains(s2)) continue;
                pfade.add(s2);
            }
        }
        if (showLastUsedPath && !pfad.isEmpty() && !pfade.contains(pfad)) {
            pfade.add(pfad);
        }
        jcb.setModel(new DefaultComboBoxModel<String>(pfade.toArray(new String[0])));
    }

    public static void saveComboPfad(JComboBox<String> jcb, String orgPath) {
        int i;
        ArrayList<String> pfade = new ArrayList<String>();
        Object s2 = Objects.requireNonNull(jcb.getSelectedItem()).toString();
        if (!((String)s2).equals(orgPath) || ApplicationConfiguration.getConfiguration().getBoolean("download.path.last_used.show", true)) {
            pfade.add((String)s2);
        }
        for (i = 0; i < jcb.getItemCount(); ++i) {
            s2 = jcb.getItemAt(i);
            if (((String)s2).equals(orgPath) || pfade.contains(s2)) continue;
            pfade.add((String)s2);
        }
        if (!pfade.isEmpty()) {
            s2 = (String)pfade.get(0);
            for (i = 1; i < Math.min(15, pfade.size()); ++i) {
                String pfad = (String)pfade.get(i);
                if (pfad.isEmpty()) continue;
                s2 = (String)s2 + "<>" + pfad;
            }
        }
        MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, (String)s2);
    }

    private boolean isHighQualityRequested() {
        return this.pSet.arr[15].equals(FilmResolution.Enum.HIGH_QUALITY.toString()) && !this.datenFilm.getUrlHighQuality().isEmpty();
    }

    private boolean isLowQualityRequested() {
        return this.pSet.arr[15].equals(FilmResolution.Enum.LOW.toString()) && !this.datenFilm.getUrlLowQuality().isEmpty();
    }

    private void setupResolutionButtons() {
        this.pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(this.jComboBoxPset.getSelectedIndex());
        this.requestedResolution.ifPresent(it -> {
            this.highQualityMandated = it == FilmResolution.Enum.HIGH_QUALITY;
        });
        if (this.highQualityMandated || this.isHighQualityRequested()) {
            this.jRadioButtonAufloesungHd.setSelected(true);
        } else if (this.isLowQualityRequested()) {
            this.jRadioButtonAufloesungKlein.setSelected(true);
        } else {
            this.jRadioButtonAufloesungHoch.setSelected(true);
        }
        this.jCheckBoxInfodatei.setSelected(Boolean.parseBoolean(this.pSet.arr[19]));
        if (this.datenFilm.getUrlSubtitle().isEmpty()) {
            this.jCheckBoxSubtitle.setEnabled(false);
        } else {
            this.jCheckBoxSubtitle.setSelected(Boolean.parseBoolean(this.pSet.arr[21]));
        }
        this.setNameFilm();
    }

    private FilmResolution.Enum getFilmResolution() {
        if (this.jRadioButtonAufloesungHd.isSelected()) {
            return FilmResolution.Enum.HIGH_QUALITY;
        }
        if (this.jRadioButtonAufloesungKlein.isSelected()) {
            return FilmResolution.Enum.LOW;
        }
        return FilmResolution.Enum.NORMAL;
    }

    private String getFilmSize() {
        if (this.jRadioButtonAufloesungHd.isSelected()) {
            return this.dateiGroesse_HQ;
        }
        if (this.jRadioButtonAufloesungKlein.isSelected()) {
            return this.dateiGroesse_Klein;
        }
        return this.dateiGroesse_Hoch;
    }

    private boolean check() {
        boolean ok = false;
        Object pfad = Objects.requireNonNull(this.jComboBoxPfad.getSelectedItem()).toString();
        String name = this.jTextFieldName.getText();
        if (this.datenDownload != null) {
            if (((String)pfad).isEmpty() || name.isEmpty()) {
                MVMessageDialog.showMessageDialog(this, "Pfad oder Name ist leer", "Fehlerhafter Pfad/Name!", 0);
            } else {
                if (!((String)pfad).substring(((String)pfad).length() - 1).equals(File.separator)) {
                    pfad = (String)pfad + File.separator;
                }
                if (GuiFunktionenProgramme.checkPathWriteable((String)pfad)) {
                    ok = true;
                } else {
                    MVMessageDialog.showMessageDialog(this, "Pfad ist nicht beschreibbar", "Fehlerhafter Pfad!", 0);
                }
            }
        }
        return ok;
    }

    private void addDownloadToQueue() {
        Daten.getInstance().getListeDownloads().addMitNummer(this.datenDownload);
        MessageBus.getMessageBus().publishAsync(new DownloadListChangedEvent());
        if (this.jCheckBoxStarten.isSelected()) {
            this.datenDownload.startDownload();
        }
    }

    private void saveDownload() {
        this.datenDownload = new DatenDownload(this.pSet, this.datenFilm, 2, null, this.jTextFieldName.getText(), Objects.requireNonNull(this.jComboBoxPfad.getSelectedItem()).toString(), this.getFilmResolution().toString());
        this.datenDownload.setGroesse(this.getFilmSize());
        this.datenDownload.arr[35] = Boolean.toString(this.jCheckBoxInfodatei.isSelected());
        this.datenDownload.arr[37] = Boolean.toString(this.jCheckBoxSubtitle.isSelected());
        this.addDownloadToQueue();
        this.dispose();
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        this.jButtonOk = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.jCheckBoxStarten = new JCheckBox();
        JPanel jPanel1 = new JPanel();
        this.jTextFieldName = new JTextField();
        this.jButtonZiel = new JButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.jComboBoxPfad = new JComboBox();
        this.jButtonDelHistory = new JButton();
        this.jCheckBoxPfadSpeichern = new JCheckBox();
        this.jCheckBoxInfodatei = new JCheckBox();
        JLabel jLabelSet = new JLabel();
        this.jComboBoxPset = new JComboBox();
        this.jCheckBoxSubtitle = new JCheckBox();
        this.jPanelSize = new JPanel();
        this.jRadioButtonAufloesungHd = new JRadioButton();
        this.jRadioButtonAufloesungHoch = new JRadioButton();
        this.jRadioButtonAufloesungKlein = new JRadioButton();
        this.jTextFieldSender = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Film speichern");
        this.setMinimumSize(new Dimension(646, 372));
        this.jButtonOk.setText("Ok");
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jCheckBoxStarten.setSelected(true);
        this.jCheckBoxStarten.setText("Download sofort starten");
        this.jButtonZiel.setText("File");
        this.jButtonZiel.setToolTipText("Zielpfad ausw\u00e4hlen");
        jLabel1.setText("Zielpfad:");
        jLabel4.setText("Dateiname:");
        this.jComboBoxPfad.setEditable(true);
        this.jComboBoxPfad.setMaximumRowCount(15);
        this.jButtonDelHistory.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-del.png")));
        this.jButtonDelHistory.setToolTipText("History l\u00f6schen");
        this.jCheckBoxPfadSpeichern.setText("Zielpfad speichern");
        this.jCheckBoxInfodatei.setText("Lege Infodatei an");
        this.jCheckBoxInfodatei.setToolTipText("Erzeugt eine Infodatei im Format \"Infodatei.txt\"");
        jLabelSet.setText("Set:");
        this.jCheckBoxSubtitle.setText("Untertitel speichern: \"Filmname.xxx\"");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabelSet).addComponent(jLabel1)).addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxPfad, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelHistory)).addComponent(this.jComboBoxPset, 0, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxSubtitle).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxInfodatei).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 235, Short.MAX_VALUE).addComponent(this.jCheckBoxPfadSpeichern)).addComponent(this.jTextFieldName)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabelSet).addComponent(this.jComboBoxPset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel1).addComponent(this.jButtonZiel).addComponent(this.jComboBoxPfad, -2, -1, -2).addComponent(this.jButtonDelHistory)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel4).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxPfadSpeichern).addComponent(this.jCheckBoxInfodatei)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSubtitle).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldName);
        this.jPanelSize.setBorder(BorderFactory.createTitledBorder(TITLED_BORDER_STRING));
        buttonGroup1.add(this.jRadioButtonAufloesungHd);
        this.jRadioButtonAufloesungHd.setText("H\u00f6chste/Hoch");
        buttonGroup1.add(this.jRadioButtonAufloesungHoch);
        this.jRadioButtonAufloesungHoch.setText("Mittel");
        buttonGroup1.add(this.jRadioButtonAufloesungKlein);
        this.jRadioButtonAufloesungKlein.setText("Niedrig");
        GroupLayout jPanelSizeLayout = new GroupLayout(this.jPanelSize);
        this.jPanelSize.setLayout(jPanelSizeLayout);
        jPanelSizeLayout.setHorizontalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonAufloesungHd).addGap(18, 18, 18).addComponent(this.jRadioButtonAufloesungHoch).addGap(18, 18, 18).addComponent(this.jRadioButtonAufloesungKlein).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSizeLayout.setVerticalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAufloesungHd).addComponent(this.jRadioButtonAufloesungHoch).addComponent(this.jRadioButtonAufloesungKlein)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextFieldSender.setEditable(false);
        this.jTextFieldSender.setFont(this.jTextFieldSender.getFont().deriveFont(this.jTextFieldSender.getFont().getStyle() | 1));
        this.jTextFieldSender.setText(" ARD: Tatort, ...");
        this.jTextFieldSender.setBorder(BorderFactory.createTitledBorder("Film"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelSize, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxStarten).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOk, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen)).addComponent(this.jTextFieldSender)).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldSender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButtonAbbrechen)).addComponent(this.jCheckBoxStarten)).addContainerGap()));
        this.pack();
    }
}

