/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.notification;

import es.blackleg.jlibnotify.LibNotify;
import es.blackleg.jlibnotify.Notification;
import es.blackleg.jlibnotify.ServerInfo;
import es.blackleg.jlibnotify.core.DefaultLibNotifyLoader;
import java.io.Closeable;
import java.util.Collection;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.NotificationMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LinuxNotificationCenter
implements INotificationCenter,
Closeable {
    private static final Logger logger = LogManager.getLogger();
    private LibNotify libNotify;
    private boolean nativeSupport;

    public LinuxNotificationCenter() {
        try {
            this.libNotify = DefaultLibNotifyLoader.getInstance().load();
            this.libNotify.init("MediathekView");
            this.nativeSupport = true;
            ServerInfo serverInfo = this.libNotify.getServerInfo();
            logger.debug("Name: {}", (Object)serverInfo.getName());
            logger.debug("Spec Version: {}", (Object)serverInfo.getSpecVersion());
            logger.debug("Vendor: {}", (Object)serverInfo.getVendor());
            logger.debug("Version: {}", (Object)serverInfo.getVersion());
            logger.debug("Server capabilities:");
            Collection<String> caps = this.libNotify.getServerCapabilities();
            for (String s2 : caps) {
                logger.debug("\t {}", (Object)s2);
            }
        }
        catch (RuntimeException | UnsatisfiedLinkError e) {
            this.nativeSupport = false;
            logger.error("failed to initialize libNotify", e);
        }
    }

    @Override
    public void displayNotification(NotificationMessage msg) {
        Notification notification = this.libNotify.createNotification(msg.getTitle(), msg.message, "dialog-information");
        this.libNotify.showNotification(notification);
    }

    public boolean hasNativeSupport() {
        return this.nativeSupport;
    }

    @Override
    public void close() {
        this.libNotify.unInit();
    }
}

