/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.settings;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.opensearch.Version;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;

public class WriteableSetting
implements Writeable {
    private Setting<?> setting;
    private SettingType type;

    public WriteableSetting(Setting<?> setting) {
        this(setting, WriteableSetting.getGenericTypeFromDefault(setting));
    }

    public WriteableSetting(Setting<?> setting, SettingType type) {
        this.setting = setting;
        this.type = type;
    }

    public WriteableSetting(StreamInput in) throws IOException {
        this.type = in.readEnum(SettingType.class);
        String key = in.readString();
        Object defaultValue = this.readDefaultValue(in);
        WriteableSetting fallback = null;
        boolean hasFallback = in.readBoolean();
        if (hasFallback) {
            fallback = new WriteableSetting(in);
        }
        EnumSet<Setting.Property> propSet = in.readEnumSet(Setting.Property.class);
        this.setting = this.createSetting(this.type, key, defaultValue, fallback, (Setting.Property[])propSet.toArray(Setting.Property[]::new));
    }

    private static SettingType getGenericTypeFromDefault(Setting<?> setting) {
        String typeStr = setting.getDefault(Settings.EMPTY).getClass().getSimpleName();
        try {
            return SettingType.valueOf(typeStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("This class is not yet set up to handle the generic type: " + typeStr + ". Supported types are " + Arrays.toString((Object[])SettingType.values()));
        }
    }

    public Setting<?> getSetting() {
        return this.setting;
    }

    public SettingType getType() {
        return this.type;
    }

    private Setting<?> createSetting(SettingType type, String key, Object defaultValue, WriteableSetting fallback, Setting.Property[] propertyArray) {
        switch (type) {
            case Boolean: {
                return fallback == null ? Setting.boolSetting(key, (boolean)((Boolean)defaultValue), propertyArray) : Setting.boolSetting(key, fallback.getSetting(), propertyArray);
            }
            case Integer: {
                return fallback == null ? Setting.intSetting(key, (int)((Integer)defaultValue), propertyArray) : Setting.intSetting(key, fallback.getSetting(), propertyArray);
            }
            case Long: {
                return fallback == null ? Setting.longSetting(key, (long)((Long)defaultValue), propertyArray) : Setting.longSetting(key, fallback.getSetting(), propertyArray);
            }
            case Float: {
                return fallback == null ? Setting.floatSetting(key, ((Float)defaultValue).floatValue(), propertyArray) : Setting.floatSetting(key, fallback.getSetting(), propertyArray);
            }
            case Double: {
                return fallback == null ? Setting.doubleSetting(key, (double)((Double)defaultValue), propertyArray) : Setting.doubleSetting(key, fallback.getSetting(), propertyArray);
            }
            case String: {
                return fallback == null ? Setting.simpleString(key, (String)defaultValue, propertyArray) : Setting.simpleString(key, fallback.getSetting(), propertyArray);
            }
            case TimeValue: {
                return fallback == null ? Setting.timeSetting(key, (TimeValue)defaultValue, propertyArray) : Setting.timeSetting(key, fallback.getSetting(), propertyArray);
            }
            case ByteSizeValue: {
                return fallback == null ? Setting.byteSizeSetting(key, (ByteSizeValue)defaultValue, propertyArray) : Setting.byteSizeSetting(key, fallback.getSetting(), propertyArray);
            }
            case Version: {
                return Setting.versionSetting(key, (Version)defaultValue, propertyArray);
            }
        }
        throw new IllegalArgumentException("A SettingType has been added to the enum and not handled here.");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.type);
        out.writeString(this.setting.getKey());
        this.writeDefaultValue(out, this.setting.getDefault(Settings.EMPTY));
        boolean hasFallback = this.setting.fallbackSetting != null;
        out.writeBoolean(hasFallback);
        if (hasFallback) {
            new WriteableSetting(this.setting.fallbackSetting, this.type).writeTo(out);
        }
        out.writeEnumSet(this.setting.getProperties());
    }

    private void writeDefaultValue(StreamOutput out, Object defaultValue) throws IOException {
        switch (this.type) {
            case Boolean: {
                out.writeBoolean((Boolean)defaultValue);
                break;
            }
            case Integer: {
                out.writeInt((Integer)defaultValue);
                break;
            }
            case Long: {
                out.writeLong((Long)defaultValue);
                break;
            }
            case Float: {
                out.writeFloat(((Float)defaultValue).floatValue());
                break;
            }
            case Double: {
                out.writeDouble((Double)defaultValue);
                break;
            }
            case String: {
                out.writeString((String)defaultValue);
                break;
            }
            case TimeValue: {
                TimeValue tv = (TimeValue)defaultValue;
                out.writeLong(tv.duration());
                out.writeString(tv.timeUnit().name());
                break;
            }
            case ByteSizeValue: {
                ((ByteSizeValue)defaultValue).writeTo(out);
                break;
            }
            case Version: {
                Version.writeVersion((Version)defaultValue, out);
                break;
            }
            default: {
                throw new IllegalArgumentException("A SettingType has been added to the enum and not handled here.");
            }
        }
    }

    private Object readDefaultValue(StreamInput in) throws IOException {
        switch (this.type) {
            case Boolean: {
                return in.readBoolean();
            }
            case Integer: {
                return in.readInt();
            }
            case Long: {
                return in.readLong();
            }
            case Float: {
                return Float.valueOf(in.readFloat());
            }
            case Double: {
                return in.readDouble();
            }
            case String: {
                return in.readString();
            }
            case TimeValue: {
                long duration = in.readLong();
                TimeUnit unit = TimeUnit.valueOf(in.readString());
                return new TimeValue(duration, unit);
            }
            case ByteSizeValue: {
                return new ByteSizeValue(in);
            }
            case Version: {
                return Version.readVersion(in);
            }
        }
        throw new IllegalArgumentException("A SettingType has been added to the enum and not handled here.");
    }

    public String toString() {
        return "WriteableSettings{type=Setting<" + this.type + ">, setting=" + this.setting + "}";
    }

    public static enum SettingType {
        Boolean,
        Integer,
        Long,
        Float,
        Double,
        String,
        TimeValue,
        ByteSizeValue,
        Version;

    }
}

