/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.extensions.ExtensionsManager;
import org.opensearch.transport.TransportRequest;

public class ExtensionRequest
extends TransportRequest {
    private static final Logger logger = LogManager.getLogger(ExtensionRequest.class);
    private ExtensionsManager.RequestType requestType;

    public ExtensionRequest(ExtensionsManager.RequestType requestType) {
        this.requestType = requestType;
    }

    public ExtensionRequest(StreamInput in) throws IOException {
        super(in);
        this.requestType = in.readEnum(ExtensionsManager.RequestType.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum(this.requestType);
    }

    public ExtensionsManager.RequestType getRequestType() {
        return this.requestType;
    }

    public String toString() {
        return "ExtensionRequest{requestType=" + this.requestType + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionRequest that = (ExtensionRequest)o;
        return Objects.equals((Object)this.requestType, (Object)that.requestType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestType});
    }
}

