/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.transport.TransportRequest;

public class RegisterRestActionsRequest
extends TransportRequest {
    private String uniqueId;
    private List<String> restActions;

    public RegisterRestActionsRequest(String uniqueId, List<String> restActions) {
        this.uniqueId = uniqueId;
        this.restActions = new ArrayList<String>(restActions);
    }

    public RegisterRestActionsRequest(StreamInput in) throws IOException {
        super(in);
        this.uniqueId = in.readString();
        this.restActions = in.readStringList();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.uniqueId);
        out.writeStringCollection(this.restActions);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public List<String> getRestActions() {
        return new ArrayList<String>(this.restActions);
    }

    public String toString() {
        return "RestActionsRequest{uniqueId=" + this.uniqueId + ", restActions=" + this.restActions + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegisterRestActionsRequest that = (RegisterRestActionsRequest)obj;
        return Objects.equals(this.uniqueId, that.uniqueId) && Objects.equals(this.restActions, that.restActions);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.restActions);
    }
}

