/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.util.SetOnce;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.BytesStreamOutput;

public class TranslogTransferMetadata {
    private final long primaryTerm;
    private final long generation;
    private final long minTranslogGeneration;
    private final long timeStamp;
    private int count;
    private final SetOnce<Map<String, String>> generationToPrimaryTermMapper = new SetOnce();
    private static final String METADATA_SEPARATOR = "__";
    private static final int BUFFER_SIZE = 4096;
    private static final int CURRENT_VERSION = 1;
    private static final String METADATA_CODEC = "md";
    public static final Comparator<String> METADATA_FILENAME_COMPARATOR = new MetadataFilenameComparator();

    public TranslogTransferMetadata(long primaryTerm, long generation, long minTranslogGeneration, int count) {
        this.primaryTerm = primaryTerm;
        this.generation = generation;
        this.minTranslogGeneration = minTranslogGeneration;
        this.timeStamp = System.currentTimeMillis();
        this.count = count;
    }

    public TranslogTransferMetadata(IndexInput indexInput) throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)indexInput);
        CodecUtil.checkHeader((DataInput)indexInput, (String)METADATA_CODEC, (int)1, (int)1);
        this.primaryTerm = indexInput.readLong();
        this.generation = indexInput.readLong();
        this.minTranslogGeneration = indexInput.readLong();
        this.timeStamp = indexInput.readLong();
        this.generationToPrimaryTermMapper.set((Object)indexInput.readMapOfStrings());
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getMinTranslogGeneration() {
        return this.minTranslogGeneration;
    }

    public int getCount() {
        return this.count;
    }

    public void setGenerationToPrimaryTermMapper(Map<String, String> generationToPrimaryTermMap) {
        this.generationToPrimaryTermMapper.set(generationToPrimaryTermMap);
    }

    public Map<String, String> getGenerationToPrimaryTermMapper() {
        return (Map)this.generationToPrimaryTermMapper.get();
    }

    public String getFileName() {
        return String.join((CharSequence)METADATA_SEPARATOR, Arrays.asList(String.valueOf(this.primaryTerm), String.valueOf(this.generation), String.valueOf(this.timeStamp)));
    }

    public byte[] createMetadataBytes() throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("translog transfer metadata " + this.primaryTerm, this.getFileName(), (OutputStream)output, 4096);){
                CodecUtil.writeHeader((DataOutput)indexOutput, (String)METADATA_CODEC, (int)1);
                this.write((DataOutput)indexOutput);
                CodecUtil.writeFooter((IndexOutput)indexOutput);
            }
            byte[] byArray = BytesReference.toBytes(output.bytes());
            return byArray;
        }
    }

    public int hashCode() {
        return Objects.hash(this.primaryTerm, this.generation, this.timeStamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslogTransferMetadata other = (TranslogTransferMetadata)o;
        return Objects.equals(this.primaryTerm, other.primaryTerm) && Objects.equals(this.generation, other.generation) && Objects.equals(this.timeStamp, other.timeStamp);
    }

    private void write(DataOutput out) throws IOException {
        out.writeLong(this.primaryTerm);
        out.writeLong(this.generation);
        out.writeLong(this.minTranslogGeneration);
        out.writeLong(this.timeStamp);
        if (this.generationToPrimaryTermMapper.get() != null) {
            out.writeMapOfStrings((Map)this.generationToPrimaryTermMapper.get());
        } else {
            out.writeMapOfStrings(new HashMap());
        }
    }

    private static class MetadataFilenameComparator
    implements Comparator<String> {
        private MetadataFilenameComparator() {
        }

        @Override
        public int compare(String first, String second) {
            String[] filenameTokens1 = first.split(TranslogTransferMetadata.METADATA_SEPARATOR);
            String[] filenameTokens2 = second.split(TranslogTransferMetadata.METADATA_SEPARATOR);
            for (int i = 0; i < filenameTokens1.length - 1; ++i) {
                if (filenameTokens1[i].equals(filenameTokens2[i])) continue;
                return Long.compare(Long.parseLong(filenameTokens1[i]), Long.parseLong(filenameTokens2[i]));
            }
            throw new IllegalArgumentException("TranslogTransferMetadata files " + first + " and " + second + " have same primary term and generation");
        }
    }
}

