/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.PriorityQueue;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.LongArray;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.opensearch.search.aggregations.bucket.terms.BucketSignificancePriorityQueue;
import org.opensearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.opensearch.search.aggregations.bucket.terms.SignificantStringTerms;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;

public class MapStringTermsAggregator
extends AbstractStringTermsAggregator {
    private final CollectorSource collectorSource;
    private final ResultStrategy<?, ?> resultStrategy;
    private final BytesKeyedBucketOrds bucketOrds;
    private final IncludeExclude.StringFilter includeExclude;

    public MapStringTermsAggregator(String name, AggregatorFactories factories, CollectorSource collectorSource, Function<MapStringTermsAggregator, ResultStrategy<?, ?>> resultStrategy, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.StringFilter includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, metadata);
        this.collectorSource = collectorSource;
        this.resultStrategy = resultStrategy.apply(this);
        this.includeExclude = includeExclude;
        this.bucketOrds = BytesKeyedBucketOrds.build(context.bigArrays(), cardinality);
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.collectorSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        return this.resultStrategy.wrapCollector(this.collectorSource.getLeafCollector(this.includeExclude, ctx, sub, this::addRequestCircuitBreakerBytes, (s, doc, owningBucketOrd, bytes) -> {
            long bucketOrdinal = this.bucketOrds.add(owningBucketOrd, bytes);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingBucket(s, doc, bucketOrdinal);
            } else {
                this.collectBucket(s, doc, bucketOrdinal);
            }
        }));
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.resultStrategy.buildAggregations(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("total_buckets", this.bucketOrds.size());
        add.accept("result_strategy", this.resultStrategy.describe());
    }

    @Override
    public void doClose() {
        Releasables.close(this.collectorSource, this.resultStrategy, this.bucketOrds);
    }

    class SignificantTermsResults
    extends ResultStrategy<SignificantStringTerms, SignificantStringTerms.Bucket> {
        private final SignificanceLookup.BackgroundFrequencyForBytes backgroundFrequencies;
        private final long supersetSize;
        private final SignificanceHeuristic significanceHeuristic;
        private LongArray subsetSizes;

        SignificantTermsResults(SignificanceLookup significanceLookup, SignificanceHeuristic significanceHeuristic, CardinalityUpperBound cardinality) {
            this.subsetSizes = MapStringTermsAggregator.this.context.bigArrays().newLongArray(1L, true);
            this.backgroundFrequencies = significanceLookup.bytesLookup(MapStringTermsAggregator.this.context.bigArrays(), cardinality);
            this.supersetSize = significanceLookup.supersetSize();
            this.significanceHeuristic = significanceHeuristic;
        }

        @Override
        String describe() {
            return "significant_terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return new LeafBucketCollectorBase(primary, null){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    super.collect(doc, owningBucketOrd);
                    SignificantTermsResults.this.subsetSizes = MapStringTermsAggregator.this.context.bigArrays().grow(SignificantTermsResults.this.subsetSizes, owningBucketOrd + 1L);
                    SignificantTermsResults.this.subsetSizes.increment(owningBucketOrd, 1L);
                }
            };
        }

        @Override
        void collectZeroDocEntriesIfNeeded(long owningBucketOrd) throws IOException {
        }

        @Override
        Supplier<SignificantStringTerms.Bucket> emptyBucketBuilder(long owningBucketOrd) {
            long subsetSize = this.subsetSizes.get(owningBucketOrd);
            return () -> new SignificantStringTerms.Bucket(new BytesRef(), 0L, subsetSize, 0L, 0L, null, MapStringTermsAggregator.this.format, 0.0);
        }

        @Override
        PriorityQueue<SignificantStringTerms.Bucket> buildPriorityQueue(int size) {
            return new BucketSignificancePriorityQueue<SignificantStringTerms.Bucket>(size);
        }

        @Override
        void updateBucket(SignificantStringTerms.Bucket spare, BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount) throws IOException {
            ordsEnum.readValue(spare.termBytes);
            spare.bucketOrd = ordsEnum.ord();
            spare.subsetDf = docCount;
            spare.supersetDf = this.backgroundFrequencies.freq(spare.termBytes);
            spare.supersetSize = this.supersetSize;
            spare.updateScore(this.significanceHeuristic);
        }

        SignificantStringTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new SignificantStringTerms.Bucket[size][];
        }

        SignificantStringTerms.Bucket[] buildBuckets(int size) {
            return new SignificantStringTerms.Bucket[size];
        }

        @Override
        void finalizeBucket(SignificantStringTerms.Bucket bucket) {
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
        }

        void buildSubAggs(SignificantStringTerms.Bucket[][] topBucketsPerOrd) throws IOException {
            MapStringTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, a) -> {
                b.aggregations = a;
            });
        }

        SignificantStringTerms buildResult(long owningBucketOrd, long otherDocCount, SignificantStringTerms.Bucket[] topBuckets) {
            return new SignificantStringTerms(MapStringTermsAggregator.this.name, MapStringTermsAggregator.this.bucketCountThresholds.getRequiredSize(), MapStringTermsAggregator.this.bucketCountThresholds.getMinDocCount(), MapStringTermsAggregator.this.metadata(), MapStringTermsAggregator.this.format, this.subsetSizes.get(owningBucketOrd), this.supersetSize, this.significanceHeuristic, Arrays.asList(topBuckets));
        }

        @Override
        SignificantStringTerms buildEmptyResult() {
            return MapStringTermsAggregator.this.buildEmptySignificantTermsAggregation(0L, this.significanceHeuristic);
        }

        @Override
        public void close() {
            Releasables.close(this.backgroundFrequencies, this.subsetSizes);
        }
    }

    class StandardTermsResults
    extends ResultStrategy<StringTerms, StringTerms.Bucket> {
        private final ValuesSource valuesSource;

        StandardTermsResults(ValuesSource valuesSource) {
            this.valuesSource = valuesSource;
        }

        @Override
        String describe() {
            return "terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        @Override
        void collectZeroDocEntriesIfNeeded(long owningBucketOrd) throws IOException {
            if (MapStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L) {
                return;
            }
            if (InternalOrder.isCountDesc(MapStringTermsAggregator.this.order) && MapStringTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrd) >= (long)MapStringTermsAggregator.this.bucketCountThresholds.getRequiredSize()) {
                return;
            }
            for (LeafReaderContext ctx : MapStringTermsAggregator.this.context.searcher().getTopReaderContext().leaves()) {
                SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    if (!values.advanceExact(docId)) continue;
                    int valueCount = values.docValueCount();
                    for (int i = 0; i < valueCount; ++i) {
                        BytesRef term = values.nextValue();
                        if (MapStringTermsAggregator.this.includeExclude != null && !MapStringTermsAggregator.this.includeExclude.accept(term)) continue;
                        MapStringTermsAggregator.this.bucketOrds.add(owningBucketOrd, term);
                    }
                }
            }
        }

        @Override
        Supplier<StringTerms.Bucket> emptyBucketBuilder(long owningBucketOrd) {
            return () -> new StringTerms.Bucket(new BytesRef(), 0L, null, MapStringTermsAggregator.this.showTermDocCountError, 0L, MapStringTermsAggregator.this.format);
        }

        @Override
        PriorityQueue<StringTerms.Bucket> buildPriorityQueue(int size) {
            return new BucketPriorityQueue<StringTerms.Bucket>(size, MapStringTermsAggregator.this.partiallyBuiltBucketComparator);
        }

        @Override
        void updateBucket(StringTerms.Bucket spare, BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum, long docCount) throws IOException {
            ordsEnum.readValue(spare.termBytes);
            spare.docCount = docCount;
            spare.bucketOrd = ordsEnum.ord();
        }

        StringTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new StringTerms.Bucket[size][];
        }

        StringTerms.Bucket[] buildBuckets(int size) {
            return new StringTerms.Bucket[size];
        }

        @Override
        void finalizeBucket(StringTerms.Bucket bucket) {
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
        }

        void buildSubAggs(StringTerms.Bucket[][] topBucketsPerOrd) throws IOException {
            MapStringTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, a) -> {
                b.aggregations = a;
            });
        }

        StringTerms buildResult(long owningBucketOrd, long otherDocCount, StringTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(MapStringTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = MapStringTermsAggregator.this.order;
            }
            return new StringTerms(MapStringTermsAggregator.this.name, reduceOrder, MapStringTermsAggregator.this.order, MapStringTermsAggregator.this.bucketCountThresholds.getRequiredSize(), MapStringTermsAggregator.this.bucketCountThresholds.getMinDocCount(), MapStringTermsAggregator.this.metadata(), MapStringTermsAggregator.this.format, MapStringTermsAggregator.this.bucketCountThresholds.getShardSize(), MapStringTermsAggregator.this.showTermDocCountError, otherDocCount, Arrays.asList(topBuckets), 0L);
        }

        @Override
        StringTerms buildEmptyResult() {
            return MapStringTermsAggregator.this.buildEmptyTermsAggregation();
        }

        @Override
        public void close() {
        }
    }

    abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        ResultStrategy() {
        }

        private InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            InternalMultiBucketAggregation.InternalBucket[][] topBucketsPerOrd = this.buildTopBucketsPerOrd(owningBucketOrds.length);
            long[] otherDocCounts = new long[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                this.collectZeroDocEntriesIfNeeded(owningBucketOrds[ordIdx]);
                int size = (int)Math.min(MapStringTermsAggregator.this.bucketOrds.size(), (long)MapStringTermsAggregator.this.bucketCountThresholds.getShardSize());
                PriorityQueue<B> ordered = this.buildPriorityQueue(size);
                InternalMultiBucketAggregation.InternalBucket spare = null;
                BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = MapStringTermsAggregator.this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
                Supplier<B> emptyBucketBuilder = this.emptyBucketBuilder(owningBucketOrds[ordIdx]);
                while (ordsEnum.next()) {
                    long docCount = MapStringTermsAggregator.this.bucketDocCount(ordsEnum.ord());
                    int n = ordIdx;
                    otherDocCounts[n] = otherDocCounts[n] + docCount;
                    if (docCount < MapStringTermsAggregator.this.bucketCountThresholds.getShardMinDocCount()) continue;
                    if (spare == null) {
                        spare = (InternalMultiBucketAggregation.InternalBucket)emptyBucketBuilder.get();
                    }
                    this.updateBucket(spare, ordsEnum, docCount);
                    spare = (InternalMultiBucketAggregation.InternalBucket)ordered.insertWithOverflow((Object)spare);
                }
                topBucketsPerOrd[ordIdx] = this.buildBuckets(ordered.size());
                for (int i = ordered.size() - 1; i >= 0; --i) {
                    topBucketsPerOrd[ordIdx][i] = (InternalMultiBucketAggregation.InternalBucket)ordered.pop();
                    int n = ordIdx;
                    otherDocCounts[n] = otherDocCounts[n] - topBucketsPerOrd[ordIdx][i].getDocCount();
                    this.finalizeBucket(topBucketsPerOrd[ordIdx][i]);
                }
            }
            this.buildSubAggs(topBucketsPerOrd);
            InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                result[ordIdx] = this.buildResult(owningBucketOrds[ordIdx], otherDocCounts[ordIdx], topBucketsPerOrd[ordIdx]);
            }
            return result;
        }

        abstract String describe();

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract void collectZeroDocEntriesIfNeeded(long var1) throws IOException;

        abstract Supplier<B> emptyBucketBuilder(long var1);

        abstract PriorityQueue<B> buildPriorityQueue(int var1);

        abstract void updateBucket(B var1, BytesKeyedBucketOrds.BucketOrdsEnum var2, long var3) throws IOException;

        abstract B[][] buildTopBucketsPerOrd(int var1);

        abstract B[] buildBuckets(int var1);

        abstract void finalizeBucket(B var1);

        abstract void buildSubAggs(B[][] var1) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();
    }

    public static class ValuesSourceCollectorSource
    implements CollectorSource {
        private final ValuesSource valuesSource;

        public ValuesSourceCollectorSource(ValuesSource valuesSource) {
            this.valuesSource = valuesSource;
        }

        @Override
        public boolean needsScores() {
            return this.valuesSource.needsScores();
        }

        @Override
        public LeafBucketCollector getLeafCollector(final IncludeExclude.StringFilter includeExclude, LeafReaderContext ctx, final LeafBucketCollector sub, LongConsumer addRequestCircuitBreakerBytes, final CollectConsumer consumer) throws IOException {
            final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
            return new LeafBucketCollectorBase(sub, values){
                final BytesRefBuilder previous;
                {
                    super(sub2, values2);
                    this.previous = new BytesRefBuilder();
                }

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!values.advanceExact(doc)) {
                        return;
                    }
                    int valuesCount = values.docValueCount();
                    this.previous.clear();
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef bytes = values.nextValue();
                        if (includeExclude != null && !includeExclude.accept(bytes) || i > 0 && this.previous.get().equals((Object)bytes)) continue;
                        this.previous.copyBytes(bytes);
                        consumer.accept(sub, doc, owningBucketOrd, bytes);
                    }
                }
            };
        }

        @Override
        public void close() {
        }
    }

    @FunctionalInterface
    public static interface CollectConsumer {
        public void accept(LeafBucketCollector var1, int var2, long var3, BytesRef var5) throws IOException;
    }

    public static interface CollectorSource
    extends Releasable {
        public boolean needsScores();

        public LeafBucketCollector getLeafCollector(IncludeExclude.StringFilter var1, LeafReaderContext var2, LeafBucketCollector var3, LongConsumer var4, CollectConsumer var5) throws IOException;
    }
}

