/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.io.IOException;
import java.util.Objects;
import lombok.NonNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

public class UploadGeoJSONRequest
extends ActionRequest {
    @NonNull
    private final RestRequest.Method method;
    @NonNull
    private final BytesReference content;

    public UploadGeoJSONRequest(StreamInput in) throws IOException {
        super(in);
        this.content = Objects.requireNonNull(in.readBytesReference(), "data is missing");
        this.method = Objects.requireNonNull((RestRequest.Method)in.readEnum(RestRequest.Method.class), "RestRequest Method is missing");
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.content);
        out.writeEnum((Enum)this.method);
    }

    public UploadGeoJSONRequest(@NonNull RestRequest.Method method, @NonNull BytesReference content) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.method = method;
        this.content = content;
    }

    @NonNull
    public RestRequest.Method getMethod() {
        return this.method;
    }

    @NonNull
    public BytesReference getContent() {
        return this.content;
    }
}

