/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.mapper.xyshape;

import java.util.Locale;
import java.util.Objects;
import org.opensearch.geometry.Circle;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.GeometryCollection;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geometry.Line;
import org.opensearch.geometry.LinearRing;
import org.opensearch.geometry.MultiLine;
import org.opensearch.geometry.MultiPoint;
import org.opensearch.geometry.MultiPolygon;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Polygon;
import org.opensearch.geometry.Rectangle;
import org.opensearch.geometry.ShapeType;

public final class XYShapeSupportVisitor
implements GeometryVisitor<Geometry, RuntimeException> {
    public Geometry visit(Circle circle) {
        throw new UnsupportedOperationException(String.format(Locale.getDefault(), "%s is not supported", ShapeType.CIRCLE));
    }

    public Geometry visit(GeometryCollection<?> collection) {
        return (Geometry)Objects.requireNonNull(collection, "Geometry collection cannot be null");
    }

    public Geometry visit(Line line) {
        return (Geometry)Objects.requireNonNull(line, "Line cannot be null");
    }

    public Geometry visit(LinearRing ring) {
        throw new UnsupportedOperationException(String.format(Locale.getDefault(), "cannot index %s [ %s ] directly", ShapeType.LINEARRING, ring));
    }

    public Geometry visit(MultiLine multiLine) {
        return (Geometry)Objects.requireNonNull(multiLine, "Multi Line cannot be null");
    }

    public Geometry visit(MultiPoint multiPoint) {
        return (Geometry)Objects.requireNonNull(multiPoint, "Multi Point cannot be null");
    }

    public Geometry visit(MultiPolygon multiPolygon) {
        return (Geometry)Objects.requireNonNull(multiPolygon, "Multi Polygon cannot be null");
    }

    public Geometry visit(Point point) {
        return (Geometry)Objects.requireNonNull(point, "Point cannot be null");
    }

    public Geometry visit(Polygon polygon) {
        return (Geometry)Objects.requireNonNull(polygon, "Polygon cannot be null");
    }

    public Geometry visit(Rectangle rectangle) {
        return (Geometry)Objects.requireNonNull(rectangle, "Rectangle cannot be null");
    }
}

