/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.stats.upload;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.geospatial.stats.upload.TotalUploadStats;
import org.opensearch.geospatial.stats.upload.UploadMetric;
import org.opensearch.geospatial.stats.upload.UploadStats;

public class UploadStatsService
implements ToXContentFragment {
    public static final String METRICS = "metrics";
    public static final String NODE_ID = "node_id";
    private final Map<String, UploadStats> uploadStats;
    private final TotalUploadStats totalUploadStats;

    public UploadStatsService(Map<String, UploadStats> uploadStats) {
        this.uploadStats = Objects.requireNonNull(uploadStats, "upload stats map cannot be null");
        this.totalUploadStats = new TotalUploadStats(new ArrayList<UploadStats>(uploadStats.values()));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.totalUploadStats.toXContent(builder, params);
        builder.startArray(METRICS);
        if (this.totalUploadStats.isUploadStatsEmpty()) {
            builder.endArray();
            return builder.endObject();
        }
        List<AbstractMap.SimpleEntry<String, UploadMetric>> metricsByNodeID = this.groupMetricsByNodeID(this.uploadStats);
        for (AbstractMap.SimpleEntry<String, UploadMetric> entry : metricsByNodeID) {
            this.addMetrics(builder, params, entry);
        }
        builder.endArray();
        return builder.endObject();
    }

    private void addMetrics(XContentBuilder builder, ToXContent.Params params, AbstractMap.SimpleEntry<String, UploadMetric> entry) throws IOException {
        builder.startObject();
        builder.field(NODE_ID, entry.getKey());
        entry.getValue().toXContent(builder, params);
        builder.endObject();
    }

    private List<AbstractMap.SimpleEntry<String, UploadMetric>> groupMetricsByNodeID(Map<String, UploadStats> uploadStats) {
        return uploadStats.entrySet().stream().flatMap(stat -> ((UploadStats)stat.getValue()).getMetrics().stream().map(metric -> new AbstractMap.SimpleEntry<String, UploadMetric>((String)stat.getKey(), (UploadMetric)metric))).collect(Collectors.toList());
    }
}

