/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.shrink;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.node.stats.NodeStats;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.opensearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.opensearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.opensearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.allocation.RerouteExplanation;
import org.opensearch.cluster.routing.allocation.command.AllocationCommand;
import org.opensearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.index.shard.DocsStats;
import org.opensearch.index.store.StoreStats;
import org.opensearch.indexmanagement.indexstatemanagement.action.ShrinkAction;
import org.opensearch.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import org.opensearch.indexmanagement.indexstatemanagement.step.shrink.AttemptMoveShardsStep;
import org.opensearch.indexmanagement.indexstatemanagement.step.shrink.ShrinkStep;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.indexstatemanagement.util.StepUtilsKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ShrinkActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.TemplateScript;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u0000 H2\u00020\u0001:\u0001HB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JG\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J*\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J5\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\bH\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0002J;\u0010&\u001a\u001c\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0018\u00010'2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J#\u0010-\u001a\u0004\u0018\u00010\u000e2\u0006\u0010.\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0018\u0010/\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0002J\u0018\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u000eH\u0002J$\u00103\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b042\u0006\u0010\u000f\u001a\u00020\b2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u00152\u0006\u00108\u001a\u00020\u0015H\u0016J\b\u00109\u001a\u00020:H\u0016J)\u0010;\u001a\u00020:2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020\u0007H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J\u0018\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020)2\u0006\u0010A\u001a\u00020#H\u0002J\u0018\u0010B\u001a\u00020:2\u0006\u00105\u001a\u0002062\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0018\u0010C\u001a\u00020:2\u0006\u00105\u001a\u0002062\u0006\u0010D\u001a\u00020\bH\u0002J\u0019\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u001bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006I"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/AttemptMoveShardsStep;", "Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/ShrinkStep;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/ShrinkAction;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/ShrinkAction;)V", "acquireLockFromNodeList", "Lkotlin/Pair;", "Lorg/opensearch/jobscheduler/spi/LockModel;", "", "lockService", "Lorg/opensearch/jobscheduler/spi/utils/LockService;", "suitableNodes", "", "jobIntervalSeconds", "", "indexName", "(Lorg/opensearch/jobscheduler/spi/utils/LockService;Ljava/util/List;Ljava/lang/Long;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "compileTemplate", "template", "Lorg/opensearch/script/Script;", "managedIndexMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "defaultValue", "scriptService", "Lorg/opensearch/script/ScriptService;", "findSuitableNodes", "stepContext", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "shardStats", "", "Lorg/opensearch/action/admin/indices/stats/ShardStats;", "indexSizeInBytes", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;[Lorg/opensearch/action/admin/indices/stats/ShardStats;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getGenericFailureMessage", "getGreatestFactorLessThan", "", "n", "k", "getIndexStats", "Lkotlin/Triple;", "Lorg/opensearch/index/store/StoreStats;", "Lorg/opensearch/index/shard/DocsStats;", "client", "Lorg/opensearch/client/Client;", "(Ljava/lang/String;Lorg/opensearch/client/Client;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getJobIntervalSeconds", "indexUuid", "getMinFactorGreaterThan", "getNumTargetShards", "numOriginalShards", "indexSize", "getOriginalSettings", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "getUpdatedManagedIndexMetadata", "currentMetadata", "isIdempotent", "", "setToReadOnlyAndMoveIndexToNode", "node", "lock", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Ljava/lang/String;Lorg/opensearch/jobscheduler/spi/LockModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shouldFailTooManyDocuments", "docsStats", "numTargetShards", "shouldFailUnsafe", "targetIndexNameIsInvalid", "shrinkTargetIndexName", "wrappedExecute", "context", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-index-management"})
public final class AttemptMoveShardsStep
extends ShrinkStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShrinkAction action;
    @NotNull
    public static final String FS_METRIC = "fs";
    @NotNull
    public static final String ROUTING_SETTING = "index.routing.allocation.require._name";
    @NotNull
    public static final String DEFAULT_TARGET_SUFFIX = "_shrunken";
    @NotNull
    public static final String name = "attempt_move_shards_step";
    @NotNull
    public static final String UPDATE_FAILED_MESSAGE = "Shrink failed because shard settings could not be updated.";
    @NotNull
    public static final String NO_AVAILABLE_NODES_MESSAGE = "There are no available nodes to move to to execute a shrink. Delaying until node becomes available.";
    @NotNull
    public static final String UNSAFE_FAILURE_MESSAGE = "Shrink failed because index has no replicas and force_unsafe is not set to true.";
    @NotNull
    public static final String ONE_PRIMARY_SHARD_MESSAGE = "Shrink action did not do anything because source index only has one primary shard.";
    @NotNull
    public static final String TOO_MANY_DOCS_FAILURE_MESSAGE = "Shrink failed because there would be too many documents on each target shard following the shrink.";
    @NotNull
    public static final String INDEX_NOT_GREEN_MESSAGE = "Shrink action cannot start moving shards as the index is not green.";
    @NotNull
    public static final String FAILURE_MESSAGE = "Shrink failed to start moving shards.";
    private static final long DEFAULT_LOCK_INTERVAL = 10800L;
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    public static final long THIRTY_SECONDS_IN_MILLIS = 30000L;
    private static final int JOB_INTERVAL_LOCK_MULTIPLIER = 3;
    private static final int LOCK_BUFFER_SECONDS = 1800;
    private static final long MAXIMUM_DOCS_PER_SHARD = 0x80000000L;
    @NotNull
    private static final Set<String> ALLOWED_TEMPLATE_FIELDS;

    public AttemptMoveShardsStep(@NotNull ShrinkAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false, false, false);
        this.action = action;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object wrappedExecute(@NotNull StepContext var1_1, @NotNull Continuation<? super AttemptMoveShardsStep> var2_2) {
        if (!(var2_2 instanceof wrappedExecute.1)) ** GOTO lbl-1000
        var21_3 = var2_2;
        if ((var21_3.label & -2147483648) != 0) {
            var21_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptMoveShardsStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.wrappedExecute((StepContext)null, (Continuation<? super AttemptMoveShardsStep>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var22_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                client = context.getClient();
                indexName = context.getMetadata().getIndex();
                shrinkTargetIndexName = this.compileTemplate(this.action.getTargetIndexTemplate(), context.getMetadata(), indexName + "_shrunken", context.getScriptService());
                if (this.targetIndexNameIsInvalid(context.getClusterService(), shrinkTargetIndexName)) {
                    return this;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = client;
                $continuation.L$3 = indexName;
                $continuation.L$4 = shrinkTargetIndexName;
                $continuation.label = 1;
                v0 = StepUtilsKt.isIndexGreen$default(client, indexName, null, (Continuation)$continuation, 4, null);
                if (v0 == var22_5) {
                    return var22_5;
                }
                ** GOTO lbl35
            }
            case 1: {
                shrinkTargetIndexName = (String)$continuation.L$4;
                indexName = (String)$continuation.L$3;
                client = (Client)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    this.setInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)"Shrink action cannot start moving shards as the index is not green.")));
                    this.setStepStatus(Step.StepStatus.CONDITION_NOT_MET);
                    return this;
                }
                if (this.shouldFailUnsafe(context.getClusterService(), indexName)) {
                    return this;
                }
                numOriginalShards = ((IndexMetadata)context.getClusterService().state().getMetadata().getIndices().get((Object)indexName)).getNumberOfShards();
                if (numOriginalShards == 1) {
                    this.setInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)"Shrink action did not do anything because source index only has one primary shard.")));
                    this.setStepStatus(Step.StepStatus.COMPLETED);
                    return this;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = client;
                $continuation.L$3 = indexName;
                $continuation.L$4 = shrinkTargetIndexName;
                $continuation.I$0 = numOriginalShards;
                $continuation.label = 2;
                v1 = this.getIndexStats(indexName, client, (Continuation<? super Triple<? extends StoreStats, ? extends DocsStats, ShardStats[]>>)$continuation);
                if (v1 == var22_5) {
                    return var22_5;
                }
                ** GOTO lbl66
            }
            case 2: {
                numOriginalShards = $continuation.I$0;
                shrinkTargetIndexName = (String)$continuation.L$4;
                indexName = (String)$continuation.L$3;
                client = (Client)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl66:
                // 2 sources

                v2 = (Triple)v1;
                if (v2 == null) {
                    return this;
                }
                var7_10 = v2;
                statsStore = (StoreStats)var7_10.component1();
                statsDocs = (DocsStats)var7_10.component2();
                shardStats = (ShardStats[])var7_10.component3();
                indexSize = statsStore.getSizeInBytes();
                numTargetShards = this.getNumTargetShards(numOriginalShards, indexSize);
                if (this.shouldFailTooManyDocuments(statsDocs, numTargetShards)) {
                    return this;
                }
                originalIndexSettings = this.getOriginalSettings(indexName, context.getClusterService());
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = client;
                $continuation.L$3 = indexName;
                $continuation.L$4 = shrinkTargetIndexName;
                $continuation.L$5 = originalIndexSettings;
                $continuation.I$0 = numTargetShards;
                $continuation.label = 3;
                v3 = this.findSuitableNodes(context, shardStats, indexSize, (Continuation<? super List<String>>)$continuation);
                if (v3 == var22_5) {
                    return var22_5;
                }
                ** GOTO lbl100
            }
            case 3: {
                numTargetShards = $continuation.I$0;
                originalIndexSettings = (Map<String, String>)$continuation.L$5;
                shrinkTargetIndexName = (String)$continuation.L$4;
                indexName = (String)$continuation.L$3;
                client = (Client)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl100:
                // 2 sources

                suitableNodes = (List)v3;
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = indexName;
                $continuation.L$3 = shrinkTargetIndexName;
                $continuation.L$4 = originalIndexSettings;
                $continuation.L$5 = suitableNodes;
                $continuation.I$0 = numTargetShards;
                $continuation.label = 4;
                v4 = this.getJobIntervalSeconds(context.getMetadata().getIndexUuid(), client, (Continuation<? super Long>)$continuation);
                if (v4 == var22_5) {
                    return var22_5;
                }
                ** GOTO lbl123
            }
            case 4: {
                numTargetShards = $continuation.I$0;
                suitableNodes = (List)$continuation.L$5;
                originalIndexSettings = (Map)$continuation.L$4;
                shrinkTargetIndexName = (String)$continuation.L$3;
                indexName = (String)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl123:
                // 2 sources

                interval = (Long)v4;
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = shrinkTargetIndexName;
                $continuation.L$3 = originalIndexSettings;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.I$0 = numTargetShards;
                $continuation.label = 5;
                v5 = this.acquireLockFromNodeList(context.getLockService(), suitableNodes, interval, indexName, (Continuation<? super Pair<LockModel, String>>)$continuation);
                if (v5 == var22_5) {
                    return var22_5;
                }
                ** GOTO lbl144
            }
            case 5: {
                numTargetShards = $continuation.I$0;
                originalIndexSettings = (Map)$continuation.L$3;
                shrinkTargetIndexName = (String)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl144:
                // 2 sources

                v6 = (Pair)v5;
                if (v6 == null) {
                    return this;
                }
                var17_19 = v6;
                lock = (LockModel)var17_19.component1();
                nodeName = (String)var17_19.component2();
                this.setShrinkActionProperties(new ShrinkActionProperties(nodeName, shrinkTargetIndexName, numTargetShards, lock.getPrimaryTerm(), lock.getSeqNo(), lock.getLockTime().getEpochSecond(), lock.getLockDurationSeconds(), (Map)originalIndexSettings));
                $continuation.L$0 = this;
                $continuation.L$1 = nodeName;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 6;
                v7 = this.setToReadOnlyAndMoveIndexToNode(context, nodeName, lock, (Continuation<? super Boolean>)$continuation);
                if (v7 == var22_5) {
                    return var22_5;
                }
                ** GOTO lbl165
            }
            case 6: {
                nodeName = (String)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl165:
                // 2 sources

                this.setInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)AttemptMoveShardsStep.Companion.getSuccessMessage(nodeName))));
                this.setStepStatus(Step.StepStatus.COMPLETED);
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public String getGenericFailureMessage() {
        return FAILURE_MESSAGE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getIndexStats(String var1_1, Client var2_2, Continuation<? super Triple<? extends StoreStats, ? extends DocsStats, ShardStats[]>> var3_3) {
        if (!(var3_3 instanceof getIndexStats.1)) ** GOTO lbl-1000
        var10_4 = var3_3;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptMoveShardsStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptMoveShardsStep.access$getIndexStats(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new String[]{indexName};
                statsRequest = (IndicesStatsRequest)new IndicesStatsRequest().indices(var5_7);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client.admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<IndicesStatsResponse>, Unit>(statsRequest){
                    final /* synthetic */ IndicesStatsRequest $statsRequest;
                    {
                        this.$statsRequest = $statsRequest;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<IndicesStatsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.stats(this.$statsRequest, it);
                    }
                }, $continuation);
                if (v0 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                statsResponse = (IndicesStatsResponse)v0;
                statsStore = statsResponse.getTotal().store;
                statsDocs = statsResponse.getTotal().docs;
                statsShards = statsResponse.getShards();
                if (statsStore == null || statsDocs == null || statsShards == null) {
                    ShrinkStep.fail$default(this, "Shrink failed to start moving shards.", "Failed to move shards in shrink action as IndicesStatsResponse was missing some stats.", null, null, 12, null);
                    return null;
                }
                return new Triple((Object)statsStore, (Object)statsDocs, (Object)statsShards);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Map<String, String> getOriginalSettings(String indexName, ClusterService clusterService) {
        String it;
        Settings indexSettings = clusterService.state().getMetadata().index(indexName).getSettings();
        Map originalSettings = new LinkedHashMap();
        String string = indexSettings.get(ROUTING_SETTING);
        if (string != null) {
            it = string;
            boolean bl = false;
            originalSettings.put(ROUTING_SETTING, it);
        }
        String string2 = indexSettings.get(IndexMetadata.SETTING_BLOCKS_WRITE);
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            String string3 = IndexMetadata.SETTING_BLOCKS_WRITE;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SETTING_BLOCKS_WRITE");
            originalSettings.put(string3, it);
        }
        return originalSettings;
    }

    private final String compileTemplate(Script template, ManagedIndexMetaData managedIndexMetaData, String defaultValue, ScriptService scriptService) {
        Object object;
        if (template == null) {
            return defaultValue;
        }
        Map<String, Object> $this$filterKeys$iv = OpenSearchExtensionsKt.convertToMap((ToXContent)managedIndexMetaData);
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, Object> result$iv = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry$iv : $this$filterKeys$iv.entrySet()) {
            String key = entry$iv.getKey();
            boolean bl = false;
            if (!ALLOWED_TEMPLATE_FIELDS.contains(key)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map contextMap = result$iv;
        TemplateScript.Factory factory = (TemplateScript.Factory)scriptService.compile(template, TemplateScript.CONTEXT);
        Object object2 = template.getParams();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"template.params");
        String compiledValue = factory.newInstance(MapsKt.plus((Map)object2, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"ctx", (Object)contextMap)))).execute();
        object2 = compiledValue;
        if (StringsKt.isBlank((CharSequence)object2)) {
            boolean bl = false;
            object = defaultValue;
        } else {
            object = object2;
        }
        return (String)object;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getJobIntervalSeconds(String var1_1, Client var2_2, Continuation<? super Long> var3_3) {
        if (!(var3_3 instanceof getJobIntervalSeconds.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ AttemptMoveShardsStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptMoveShardsStep.access$getJobIntervalSeconds(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = ManagedIndexUtils.getManagedIndexConfig((String)indexUuid, (Client)client, (Continuation<? super ManagedIndexConfig>)$continuation);
                ** if (v0 != var10_6) goto lbl18
lbl17:
                // 1 sources

                return var10_6;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    managedIndexConfig = (ManagedIndexConfig)v0;
                }
                catch (Exception var5_8) {
                    return null;
                }
                v1 = managedIndexConfig;
                if (v1 == null) {
                    v2 = null;
                } else {
                    it = v1;
                    $i$a$-let-AttemptMoveShardsStep$getJobIntervalSeconds$2 = false;
                    v2 = Boxing.boxLong((long)(ManagedIndexUtils.getIntervalFromManagedIndexConfig(it) / 1000L));
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean shouldFailTooManyDocuments(DocsStats docsStats, int numTargetShards) {
        long totalDocs = docsStats.getCount();
        long docsPerTargetShard = totalDocs / (long)numTargetShards;
        if (docsPerTargetShard > 0x80000000L) {
            ShrinkStep.fail$default(this, TOO_MANY_DOCS_FAILURE_MESSAGE, TOO_MANY_DOCS_FAILURE_MESSAGE, null, null, 12, null);
            return true;
        }
        return false;
    }

    private final boolean shouldFailUnsafe(ClusterService clusterService, String indexName) {
        boolean shouldFailForceUnsafeCheck;
        if (Intrinsics.areEqual((Object)this.action.getForceUnsafe(), (Object)true)) {
            return false;
        }
        int numReplicas = ((IndexMetadata)clusterService.state().getMetadata().getIndices().get((Object)indexName)).getNumberOfReplicas();
        boolean bl = shouldFailForceUnsafeCheck = numReplicas == 0;
        if (shouldFailForceUnsafeCheck) {
            this.getLogger().info(UNSAFE_FAILURE_MESSAGE);
            ShrinkStep.fail$default(this, UNSAFE_FAILURE_MESSAGE, null, null, null, 14, null);
            return true;
        }
        return false;
    }

    private final boolean targetIndexNameIsInvalid(ClusterService clusterService, String shrinkTargetIndexName) {
        boolean indexExists = clusterService.state().getMetadata().getIndices().containsKey((Object)shrinkTargetIndexName);
        if (indexExists) {
            String indexExistsMessage = Companion.getIndexExistsMessage(shrinkTargetIndexName);
            ShrinkStep.fail$default(this, indexExistsMessage, indexExistsMessage, null, null, 12, null);
            return true;
        }
        Function2 exceptionGenerator2 = targetIndexNameIsInvalid.exceptionGenerator.1.INSTANCE;
        MetadataCreateIndexService.validateIndexOrAliasName((String)shrinkTargetIndexName, (arg_0, arg_1) -> AttemptMoveShardsStep.targetIndexNameIsInvalid$lambda-5(exceptionGenerator2, arg_0, arg_1));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object setToReadOnlyAndMoveIndexToNode(StepContext var1_1, String var2_2, LockModel var3_3, Continuation<? super Boolean> var4_4) {
        if (!(var4_4 instanceof setToReadOnlyAndMoveIndexToNode.1)) ** GOTO lbl-1000
        var12_5 = var4_4;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptMoveShardsStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptMoveShardsStep.access$setToReadOnlyAndMoveIndexToNode(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                updateSettings = Settings.builder().put(IndexMetadata.SETTING_BLOCKS_WRITE, true).put("index.routing.allocation.require._name", node).build();
                lockService = stepContext.getLockService();
                response = null;
                v0 = stepContext.getClient();
                v1 = stepContext.getMetadata().getIndex();
                Intrinsics.checkNotNullExpressionValue((Object)updateSettings, (String)"updateSettings");
                $continuation.L$0 = this;
                $continuation.L$1 = node;
                $continuation.L$2 = lock;
                $continuation.L$3 = lockService;
                $continuation.label = 1;
                v2 = StepUtilsKt.issueUpdateSettingsRequest(v0, v1, updateSettings, (Continuation<? super AcknowledgedResponse>)$continuation);
                ** if (v2 != var13_7) goto lbl28
lbl27:
                // 1 sources

                return var13_7;
lbl28:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                response = null;
                lockService = (LockService)$continuation.L$3;
                lock = (LockModel)$continuation.L$2;
                node = (String)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl39:
                // 2 sources

                v3 = isUpdateAcknowledged = (response = (AcknowledgedResponse)v2) != null && response.isAcknowledged() != false ? 1 : 0;
                if (isUpdateAcknowledged != 0) break;
                ShrinkStep.fail$default(this, "Shrink failed because shard settings could not be updated.", "Shrink failed because shard settings could not be updated.", null, null, 12, null);
                $continuation.L$0 = this;
                $continuation.L$1 = node;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.I$0 = isUpdateAcknowledged;
                $continuation.label = 2;
                v4 = OpenSearchExtensionsKt.suspendUntil(lockService, (Function2)new Function2<LockService, ActionListener<Boolean>, Unit>(lock){
                    final /* synthetic */ LockModel $lock;
                    {
                        this.$lock = $lock;
                        super(2);
                    }

                    public final void invoke(@NotNull LockService $this$suspendUntil, @NotNull ActionListener<Boolean> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.release(this.$lock, it);
                    }
                }, $continuation);
                if (v4 == var13_7) {
                    return var13_7;
                }
                ** GOTO lbl58
            }
            case 2: {
                isUpdateAcknowledged = $continuation.I$0;
                node = (String)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl58:
                // 2 sources

                if (released = ((Boolean)v4).booleanValue()) break;
                this.getLogger().error("Failed to release Shrink action lock on node [" + node + "]");
                break;
            }
        }
        catch (Throwable var9_14) {
            isUpdateAcknowledged = false;
            ShrinkStep.fail$default(this, "Shrink failed because shard settings could not be updated.", "Shrink failed because shard settings could not be updated.", null, null, 12, null);
            $continuation.L$0 = this;
            $continuation.L$1 = node;
            $continuation.L$2 = var9_14;
            $continuation.L$3 = null;
            $continuation.label = 3;
            v5 = OpenSearchExtensionsKt.suspendUntil(lockService, (Function2)new /* invalid duplicate definition of identical inner class */, $continuation);
            if (v5 == var13_7) {
                return var13_7;
            }
            ** GOTO lbl80
        }
        {
            case 3: {
                var9_15 = (Throwable)$continuation.L$2;
                node = (String)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl80:
                // 2 sources

                if (!(released = ((Boolean)v5).booleanValue())) {
                    this.getLogger().error("Failed to release Shrink action lock on node [" + node + "]");
                }
                throw var9_15;
            }
        }
        return Boxing.boxBoolean((boolean)(isUpdateAcknowledged != 0));
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object acquireLockFromNodeList(LockService var1_1, List<String> var2_2, Long var3_3, String var4_4, Continuation<? super Pair<LockModel, String>> var5_5) {
        if (!(var5_5 instanceof acquireLockFromNodeList.1)) ** GOTO lbl-1000
        var11_6 = var5_5;
        if ((var11_6.label & -2147483648) != 0) {
            var11_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptMoveShardsStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptMoveShardsStep.access$acquireLockFromNodeList(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_9 = suitableNodes.iterator();
lbl13:
                // 2 sources

                while (var6_9.hasNext()) {
                    nodeName = (String)var6_9.next();
                    lockID = StepUtilsKt.getShrinkLockID(nodeName);
                    $continuation.L$0 = this;
                    $continuation.L$1 = lockService;
                    $continuation.L$2 = jobIntervalSeconds;
                    $continuation.L$3 = indexName;
                    $continuation.L$4 = var6_9;
                    $continuation.L$5 = nodeName;
                    $continuation.label = 1;
                    v0 = OpenSearchExtensionsKt.suspendUntil(lockService, (Function2)new Function2<LockService, ActionListener<LockModel>, Unit>(jobIntervalSeconds, lockID){
                        final /* synthetic */ Long $jobIntervalSeconds;
                        final /* synthetic */ String $lockID;
                        {
                            this.$jobIntervalSeconds = $jobIntervalSeconds;
                            this.$lockID = $lockID;
                            super(2);
                        }

                        public final void invoke(@NotNull LockService $this$suspendUntil, @NotNull ActionListener<LockModel> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            $this$suspendUntil.acquireLockWithId(".opendistro-ism-config", Long.valueOf(org.opensearch.indexmanagement.indexstatemanagement.step.shrink.AttemptMoveShardsStep$Companion.access$getShrinkLockDuration(AttemptMoveShardsStep.Companion, this.$jobIntervalSeconds)), this.$lockID, it);
                        }
                    }, $continuation);
                    if (v0 == var12_8) {
                        return var12_8;
                    }
                    ** GOTO lbl37
                }
                break;
            }
            case 1: {
                nodeName = (String)$continuation.L$5;
                var6_9 = (Iterator)$continuation.L$4;
                indexName = (String)$continuation.L$3;
                jobIntervalSeconds = (Long)$continuation.L$2;
                lockService = (LockService)$continuation.L$1;
                this = (AttemptMoveShardsStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                if ((lock = (LockModel)v0) == null) ** GOTO lbl13
                return TuplesKt.to((Object)lock, (Object)nodeName);
            }
        }
        this.getLogger().info("Shrink action could not find available node to shrink onto for index [" + indexName + "].");
        this.setInfo(MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)"There are no available nodes to move to to execute a shrink. Delaying until node becomes available.")));
        this.setStepStatus(Step.StepStatus.CONDITION_NOT_MET);
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object findSuitableNodes(StepContext var1_1, ShardStats[] var2_2, long var3_3, Continuation<? super List<String>> var5_4) {
        if (!(var5_4 instanceof findSuitableNodes.1)) ** GOTO lbl-1000
        var29_5 = var5_4;
        if ((var29_5.label & -2147483648) != 0) {
            var29_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ AttemptMoveShardsStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AttemptMoveShardsStep.access$findSuitableNodes(this.this$0, null, null, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var30_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                nodesStatsReq = new NodesStatsRequest().addMetric("fs");
                $continuation.L$0 = stepContext;
                $continuation.L$1 = shardStats;
                $continuation.J$0 = indexSizeInBytes;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)stepContext.getClient().admin().cluster(), (Function2)new Function2<ClusterAdminClient, ActionListener<NodesStatsResponse>, Unit>(nodesStatsReq){
                    final /* synthetic */ NodesStatsRequest $nodesStatsReq;
                    {
                        this.$nodesStatsReq = $nodesStatsReq;
                        super(2);
                    }

                    public final void invoke(ClusterAdminClient $this$suspendUntil, @NotNull ActionListener<NodesStatsResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.nodesStats(this.$nodesStatsReq, it);
                    }
                }, $continuation);
                if (v0 == var30_7) {
                    return var30_7;
                }
                ** GOTO lbl27
            }
            case 1: {
                indexSizeInBytes = $continuation.J$0;
                shardStats = (ShardStats[])$continuation.L$1;
                stepContext = (StepContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                nodeStatsResponse = (NodesStatsResponse)v0;
                var9_10 = nodeStatsResponse.getNodes();
                Intrinsics.checkNotNullExpressionValue((Object)var9_10, (String)"nodeStatsResponse.nodes");
                $this$filter$iv = var9_10;
                $i$f$filter = false;
                var11_13 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var14_18 = $this$filterTo$iv$iv.iterator();
                while (var14_18.hasNext()) {
                    element$iv$iv /* !! */  = var14_18.next();
                    it = (NodeStats)element$iv$iv /* !! */ ;
                    $i$a$-filter-AttemptMoveShardsStep$findSuitableNodes$nodesList$1 = false;
                    if (!it.getNode().isDataNode()) continue;
                    destination$iv$iv.add(element$iv$iv /* !! */ );
                }
                nodesList = (List)destination$iv$iv;
                comparator = (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, findSuitableNodes$lambda-7(org.opensearch.common.collect.Tuple org.opensearch.common.collect.Tuple ), (Lorg/opensearch/common/collect/Tuple;Lorg/opensearch/common/collect/Tuple;)I)();
                nodesWithSpace = new PriorityQueue<Tuple>(comparator);
                for (NodeStats node : nodesList) {
                    Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                    element$iv$iv /* !! */  = stepContext.getClusterService().getClusterSettings();
                    Intrinsics.checkNotNullExpressionValue(element$iv$iv /* !! */ , (String)"stepContext.clusterService.clusterSettings");
                    remainingMem = StepUtilsKt.getNodeFreeMemoryAfterShrink(node, indexSizeInBytes, element$iv$iv /* !! */ );
                    if (remainingMem <= 0L) continue;
                    nodesWithSpace.add(new Tuple((Object)Boxing.boxLong((long)remainingMem), (Object)node.getNode().getName()));
                }
                node = stepContext.getClusterService().state().getNodes();
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"stepContext.clusterService.state().nodes");
                shardIdToNodeList = StepUtilsKt.getShardIdToNodeNameSet(shardStats, (DiscoveryNodes)node);
                suitableNodes = new ArrayList<Object>();
                var13_17 = nodesWithSpace.iterator();
lbl61:
                // 3 sources

                while (var13_17.hasNext()) {
                    sizeNodeTuple = (Tuple)var13_17.next();
                    targetNodeName = (String)sizeNodeTuple.v2();
                    indexName = stepContext.getMetadata().getIndex();
                    clusterRerouteRequest = new ClusterRerouteRequest().explain(true).dryRun(true);
                    requestedShardIds = new LinkedHashSet<E>();
                    var20_27 = shardStats.length;
                    for (var19_26 = 0; var19_26 < var20_27; ++var19_26) {
                        shard = shardStats[var19_26];
                        shardId = shard.getShardRouting().shardId();
                        currentShardNode = stepContext.getClusterService().state().getNodes().get(shard.getShardRouting().currentNodeId());
                        v1 = shardIdToNodeList.get(Boxing.boxInt((int)shardId.getId()));
                        if ((v1 == null ? false : v1.contains(targetNodeName) == true) || requestedShardIds.contains(Boxing.boxInt((int)shardId.getId()))) continue;
                        var24_33 = new AllocationCommand[]{(AllocationCommand)new MoveAllocationCommand(indexName, shardId.getId(), currentShardNode.getName(), targetNodeName)};
                        clusterRerouteRequest.add(var24_33);
                        requestedShardIds.add(Boxing.boxInt((int)shardId.getId()));
                    }
                    $continuation.L$0 = stepContext;
                    $continuation.L$1 = shardStats;
                    $continuation.L$2 = shardIdToNodeList;
                    $continuation.L$3 = suitableNodes;
                    $continuation.L$4 = var13_17;
                    $continuation.L$5 = sizeNodeTuple;
                    $continuation.L$6 = requestedShardIds;
                    $continuation.label = 2;
                    v2 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)stepContext.getClient().admin().cluster(), (Function2)new Function2<ClusterAdminClient, ActionListener<ClusterRerouteResponse>, Unit>(clusterRerouteRequest){
                        final /* synthetic */ ClusterRerouteRequest $clusterRerouteRequest;
                        {
                            this.$clusterRerouteRequest = $clusterRerouteRequest;
                            super(2);
                        }

                        public final void invoke(ClusterAdminClient $this$suspendUntil, @NotNull ActionListener<ClusterRerouteResponse> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            $this$suspendUntil.reroute(this.$clusterRerouteRequest, it);
                        }
                    }, $continuation);
                    if (v2 == var30_7) {
                        return var30_7;
                    }
                    ** GOTO lbl103
                }
                break;
            }
            case 2: {
                requestedShardIds = (Set)$continuation.L$6;
                sizeNodeTuple = (Tuple)$continuation.L$5;
                var13_17 = (Iterator<E>)$continuation.L$4;
                suitableNodes = (ArrayList<Object>)$continuation.L$3;
                shardIdToNodeList = (Map<Integer, Set<String>>)$continuation.L$2;
                shardStats = (ShardStats[])$continuation.L$1;
                stepContext = (StepContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl103:
                // 2 sources

                clusterRerouteResponse = (ClusterRerouteResponse)v2;
                shard = clusterRerouteResponse.getExplanations().explanations();
                Intrinsics.checkNotNullExpressionValue((Object)shard, (String)"clusterRerouteResponse.explanations.explanations()");
                $this$count$iv = shard;
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v3 = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (RerouteExplanation)element$iv;
                        $i$a$-count-AttemptMoveShardsStep$findSuitableNodes$numYesDecisions$1 = false;
                        if (!it.decisions().type().equals((Object)Decision.Type.YES) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v3 = count$iv;
                }
                if ((numYesDecisions = v3) != requestedShardIds.size()) ** GOTO lbl61
                suitableNodes.add(sizeNodeTuple.v2());
                ** GOTO lbl61
            }
        }
        return suitableNodes;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int getNumTargetShards(int numOriginalShards, long indexSize) {
        if (this.action.getNumNewShards() != null) {
            return this.getGreatestFactorLessThan(numOriginalShards, this.action.getNumNewShards());
        }
        if (this.action.getPercentageOfSourceShards() != null) {
            int numTargetShards = (int)Math.floor(this.action.getPercentageOfSourceShards() * (double)numOriginalShards);
            return this.getGreatestFactorLessThan(numOriginalShards, numTargetShards);
        }
        if (this.action.getMaxShardSize() != null) {
            long maxShardSizeInBytes = this.action.getMaxShardSize().getBytes();
            int minNumTargetShards = (int)Math.ceil((double)indexSize / (double)maxShardSizeInBytes);
            return this.getMinFactorGreaterThan(numOriginalShards, minNumTargetShards);
        }
        return numOriginalShards;
    }

    private final int getGreatestFactorLessThan(int n, int k) {
        if (k >= n) {
            return n;
        }
        int bound = Math.min((int)Math.floor(Math.sqrt(n)), k);
        int greatestFactor = 1;
        int n2 = 2;
        if (n2 <= bound) {
            int i;
            do {
                if (n % (i = n2++) != 0) continue;
                int complement = n / i;
                if (complement <= k) {
                    return complement;
                }
                greatestFactor = i;
            } while (i != bound);
        }
        return greatestFactor;
    }

    private final int getMinFactorGreaterThan(int n, int k) {
        if (k >= n) {
            return n;
        }
        int n2 = k;
        if (n2 <= n) {
            int i;
            do {
                if (n % (i = n2++) != 0) continue;
                return i;
            } while (i != n);
        }
        return n;
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData currentActionMetaData = currentMetadata.getActionMetaData();
        Map<String, Object> map = this.getInfo();
        StepMetaData stepMetaData = Intrinsics.areEqual((Object)(map == null ? null : map.get("message")), (Object)ONE_PRIMARY_SHARD_MESSAGE) ? new StepMetaData("wait_for_shrink_step", this.getStepStartTime(currentMetadata).toEpochMilli(), this.getStepStatus()) : new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.getStepStatus());
        ActionMetaData actionMetaData = currentActionMetaData;
        ActionMetaData actionMetaData2 = actionMetaData == null ? null : ActionMetaData.copy$default((ActionMetaData)actionMetaData, null, null, (int)0, (boolean)false, (int)0, null, (ActionProperties)new ActionProperties(null, null, null, null, this.getShrinkActionProperties(), 15, null), (int)63, null);
        Map<String, Object> map2 = this.getInfo();
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)actionMetaData2, (StepMetaData)stepMetaData, null, map2, null, (long)0L, (long)0L, (int)119551, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    private static final RuntimeException targetIndexNameIsInvalid$lambda-5(Function2 $tmp0, String p0, String p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RuntimeException)$tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final int findSuitableNodes$lambda-7(Tuple o1, Tuple o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        long l = ((Number)o1.v1()).longValue();
        Object object = o2.v1();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"o2.v1()");
        return Intrinsics.compare((long)l, (long)((Number)object).longValue());
    }

    public static final /* synthetic */ Object access$getIndexStats(AttemptMoveShardsStep $this, String indexName, Client client, Continuation $completion) {
        return $this.getIndexStats(indexName, client, (Continuation<? super Triple<? extends StoreStats, ? extends DocsStats, ShardStats[]>>)$completion);
    }

    public static final /* synthetic */ Object access$getJobIntervalSeconds(AttemptMoveShardsStep $this, String indexUuid, Client client, Continuation $completion) {
        return $this.getJobIntervalSeconds(indexUuid, client, (Continuation<? super Long>)$completion);
    }

    public static final /* synthetic */ Object access$setToReadOnlyAndMoveIndexToNode(AttemptMoveShardsStep $this, StepContext stepContext, String node, LockModel lock2, Continuation $completion) {
        return $this.setToReadOnlyAndMoveIndexToNode(stepContext, node, lock2, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$acquireLockFromNodeList(AttemptMoveShardsStep $this, LockService lockService, List suitableNodes, Long jobIntervalSeconds, String indexName, Continuation $completion) {
        return $this.acquireLockFromNodeList(lockService, suitableNodes, jobIntervalSeconds, indexName, (Continuation<? super Pair<LockModel, String>>)$completion);
    }

    public static final /* synthetic */ Object access$findSuitableNodes(AttemptMoveShardsStep $this, StepContext stepContext, ShardStats[] shardStats, long indexSizeInBytes, Continuation $completion) {
        return $this.findSuitableNodes(stepContext, shardStats, indexSizeInBytes, (Continuation<? super List<String>>)$completion);
    }

    static {
        Object[] objectArray = new String[]{"index", "indexUuid"};
        ALLOWED_TEMPLATE_FIELDS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u0017\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/shrink/AttemptMoveShardsStep$Companion;", "", "()V", "ALLOWED_TEMPLATE_FIELDS", "", "", "DEFAULT_LOCK_INTERVAL", "", "DEFAULT_TARGET_SUFFIX", "FAILURE_MESSAGE", "FS_METRIC", "INDEX_NOT_GREEN_MESSAGE", "JOB_INTERVAL_LOCK_MULTIPLIER", "", "LOCK_BUFFER_SECONDS", "MAXIMUM_DOCS_PER_SHARD", "MILLISECONDS_IN_SECOND", "NO_AVAILABLE_NODES_MESSAGE", "ONE_PRIMARY_SHARD_MESSAGE", "ROUTING_SETTING", "THIRTY_SECONDS_IN_MILLIS", "TOO_MANY_DOCS_FAILURE_MESSAGE", "UNSAFE_FAILURE_MESSAGE", "UPDATE_FAILED_MESSAGE", "name", "getIndexExistsMessage", "newIndex", "getShrinkLockDuration", "jobInterval", "(Ljava/lang/Long;)J", "getSuccessMessage", "node", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return "Successfully started moving the shards to " + node + ".";
        }

        @NotNull
        public final String getIndexExistsMessage(@NotNull String newIndex) {
            Intrinsics.checkNotNullParameter((Object)newIndex, (String)"newIndex");
            return "Shrink failed because " + newIndex + " already exists.";
        }

        private final long getShrinkLockDuration(Long jobInterval) {
            long l;
            Long l2 = jobInterval;
            if (l2 == null) {
                l = 10800L;
            } else {
                long l3;
                long it = ((Number)l2).longValue();
                boolean bl = false;
                l = l3 = it * (long)3 + (long)1800;
            }
            return l;
        }

        public static final /* synthetic */ long access$getShrinkLockDuration(Companion $this, Long jobInterval) {
            return $this.getShrinkLockDuration(jobInterval);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

