/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.attachment;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.langdetect.optimaize.OptimaizeLangDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.Strings;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;
import org.opensearch.ingest.attachment.TikaImpl;

public final class AttachmentProcessor
extends AbstractProcessor {
    public static final String TYPE = "attachment";
    private static final int NUMBER_OF_CHARS_INDEXED = 100000;
    private final String field;
    private final String targetField;
    private final Set<Property> properties;
    private final int indexedChars;
    private final boolean ignoreMissing;
    private final String indexedCharsField;

    AttachmentProcessor(String tag, String description, String field, String targetField, Set<Property> properties, int indexedChars, boolean ignoreMissing, String indexedCharsField) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.properties = properties;
        this.indexedChars = indexedChars;
        this.ignoreMissing = ignoreMissing;
        this.indexedCharsField = indexedCharsField;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        String contentType;
        String title;
        String createdDate;
        HashMap<String, Object> additionalFields = new HashMap<String, Object>();
        byte[] input = ingestDocument.getFieldValueAsBytes(this.field, this.ignoreMissing);
        if (input == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (input == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot parse.");
        }
        Integer indexedChars = this.indexedChars;
        if (this.indexedCharsField != null && (indexedChars = (Integer)ingestDocument.getFieldValue(this.indexedCharsField, Integer.class, true)) == null) {
            indexedChars = this.indexedChars;
        }
        Metadata metadata = new Metadata();
        String parsedContent = "";
        try {
            parsedContent = TikaImpl.parse(input, metadata, indexedChars);
        }
        catch (ZeroByteFileException zeroByteFileException) {
        }
        catch (Exception e) {
            throw new OpenSearchParseException("Error parsing document in field [{}]", (Throwable)e, new Object[]{this.field});
        }
        if (this.properties.contains((Object)Property.CONTENT) && Strings.hasLength((String)parsedContent)) {
            additionalFields.put(Property.CONTENT.toLowerCase(), parsedContent.trim());
        }
        if (this.properties.contains((Object)Property.LANGUAGE) && Strings.hasLength((String)parsedContent)) {
            OptimaizeLangDetector langDetector = new OptimaizeLangDetector();
            langDetector.loadModels();
            LanguageResult result = langDetector.detect((CharSequence)parsedContent);
            String language = result.getLanguage();
            additionalFields.put(Property.LANGUAGE.toLowerCase(), language);
        }
        if (this.properties.contains((Object)Property.DATE) && (createdDate = metadata.get(TikaCoreProperties.CREATED)) != null) {
            additionalFields.put(Property.DATE.toLowerCase(), createdDate);
        }
        if (this.properties.contains((Object)Property.TITLE) && Strings.hasLength((String)(title = metadata.get(TikaCoreProperties.TITLE)))) {
            additionalFields.put(Property.TITLE.toLowerCase(), title);
        }
        if (this.properties.contains((Object)Property.AUTHOR)) {
            String author = metadata.get("Author");
            if (Strings.hasLength((String)author)) {
                additionalFields.put(Property.AUTHOR.toLowerCase(), author);
            } else {
                author = metadata.get(TikaCoreProperties.CREATOR);
                if (Strings.hasLength((String)author)) {
                    additionalFields.put(Property.AUTHOR.toLowerCase(), author);
                }
            }
        }
        if (this.properties.contains((Object)Property.KEYWORDS)) {
            String keywords = metadata.get("Keywords");
            if (Strings.hasLength((String)keywords)) {
                additionalFields.put(Property.KEYWORDS.toLowerCase(), keywords);
            } else {
                keywords = metadata.get(TikaCoreProperties.SUBJECT);
                if (Strings.hasLength((String)keywords)) {
                    additionalFields.put(Property.KEYWORDS.toLowerCase(), keywords);
                }
            }
        }
        if (this.properties.contains((Object)Property.CONTENT_TYPE) && Strings.hasLength((String)(contentType = metadata.get("Content-Type")))) {
            additionalFields.put(Property.CONTENT_TYPE.toLowerCase(), contentType);
        }
        if (this.properties.contains((Object)Property.CONTENT_LENGTH)) {
            String contentLength = metadata.get("Content-Length");
            long length = Strings.hasLength((String)contentLength) ? Long.parseLong(contentLength) : (long)parsedContent.length();
            additionalFields.put(Property.CONTENT_LENGTH.toLowerCase(), length);
        }
        ingestDocument.setFieldValue(this.targetField, additionalFields);
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    int getIndexedChars() {
        return this.indexedChars;
    }

    static enum Property {
        CONTENT,
        TITLE,
        AUTHOR,
        KEYWORDS,
        DATE,
        CONTENT_TYPE,
        CONTENT_LENGTH,
        LANGUAGE;


        public static Property parse(String value) {
            return Property.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toLowerCase() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final Set<Property> DEFAULT_PROPERTIES = EnumSet.allOf(Property.class);

        public AttachmentProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            Set<Property> properties;
            String field = ConfigurationUtils.readStringProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)AttachmentProcessor.TYPE);
            List propertyNames = ConfigurationUtils.readOptionalList((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"properties");
            int indexedChars = ConfigurationUtils.readIntProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"indexed_chars", (Integer)100000);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)false);
            String indexedCharsField = ConfigurationUtils.readOptionalStringProperty((String)AttachmentProcessor.TYPE, (String)processorTag, config, (String)"indexed_chars_field");
            if (propertyNames != null) {
                properties = EnumSet.noneOf(Property.class);
                for (String fieldName : propertyNames) {
                    try {
                        properties.add(Property.parse(fieldName));
                    }
                    catch (Exception e) {
                        throw ConfigurationUtils.newConfigurationException((String)AttachmentProcessor.TYPE, (String)processorTag, (String)"properties", (String)("illegal field option [" + fieldName + "]. valid values are " + Arrays.toString((Object[])Property.values())));
                    }
                }
            } else {
                properties = DEFAULT_PROPERTIES;
            }
            return new AttachmentProcessor(processorTag, description, field, targetField, properties, indexedChars, ignoreMissing, indexedCharsField);
        }
    }
}

