/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.memory;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opensearch.knn.index.util.KNNEngine;
import org.opensearch.knn.jni.JNIService;
import org.opensearch.watcher.FileWatcher;
import org.opensearch.watcher.WatcherHandle;

public interface NativeMemoryAllocation {
    public void close();

    public boolean isClosed();

    public long getMemoryAddress();

    public void readLock();

    public void writeLock();

    public void readUnlock();

    public void writeUnlock();

    public int getSizeInKB();

    public static class AnonymousAllocation
    implements NativeMemoryAllocation {
        private final ExecutorService executor;
        private volatile boolean closed;
        private final int size;
        private final ReadWriteLock readWriteLock;

        AnonymousAllocation(ExecutorService executor, int size) {
            this.executor = executor;
            this.closed = false;
            this.size = size;
            this.readWriteLock = new ReentrantReadWriteLock();
        }

        @Override
        public void close() {
            if (this.isClosed()) {
                return;
            }
            this.executor.execute(() -> {
                this.writeLock();
                this.closed = true;
                this.writeUnlock();
            });
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public long getMemoryAddress() {
            throw new UnsupportedOperationException("Cannot get memory address for an AnonymousAllocation.");
        }

        @Override
        public void readLock() {
            this.readWriteLock.readLock().lock();
        }

        @Override
        public void writeLock() {
            this.readWriteLock.writeLock().lock();
        }

        @Override
        public void readUnlock() {
            this.readWriteLock.readLock().unlock();
        }

        @Override
        public void writeUnlock() {
            this.readWriteLock.writeLock().unlock();
        }

        @Override
        public int getSizeInKB() {
            return this.size;
        }
    }

    public static class TrainingDataAllocation
    implements NativeMemoryAllocation {
        private final ExecutorService executor;
        private volatile boolean closed;
        private long memoryAddress;
        private final int size;
        private int readCount;
        private Semaphore readSemaphore;
        private Semaphore writeSemaphore;

        TrainingDataAllocation(ExecutorService executor, long memoryAddress, int size) {
            this.executor = executor;
            this.closed = false;
            this.memoryAddress = memoryAddress;
            this.size = size;
            this.readCount = 0;
            this.readSemaphore = new Semaphore(1);
            this.writeSemaphore = new Semaphore(1);
        }

        @Override
        public void close() {
            this.executor.execute(() -> {
                this.writeLock();
                this.cleanup();
                this.writeUnlock();
            });
        }

        public void closeUnsafe() {
            this.executor.execute(() -> {
                this.cleanup();
                this.writeUnlock();
            });
        }

        private void cleanup() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.memoryAddress != 0L) {
                JNIService.freeVectors(this.memoryAddress);
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public long getMemoryAddress() {
            return this.memoryAddress;
        }

        @Override
        public void readLock() {
            try {
                this.readSemaphore.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            if (this.readCount == 0) {
                try {
                    this.writeLock();
                }
                catch (RuntimeException e) {
                    this.readSemaphore.release();
                    throw e;
                }
            }
            ++this.readCount;
            this.readSemaphore.release();
        }

        @Override
        public void writeLock() {
            try {
                this.writeSemaphore.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void readUnlock() {
            try {
                this.readSemaphore.acquire();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            --this.readCount;
            if (this.readCount <= 0) {
                this.writeUnlock();
            }
            this.readSemaphore.release();
        }

        @Override
        public void writeUnlock() {
            this.writeSemaphore.release();
        }

        @Override
        public int getSizeInKB() {
            return this.size;
        }

        public void setMemoryAddress(long memoryAddress) {
            this.memoryAddress = memoryAddress;
        }
    }

    public static class IndexAllocation
    implements NativeMemoryAllocation {
        private final ExecutorService executor;
        private final long memoryAddress;
        private final int size;
        private volatile boolean closed;
        private final KNNEngine knnEngine;
        private final String indexPath;
        private final String openSearchIndexName;
        private final ReadWriteLock readWriteLock;
        private final WatcherHandle<FileWatcher> watcherHandle;

        IndexAllocation(ExecutorService executorService, long memoryAddress, int size, KNNEngine knnEngine, String indexPath, String openSearchIndexName, WatcherHandle<FileWatcher> watcherHandle) {
            this.executor = executorService;
            this.closed = false;
            this.knnEngine = knnEngine;
            this.indexPath = indexPath;
            this.openSearchIndexName = openSearchIndexName;
            this.memoryAddress = memoryAddress;
            this.readWriteLock = new ReentrantReadWriteLock();
            this.size = size;
            this.watcherHandle = watcherHandle;
        }

        @Override
        public void close() {
            this.executor.execute(() -> {
                this.writeLock();
                this.cleanup();
                this.writeUnlock();
            });
        }

        private void cleanup() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.watcherHandle.stop();
            if (this.memoryAddress != 0L) {
                JNIService.free(this.memoryAddress, this.knnEngine.getName());
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public long getMemoryAddress() {
            return this.memoryAddress;
        }

        @Override
        public void readLock() {
            this.readWriteLock.readLock().lock();
        }

        @Override
        public void writeLock() {
            this.readWriteLock.writeLock().lock();
        }

        @Override
        public void readUnlock() {
            this.readWriteLock.readLock().unlock();
        }

        @Override
        public void writeUnlock() {
            this.readWriteLock.writeLock().unlock();
        }

        @Override
        public int getSizeInKB() {
            return this.size;
        }

        public KNNEngine getKnnEngine() {
            return this.knnEngine;
        }

        public String getIndexPath() {
            return this.indexPath;
        }

        public String getOpenSearchIndexName() {
            return this.openSearchIndexName;
        }
    }
}

