/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.threads;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerThreads;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.threads.exceptions.PAThreadException;

public class ThreadProvider {
    private static final Logger LOG = LogManager.getLogger(ThreadProvider.class);

    public Thread createThreadForRunnable(Runnable innerRunnable, PerformanceAnalyzerThreads paThread, String threadNameAppender) {
        StringBuilder threadName = new StringBuilder(paThread.toString());
        if (!threadNameAppender.isEmpty()) {
            threadName.append("-").append(threadNameAppender);
        }
        String threadNameStr = threadName.toString();
        MeasurementSet metric = paThread.getThreadExceptionCode();
        Thread t = new Thread(() -> {
            try {
                innerRunnable.run();
            }
            catch (Throwable innerThrowable) {
                LOG.error("A thread crashed: ", innerThrowable);
                try {
                    PerformanceAnalyzerApp.exceptionQueue.put(new PAThreadException(paThread, innerThrowable));
                }
                catch (InterruptedException e) {
                    PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(metric, "", 1);
                    LOG.error("Thread was interrupted while waiting to put an exception into the queue. Message: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.NUM_PA_THREADS_ENDED, ReaderMetrics.NUM_PA_THREADS_ENDED.toString(), 1);
            LOG.info("Thread: {} completed.", (Object)threadNameStr);
        }, threadNameStr);
        PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.NUM_PA_THREADS_STARTED, ReaderMetrics.NUM_PA_THREADS_STARTED.toString(), 1);
        LOG.info("Spun up a thread with name: {}", (Object)threadNameStr);
        return t;
    }

    public Thread createThreadForRunnable(Runnable innerRunnable, PerformanceAnalyzerThreads paThread) {
        return this.createThreadForRunnable(innerRunnable, paThread, "");
    }
}

