/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.listener;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.rca.framework.core.Stats;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.stats.listeners.IListener;
import org.opensearch.performanceanalyzer.rca.stats.measurements.MeasurementSet;

public class MisbehavingGraphOperateMethodListener
implements IListener {
    private static final Logger LOG = LogManager.getLogger(MisbehavingGraphOperateMethodListener.class);
    Map<String, AtomicInteger> map = new ConcurrentHashMap<String, AtomicInteger>();
    public static final int TOLERANCE_LIMIT = 1;

    @Override
    public Set<MeasurementSet> getMeasurementsListenedTo() {
        return new HashSet<MeasurementSet>(Arrays.asList(ExceptionsAndErrors.EXCEPTION_IN_OPERATE));
    }

    @Override
    public void onOccurrence(MeasurementSet measurementSet, Number value, String key) {
        if (!key.isEmpty()) {
            AtomicInteger count = this.map.putIfAbsent(key, new AtomicInteger(1));
            int newCount = 1;
            if (count != null) {
                newCount = count.incrementAndGet();
            }
            if (newCount > 1 && Stats.getInstance().addToMutedGraphNodes(key)) {
                LOG.warn("Node {} got muted for throwing one or more of '{}' more than {} times.", (Object)key, this.getMeasurementsListenedTo(), (Object)1);
            }
        }
    }
}

