/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.model;

import java.io.IOException;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.settings.PluginSettings;
import org.opensearch.reportsscheduler.util.HelpersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\r\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006#"}, d2={"Lorg/opensearch/reportsscheduler/model/GetAllReportInstancesRequest;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/common/xcontent/ToXContentObject;", "input", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "fromIndex", "", "maxItems", "(II)V", "getFromIndex", "()I", "getMaxItems", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "builder", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "output", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "opensearch-reports-scheduler"})
public final class GetAllReportInstancesRequest
extends ActionRequest
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int fromIndex;
    private final int maxItems;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(GetAllReportInstancesRequest.class);

    public GetAllReportInstancesRequest(int fromIndex, int maxItems) {
        this.fromIndex = fromIndex;
        this.maxItems = maxItems;
    }

    public final int getFromIndex() {
        return this.fromIndex;
    }

    public final int getMaxItems() {
        return this.maxItems;
    }

    public GetAllReportInstancesRequest(@NotNull StreamInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(input.readInt(), input.readInt());
    }

    public void writeTo(@NotNull StreamOutput output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeInt(this.fromIndex);
        output.writeInt(this.maxItems);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException actionRequestValidationException;
        if (this.fromIndex < 0) {
            void var1_1;
            ActionRequestValidationException exception = new ActionRequestValidationException();
            exception.addValidationError("fromIndex should be greater than 0");
            Metrics.REPORT_INSTANCE_LIST_USER_ERROR_INVALID_FROM_INDEX.getCounter().increment();
            actionRequestValidationException = var1_1;
        } else {
            actionRequestValidationException = null;
        }
        return actionRequestValidationException;
    }

    @Nullable
    public final XContentBuilder toXContent(@NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.toXContent(XContentFactory.jsonBuilder(), params);
    }

    public static /* synthetic */ XContentBuilder toXContent$default(GetAllReportInstancesRequest getAllReportInstancesRequest, ToXContent.Params params, int n, Object object) {
        if ((n & 1) != 0) {
            ToXContent.Params params2 = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"EMPTY_PARAMS");
            params = params2;
        }
        return getAllReportInstancesRequest.toXContent(params);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        XContentBuilder xContentBuilder = builder;
        Intrinsics.checkNotNull((Object)xContentBuilder);
        XContentBuilder xContentBuilder2 = xContentBuilder.startObject().field("fromIndex", this.fromIndex).field("maxItems", this.maxItems).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder!!.startObject()\n\u2026\n            .endObject()");
        return xContentBuilder2;
    }

    public final int component1() {
        return this.fromIndex;
    }

    public final int component2() {
        return this.maxItems;
    }

    @NotNull
    public final GetAllReportInstancesRequest copy(int fromIndex, int maxItems) {
        return new GetAllReportInstancesRequest(fromIndex, maxItems);
    }

    public static /* synthetic */ GetAllReportInstancesRequest copy$default(GetAllReportInstancesRequest getAllReportInstancesRequest, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = getAllReportInstancesRequest.fromIndex;
        }
        if ((n3 & 2) != 0) {
            n2 = getAllReportInstancesRequest.maxItems;
        }
        return getAllReportInstancesRequest.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "GetAllReportInstancesRequest(fromIndex=" + this.fromIndex + ", maxItems=" + this.maxItems + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.fromIndex);
        result = result * 31 + Integer.hashCode(this.maxItems);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GetAllReportInstancesRequest)) {
            return false;
        }
        GetAllReportInstancesRequest getAllReportInstancesRequest = (GetAllReportInstancesRequest)((Object)other);
        if (this.fromIndex != getAllReportInstancesRequest.fromIndex) {
            return false;
        }
        return this.maxItems == getAllReportInstancesRequest.maxItems;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/opensearch/reportsscheduler/model/GetAllReportInstancesRequest$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "parse", "Lorg/opensearch/reportsscheduler/model/GetAllReportInstancesRequest;", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final GetAllReportInstancesRequest parse(@NotNull XContentParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            int fromIndex = 0;
            int maxItems = PluginSettings.INSTANCE.getDefaultItemsQueryCount();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                String fieldName = parser.currentName();
                parser.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)"fromIndex")) {
                    fromIndex = parser.intValue();
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"maxItems")) {
                    maxItems = parser.intValue();
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("reports:Skipping Unknown field " + fieldName);
            }
            return new GetAllReportInstancesRequest(fromIndex, maxItems);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

