/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.azure;

import com.azure.core.http.ProxyOptions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.SettingsException;

public class ProxySettings {
    public static final ProxySettings NO_PROXY_SETTINGS = new ProxySettings(ProxyType.DIRECT, null, -1, null, null);
    private final ProxyType type;
    private final InetAddress host;
    private final String username;
    private final String password;
    private final int port;

    public ProxySettings(ProxyType type, InetAddress host, int port, String username, String password) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public ProxyType getType() {
        return this.type;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticated() {
        return !Strings.isNullOrEmpty((String)this.username) && !Strings.isNullOrEmpty((String)this.password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxySettings that = (ProxySettings)o;
        return this.port == that.port && this.type == that.type && Objects.equals(this.host, that.host) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.host, this.username, this.password, this.port});
    }

    public static enum ProxyType {
        HTTP(ProxyOptions.Type.HTTP.name()),
        SOCKS(ProxyOptions.Type.SOCKS4.name()),
        SOCKS4(ProxyOptions.Type.SOCKS4.name()),
        SOCKS5(ProxyOptions.Type.SOCKS5.name()),
        DIRECT("DIRECT");

        private final String name;

        private ProxyType(String name) {
            this.name = name;
        }

        public ProxyOptions.Type toProxyType() {
            if (this == DIRECT) {
                throw new SettingsException("Couldn't convert to Azure proxy type");
            }
            return ProxyOptions.Type.valueOf((String)this.name());
        }
    }
}

