/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.kerberos;

import com.amazon.dlic.auth.http.kerberos.util.JaasKrbUtil;
import com.amazon.dlic.auth.http.kerberos.util.KrbConstants;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.opensearch.ExceptionsHelper;
import org.opensearch.SpecialPermission;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.env.Environment;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.user.AuthCredentials;

public class HTTPSpnegoAuthenticator
implements HTTPAuthenticator {
    private static final String EMPTY_STRING = "";
    private static final Oid[] KRB_OIDS = new Oid[]{KrbConstants.SPNEGO, KrbConstants.KRB5MECH};
    protected final Logger log = LogManager.getLogger(this.getClass());
    private boolean stripRealmFromPrincipalName;
    private Set<String> acceptorPrincipal;
    private Path acceptorKeyTabPath;

    public HTTPSpnegoAuthenticator(final Settings settings, Path configPath) {
        try {
            final Path configDir = new Environment(settings, configPath).configFile();
            final String krb5PathSetting = settings.get("plugins.security.kerberos.krb5_filepath");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        if (settings.getAsBoolean("krb_debug", Boolean.valueOf(false)).booleanValue()) {
                            JaasKrbUtil.setDebug(true);
                            System.setProperty("sun.security.krb5.debug", "true");
                            System.setProperty("java.security.debug", "gssloginconfig,logincontext,configparser,configfile");
                            System.setProperty("sun.security.spnego.debug", "true");
                            System.out.println("Kerberos debug is enabled");
                            System.err.println("Kerberos debug is enabled");
                            HTTPSpnegoAuthenticator.this.log.info("Kerberos debug is enabled on stdout");
                        } else {
                            HTTPSpnegoAuthenticator.this.log.debug("Kerberos debug is NOT enabled");
                        }
                    }
                    catch (Throwable e) {
                        HTTPSpnegoAuthenticator.this.log.error("Unable to enable krb_debug due to ", e);
                        System.err.println("Unable to enable krb_debug due to " + ExceptionsHelper.stackTrace((Throwable)e));
                        System.out.println("Unable to enable krb_debug due to " + ExceptionsHelper.stackTrace((Throwable)e));
                    }
                    System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                    String krb5Path = krb5PathSetting;
                    if (!Strings.isNullOrEmpty((String)krb5Path)) {
                        if (Paths.get(krb5Path, new String[0]).isAbsolute()) {
                            HTTPSpnegoAuthenticator.this.log.debug("krb5_filepath: {}", (Object)krb5Path);
                            System.setProperty("java.security.krb5.conf", krb5Path);
                        } else {
                            krb5Path = configDir.resolve(krb5Path).toAbsolutePath().toString();
                            HTTPSpnegoAuthenticator.this.log.debug("krb5_filepath (resolved from {}): {}", (Object)configDir, (Object)krb5Path);
                        }
                        System.setProperty("java.security.krb5.conf", krb5Path);
                    } else if (Strings.isNullOrEmpty((String)System.getProperty("java.security.krb5.conf"))) {
                        System.setProperty("java.security.krb5.conf", "/etc/krb5.conf");
                        HTTPSpnegoAuthenticator.this.log.debug("krb5_filepath (was not set or configured, set to default): /etc/krb5.conf");
                    }
                    HTTPSpnegoAuthenticator.this.stripRealmFromPrincipalName = settings.getAsBoolean("strip_realm_from_principal", Boolean.valueOf(true));
                    HTTPSpnegoAuthenticator.this.acceptorPrincipal = new HashSet<String>(settings.getAsList("plugins.security.kerberos.acceptor_principal", Collections.emptyList()));
                    String _acceptorKeyTabPath = settings.get("plugins.security.kerberos.acceptor_keytab_filepath");
                    if (HTTPSpnegoAuthenticator.this.acceptorPrincipal == null || HTTPSpnegoAuthenticator.this.acceptorPrincipal.size() == 0) {
                        HTTPSpnegoAuthenticator.this.log.error("acceptor_principal must not be null or empty. Kerberos authentication will not work");
                        HTTPSpnegoAuthenticator.this.acceptorPrincipal = null;
                    }
                    if (_acceptorKeyTabPath == null || _acceptorKeyTabPath.length() == 0) {
                        HTTPSpnegoAuthenticator.this.log.error("plugins.security.kerberos.acceptor_keytab_filepath must not be null or empty. Kerberos authentication will not work");
                        HTTPSpnegoAuthenticator.this.acceptorKeyTabPath = null;
                    } else {
                        HTTPSpnegoAuthenticator.this.acceptorKeyTabPath = configDir.resolve(settings.get("plugins.security.kerberos.acceptor_keytab_filepath"));
                        if (!Files.exists(HTTPSpnegoAuthenticator.this.acceptorKeyTabPath, new LinkOption[0])) {
                            HTTPSpnegoAuthenticator.this.log.error("Unable to read keytab from {} - Maybe the file does not exist or is not readable. Kerberos authentication will not work", (Object)HTTPSpnegoAuthenticator.this.acceptorKeyTabPath);
                            HTTPSpnegoAuthenticator.this.acceptorKeyTabPath = null;
                        }
                    }
                    return null;
                }
            });
            this.log.debug("strip_realm_from_principal {}", (Object)this.stripRealmFromPrincipalName);
            this.log.debug("acceptor_principal {}", this.acceptorPrincipal);
            this.log.debug("acceptor_keytab_filepath {}", (Object)this.acceptorKeyTabPath);
        }
        catch (Throwable e) {
            this.log.error("Cannot construct HTTPSpnegoAuthenticator due to {}", (Object)e.getMessage(), (Object)e);
            this.log.error("Please make sure you configured 'plugins.security.kerberos.acceptor_keytab_filepath' realtive to the ES config/ dir!");
            throw e;
        }
    }

    @Override
    public AuthCredentials extractCredentials(final RestRequest request, ThreadContext threadContext) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AuthCredentials creds = AccessController.doPrivileged(new PrivilegedAction<AuthCredentials>(){

            @Override
            public AuthCredentials run() {
                return HTTPSpnegoAuthenticator.this.extractCredentials0(request);
            }
        });
        return creds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private AuthCredentials extractCredentials0(RestRequest request) {
        if (this.acceptorPrincipal == null || this.acceptorKeyTabPath == null) {
            this.log.error("Missing acceptor principal or keytab configuration. Kerberos authentication will not work");
            return null;
        }
        Principal principal = null;
        String authorizationHeader = request.header("Authorization");
        if (authorizationHeader != null) {
            GSSManager manager;
            if (!authorizationHeader.trim().toLowerCase().startsWith("negotiate ")) {
                this.log.warn("No 'Negotiate Authorization' header, send 401 and 'WWW-Authenticate Negotiate'");
                return null;
            }
            byte[] decodedNegotiateHeader = Base64.getDecoder().decode(authorizationHeader.substring(10));
            GSSContext gssContext = null;
            byte[] outToken = null;
            try {
                Subject subject = JaasKrbUtil.loginUsingKeytab(this.acceptorPrincipal, this.acceptorKeyTabPath, false);
                manager = GSSManager.getInstance();
                int credentialLifetime = Integer.MAX_VALUE;
                PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

                    @Override
                    public GSSCredential run() throws GSSException {
                        return manager.createCredential(null, Integer.MAX_VALUE, KRB_OIDS, 2);
                    }
                };
                gssContext = manager.createContext(Subject.doAs(subject, action));
                outToken = Subject.doAs(subject, new AcceptAction(gssContext, decodedNegotiateHeader));
                if (outToken == null) {
                    this.log.warn("Ticket validation not successful, outToken is null");
                    AuthCredentials authCredentials = null;
                    return authCredentials;
                }
                principal = Subject.doAs(subject, new AuthenticateAction(this.log, gssContext, this.stripRealmFromPrincipalName));
            }
            catch (LoginException e) {
                this.log.error("Login exception due to", (Throwable)e);
                manager = null;
                return manager;
            }
            catch (GSSException e) {
                this.log.error("Ticket validation not successful due to", (Throwable)e);
                manager = null;
                return manager;
            }
            catch (PrivilegedActionException e2) {
                Throwable cause = e2.getCause();
                if (cause instanceof GSSException) {
                    this.log.info("Service login not successful due to", (Throwable)e2);
                } else {
                    this.log.error("Service login not successful due to", (Throwable)e2);
                }
                AuthCredentials authCredentials = null;
                return authCredentials;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (gssContext != null) {
                    try {
                        gssContext.dispose();
                    }
                    catch (GSSException gSSException) {}
                }
            }
            if (principal == null) {
                return new AuthCredentials("_incomplete_", (Object)outToken);
            }
            String username = ((SimpleUserPrincipal)principal).getName();
            if (username == null || username.length() == 0) {
                this.log.error("Got empty or null user from kerberos. Normally this means that you acceptor principal {} does not match the server hostname", this.acceptorPrincipal);
            }
            return new AuthCredentials(username, (Object)outToken).markComplete();
        }
        this.log.trace("No 'Authorization' header, send 401 and 'WWW-Authenticate Negotiate'");
        return null;
    }

    @Override
    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials creds) {
        XContentBuilder response = this.getNegotiateResponseBody();
        BytesRestResponse wwwAuthenticateResponse = response != null ? new BytesRestResponse(RestStatus.UNAUTHORIZED, response) : new BytesRestResponse(RestStatus.UNAUTHORIZED, EMPTY_STRING);
        if (creds == null || creds.getNativeCredentials() == null) {
            wwwAuthenticateResponse.addHeader("WWW-Authenticate", "Negotiate");
        } else {
            wwwAuthenticateResponse.addHeader("WWW-Authenticate", "Negotiate " + Base64.getEncoder().encodeToString((byte[])creds.getNativeCredentials()));
        }
        channel.sendResponse((RestResponse)wwwAuthenticateResponse);
        return true;
    }

    @Override
    public String getType() {
        return "spnego";
    }

    private static String getUsernameFromGSSContext(GSSContext gssContext, boolean strip, Logger logger) {
        if (gssContext.isEstablished()) {
            GSSName gssName = null;
            try {
                gssName = gssContext.getSrcName();
            }
            catch (GSSException e) {
                logger.error("Unable to get src name from gss context", (Throwable)e);
            }
            if (gssName != null) {
                String name = gssName.toString();
                return HTTPSpnegoAuthenticator.stripRealmName(name, strip);
            }
            logger.error("GSS name is null");
        } else {
            logger.error("GSS context not established");
        }
        return null;
    }

    private XContentBuilder getNegotiateResponseBody() {
        try {
            XContentBuilder negotiateResponseBody = XContentFactory.jsonBuilder();
            negotiateResponseBody.startObject();
            negotiateResponseBody.field("error");
            negotiateResponseBody.startObject();
            negotiateResponseBody.field("header");
            negotiateResponseBody.startObject();
            negotiateResponseBody.field("WWW-Authenticate", "Negotiate");
            negotiateResponseBody.endObject();
            negotiateResponseBody.endObject();
            negotiateResponseBody.endObject();
            return negotiateResponseBody;
        }
        catch (Exception ex) {
            this.log.error("Can't construct response body", (Throwable)ex);
            return null;
        }
    }

    private static String stripRealmName(String name, boolean strip) {
        int i;
        if (strip && name != null && (i = name.indexOf(64)) > 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    private static class SimpleUserPrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = -1L;
        private final String username;

        SimpleUserPrincipal(String username) {
            this.username = username;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleUserPrincipal other = (SimpleUserPrincipal)obj;
            return !(this.username == null ? other.username != null : !this.username.equals(other.username));
        }

        @Override
        public String getName() {
            return this.username;
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[principal: ");
            buffer.append(this.username);
            buffer.append("]");
            return buffer.toString();
        }
    }

    private static class AuthenticateAction
    implements PrivilegedAction<Principal> {
        private final Logger logger;
        private final GSSContext gssContext;
        private final boolean strip;

        private AuthenticateAction(Logger logger, GSSContext gssContext, boolean strip) {
            this.logger = logger;
            this.gssContext = gssContext;
            this.strip = strip;
        }

        @Override
        public Principal run() {
            return new SimpleUserPrincipal(HTTPSpnegoAuthenticator.getUsernameFromGSSContext(this.gssContext, this.strip, this.logger));
        }
    }

    private static class AcceptAction
    implements PrivilegedExceptionAction<byte[]> {
        GSSContext gssContext;
        byte[] decoded;

        AcceptAction(GSSContext context, byte[] decodedToken) {
            this.gssContext = context;
            this.decoded = decodedToken;
        }

        @Override
        public byte[] run() throws GSSException {
            return this.gssContext.acceptSecContext(this.decoded, 0, this.decoded.length);
        }
    }
}

