/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.ldap.util;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.ldaptive.Connection;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.SearchScope;
import org.ldaptive.referral.ReferralHandler;
import org.ldaptive.referral.SearchReferralHandler;
import org.opensearch.SpecialPermission;

public class LdapHelper {
    private static SearchFilter ALL = new SearchFilter("(objectClass=*)");

    public static List<LdapEntry> search(final Connection conn, String unescapedDn, final SearchFilter filter, final SearchScope searchScope, final String[] returnAttributes) throws LdapException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            final String baseDn = LdapHelper.escapeDn(unescapedDn);
            return AccessController.doPrivileged(new PrivilegedExceptionAction<List<LdapEntry>>(){

                @Override
                public List<LdapEntry> run() throws Exception {
                    ArrayList<LdapEntry> entries = new ArrayList<LdapEntry>();
                    SearchRequest request = new SearchRequest(baseDn, filter);
                    request.setReferralHandler((ReferralHandler)new SearchReferralHandler());
                    request.setSearchScope(searchScope);
                    request.setDerefAliases(DerefAliases.ALWAYS);
                    request.setReturnAttributes(returnAttributes);
                    SearchOperation search = new SearchOperation(conn);
                    Response r = search.execute((Request)request);
                    SearchResult result = (SearchResult)r.getResult();
                    entries.addAll(result.getEntries());
                    return entries;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof LdapException) {
                throw (LdapException)((Object)e.getException());
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e);
        }
        catch (InvalidNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static LdapEntry lookup(Connection conn, String unescapedDn, String[] returnAttributes) throws LdapException {
        List<LdapEntry> entries = LdapHelper.search(conn, unescapedDn, ALL, SearchScope.OBJECT, returnAttributes);
        if (entries.size() == 1) {
            return entries.get(0);
        }
        return null;
    }

    private static String escapeDn(String dn) throws InvalidNameException {
        LdapName dnName = new LdapName(dn);
        ArrayList<Rdn> escaped = new ArrayList<Rdn>(dnName.size());
        for (Rdn rdn : dnName.getRdns()) {
            escaped.add(new Rdn(rdn.getType(), LdapHelper.escapeForwardSlash(rdn.getValue())));
        }
        return new LdapName(escaped).toString();
    }

    private static Object escapeForwardSlash(Object input) {
        if (input != null && input instanceof String) {
            return ((String)input).replace("/", "\\2f");
        }
        return input;
    }
}

