/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.ldap2;

import com.amazon.dlic.auth.ldap.util.LdapHelper;
import com.amazon.dlic.auth.ldap.util.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ldaptive.Connection;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchScope;
import org.opensearch.common.settings.Settings;

public class LDAPUserSearcher {
    protected static final Logger log = LogManager.getLogger(LDAPUserSearcher.class);
    private static final int ZERO_PLACEHOLDER = 0;
    private static final String DEFAULT_USERBASE = "";
    private static final String DEFAULT_USERSEARCH_PATTERN = "(sAMAccountName={0})";
    private final Settings settings;
    private final List<Map.Entry<String, Settings>> userBaseSettings;

    public LDAPUserSearcher(Settings settings) {
        this.settings = settings;
        this.userBaseSettings = LDAPUserSearcher.getUserBaseSettings(settings);
    }

    static List<Map.Entry<String, Settings>> getUserBaseSettings(Settings settings) {
        HashMap<String, Settings> userBaseSettingsMap = new HashMap<String, Settings>(settings.getGroups("users"));
        if (!userBaseSettingsMap.isEmpty()) {
            if (settings.hasValue("userbase")) {
                throw new RuntimeException("Both old-style and new-style configuration defined for LDAP authentication backend: " + settings);
            }
            return Utils.getOrderedBaseSettings(userBaseSettingsMap);
        }
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("base", settings.get("userbase", DEFAULT_USERBASE));
        settingsBuilder.put("search", settings.get("usersearch", DEFAULT_USERSEARCH_PATTERN));
        return Collections.singletonList(Pair.of((Object)"_legacyConfig", (Object)settingsBuilder.build()));
    }

    LdapEntry exists(Connection ldapConnection, String user, String[] returnAttributes) throws Exception {
        if (this.settings.getAsBoolean("fakelogin_enabled", Boolean.valueOf(false)).booleanValue() || this.settings.getAsBoolean("search_all_bases", Boolean.valueOf(false)).booleanValue() || this.settings.hasValue("userbase")) {
            return this.existsSearchingAllBases(ldapConnection, user, returnAttributes);
        }
        return this.existsSearchingUntilFirstHit(ldapConnection, user, returnAttributes);
    }

    private LdapEntry existsSearchingUntilFirstHit(Connection ldapConnection, String user, String[] returnAttributes) throws Exception {
        String username = user;
        boolean isDebugEnabled = log.isDebugEnabled();
        for (Map.Entry<String, Settings> entry : this.userBaseSettings) {
            Settings baseSettings = entry.getValue();
            SearchFilter f = new SearchFilter();
            f.setFilter(baseSettings.get("search", DEFAULT_USERSEARCH_PATTERN));
            f.setParameter(0, (Object)username);
            List<LdapEntry> result = LdapHelper.search(ldapConnection, baseSettings.get("base", DEFAULT_USERBASE), f, SearchScope.SUBTREE, returnAttributes);
            if (isDebugEnabled) {
                log.debug("Results for LDAP search for {} in base {}:\n{}", (Object)user, (Object)entry.getKey(), result);
            }
            if (result == null || result.size() < 1) continue;
            return result.get(0);
        }
        return null;
    }

    private LdapEntry existsSearchingAllBases(Connection ldapConnection, String user, String[] returnAttributes) throws Exception {
        String username = user;
        HashSet<LdapEntry> result = new HashSet<LdapEntry>();
        boolean isDebugEnabled = log.isDebugEnabled();
        for (Map.Entry<String, Settings> entry : this.userBaseSettings) {
            Settings baseSettings = entry.getValue();
            SearchFilter f = new SearchFilter();
            f.setFilter(baseSettings.get("search", DEFAULT_USERSEARCH_PATTERN));
            f.setParameter(0, (Object)username);
            List<LdapEntry> foundEntries = LdapHelper.search(ldapConnection, baseSettings.get("base", DEFAULT_USERBASE), f, SearchScope.SUBTREE, returnAttributes);
            if (isDebugEnabled) {
                log.debug("Results for LDAP search for {} in base {}:\n{}", (Object)user, (Object)entry.getKey(), result);
            }
            if (foundEntries == null) continue;
            result.addAll(foundEntries);
        }
        if (result.isEmpty()) {
            log.debug("No user {} found", (Object)username);
            return null;
        }
        if (result.size() > 1) {
            log.debug("More than one user for '{}' found", (Object)username);
            return null;
        }
        return (LdapEntry)result.iterator().next();
    }
}

