/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.util;

import com.google.common.collect.ImmutableList;
import java.net.Socket;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.support.PemKeyReader;

public class SettingsBasedSSLConfigurator {
    private static final Logger log = LogManager.getLogger(SettingsBasedSSLConfigurator.class);
    public static final String CERT_ALIAS = "cert_alias";
    public static final String CA_ALIAS = "ca_alias";
    public static final String ENABLE_SSL = "enable_ssl";
    public static final String ENABLE_START_TLS = "enable_start_tls";
    public static final String ENABLE_SSL_CLIENT_AUTH = "enable_ssl_client_auth";
    public static final String PEMKEY_FILEPATH = "pemkey_filepath";
    public static final String PEMKEY_CONTENT = "pemkey_content";
    public static final String PEMKEY_PASSWORD = "pemkey_password";
    public static final String PEMCERT_FILEPATH = "pemcert_filepath";
    public static final String PEMCERT_CONTENT = "pemcert_content";
    public static final String PEMTRUSTEDCAS_CONTENT = "pemtrustedcas_content";
    public static final String PEMTRUSTEDCAS_FILEPATH = "pemtrustedcas_filepath";
    public static final String VERIFY_HOSTNAMES = "verify_hostnames";
    public static final String TRUST_ALL = "trust_all";
    private static final List<String> DEFAULT_TLS_PROTOCOLS = ImmutableList.of((Object)"TLSv1.2", (Object)"TLSv1.1");
    private SSLContextBuilder sslContextBuilder;
    private final Settings settings;
    private final String settingsKeyPrefix;
    private final Path configPath;
    private final String clientName;
    private boolean enabled;
    private boolean enableSslClientAuth;
    private KeyStore effectiveTruststore;
    private KeyStore effectiveKeystore;
    private char[] effectiveKeyPassword;
    private String effectiveKeyAlias;
    private List<String> effectiveTruststoreAliases;

    public SettingsBasedSSLConfigurator(Settings settings, Path configPath, String settingsKeyPrefix, String clientName) {
        this.settings = settings;
        this.configPath = configPath;
        this.settingsKeyPrefix = SettingsBasedSSLConfigurator.normalizeSettingsKeyPrefix(settingsKeyPrefix);
        this.clientName = clientName != null ? clientName : this.settingsKeyPrefix;
    }

    public SettingsBasedSSLConfigurator(Settings settings, Path configPath, String settingsKeyPrefix) {
        this(settings, configPath, settingsKeyPrefix, null);
    }

    SSLContext buildSSLContext() throws SSLConfigException {
        try {
            this.sslContextBuilder = this.isTrustAllEnabled() ? new OverlyTrustfulSSLContextBuilder() : SSLContexts.custom();
            this.configureWithSettings();
            if (!this.enabled) {
                return null;
            }
            return this.sslContextBuilder.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new SSLConfigException("Error while initializing SSL configuration for " + this.clientName, e);
        }
    }

    public SSLConfig buildSSLConfig() throws SSLConfigException {
        SSLContext sslContext = this.buildSSLContext();
        if (sslContext == null) {
            return null;
        }
        return new SSLConfig(sslContext, this.getSupportedProtocols(), this.getSupportedCipherSuites(), this.getHostnameVerifier(), this.isHostnameVerificationEnabled(), this.isTrustAllEnabled(), this.isStartTlsEnabled(), this.effectiveTruststore, this.effectiveTruststoreAliases, this.effectiveKeystore, this.effectiveKeyPassword, this.effectiveKeyAlias);
    }

    private boolean isHostnameVerificationEnabled() {
        return this.getSettingAsBoolean(VERIFY_HOSTNAMES, true) != false && !this.isTrustAllEnabled();
    }

    private HostnameVerifier getHostnameVerifier() {
        if (this.isHostnameVerificationEnabled()) {
            return new DefaultHostnameVerifier();
        }
        return NoopHostnameVerifier.INSTANCE;
    }

    private String[] getSupportedProtocols() {
        return this.getSettingAsArray("enabled_ssl_protocols", DEFAULT_TLS_PROTOCOLS);
    }

    private String[] getSupportedCipherSuites() {
        return this.getSettingAsArray("enabled_ssl_ciphers", null);
    }

    private boolean isStartTlsEnabled() {
        return this.getSettingAsBoolean(ENABLE_START_TLS, false);
    }

    private boolean isTrustAllEnabled() {
        return this.getSettingAsBoolean(TRUST_ALL, false);
    }

    private void configureWithSettings() throws SSLConfigException, NoSuchAlgorithmException, KeyStoreException {
        this.enabled = this.getSettingAsBoolean(ENABLE_SSL, false);
        if (!this.enabled) {
            return;
        }
        this.enableSslClientAuth = this.getSettingAsBoolean(ENABLE_SSL_CLIENT_AUTH, false);
        if (this.settings.get(this.settingsKeyPrefix + PEMTRUSTEDCAS_FILEPATH, null) != null || this.settings.get(this.settingsKeyPrefix + PEMTRUSTEDCAS_CONTENT, null) != null) {
            this.initFromPem();
        } else {
            this.initFromKeyStore();
        }
        if (this.effectiveTruststore != null) {
            this.sslContextBuilder.loadTrustMaterial(this.effectiveTruststore, null);
        }
        if (this.enableSslClientAuth && this.effectiveKeystore != null) {
            try {
                this.sslContextBuilder.loadKeyMaterial(this.effectiveKeystore, this.effectiveKeyPassword, new PrivateKeyStrategy(){

                    public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
                        if (aliases == null || aliases.isEmpty()) {
                            return SettingsBasedSSLConfigurator.this.effectiveKeyAlias;
                        }
                        if (SettingsBasedSSLConfigurator.this.effectiveKeyAlias == null || SettingsBasedSSLConfigurator.this.effectiveKeyAlias.isEmpty()) {
                            return aliases.keySet().iterator().next();
                        }
                        return SettingsBasedSSLConfigurator.this.effectiveKeyAlias;
                    }
                });
            }
            catch (UnrecoverableKeyException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void initFromPem() throws SSLConfigException {
        PrivateKey authenticationKey;
        X509Certificate[] authenticationCertificate;
        X509Certificate[] trustCertificates;
        try {
            trustCertificates = PemKeyReader.loadCertificatesFromStream(PemKeyReader.resolveStream(this.settingsKeyPrefix + PEMTRUSTEDCAS_CONTENT, this.settings));
        }
        catch (Exception e) {
            throw new SSLConfigException("Error loading PEM from " + this.settingsKeyPrefix + "pemtrustedcas_content for " + this.clientName, e);
        }
        if (trustCertificates == null) {
            String path = PemKeyReader.resolve(this.settingsKeyPrefix + PEMTRUSTEDCAS_FILEPATH, this.settings, this.configPath, !this.isTrustAllEnabled());
            try {
                trustCertificates = PemKeyReader.loadCertificatesFromFile(path);
            }
            catch (Exception e) {
                throw new SSLConfigException("Error loading PEM from " + path + " (" + this.settingsKeyPrefix + "pemtrustedcas_filepath) for " + this.clientName, e);
            }
        }
        try {
            authenticationCertificate = PemKeyReader.loadCertificatesFromStream(PemKeyReader.resolveStream(this.settingsKeyPrefix + PEMCERT_CONTENT, this.settings));
        }
        catch (Exception e) {
            throw new SSLConfigException("Error loading PEM from " + this.settingsKeyPrefix + "pemcert_content for " + this.clientName, e);
        }
        if (authenticationCertificate == null) {
            String path = PemKeyReader.resolve(this.settingsKeyPrefix + PEMCERT_FILEPATH, this.settings, this.configPath, this.enableSslClientAuth);
            try {
                authenticationCertificate = PemKeyReader.loadCertificatesFromFile(path);
            }
            catch (Exception e) {
                throw new SSLConfigException("Error loading PEM from " + path + " (" + this.settingsKeyPrefix + "pemcert_filepath) for " + this.clientName, e);
            }
        }
        try {
            authenticationKey = PemKeyReader.loadKeyFromStream(this.getSetting(PEMKEY_PASSWORD), PemKeyReader.resolveStream(this.settingsKeyPrefix + PEMKEY_CONTENT, this.settings));
        }
        catch (Exception e) {
            throw new SSLConfigException("Error loading PEM from " + this.settingsKeyPrefix + "pemkey_content for " + this.clientName, e);
        }
        if (authenticationKey == null) {
            String path = PemKeyReader.resolve(this.settingsKeyPrefix + PEMKEY_FILEPATH, this.settings, this.configPath, this.enableSslClientAuth);
            try {
                authenticationKey = PemKeyReader.loadKeyFromFile(this.getSetting(PEMKEY_PASSWORD), path);
            }
            catch (Exception e) {
                throw new SSLConfigException("Error loading PEM from " + path + " (" + this.settingsKeyPrefix + "pemkey_filepath) for " + this.clientName, e);
            }
        }
        try {
            this.effectiveKeyPassword = PemKeyReader.randomChars(12);
            this.effectiveKeyAlias = "al";
            this.effectiveTruststore = PemKeyReader.toTruststore(this.effectiveKeyAlias, trustCertificates);
            this.effectiveKeystore = PemKeyReader.toKeystore(this.effectiveKeyAlias, this.effectiveKeyPassword, authenticationCertificate, authenticationKey);
        }
        catch (Exception e) {
            throw new SSLConfigException("Error initializing SSLConfig for " + this.clientName, e);
        }
    }

    private void initFromKeyStore() throws SSLConfigException {
        KeyStore keyStore;
        KeyStore trustStore;
        try {
            trustStore = PemKeyReader.loadKeyStore(PemKeyReader.resolve("plugins.security.ssl.transport.truststore_filepath", this.settings, this.configPath, !this.isTrustAllEnabled()), this.settings.get("plugins.security.ssl.transport.truststore_password", "changeit"), this.settings.get("plugins.security.ssl.transport.truststore_type"));
        }
        catch (Exception e) {
            throw new SSLConfigException("Error loading trust store from " + this.settings.get("plugins.security.ssl.transport.truststore_filepath"), e);
        }
        this.effectiveTruststoreAliases = this.getSettingAsList(CA_ALIAS, null);
        try {
            keyStore = PemKeyReader.loadKeyStore(PemKeyReader.resolve("plugins.security.ssl.transport.keystore_filepath", this.settings, this.configPath, this.enableSslClientAuth), this.settings.get("plugins.security.ssl.transport.keystore_password", "changeit"), this.settings.get("plugins.security.ssl.transport.keystore_type"));
        }
        catch (Exception e) {
            throw new SSLConfigException("Error loading key store from " + this.settings.get("plugins.security.ssl.transport.keystore_filepath"), e);
        }
        String keyStorePassword = this.settings.get("plugins.security.ssl.transport.keystore_password", "changeit");
        this.effectiveKeyPassword = keyStorePassword == null || keyStorePassword.isEmpty() ? null : keyStorePassword.toCharArray();
        this.effectiveKeyAlias = this.getSetting(CERT_ALIAS);
        if (this.enableSslClientAuth && this.effectiveKeyAlias == null) {
            throw new IllegalArgumentException(this.settingsKeyPrefix + "cert_alias not given");
        }
        this.effectiveTruststore = trustStore;
        this.effectiveKeystore = keyStore;
    }

    private String getSetting(String key) {
        return this.settings.get(this.settingsKeyPrefix + key);
    }

    private Boolean getSettingAsBoolean(String key, Boolean defaultValue) {
        return this.settings.getAsBoolean(this.settingsKeyPrefix + key, defaultValue);
    }

    private List<String> getSettingAsList(String key, List<String> defaultValue) {
        return this.settings.getAsList(this.settingsKeyPrefix + key, defaultValue);
    }

    private String[] getSettingAsArray(String key, List<String> defaultValue) {
        List<String> list = this.getSettingAsList(key, defaultValue);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    private static String normalizeSettingsKeyPrefix(String settingsKeyPrefix) {
        if (settingsKeyPrefix == null || settingsKeyPrefix.length() == 0) {
            return "";
        }
        if (!settingsKeyPrefix.endsWith(".")) {
            return settingsKeyPrefix + ".";
        }
        return settingsKeyPrefix;
    }

    private static class OverlyTrustfulTrustManager
    implements X509TrustManager {
        private OverlyTrustfulTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class OverlyTrustfulSSLContextBuilder
    extends SSLContextBuilder {
        private OverlyTrustfulSSLContextBuilder() {
        }

        protected void initSSLContext(SSLContext sslContext, Collection<KeyManager> keyManagers, Collection<TrustManager> trustManagers, SecureRandom secureRandom) throws KeyManagementException {
            sslContext.init(!keyManagers.isEmpty() ? keyManagers.toArray(new KeyManager[keyManagers.size()]) : null, new TrustManager[]{new OverlyTrustfulTrustManager()}, secureRandom);
        }
    }

    public static class SSLConfigException
    extends Exception {
        private static final long serialVersionUID = 5827273100470174111L;

        public SSLConfigException() {
        }

        public SSLConfigException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public SSLConfigException(String message, Throwable cause) {
            super(message, cause);
        }

        public SSLConfigException(String message) {
            super(message);
        }

        public SSLConfigException(Throwable cause) {
            super(cause);
        }
    }

    public static class SSLConfig {
        private final SSLContext sslContext;
        private final String[] supportedProtocols;
        private final String[] supportedCipherSuites;
        private final HostnameVerifier hostnameVerifier;
        private final boolean startTlsEnabled;
        private final boolean hostnameVerificationEnabled;
        private final boolean trustAll;
        private final KeyStore effectiveTruststore;
        private final List<String> effectiveTruststoreAliases;
        private final KeyStore effectiveKeystore;
        private final char[] effectiveKeyPassword;
        private final String effectiveKeyAlias;

        public SSLConfig(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier, boolean hostnameVerificationEnabled, boolean trustAll, boolean startTlsEnabled, KeyStore effectiveTruststore, List<String> effectiveTruststoreAliases, KeyStore effectiveKeystore, char[] effectiveKeyPassword, String effectiveKeyAlias) {
            this.sslContext = sslContext;
            this.supportedProtocols = supportedProtocols;
            this.supportedCipherSuites = supportedCipherSuites;
            this.hostnameVerifier = hostnameVerifier;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.trustAll = trustAll;
            this.startTlsEnabled = startTlsEnabled;
            this.effectiveTruststore = effectiveTruststore;
            this.effectiveTruststoreAliases = effectiveTruststoreAliases;
            this.effectiveKeystore = effectiveKeystore;
            this.effectiveKeyPassword = effectiveKeyPassword;
            this.effectiveKeyAlias = effectiveKeyAlias;
            if (log.isDebugEnabled()) {
                log.debug("Created SSLConfig: {}", (Object)this);
            }
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public String[] getSupportedProtocols() {
            return this.supportedProtocols;
        }

        public String[] getSupportedCipherSuites() {
            return this.supportedCipherSuites;
        }

        public HostnameVerifier getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public SSLIOSessionStrategy toSSLIOSessionStrategy() {
            return new SSLIOSessionStrategy(this.sslContext, this.supportedProtocols, this.supportedCipherSuites, this.hostnameVerifier);
        }

        public SSLConnectionSocketFactory toSSLConnectionSocketFactory() {
            return new SSLConnectionSocketFactory(this.sslContext, this.supportedProtocols, this.supportedCipherSuites, this.hostnameVerifier);
        }

        public boolean isStartTlsEnabled() {
            return this.startTlsEnabled;
        }

        public boolean isHostnameVerificationEnabled() {
            return this.hostnameVerificationEnabled;
        }

        public KeyStore getEffectiveTruststore() {
            return this.effectiveTruststore;
        }

        public KeyStore getEffectiveKeystore() {
            return this.effectiveKeystore;
        }

        public char[] getEffectiveKeyPassword() {
            return this.effectiveKeyPassword;
        }

        public String getEffectiveKeyPasswordString() {
            if (this.effectiveKeyPassword == null) {
                return null;
            }
            return new String(this.effectiveKeyPassword);
        }

        public String getEffectiveKeyAlias() {
            return this.effectiveKeyAlias;
        }

        public List<String> getEffectiveTruststoreAliases() {
            return this.effectiveTruststoreAliases;
        }

        public String[] getEffectiveTruststoreAliasesArray() {
            if (this.effectiveTruststoreAliases == null) {
                return null;
            }
            return this.effectiveTruststoreAliases.toArray(new String[this.effectiveTruststoreAliases.size()]);
        }

        public String[] getEffectiveKeyAliasesArray() {
            if (this.effectiveKeyAlias == null) {
                return null;
            }
            return new String[]{this.effectiveKeyAlias};
        }

        public String toString() {
            return "SSLConfig [sslContext=" + this.sslContext + ", supportedProtocols=" + Arrays.toString(this.supportedProtocols) + ", supportedCipherSuites=" + Arrays.toString(this.supportedCipherSuites) + ", hostnameVerifier=" + this.hostnameVerifier + ", startTlsEnabled=" + this.startTlsEnabled + ", hostnameVerificationEnabled=" + this.hostnameVerificationEnabled + ", trustAll=" + this.trustAll + ", effectiveTruststore=" + this.effectiveTruststore + ", effectiveTruststoreAliases=" + this.effectiveTruststoreAliases + ", effectiveKeystore=" + this.effectiveKeystore + ", effectiveKeyAlias=" + this.effectiveKeyAlias + "]";
        }

        public boolean isTrustAllEnabled() {
            return this.trustAll;
        }
    }
}

