/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql;

import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.QueryManager;
import org.opensearch.sql.executor.execution.AbstractPlan;
import org.opensearch.sql.executor.execution.QueryPlanFactory;
import org.opensearch.sql.sql.antlr.SQLSyntaxParser;
import org.opensearch.sql.sql.domain.SQLQueryRequest;
import org.opensearch.sql.sql.parser.AstBuilder;
import org.opensearch.sql.sql.parser.AstStatementBuilder;

public class SQLService {
    private final SQLSyntaxParser parser;
    private final QueryManager queryManager;
    private final QueryPlanFactory queryExecutionFactory;

    public void execute(SQLQueryRequest request, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            this.queryManager.submit(this.plan(request, Optional.of(listener), Optional.empty()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void explain(SQLQueryRequest request, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        try {
            this.queryManager.submit(this.plan(request, Optional.empty(), Optional.of(listener)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private AbstractPlan plan(SQLQueryRequest request, Optional<ResponseListener<ExecutionEngine.QueryResponse>> queryListener, Optional<ResponseListener<ExecutionEngine.ExplainResponse>> explainListener) {
        ParseTree cst = this.parser.parse(request.getQuery());
        Statement statement = (Statement)cst.accept((ParseTreeVisitor)new AstStatementBuilder(new AstBuilder(request.getQuery()), AstStatementBuilder.StatementBuilderContext.builder().isExplain(request.isExplainRequest()).build()));
        return this.queryExecutionFactory.create(statement, queryListener, explainListener);
    }

    @Generated
    public SQLService(SQLSyntaxParser parser, QueryManager queryManager, QueryPlanFactory queryExecutionFactory) {
        this.parser = parser;
        this.queryManager = queryManager;
        this.queryExecutionFactory = queryExecutionFactory;
    }
}

