/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.node.scroll;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.search.SearchHit;
import org.opensearch.sql.legacy.query.planner.physical.Row;

class SearchHitRow
implements Row<SearchHit> {
    private final SearchHit hit;
    private final Map<String, Object> source;
    private final String tableAlias;

    SearchHitRow(SearchHit hit, String tableAlias) {
        this.hit = hit;
        this.source = hit.getSourceAsMap();
        this.tableAlias = tableAlias;
    }

    @Override
    public Row.RowKey key(String[] colNames) {
        if (colNames.length == 0) {
            return Row.RowKey.NULL;
        }
        Object[] keys = new Object[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            keys[i] = this.getValueOfPath(colNames[i]);
            if (keys[i] != null) continue;
            return Row.RowKey.NULL;
        }
        return new Row.RowKey(keys);
    }

    @Override
    public Row<SearchHit> combine(Row<SearchHit> other) {
        SearchHit combined = this.cloneHit(other);
        this.collectFullName(combined.getSourceAsMap(), this);
        if (other != NULL) {
            this.collectFullName(combined.getSourceAsMap(), (SearchHitRow)other);
        }
        return new SearchHitRow(combined, "");
    }

    @Override
    public void retain(Map<String, String> colNameAlias) {
        HashMap<String, Object> aliasSource = new HashMap<String, Object>();
        colNameAlias.forEach((colName, alias) -> {
            if (colName.endsWith(".*")) {
                String tableAlias = colName.substring(0, colName.length() - 2) + ".";
                this.retainAllFieldsFromTable(aliasSource, tableAlias);
            } else {
                this.retainOneField((Map<String, Object>)aliasSource, (String)colName, (String)alias);
            }
        });
        this.resetSource(aliasSource);
    }

    @Override
    public SearchHit data() {
        return this.hit;
    }

    public String toString() {
        return "SearchHitRow{hit=" + this.source + "}";
    }

    private Object getValueOfPath(String path) {
        return this.getValueOfPath(this.source, path, Strings.isNullOrEmpty((String)this.tableAlias));
    }

    private Object getValueOfPath(Object source, String path, boolean isIgnoreFirstDot) {
        if (!(source instanceof Map) || path.isEmpty()) {
            return source;
        }
        int dot = path.indexOf(46, isIgnoreFirstDot ? path.indexOf(46) + 1 : 0);
        if (dot == -1) {
            return ((Map)source).get(path);
        }
        if (((Map)source).containsKey(path)) {
            return ((Map)source).get(path);
        }
        return this.getValueOfPath(((Map)source).get(path.substring(0, dot)), path.substring(dot + 1), false);
    }

    private SearchHit cloneHit(Row<SearchHit> other) {
        HashMap documentFields = new HashMap();
        HashMap metaFields = new HashMap();
        this.hit.getFields().forEach((fieldName, docField) -> (MapperService.META_FIELDS_BEFORE_7DOT8.contains(fieldName) ? metaFields : documentFields).put(fieldName, docField));
        SearchHit combined = new SearchHit(this.hit.docId(), this.hit.getId() + "|" + (other == NULL ? "0" : ((SearchHitRow)other).hit.getId()), documentFields, metaFields);
        combined.sourceRef(this.hit.getSourceRef());
        combined.getSourceAsMap().clear();
        return combined;
    }

    private void collectFullName(Map<String, Object> newSource, SearchHitRow row) {
        row.source.forEach((colName, value) -> newSource.put(row.tableAlias + "." + colName, value));
    }

    private void retainAllFieldsFromTable(Map<String, Object> aliasSource, String tableAlias) {
        this.source.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(tableAlias)).forEach(e -> aliasSource.put((String)e.getKey(), e.getValue()));
    }

    private void retainOneField(Map<String, Object> aliasSource, String colName, String alias) {
        aliasSource.put(Strings.isNullOrEmpty((String)alias) ? colName : alias, this.getValueOfPath(colName));
    }

    private void resetSource(Map<String, Object> newSource) {
        this.source.clear();
        this.source.putAll(newSource);
    }
}

