/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredClassAxiomGenerator;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class InferredSubClassAxiomGenerator
extends InferredClassAxiomGenerator<OWLSubClassOfAxiom> {
    @Override
    protected void addAxioms(OWLClass entity, @Nonnull OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLSubClassOfAxiom> result) {
        OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        OWLAPIPreconditions.checkNotNull(reasoner, "reasoner cannot be null");
        OWLAPIPreconditions.checkNotNull(result, "result cannot be null");
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        if (reasoner.isSatisfiable(entity)) {
            for (OWLClass sup : reasoner.getSuperClasses(entity, true).getFlattened()) {
                assert (sup != null);
                result.add(dataFactory.getOWLSubClassOfAxiom(entity, sup));
            }
        } else {
            result.add(dataFactory.getOWLSubClassOfAxiom(entity, dataFactory.getOWLNothing()));
        }
    }

    @Override
    public String getLabel() {
        return "Subclasses";
    }
}

