from _typeshed import Incomplete
from typing import Any

def skip_if(predicate, reason: Incomplete | None = None): ...
def fails_if(predicate, reason: Incomplete | None = None): ...

class compound:
    fails: Any
    skips: Any
    tags: Any
    def __add__(self, other): ...
    def as_skips(self): ...
    def add(self, *others): ...
    def not_(self): ...
    @property
    def enabled(self): ...
    def enabled_for_config(self, config): ...
    def matching_config_reasons(self, config): ...
    def include_test(self, include_tags, exclude_tags): ...
    def __call__(self, fn): ...
    def fail_if(self) -> None: ...

def requires_tag(tagname): ...
def tags(tagnames): ...
def only_if(predicate, reason: Incomplete | None = None): ...
def succeeds_if(predicate, reason: Incomplete | None = None): ...

class Predicate:
    @classmethod
    def as_predicate(cls, predicate, description: Incomplete | None = None): ...

class BooleanPredicate(Predicate):
    value: Any
    description: Any
    def __init__(self, value, description: Incomplete | None = None) -> None: ...
    def __call__(self, config): ...

class SpecPredicate(Predicate):
    db: Any
    op: Any
    spec: Any
    description: Any
    def __init__(
        self, db, op: Incomplete | None = None, spec: Incomplete | None = None, description: Incomplete | None = None
    ) -> None: ...
    def __call__(self, config): ...

class LambdaPredicate(Predicate):
    lambda_: Any
    args: Any
    kw: Any
    description: Any
    def __init__(
        self, lambda_, description: Incomplete | None = None, args: Incomplete | None = None, kw: Incomplete | None = None
    ): ...
    def __call__(self, config): ...

class NotPredicate(Predicate):
    predicate: Any
    description: Any
    def __init__(self, predicate, description: Incomplete | None = None) -> None: ...
    def __call__(self, config): ...

class OrPredicate(Predicate):
    predicates: Any
    description: Any
    def __init__(self, predicates, description: Incomplete | None = None) -> None: ...
    def __call__(self, config): ...

def db_spec(*dbs): ...
def open(): ...
def closed(): ...
def fails(reason: Incomplete | None = None): ...
def future(fn, *arg): ...
def fails_on(db, reason: Incomplete | None = None): ...
def fails_on_everything_except(*dbs): ...
def skip(db, reason: Incomplete | None = None): ...
def only_on(dbs, reason: Incomplete | None = None): ...
def exclude(db, op, spec, reason: Incomplete | None = None): ...
def against(config, *queries): ...
