from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.math import *
from OCC.Core.Adaptor3d import *
from OCC.Core.Adaptor2d import *
from OCC.Core.Geom2d import *
from OCC.Core.gp import *
from OCC.Core.GeomAbs import *
from OCC.Core.TColStd import *
from OCC.Core.Geom import *
from OCC.Core.GeomAdaptor import *

#the following typedef cannot be wrapped as is
Extrema_Array2OfPOnCurv = NewType('Extrema_Array2OfPOnCurv', Any)
#the following typedef cannot be wrapped as is
Extrema_Array2OfPOnCurv2d = NewType('Extrema_Array2OfPOnCurv2d', Any)
#the following typedef cannot be wrapped as is
Extrema_Array2OfPOnSurf = NewType('Extrema_Array2OfPOnSurf', Any)
#the following typedef cannot be wrapped as is
Extrema_Array2OfPOnSurfParams = NewType('Extrema_Array2OfPOnSurfParams', Any)
#the following typedef cannot be wrapped as is
Extrema_HUBTreeOfSphere = NewType('Extrema_HUBTreeOfSphere', Any)
#the following typedef cannot be wrapped as is
Extrema_UBTreeFillerOfSphere = NewType('Extrema_UBTreeFillerOfSphere', Any)
#the following typedef cannot be wrapped as is
Extrema_UBTreeOfSphere = NewType('Extrema_UBTreeOfSphere', Any)

class Extrema_Array1OfPOnCurv:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> Extrema_POnCurv: ...
    def __setitem__(self, index: int, value: Extrema_POnCurv) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Extrema_POnCurv]: ...
    def next(self) -> Extrema_POnCurv: ...
    __next__ = next
    def Init(self, theValue: Extrema_POnCurv) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> Extrema_POnCurv: ...
    def Last(self) -> Extrema_POnCurv: ...
    def Value(self, theIndex: int) -> Extrema_POnCurv: ...
    def SetValue(self, theIndex: int, theValue: Extrema_POnCurv) -> None: ...

class Extrema_Array1OfPOnCurv2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> Extrema_POnCurv2d: ...
    def __setitem__(self, index: int, value: Extrema_POnCurv2d) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Extrema_POnCurv2d]: ...
    def next(self) -> Extrema_POnCurv2d: ...
    __next__ = next
    def Init(self, theValue: Extrema_POnCurv2d) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> Extrema_POnCurv2d: ...
    def Last(self) -> Extrema_POnCurv2d: ...
    def Value(self, theIndex: int) -> Extrema_POnCurv2d: ...
    def SetValue(self, theIndex: int, theValue: Extrema_POnCurv2d) -> None: ...

class Extrema_Array1OfPOnSurf:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> Extrema_POnSurf: ...
    def __setitem__(self, index: int, value: Extrema_POnSurf) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Extrema_POnSurf]: ...
    def next(self) -> Extrema_POnSurf: ...
    __next__ = next
    def Init(self, theValue: Extrema_POnSurf) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> Extrema_POnSurf: ...
    def Last(self) -> Extrema_POnSurf: ...
    def Value(self, theIndex: int) -> Extrema_POnSurf: ...
    def SetValue(self, theIndex: int, theValue: Extrema_POnSurf) -> None: ...

class Extrema_SequenceOfPOnCurv:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> Extrema_POnCurv: ...
    def Last(self) -> Extrema_POnCurv: ...
    def Length(self) -> int: ...
    def Append(self, theItem: Extrema_POnCurv) -> Extrema_POnCurv: ...
    def Prepend(self, theItem: Extrema_POnCurv) -> Extrema_POnCurv: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> Extrema_POnCurv: ...
    def SetValue(self, theIndex: int, theValue: Extrema_POnCurv) -> None: ...

class Extrema_SequenceOfPOnCurv2d:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> Extrema_POnCurv2d: ...
    def Last(self) -> Extrema_POnCurv2d: ...
    def Length(self) -> int: ...
    def Append(self, theItem: Extrema_POnCurv2d) -> Extrema_POnCurv2d: ...
    def Prepend(self, theItem: Extrema_POnCurv2d) -> Extrema_POnCurv2d: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> Extrema_POnCurv2d: ...
    def SetValue(self, theIndex: int, theValue: Extrema_POnCurv2d) -> None: ...

class Extrema_SequenceOfPOnSurf:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> Extrema_POnSurf: ...
    def Last(self) -> Extrema_POnSurf: ...
    def Length(self) -> int: ...
    def Append(self, theItem: Extrema_POnSurf) -> Extrema_POnSurf: ...
    def Prepend(self, theItem: Extrema_POnSurf) -> Extrema_POnSurf: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> Extrema_POnSurf: ...
    def SetValue(self, theIndex: int, theValue: Extrema_POnSurf) -> None: ...

class Extrema_ExtAlgo(IntEnum):
    Extrema_ExtAlgo_Grad: int = ...
    Extrema_ExtAlgo_Tree: int = ...

Extrema_ExtAlgo_Grad = Extrema_ExtAlgo.Extrema_ExtAlgo_Grad
Extrema_ExtAlgo_Tree = Extrema_ExtAlgo.Extrema_ExtAlgo_Tree

class Extrema_ExtFlag(IntEnum):
    Extrema_ExtFlag_MIN: int = ...
    Extrema_ExtFlag_MAX: int = ...
    Extrema_ExtFlag_MINMAX: int = ...

Extrema_ExtFlag_MIN = Extrema_ExtFlag.Extrema_ExtFlag_MIN
Extrema_ExtFlag_MAX = Extrema_ExtFlag.Extrema_ExtFlag_MAX
Extrema_ExtFlag_MINMAX = Extrema_ExtFlag.Extrema_ExtFlag_MINMAX

class Extrema_ElementType(IntEnum):
    Extrema_Node: int = ...
    Extrema_UIsoEdge: int = ...
    Extrema_VIsoEdge: int = ...
    Extrema_Face: int = ...

Extrema_Node = Extrema_ElementType.Extrema_Node
Extrema_UIsoEdge = Extrema_ElementType.Extrema_UIsoEdge
Extrema_VIsoEdge = Extrema_ElementType.Extrema_VIsoEdge
Extrema_Face = Extrema_ElementType.Extrema_Face

class Extrema_CCLocFOfLocECC(math_FunctionSetWithDerivatives):
    @overload
    def __init__(self, thetol: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve, thetol: Optional[float] = 1.0e-10) -> None: ...
    def CurvePtr(self, theRank: int) -> None: ...
    def Derivatives(self, UV: math_Vector, DF: math_Matrix) -> bool: ...
    def GetStateNumber(self) -> int: ...
    def NbEquations(self) -> int: ...
    def NbExt(self) -> int: ...
    def NbVariables(self) -> int: ...
    def Points(self, N: int, P1: Extrema_POnCurv, P2: Extrema_POnCurv) -> None: ...
    def SearchOfTolerance(self, C: None) -> float: ...
    def SetCurve(self, theRank: int, C1: Adaptor3d_Curve) -> None: ...
    def SetTolerance(self, theTol: float) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def SubIntervalInitialize(self, theUfirst: math_Vector, theUlast: math_Vector) -> None: ...
    def Tolerance(self) -> float: ...
    def Value(self, UV: math_Vector, F: math_Vector) -> bool: ...
    def Values(self, UV: math_Vector, F: math_Vector, DF: math_Matrix) -> bool: ...

class Extrema_CCLocFOfLocECC2d(math_FunctionSetWithDerivatives):
    @overload
    def __init__(self, thetol: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d, thetol: Optional[float] = 1.0e-10) -> None: ...
    def CurvePtr(self, theRank: int) -> None: ...
    def Derivatives(self, UV: math_Vector, DF: math_Matrix) -> bool: ...
    def GetStateNumber(self) -> int: ...
    def NbEquations(self) -> int: ...
    def NbExt(self) -> int: ...
    def NbVariables(self) -> int: ...
    def Points(self, N: int, P1: Extrema_POnCurv2d, P2: Extrema_POnCurv2d) -> None: ...
    def SearchOfTolerance(self, C: None) -> float: ...
    def SetCurve(self, theRank: int, C1: Adaptor2d_Curve2d) -> None: ...
    def SetTolerance(self, theTol: float) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def SubIntervalInitialize(self, theUfirst: math_Vector, theUlast: math_Vector) -> None: ...
    def Tolerance(self) -> float: ...
    def Value(self, UV: math_Vector, F: math_Vector) -> bool: ...
    def Values(self, UV: math_Vector, F: math_Vector, DF: math_Matrix) -> bool: ...

class Extrema_Curve2dTool:
    @staticmethod
    def BSpline(C: Adaptor2d_Curve2d) -> Geom2d_BSplineCurve: ...
    @staticmethod
    def Bezier(C: Adaptor2d_Curve2d) -> Geom2d_BezierCurve: ...
    @staticmethod
    def Circle(C: Adaptor2d_Curve2d) -> gp_Circ2d: ...
    @staticmethod
    def Continuity(C: Adaptor2d_Curve2d) -> GeomAbs_Shape: ...
    @staticmethod
    def D0(C: Adaptor2d_Curve2d, U: float, P: gp_Pnt2d) -> None: ...
    @staticmethod
    def D1(C: Adaptor2d_Curve2d, U: float, P: gp_Pnt2d, V: gp_Vec2d) -> None: ...
    @staticmethod
    def D2(C: Adaptor2d_Curve2d, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
    @staticmethod
    def D3(C: Adaptor2d_Curve2d, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
    @staticmethod
    def DN(C: Adaptor2d_Curve2d, U: float, N: int) -> gp_Vec2d: ...
    @staticmethod
    def DeflCurvIntervals(C: Adaptor2d_Curve2d) -> TColStd_HArray1OfReal: ...
    @staticmethod
    def Degree(C: Adaptor2d_Curve2d) -> int: ...
    @staticmethod
    def Ellipse(C: Adaptor2d_Curve2d) -> gp_Elips2d: ...
    @staticmethod
    def FirstParameter(C: Adaptor2d_Curve2d) -> float: ...
    @staticmethod
    def GetType(C: Adaptor2d_Curve2d) -> GeomAbs_CurveType: ...
    @staticmethod
    def Hyperbola(C: Adaptor2d_Curve2d) -> gp_Hypr2d: ...
    @staticmethod
    def Intervals(C: Adaptor2d_Curve2d, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    @staticmethod
    def IsClosed(C: Adaptor2d_Curve2d) -> bool: ...
    @staticmethod
    def IsPeriodic(C: Adaptor2d_Curve2d) -> bool: ...
    @staticmethod
    def IsRational(C: Adaptor2d_Curve2d) -> bool: ...
    @staticmethod
    def LastParameter(C: Adaptor2d_Curve2d) -> float: ...
    @staticmethod
    def Line(C: Adaptor2d_Curve2d) -> gp_Lin2d: ...
    @staticmethod
    def NbIntervals(C: Adaptor2d_Curve2d, S: GeomAbs_Shape) -> int: ...
    @staticmethod
    def NbKnots(C: Adaptor2d_Curve2d) -> int: ...
    @staticmethod
    def NbPoles(C: Adaptor2d_Curve2d) -> int: ...
    @staticmethod
    def Parabola(C: Adaptor2d_Curve2d) -> gp_Parab2d: ...
    @staticmethod
    def Period(C: Adaptor2d_Curve2d) -> float: ...
    @staticmethod
    def Resolution(C: Adaptor2d_Curve2d, R3d: float) -> float: ...
    @staticmethod
    def Value(C: Adaptor2d_Curve2d, U: float) -> gp_Pnt2d: ...

class Extrema_CurveTool:
    @staticmethod
    def BSpline(C: Adaptor3d_Curve) -> Geom_BSplineCurve: ...
    @staticmethod
    def Bezier(C: Adaptor3d_Curve) -> Geom_BezierCurve: ...
    @staticmethod
    def Circle(C: Adaptor3d_Curve) -> gp_Circ: ...
    @staticmethod
    def Continuity(C: Adaptor3d_Curve) -> GeomAbs_Shape: ...
    @staticmethod
    def D0(C: Adaptor3d_Curve, U: float, P: gp_Pnt) -> None: ...
    @staticmethod
    def D1(C: Adaptor3d_Curve, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
    @staticmethod
    def D2(C: Adaptor3d_Curve, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
    @staticmethod
    def D3(C: Adaptor3d_Curve, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
    @staticmethod
    def DN(C: Adaptor3d_Curve, U: float, N: int) -> gp_Vec: ...
    @staticmethod
    def DeflCurvIntervals(C: Adaptor3d_Curve) -> TColStd_HArray1OfReal: ...
    @staticmethod
    def Degree(C: Adaptor3d_Curve) -> int: ...
    @staticmethod
    def Ellipse(C: Adaptor3d_Curve) -> gp_Elips: ...
    @staticmethod
    def FirstParameter(C: Adaptor3d_Curve) -> float: ...
    @staticmethod
    def GetType(C: Adaptor3d_Curve) -> GeomAbs_CurveType: ...
    @staticmethod
    def Hyperbola(C: Adaptor3d_Curve) -> gp_Hypr: ...
    @staticmethod
    def Intervals(C: Adaptor3d_Curve, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    @staticmethod
    def IsPeriodic(C: Adaptor3d_Curve) -> bool: ...
    @staticmethod
    def IsRational(C: Adaptor3d_Curve) -> bool: ...
    @staticmethod
    def LastParameter(C: Adaptor3d_Curve) -> float: ...
    @staticmethod
    def Line(C: Adaptor3d_Curve) -> gp_Lin: ...
    @staticmethod
    def NbIntervals(C: Adaptor3d_Curve, S: GeomAbs_Shape) -> int: ...
    @staticmethod
    def NbKnots(C: Adaptor3d_Curve) -> int: ...
    @staticmethod
    def NbPoles(C: Adaptor3d_Curve) -> int: ...
    @staticmethod
    def Parabola(C: Adaptor3d_Curve) -> gp_Parab: ...
    @staticmethod
    def Period(C: Adaptor3d_Curve) -> float: ...
    @staticmethod
    def Resolution(C: Adaptor3d_Curve, R3d: float) -> float: ...
    @staticmethod
    def Value(C: Adaptor3d_Curve, U: float) -> gp_Pnt: ...

class Extrema_ECC:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve) -> None: ...
    @overload
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve, Uinf: float, Usup: float, Vinf: float, Vsup: float) -> None: ...
    def GetSingleSolutionFlag(self) -> bool: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self) -> None: ...
    def Points(self, N: int, P1: Extrema_POnCurv, P2: Extrema_POnCurv) -> None: ...
    def SetParams(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve, Uinf: float, Usup: float, Vinf: float, Vsup: float) -> None: ...
    def SetSingleSolutionFlag(self, theSingleSolutionFlag: bool) -> None: ...
    def SetTolerance(self, Tol: float) -> None: ...
    def SquareDistance(self, N: Optional[int] = 1) -> float: ...

class Extrema_ECC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d) -> None: ...
    @overload
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d, Uinf: float, Usup: float, Vinf: float, Vsup: float) -> None: ...
    def GetSingleSolutionFlag(self) -> bool: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self) -> None: ...
    def Points(self, N: int, P1: Extrema_POnCurv2d, P2: Extrema_POnCurv2d) -> None: ...
    def SetParams(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d, Uinf: float, Usup: float, Vinf: float, Vsup: float) -> None: ...
    def SetSingleSolutionFlag(self, theSingleSolutionFlag: bool) -> None: ...
    def SetTolerance(self, Tol: float) -> None: ...
    def SquareDistance(self, N: Optional[int] = 1) -> float: ...

class Extrema_ELPCOfLocateExtPC:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, Uinf: float, Usup: float, TolF: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, TolF: Optional[float] = 1.0e-10) -> None: ...
    def Initialize(self, C: Adaptor3d_Curve, Uinf: float, Usup: float, TolF: Optional[float] = 1.0e-10) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv: ...
    def SquareDistance(self, N: int) -> float: ...
    def TrimmedSquareDistances(self, P1: gp_Pnt, P2: gp_Pnt) -> Tuple[float, float]: ...

class Extrema_ELPCOfLocateExtPC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, Uinf: float, Usup: float, TolF: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, TolF: Optional[float] = 1.0e-10) -> None: ...
    def Initialize(self, C: Adaptor2d_Curve2d, Uinf: float, Usup: float, TolF: Optional[float] = 1.0e-10) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt2d) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv2d: ...
    def SquareDistance(self, N: int) -> float: ...
    def TrimmedSquareDistances(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> Tuple[float, float]: ...

class Extrema_EPCOfELPCOfLocateExtPC:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, NbU: int, TolU: float, TolF: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor3d_Curve, NbU: int, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor3d_Curve, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor3d_Curve) -> None: ...
    @overload
    def Initialize(self, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_EPCOfELPCOfLocateExtPC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, NbU: int, TolU: float, TolF: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor2d_Curve2d, NbU: int, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor2d_Curve2d, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor2d_Curve2d) -> None: ...
    @overload
    def Initialize(self, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt2d) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv2d: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_EPCOfExtPC:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, NbU: int, TolU: float, TolF: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor3d_Curve, NbU: int, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor3d_Curve, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor3d_Curve) -> None: ...
    @overload
    def Initialize(self, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_EPCOfExtPC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, NbU: int, TolU: float, TolF: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor2d_Curve2d, NbU: int, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor2d_Curve2d, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    @overload
    def Initialize(self, C: Adaptor2d_Curve2d) -> None: ...
    @overload
    def Initialize(self, NbU: int, Umin: float, Usup: float, TolU: float, TolF: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt2d) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv2d: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_ExtCC:
    @overload
    def __init__(self, TolC1: Optional[float] = 1.0e-10, TolC2: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve, TolC1: Optional[float] = 1.0e-10, TolC2: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve, U1: float, U2: float, V1: float, V2: float, TolC1: Optional[float] = 1.0e-10, TolC2: Optional[float] = 1.0e-10) -> None: ...
    def GetSingleSolutionFlag(self) -> bool: ...
    @overload
    def Initialize(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve, TolC1: Optional[float] = 1.0e-10, TolC2: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def Initialize(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve, U1: float, U2: float, V1: float, V2: float, TolC1: Optional[float] = 1.0e-10, TolC2: Optional[float] = 1.0e-10) -> None: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self) -> None: ...
    def Points(self, N: int, P1: Extrema_POnCurv, P2: Extrema_POnCurv) -> None: ...
    @overload
    def SetCurve(self, theRank: int, C: Adaptor3d_Curve) -> None: ...
    @overload
    def SetCurve(self, theRank: int, C: Adaptor3d_Curve, Uinf: float, Usup: float) -> None: ...
    def SetRange(self, theRank: int, Uinf: float, Usup: float) -> None: ...
    def SetSingleSolutionFlag(self, theSingleSolutionFlag: bool) -> None: ...
    def SetTolerance(self, theRank: int, Tol: float) -> None: ...
    def SquareDistance(self, N: Optional[int] = 1) -> float: ...
    def TrimmedSquareDistances(self, P11: gp_Pnt, P12: gp_Pnt, P21: gp_Pnt, P22: gp_Pnt) -> Tuple[float, float, float, float]: ...

class Extrema_ExtCC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d, TolC1: Optional[float] = 1.0e-10, TolC2: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d, U1: float, U2: float, V1: float, V2: float, TolC1: Optional[float] = 1.0e-10, TolC2: Optional[float] = 1.0e-10) -> None: ...
    def GetSingleSolutionFlag(self) -> bool: ...
    def Initialize(self, C2: Adaptor2d_Curve2d, V1: float, V2: float, TolC1: Optional[float] = 1.0e-10, TolC2: Optional[float] = 1.0e-10) -> None: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, C1: Adaptor2d_Curve2d, U1: float, U2: float) -> None: ...
    def Points(self, N: int, P1: Extrema_POnCurv2d, P2: Extrema_POnCurv2d) -> None: ...
    def SetSingleSolutionFlag(self, theSingleSolutionFlag: bool) -> None: ...
    def SquareDistance(self, N: Optional[int] = 1) -> float: ...
    def TrimmedSquareDistances(self, P11: gp_Pnt2d, P12: gp_Pnt2d, P21: gp_Pnt2d, P22: gp_Pnt2d) -> Tuple[float, float, float, float]: ...

class Extrema_ExtCS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface, TolC: float, TolS: float) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface, UCinf: float, UCsup: float, Uinf: float, Usup: float, Vinf: float, Vsup: float, TolC: float, TolS: float) -> None: ...
    @overload
    def Initialize(self, S: Adaptor3d_Surface, TolC: float, TolS: float) -> None: ...
    @overload
    def Initialize(self, S: Adaptor3d_Surface, Uinf: float, Usup: float, Vinf: float, Vsup: float, TolC: float, TolS: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, C: Adaptor3d_Curve, Uinf: float, Usup: float) -> None: ...
    def Points(self, N: int, P1: Extrema_POnCurv, P2: Extrema_POnSurf) -> None: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_ExtElC:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin, C2: gp_Lin, AngTol: float) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin, C2: gp_Circ, Tol: float) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin, C2: gp_Elips) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin, C2: gp_Hypr) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin, C2: gp_Parab) -> None: ...
    @overload
    def __init__(self, C1: gp_Circ, C2: gp_Circ) -> None: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Points(self, N: int, P1: Extrema_POnCurv, P2: Extrema_POnCurv) -> None: ...
    def SquareDistance(self, N: Optional[int] = 1) -> float: ...

class Extrema_ExtElC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin2d, C2: gp_Lin2d, AngTol: float) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin2d, C2: gp_Circ2d, Tol: float) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin2d, C2: gp_Elips2d) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin2d, C2: gp_Hypr2d) -> None: ...
    @overload
    def __init__(self, C1: gp_Lin2d, C2: gp_Parab2d) -> None: ...
    @overload
    def __init__(self, C1: gp_Circ2d, C2: gp_Circ2d) -> None: ...
    @overload
    def __init__(self, C1: gp_Circ2d, C2: gp_Elips2d) -> None: ...
    @overload
    def __init__(self, C1: gp_Circ2d, C2: gp_Hypr2d) -> None: ...
    @overload
    def __init__(self, C1: gp_Circ2d, C2: gp_Parab2d) -> None: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Points(self, N: int, P1: Extrema_POnCurv2d, P2: Extrema_POnCurv2d) -> None: ...
    def SquareDistance(self, N: Optional[int] = 1) -> float: ...

class Extrema_ExtElCS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C: gp_Lin, S: gp_Pln) -> None: ...
    @overload
    def __init__(self, C: gp_Lin, S: gp_Cylinder) -> None: ...
    @overload
    def __init__(self, C: gp_Lin, S: gp_Cone) -> None: ...
    @overload
    def __init__(self, C: gp_Lin, S: gp_Sphere) -> None: ...
    @overload
    def __init__(self, C: gp_Lin, S: gp_Torus) -> None: ...
    @overload
    def __init__(self, C: gp_Circ, S: gp_Pln) -> None: ...
    @overload
    def __init__(self, C: gp_Circ, S: gp_Cylinder) -> None: ...
    @overload
    def __init__(self, C: gp_Circ, S: gp_Cone) -> None: ...
    @overload
    def __init__(self, C: gp_Circ, S: gp_Sphere) -> None: ...
    @overload
    def __init__(self, C: gp_Circ, S: gp_Torus) -> None: ...
    @overload
    def __init__(self, C: gp_Hypr, S: gp_Pln) -> None: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    @overload
    def Perform(self, C: gp_Lin, S: gp_Pln) -> None: ...
    @overload
    def Perform(self, C: gp_Lin, S: gp_Cylinder) -> None: ...
    @overload
    def Perform(self, C: gp_Lin, S: gp_Cone) -> None: ...
    @overload
    def Perform(self, C: gp_Lin, S: gp_Sphere) -> None: ...
    @overload
    def Perform(self, C: gp_Lin, S: gp_Torus) -> None: ...
    @overload
    def Perform(self, C: gp_Circ, S: gp_Pln) -> None: ...
    @overload
    def Perform(self, C: gp_Circ, S: gp_Cylinder) -> None: ...
    @overload
    def Perform(self, C: gp_Circ, S: gp_Cone) -> None: ...
    @overload
    def Perform(self, C: gp_Circ, S: gp_Sphere) -> None: ...
    @overload
    def Perform(self, C: gp_Circ, S: gp_Torus) -> None: ...
    @overload
    def Perform(self, C: gp_Hypr, S: gp_Pln) -> None: ...
    def Points(self, N: int, P1: Extrema_POnCurv, P2: Extrema_POnSurf) -> None: ...
    def SquareDistance(self, N: Optional[int] = 1) -> float: ...

class Extrema_ExtElSS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S1: gp_Pln, S2: gp_Pln) -> None: ...
    @overload
    def __init__(self, S1: gp_Pln, S2: gp_Sphere) -> None: ...
    @overload
    def __init__(self, S1: gp_Sphere, S2: gp_Sphere) -> None: ...
    @overload
    def __init__(self, S1: gp_Sphere, S2: gp_Cylinder) -> None: ...
    @overload
    def __init__(self, S1: gp_Sphere, S2: gp_Cone) -> None: ...
    @overload
    def __init__(self, S1: gp_Sphere, S2: gp_Torus) -> None: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    @overload
    def Perform(self, S1: gp_Pln, S2: gp_Pln) -> None: ...
    @overload
    def Perform(self, S1: gp_Pln, S2: gp_Sphere) -> None: ...
    @overload
    def Perform(self, S1: gp_Sphere, S2: gp_Sphere) -> None: ...
    @overload
    def Perform(self, S1: gp_Sphere, S2: gp_Cylinder) -> None: ...
    @overload
    def Perform(self, S1: gp_Sphere, S2: gp_Cone) -> None: ...
    @overload
    def Perform(self, S1: gp_Sphere, S2: gp_Torus) -> None: ...
    def Points(self, N: int, P1: Extrema_POnSurf, P2: Extrema_POnSurf) -> None: ...
    def SquareDistance(self, N: Optional[int] = 1) -> float: ...

class Extrema_ExtPC:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, Uinf: float, Usup: float, TolF: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, TolF: Optional[float] = 1.0e-10) -> None: ...
    def Initialize(self, C: Adaptor3d_Curve, Uinf: float, Usup: float, TolF: Optional[float] = 1.0e-10) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv: ...
    def SquareDistance(self, N: int) -> float: ...
    def TrimmedSquareDistances(self, P1: gp_Pnt, P2: gp_Pnt) -> Tuple[float, float]: ...

class Extrema_ExtPC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, Uinf: float, Usup: float, TolF: Optional[float] = 1.0e-10) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, TolF: Optional[float] = 1.0e-10) -> None: ...
    def Initialize(self, C: Adaptor2d_Curve2d, Uinf: float, Usup: float, TolF: Optional[float] = 1.0e-10) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt2d) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv2d: ...
    def SquareDistance(self, N: int) -> float: ...
    def TrimmedSquareDistances(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> Tuple[float, float]: ...

class Extrema_ExtPElC:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: gp_Lin, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: gp_Circ, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: gp_Elips, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: gp_Hypr, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: gp_Parab, Tol: float, Uinf: float, Usup: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    @overload
    def Perform(self, P: gp_Pnt, C: gp_Lin, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt, C: gp_Circ, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt, C: gp_Elips, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt, C: gp_Hypr, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt, C: gp_Parab, Tol: float, Uinf: float, Usup: float) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_ExtPElC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: gp_Lin2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: gp_Circ2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: gp_Elips2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: gp_Hypr2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: gp_Parab2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    @overload
    def Perform(self, P: gp_Pnt2d, L: gp_Lin2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt2d, C: gp_Circ2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt2d, C: gp_Elips2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt2d, C: gp_Hypr2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt2d, C: gp_Parab2d, Tol: float, Uinf: float, Usup: float) -> None: ...
    def Point(self, N: int) -> Extrema_POnCurv2d: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_ExtPElS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: gp_Cylinder, Tol: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: gp_Pln, Tol: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: gp_Cone, Tol: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: gp_Torus, Tol: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: gp_Sphere, Tol: float) -> None: ...
    def IsDone(self) -> bool: ...
    def NbExt(self) -> int: ...
    @overload
    def Perform(self, P: gp_Pnt, S: gp_Cylinder, Tol: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt, S: gp_Pln, Tol: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt, S: gp_Cone, Tol: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt, S: gp_Torus, Tol: float) -> None: ...
    @overload
    def Perform(self, P: gp_Pnt, S: gp_Sphere, Tol: float) -> None: ...
    def Point(self, N: int) -> Extrema_POnSurf: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_ExtPExtS(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: GeomAdaptor_SurfaceOfLinearExtrusion, Umin: float, Usup: float, Vmin: float, Vsup: float, TolU: float, TolV: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: GeomAdaptor_SurfaceOfLinearExtrusion, TolU: float, TolV: float) -> None: ...
    def Initialize(self, S: GeomAdaptor_SurfaceOfLinearExtrusion, Uinf: float, Usup: float, Vinf: float, Vsup: float, TolU: float, TolV: float) -> None: ...
    def IsDone(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt) -> None: ...
    def Point(self, N: int) -> Extrema_POnSurf: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_ExtPRevS(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: GeomAdaptor_SurfaceOfRevolution, Umin: float, Usup: float, Vmin: float, Vsup: float, TolU: float, TolV: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: GeomAdaptor_SurfaceOfRevolution, TolU: float, TolV: float) -> None: ...
    def Initialize(self, S: GeomAdaptor_SurfaceOfRevolution, Umin: float, Usup: float, Vmin: float, Vsup: float, TolU: float, TolV: float) -> None: ...
    def IsDone(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt) -> None: ...
    def Point(self, N: int) -> Extrema_POnSurf: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_ExtPS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: Adaptor3d_Surface, TolU: float, TolV: float, F: Optional[Extrema_ExtFlag] = Extrema_ExtFlag_MINMAX, A: Optional[Extrema_ExtAlgo] = Extrema_ExtAlgo_Grad) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: Adaptor3d_Surface, Uinf: float, Usup: float, Vinf: float, Vsup: float, TolU: float, TolV: float, F: Optional[Extrema_ExtFlag] = Extrema_ExtFlag_MINMAX, A: Optional[Extrema_ExtAlgo] = Extrema_ExtAlgo_Grad) -> None: ...
    def Initialize(self, S: Adaptor3d_Surface, Uinf: float, Usup: float, Vinf: float, Vsup: float, TolU: float, TolV: float) -> None: ...
    def IsDone(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt) -> None: ...
    def Point(self, N: int) -> Extrema_POnSurf: ...
    def SetAlgo(self, A: Extrema_ExtAlgo) -> None: ...
    def SetFlag(self, F: Extrema_ExtFlag) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def TrimmedSquareDistances(self, PUfVf: gp_Pnt, PUfVl: gp_Pnt, PUlVf: gp_Pnt, PUlVl: gp_Pnt) -> Tuple[float, float, float, float]: ...

class Extrema_ExtSS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S1: Adaptor3d_Surface, S2: Adaptor3d_Surface, TolS1: float, TolS2: float) -> None: ...
    @overload
    def __init__(self, S1: Adaptor3d_Surface, S2: Adaptor3d_Surface, Uinf1: float, Usup1: float, Vinf1: float, Vsup1: float, Uinf2: float, Usup2: float, Vinf2: float, Vsup2: float, TolS1: float, TolS2: float) -> None: ...
    def Initialize(self, S2: Adaptor3d_Surface, Uinf2: float, Usup2: float, Vinf2: float, Vsup2: float, TolS1: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsParallel(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, S1: Adaptor3d_Surface, Uinf1: float, Usup1: float, Vinf1: float, Vsup1: float, TolS1: float) -> None: ...
    def Points(self, N: int, P1: Extrema_POnSurf, P2: Extrema_POnSurf) -> None: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_FuncExtCS(math_FunctionSetWithDerivatives):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface) -> None: ...
    def Derivatives(self, UV: math_Vector, DF: math_Matrix) -> bool: ...
    def GetStateNumber(self) -> int: ...
    def Initialize(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface) -> None: ...
    def NbEquations(self) -> int: ...
    def NbExt(self) -> int: ...
    def NbVariables(self) -> int: ...
    def PointOnCurve(self, N: int) -> Extrema_POnCurv: ...
    def PointOnSurface(self, N: int) -> Extrema_POnSurf: ...
    def PointsOnCurve(self) -> Extrema_SequenceOfPOnCurv: ...
    def PointsOnSurf(self) -> Extrema_SequenceOfPOnSurf: ...
    def SquareDistance(self, N: int) -> float: ...
    def SquareDistances(self) -> TColStd_SequenceOfReal: ...
    def Value(self, UV: math_Vector, F: math_Vector) -> bool: ...
    def Values(self, UV: math_Vector, F: math_Vector, DF: math_Matrix) -> bool: ...

class Extrema_FuncExtSS(math_FunctionSetWithDerivatives):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S1: Adaptor3d_Surface, S2: Adaptor3d_Surface) -> None: ...
    def Derivatives(self, UV: math_Vector, DF: math_Matrix) -> bool: ...
    def GetStateNumber(self) -> int: ...
    def Initialize(self, S1: Adaptor3d_Surface, S2: Adaptor3d_Surface) -> None: ...
    def NbEquations(self) -> int: ...
    def NbExt(self) -> int: ...
    def NbVariables(self) -> int: ...
    def PointOnS1(self, N: int) -> Extrema_POnSurf: ...
    def PointOnS2(self, N: int) -> Extrema_POnSurf: ...
    def SquareDistance(self, N: int) -> float: ...
    def Value(self, UV: math_Vector, F: math_Vector) -> bool: ...
    def Values(self, UV: math_Vector, F: math_Vector, DF: math_Matrix) -> bool: ...

class Extrema_FuncPSDist(math_MultipleVarFunctionWithGradient):
    def __init__(self, theS: Adaptor3d_Surface, theP: gp_Pnt) -> None: ...
    def Gradient(self, X: math_Vector, G: math_Vector) -> bool: ...
    def NbVariables(self) -> int: ...
    def Value(self, X: math_Vector) -> Tuple[bool, float]: ...
    def Values(self, X: math_Vector, G: math_Vector) -> Tuple[bool, float]: ...

class Extrema_FuncPSNorm(math_FunctionSetWithDerivatives):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: Adaptor3d_Surface) -> None: ...
    def Derivatives(self, UV: math_Vector, DF: math_Matrix) -> bool: ...
    def GetStateNumber(self) -> int: ...
    def Initialize(self, S: Adaptor3d_Surface) -> None: ...
    def NbEquations(self) -> int: ...
    def NbExt(self) -> int: ...
    def NbVariables(self) -> int: ...
    def Point(self, N: int) -> Extrema_POnSurf: ...
    def SetPoint(self, P: gp_Pnt) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def Value(self, UV: math_Vector, F: math_Vector) -> bool: ...
    def Values(self, UV: math_Vector, F: math_Vector, DF: math_Matrix) -> bool: ...

class Extrema_GenExtCS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface, NbT: int, NbU: int, NbV: int, Tol1: float, Tol2: float) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface, NbT: int, NbU: int, NbV: int, tmin: float, tsup: float, Umin: float, Usup: float, Vmin: float, Vsup: float, Tol1: float, Tol2: float) -> None: ...
    @overload
    def Initialize(self, S: Adaptor3d_Surface, NbU: int, NbV: int, Tol2: float) -> None: ...
    @overload
    def Initialize(self, S: Adaptor3d_Surface, NbU: int, NbV: int, Umin: float, Usup: float, Vmin: float, Vsup: float, Tol2: float) -> None: ...
    def IsDone(self) -> bool: ...
    def NbExt(self) -> int: ...
    @overload
    def Perform(self, C: Adaptor3d_Curve, NbT: int, Tol1: float) -> None: ...
    @overload
    def Perform(self, C: Adaptor3d_Curve, NbT: int, tmin: float, tsup: float, Tol1: float) -> None: ...
    def PointOnCurve(self, N: int) -> Extrema_POnCurv: ...
    def PointOnSurface(self, N: int) -> Extrema_POnSurf: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_GenExtPS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: Adaptor3d_Surface, NbU: int, NbV: int, TolU: float, TolV: float, F: Optional[Extrema_ExtFlag] = Extrema_ExtFlag_MINMAX, A: Optional[Extrema_ExtAlgo] = Extrema_ExtAlgo_Grad) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, S: Adaptor3d_Surface, NbU: int, NbV: int, Umin: float, Usup: float, Vmin: float, Vsup: float, TolU: float, TolV: float, F: Optional[Extrema_ExtFlag] = Extrema_ExtFlag_MINMAX, A: Optional[Extrema_ExtAlgo] = Extrema_ExtAlgo_Grad) -> None: ...
    @overload
    def Initialize(self, S: Adaptor3d_Surface, NbU: int, NbV: int, TolU: float, TolV: float) -> None: ...
    @overload
    def Initialize(self, S: Adaptor3d_Surface, NbU: int, NbV: int, Umin: float, Usup: float, Vmin: float, Vsup: float, TolU: float, TolV: float) -> None: ...
    def IsDone(self) -> bool: ...
    def NbExt(self) -> int: ...
    def Perform(self, P: gp_Pnt) -> None: ...
    def Point(self, N: int) -> Extrema_POnSurf: ...
    def SetAlgo(self, A: Extrema_ExtAlgo) -> None: ...
    def SetFlag(self, F: Extrema_ExtFlag) -> None: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_GenExtSS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S1: Adaptor3d_Surface, S2: Adaptor3d_Surface, NbU: int, NbV: int, Tol1: float, Tol2: float) -> None: ...
    @overload
    def __init__(self, S1: Adaptor3d_Surface, S2: Adaptor3d_Surface, NbU: int, NbV: int, U1min: float, U1sup: float, V1min: float, V1sup: float, U2min: float, U2sup: float, V2min: float, V2sup: float, Tol1: float, Tol2: float) -> None: ...
    @overload
    def Initialize(self, S2: Adaptor3d_Surface, NbU: int, NbV: int, Tol2: float) -> None: ...
    @overload
    def Initialize(self, S2: Adaptor3d_Surface, NbU: int, NbV: int, U2min: float, U2sup: float, V2min: float, V2sup: float, Tol2: float) -> None: ...
    def IsDone(self) -> bool: ...
    def NbExt(self) -> int: ...
    @overload
    def Perform(self, S1: Adaptor3d_Surface, Tol1: float) -> None: ...
    @overload
    def Perform(self, S1: Adaptor3d_Surface, U1min: float, U1sup: float, V1min: float, V1sup: float, Tol1: float) -> None: ...
    def PointOnS1(self, N: int) -> Extrema_POnSurf: ...
    def PointOnS2(self, N: int) -> Extrema_POnSurf: ...
    def SquareDistance(self, N: int) -> float: ...

class Extrema_GenLocateExtCS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface, T: float, U: float, V: float, Tol1: float, Tol2: float) -> None: ...
    def IsDone(self) -> bool: ...
    def Perform(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface, T: float, U: float, V: float, Tol1: float, Tol2: float) -> None: ...
    def PointOnCurve(self) -> Extrema_POnCurv: ...
    def PointOnSurface(self) -> Extrema_POnSurf: ...
    def SquareDistance(self) -> float: ...

class Extrema_GenLocateExtPS:
    def __init__(self, theS: Adaptor3d_Surface, theTolU: Optional[float] = precision_PConfusion(), theTolV: Optional[float] = precision_PConfusion()) -> None: ...
    def IsDone(self) -> bool: ...
    @staticmethod
    def IsMinDist(theP: gp_Pnt, theS: Adaptor3d_Surface, theU0: float, theV0: float) -> bool: ...
    def Perform(self, theP: gp_Pnt, theU0: float, theV0: float, isDistanceCriteria: Optional[bool] = False) -> None: ...
    def Point(self) -> Extrema_POnSurf: ...
    def SquareDistance(self) -> float: ...

class Extrema_GenLocateExtSS:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S1: Adaptor3d_Surface, S2: Adaptor3d_Surface, U1: float, V1: float, U2: float, V2: float, Tol1: float, Tol2: float) -> None: ...
    def IsDone(self) -> bool: ...
    def Perform(self, S1: Adaptor3d_Surface, S2: Adaptor3d_Surface, U1: float, V1: float, U2: float, V2: float, Tol1: float, Tol2: float) -> None: ...
    def PointOnS1(self) -> Extrema_POnSurf: ...
    def PointOnS2(self) -> Extrema_POnSurf: ...
    def SquareDistance(self) -> float: ...

class Extrema_GlobOptFuncCCC0(math_MultipleVarFunction):
    @overload
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve) -> None: ...
    @overload
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d) -> None: ...
    def NbVariables(self) -> int: ...
    def Value(self, X: math_Vector) -> Tuple[bool, float]: ...

class Extrema_GlobOptFuncCCC1(math_MultipleVarFunctionWithGradient):
    @overload
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve) -> None: ...
    @overload
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d) -> None: ...
    def Gradient(self, X: math_Vector, G: math_Vector) -> bool: ...
    def NbVariables(self) -> int: ...
    def Value(self, X: math_Vector) -> Tuple[bool, float]: ...
    def Values(self, X: math_Vector, G: math_Vector) -> Tuple[bool, float]: ...

class Extrema_GlobOptFuncCCC2(math_MultipleVarFunctionWithHessian):
    @overload
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve) -> None: ...
    @overload
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d) -> None: ...
    def Gradient(self, X: math_Vector, G: math_Vector) -> bool: ...
    def NbVariables(self) -> int: ...
    def Value(self, X: math_Vector) -> Tuple[bool, float]: ...
    @overload
    def Values(self, X: math_Vector, G: math_Vector) -> Tuple[bool, float]: ...
    @overload
    def Values(self, X: math_Vector, G: math_Vector, H: math_Matrix) -> Tuple[bool, float]: ...

class Extrema_GlobOptFuncCQuadric(math_MultipleVarFunction):
    @overload
    def __init__(self, C: Adaptor3d_Curve) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, theTf: float, theTl: float) -> None: ...
    @overload
    def __init__(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface) -> None: ...
    def LoadQuad(self, S: Adaptor3d_Surface, theUf: float, theUl: float, theVf: float, theVl: float) -> None: ...
    def NbVariables(self) -> int: ...
    def QuadricParameters(self, theCT: math_Vector, theUV: math_Vector) -> None: ...
    def Value(self, theX: math_Vector) -> Tuple[bool, float]: ...

class Extrema_GlobOptFuncCS(math_MultipleVarFunctionWithHessian):
    def __init__(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface) -> None: ...
    def Gradient(self, theX: math_Vector, theG: math_Vector) -> bool: ...
    def NbVariables(self) -> int: ...
    def Value(self, theX: math_Vector) -> Tuple[bool, float]: ...
    @overload
    def Values(self, theX: math_Vector, theG: math_Vector) -> Tuple[bool, float]: ...
    @overload
    def Values(self, theX: math_Vector, theG: math_Vector, theH: math_Matrix) -> Tuple[bool, float]: ...

class Extrema_GlobOptFuncConicS(math_MultipleVarFunction):
    @overload
    def __init__(self, C: Adaptor3d_Curve, S: Adaptor3d_Surface) -> None: ...
    @overload
    def __init__(self, S: Adaptor3d_Surface) -> None: ...
    @overload
    def __init__(self, S: Adaptor3d_Surface, theUf: float, theUl: float, theVf: float, theVl: float) -> None: ...
    def ConicParameter(self, theUV: math_Vector) -> float: ...
    def LoadConic(self, S: Adaptor3d_Curve, theTf: float, theTl: float) -> None: ...
    def NbVariables(self) -> int: ...
    def Value(self, theX: math_Vector) -> Tuple[bool, float]: ...

class Extrema_LocECC:
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve, U0: float, V0: float, TolU: float, TolV: float) -> None: ...
    def IsDone(self) -> bool: ...
    def Point(self, P1: Extrema_POnCurv, P2: Extrema_POnCurv) -> None: ...
    def SquareDistance(self) -> float: ...

class Extrema_LocECC2d:
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d, U0: float, V0: float, TolU: float, TolV: float) -> None: ...
    def IsDone(self) -> bool: ...
    def Point(self, P1: Extrema_POnCurv2d, P2: Extrema_POnCurv2d) -> None: ...
    def SquareDistance(self) -> float: ...

class Extrema_LocEPCOfLocateExtPC:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, U0: float, TolU: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, U0: float, Umin: float, Usup: float, TolU: float) -> None: ...
    def Initialize(self, C: Adaptor3d_Curve, Umin: float, Usup: float, TolU: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self) -> bool: ...
    def Perform(self, P: gp_Pnt, U0: float) -> None: ...
    def Point(self) -> Extrema_POnCurv: ...
    def SquareDistance(self) -> float: ...

class Extrema_LocEPCOfLocateExtPC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, U0: float, TolU: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, U0: float, Umin: float, Usup: float, TolU: float) -> None: ...
    def Initialize(self, C: Adaptor2d_Curve2d, Umin: float, Usup: float, TolU: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self) -> bool: ...
    def Perform(self, P: gp_Pnt2d, U0: float) -> None: ...
    def Point(self) -> Extrema_POnCurv2d: ...
    def SquareDistance(self) -> float: ...

class Extrema_LocateExtCC:
    def __init__(self, C1: Adaptor3d_Curve, C2: Adaptor3d_Curve, U0: float, V0: float) -> None: ...
    def IsDone(self) -> bool: ...
    def Point(self, P1: Extrema_POnCurv, P2: Extrema_POnCurv) -> None: ...
    def SquareDistance(self) -> float: ...

class Extrema_LocateExtCC2d:
    def __init__(self, C1: Adaptor2d_Curve2d, C2: Adaptor2d_Curve2d, U0: float, V0: float) -> None: ...
    def IsDone(self) -> bool: ...
    def Point(self, P1: Extrema_POnCurv2d, P2: Extrema_POnCurv2d) -> None: ...
    def SquareDistance(self) -> float: ...

class Extrema_LocateExtPC:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, U0: float, TolF: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve, U0: float, Umin: float, Usup: float, TolF: float) -> None: ...
    def Initialize(self, C: Adaptor3d_Curve, Umin: float, Usup: float, TolF: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self) -> bool: ...
    def Perform(self, P: gp_Pnt, U0: float) -> None: ...
    def Point(self) -> Extrema_POnCurv: ...
    def SquareDistance(self) -> float: ...

class Extrema_LocateExtPC2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, U0: float, TolF: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d, U0: float, Umin: float, Usup: float, TolF: float) -> None: ...
    def Initialize(self, C: Adaptor2d_Curve2d, Umin: float, Usup: float, TolF: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsMin(self) -> bool: ...
    def Perform(self, P: gp_Pnt2d, U0: float) -> None: ...
    def Point(self) -> Extrema_POnCurv2d: ...
    def SquareDistance(self) -> float: ...

class Extrema_PCFOfEPCOfELPCOfLocateExtPC(math_FunctionWithDerivative):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve) -> None: ...
    def Derivative(self, U: float) -> Tuple[bool, float]: ...
    def GetStateNumber(self) -> int: ...
    def Initialize(self, C: Adaptor3d_Curve) -> None: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Point(self, N: int) -> Extrema_POnCurv: ...
    def SearchOfTolerance(self) -> float: ...
    def SetPoint(self, P: gp_Pnt) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def SubIntervalInitialize(self, theUfirst: float, theUlast: float) -> None: ...
    def Value(self, U: float) -> Tuple[bool, float]: ...
    def Values(self, U: float) -> Tuple[bool, float, float]: ...

class Extrema_PCFOfEPCOfELPCOfLocateExtPC2d(math_FunctionWithDerivative):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d) -> None: ...
    def Derivative(self, U: float) -> Tuple[bool, float]: ...
    def GetStateNumber(self) -> int: ...
    def Initialize(self, C: Adaptor2d_Curve2d) -> None: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Point(self, N: int) -> Extrema_POnCurv2d: ...
    def SearchOfTolerance(self) -> float: ...
    def SetPoint(self, P: gp_Pnt2d) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def SubIntervalInitialize(self, theUfirst: float, theUlast: float) -> None: ...
    def Value(self, U: float) -> Tuple[bool, float]: ...
    def Values(self, U: float) -> Tuple[bool, float, float]: ...

class Extrema_PCFOfEPCOfExtPC(math_FunctionWithDerivative):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve) -> None: ...
    def Derivative(self, U: float) -> Tuple[bool, float]: ...
    def GetStateNumber(self) -> int: ...
    def Initialize(self, C: Adaptor3d_Curve) -> None: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Point(self, N: int) -> Extrema_POnCurv: ...
    def SearchOfTolerance(self) -> float: ...
    def SetPoint(self, P: gp_Pnt) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def SubIntervalInitialize(self, theUfirst: float, theUlast: float) -> None: ...
    def Value(self, U: float) -> Tuple[bool, float]: ...
    def Values(self, U: float) -> Tuple[bool, float, float]: ...

class Extrema_PCFOfEPCOfExtPC2d(math_FunctionWithDerivative):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d) -> None: ...
    def Derivative(self, U: float) -> Tuple[bool, float]: ...
    def GetStateNumber(self) -> int: ...
    def Initialize(self, C: Adaptor2d_Curve2d) -> None: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Point(self, N: int) -> Extrema_POnCurv2d: ...
    def SearchOfTolerance(self) -> float: ...
    def SetPoint(self, P: gp_Pnt2d) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def SubIntervalInitialize(self, theUfirst: float, theUlast: float) -> None: ...
    def Value(self, U: float) -> Tuple[bool, float]: ...
    def Values(self, U: float) -> Tuple[bool, float, float]: ...

class Extrema_PCLocFOfLocEPCOfLocateExtPC(math_FunctionWithDerivative):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, C: Adaptor3d_Curve) -> None: ...
    def Derivative(self, U: float) -> Tuple[bool, float]: ...
    def GetStateNumber(self) -> int: ...
    def Initialize(self, C: Adaptor3d_Curve) -> None: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Point(self, N: int) -> Extrema_POnCurv: ...
    def SearchOfTolerance(self) -> float: ...
    def SetPoint(self, P: gp_Pnt) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def SubIntervalInitialize(self, theUfirst: float, theUlast: float) -> None: ...
    def Value(self, U: float) -> Tuple[bool, float]: ...
    def Values(self, U: float) -> Tuple[bool, float, float]: ...

class Extrema_PCLocFOfLocEPCOfLocateExtPC2d(math_FunctionWithDerivative):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, C: Adaptor2d_Curve2d) -> None: ...
    def Derivative(self, U: float) -> Tuple[bool, float]: ...
    def GetStateNumber(self) -> int: ...
    def Initialize(self, C: Adaptor2d_Curve2d) -> None: ...
    def IsMin(self, N: int) -> bool: ...
    def NbExt(self) -> int: ...
    def Point(self, N: int) -> Extrema_POnCurv2d: ...
    def SearchOfTolerance(self) -> float: ...
    def SetPoint(self, P: gp_Pnt2d) -> None: ...
    def SquareDistance(self, N: int) -> float: ...
    def SubIntervalInitialize(self, theUfirst: float, theUlast: float) -> None: ...
    def Value(self, U: float) -> Tuple[bool, float]: ...
    def Values(self, U: float) -> Tuple[bool, float, float]: ...

class Extrema_POnCurv:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, U: float, P: gp_Pnt) -> None: ...
    def Parameter(self) -> float: ...
    def SetValues(self, U: float, P: gp_Pnt) -> None: ...
    def Value(self) -> gp_Pnt: ...

class Extrema_POnCurv2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, U: float, P: gp_Pnt2d) -> None: ...
    def Parameter(self) -> float: ...
    def SetValues(self, U: float, P: gp_Pnt2d) -> None: ...
    def Value(self) -> gp_Pnt2d: ...

class Extrema_POnSurf:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, U: float, V: float, P: gp_Pnt) -> None: ...
    def Parameter(self) -> Tuple[float, float]: ...
    def SetParameters(self, theU: float, theV: float, thePnt: gp_Pnt) -> None: ...
    def Value(self) -> gp_Pnt: ...

class Extrema_POnSurfParams(Extrema_POnSurf):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theU: float, theV: float, thePnt: gp_Pnt) -> None: ...
    def GetElementType(self) -> Extrema_ElementType: ...
    def GetIndices(self) -> Tuple[int, int]: ...
    def GetSqrDistance(self) -> float: ...
    def SetElementType(self, theElementType: Extrema_ElementType) -> None: ...
    def SetIndices(self, theIndexU: int, theIndexV: int) -> None: ...
    def SetSqrDistance(self, theSqrDistance: float) -> None: ...

# harray1 classes

class Extrema_HArray1OfPOnSurf(Extrema_Array1OfPOnSurf, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> Extrema_Array1OfPOnSurf: ...


class Extrema_HArray1OfPOnCurv(Extrema_Array1OfPOnCurv, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> Extrema_Array1OfPOnCurv: ...


class Extrema_HArray1OfPOnCurv2d(Extrema_Array1OfPOnCurv2d, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> Extrema_Array1OfPOnCurv2d: ...

# harray2 classes

class Extrema_HArray2OfPOnCurv2d(Extrema_Array2OfPOnCurv2d, Standard_Transient):
    @overload
    def __init__(self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int) -> None: ...
    @overload
    def __init__(self, theOther: Extrema_Array2OfPOnCurv2d) -> None: ...
    def Array2(self) -> Extrema_Array2OfPOnCurv2d: ...


class Extrema_HArray2OfPOnCurv(Extrema_Array2OfPOnCurv, Standard_Transient):
    @overload
    def __init__(self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int) -> None: ...
    @overload
    def __init__(self, theOther: Extrema_Array2OfPOnCurv) -> None: ...
    def Array2(self) -> Extrema_Array2OfPOnCurv: ...


class Extrema_HArray2OfPOnSurf(Extrema_Array2OfPOnSurf, Standard_Transient):
    @overload
    def __init__(self, theRowLow: int, theRowUpp: int, theColLow: int, theColUpp: int) -> None: ...
    @overload
    def __init__(self, theOther: Extrema_Array2OfPOnSurf) -> None: ...
    def Array2(self) -> Extrema_Array2OfPOnSurf: ...

# hsequence classes

Extrema_Curve2dTool_BSpline = Extrema_Curve2dTool.BSpline
Extrema_Curve2dTool_Bezier = Extrema_Curve2dTool.Bezier
Extrema_Curve2dTool_Circle = Extrema_Curve2dTool.Circle
Extrema_Curve2dTool_Continuity = Extrema_Curve2dTool.Continuity
Extrema_Curve2dTool_D0 = Extrema_Curve2dTool.D0
Extrema_Curve2dTool_D1 = Extrema_Curve2dTool.D1
Extrema_Curve2dTool_D2 = Extrema_Curve2dTool.D2
Extrema_Curve2dTool_D3 = Extrema_Curve2dTool.D3
Extrema_Curve2dTool_DN = Extrema_Curve2dTool.DN
Extrema_Curve2dTool_DeflCurvIntervals = Extrema_Curve2dTool.DeflCurvIntervals
Extrema_Curve2dTool_Degree = Extrema_Curve2dTool.Degree
Extrema_Curve2dTool_Ellipse = Extrema_Curve2dTool.Ellipse
Extrema_Curve2dTool_FirstParameter = Extrema_Curve2dTool.FirstParameter
Extrema_Curve2dTool_GetType = Extrema_Curve2dTool.GetType
Extrema_Curve2dTool_Hyperbola = Extrema_Curve2dTool.Hyperbola
Extrema_Curve2dTool_Intervals = Extrema_Curve2dTool.Intervals
Extrema_Curve2dTool_IsClosed = Extrema_Curve2dTool.IsClosed
Extrema_Curve2dTool_IsPeriodic = Extrema_Curve2dTool.IsPeriodic
Extrema_Curve2dTool_IsRational = Extrema_Curve2dTool.IsRational
Extrema_Curve2dTool_LastParameter = Extrema_Curve2dTool.LastParameter
Extrema_Curve2dTool_Line = Extrema_Curve2dTool.Line
Extrema_Curve2dTool_NbIntervals = Extrema_Curve2dTool.NbIntervals
Extrema_Curve2dTool_NbKnots = Extrema_Curve2dTool.NbKnots
Extrema_Curve2dTool_NbPoles = Extrema_Curve2dTool.NbPoles
Extrema_Curve2dTool_Parabola = Extrema_Curve2dTool.Parabola
Extrema_Curve2dTool_Period = Extrema_Curve2dTool.Period
Extrema_Curve2dTool_Resolution = Extrema_Curve2dTool.Resolution
Extrema_Curve2dTool_Value = Extrema_Curve2dTool.Value
Extrema_CurveTool_BSpline = Extrema_CurveTool.BSpline
Extrema_CurveTool_Bezier = Extrema_CurveTool.Bezier
Extrema_CurveTool_Circle = Extrema_CurveTool.Circle
Extrema_CurveTool_Continuity = Extrema_CurveTool.Continuity
Extrema_CurveTool_D0 = Extrema_CurveTool.D0
Extrema_CurveTool_D1 = Extrema_CurveTool.D1
Extrema_CurveTool_D2 = Extrema_CurveTool.D2
Extrema_CurveTool_D3 = Extrema_CurveTool.D3
Extrema_CurveTool_DN = Extrema_CurveTool.DN
Extrema_CurveTool_DeflCurvIntervals = Extrema_CurveTool.DeflCurvIntervals
Extrema_CurveTool_Degree = Extrema_CurveTool.Degree
Extrema_CurveTool_Ellipse = Extrema_CurveTool.Ellipse
Extrema_CurveTool_FirstParameter = Extrema_CurveTool.FirstParameter
Extrema_CurveTool_GetType = Extrema_CurveTool.GetType
Extrema_CurveTool_Hyperbola = Extrema_CurveTool.Hyperbola
Extrema_CurveTool_Intervals = Extrema_CurveTool.Intervals
Extrema_CurveTool_IsPeriodic = Extrema_CurveTool.IsPeriodic
Extrema_CurveTool_IsRational = Extrema_CurveTool.IsRational
Extrema_CurveTool_LastParameter = Extrema_CurveTool.LastParameter
Extrema_CurveTool_Line = Extrema_CurveTool.Line
Extrema_CurveTool_NbIntervals = Extrema_CurveTool.NbIntervals
Extrema_CurveTool_NbKnots = Extrema_CurveTool.NbKnots
Extrema_CurveTool_NbPoles = Extrema_CurveTool.NbPoles
Extrema_CurveTool_Parabola = Extrema_CurveTool.Parabola
Extrema_CurveTool_Period = Extrema_CurveTool.Period
Extrema_CurveTool_Resolution = Extrema_CurveTool.Resolution
Extrema_CurveTool_Value = Extrema_CurveTool.Value
Extrema_GenLocateExtPS_IsMinDist = Extrema_GenLocateExtPS.IsMinDist
