# The PEP 484 type hints stub file for the _analysis module.
#
# Generated by SIP 6.7.9
#
# 


import typing

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5 import QtXml
from PyQt5 import QtNetwork
from PyQt5 import QtWidgets
from PyQt5 import QtSql
from PyQt5 import QtPrintSupport
from PyQt5 import QtPositioning
from qgis import _core

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QgsAnalysis(PyQt5.sip.wrapper):

    @staticmethod
    def geometryCheckRegistry() -> 'QgsGeometryCheckRegistry': ...
    @staticmethod
    def instance() -> 'QgsAnalysis': ...


class QgsGcpGeometryTransformer(_core.QgsAbstractGeometryTransformer):

    @typing.overload
    def __init__(self, gcpTransformer: 'QgsGcpTransformerInterface') -> None: ...
    @typing.overload
    def __init__(self, method: 'QgsGcpTransformerInterface.TransformMethod', sourceCoordinates: typing.Iterable[_core.QgsPointXY], destinationCoordinates: typing.Iterable[_core.QgsPointXY]) -> None: ...

    def setGcpTransformer(self, transformer: 'QgsGcpTransformerInterface') -> None: ...
    def gcpTransformer(self) -> 'QgsGcpTransformerInterface': ...
    def transform(self, geometry: _core.QgsGeometry, feedback: typing.Optional[_core.QgsFeedback] = ...) -> typing.Tuple[_core.QgsGeometry, bool]: ...
    def transformPoint(self, x: float, y: float, z: float, m: float) -> typing.Tuple[bool, float, float, float, float]: ...


class QgsGcpPoint(PyQt5.sip.wrapper):

    class PointType(int):
        Source = ... # type: QgsGcpPoint.PointType
        Destination = ... # type: QgsGcpPoint.PointType

    @typing.overload
    def __init__(self, sourcePoint: _core.QgsPointXY, destinationPoint: _core.QgsPointXY, destinationPointCrs: _core.QgsCoordinateReferenceSystem, enabled: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGcpPoint') -> None: ...

    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...
    def setEnabled(self, enabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def transformedDestinationPoint(self, targetCrs: _core.QgsCoordinateReferenceSystem, context: _core.QgsCoordinateTransformContext) -> _core.QgsPointXY: ...
    def setDestinationPointCrs(self, crs: _core.QgsCoordinateReferenceSystem) -> None: ...
    def destinationPointCrs(self) -> _core.QgsCoordinateReferenceSystem: ...
    def setDestinationPoint(self, point: _core.QgsPointXY) -> None: ...
    def destinationPoint(self) -> _core.QgsPointXY: ...
    def setSourcePoint(self, point: _core.QgsPointXY) -> None: ...
    def sourcePoint(self) -> _core.QgsPointXY: ...


class QgsGcpTransformerInterface(PyQt5.sip.wrapper):

    class TransformMethod(int):
        Linear = ... # type: QgsGcpTransformerInterface.TransformMethod
        Helmert = ... # type: QgsGcpTransformerInterface.TransformMethod
        PolynomialOrder1 = ... # type: QgsGcpTransformerInterface.TransformMethod
        PolynomialOrder2 = ... # type: QgsGcpTransformerInterface.TransformMethod
        PolynomialOrder3 = ... # type: QgsGcpTransformerInterface.TransformMethod
        ThinPlateSpline = ... # type: QgsGcpTransformerInterface.TransformMethod
        Projective = ... # type: QgsGcpTransformerInterface.TransformMethod
        InvalidTransform = ... # type: QgsGcpTransformerInterface.TransformMethod

    staticMetaObject = ... # type: QtCore.QMetaObject

    def __init__(self) -> None: ...

    @staticmethod
    def createFromParameters(method: 'QgsGcpTransformerInterface.TransformMethod', sourceCoordinates: typing.Iterable[_core.QgsPointXY], destinationCoordinates: typing.Iterable[_core.QgsPointXY]) -> 'QgsGcpTransformerInterface': ...
    @staticmethod
    def create(method: 'QgsGcpTransformerInterface.TransformMethod') -> 'QgsGcpTransformerInterface': ...
    @staticmethod
    def methodToString(method: 'QgsGcpTransformerInterface.TransformMethod') -> str: ...
    def transform(self, x: float, y: float, inverseTransform: bool = ...) -> typing.Tuple[bool, float, float]: ...
    def method(self) -> 'QgsGcpTransformerInterface.TransformMethod': ...
    def minimumGcpCount(self) -> int: ...
    def updateParametersFromGcps(self, sourceCoordinates: typing.Iterable[_core.QgsPointXY], destinationCoordinates: typing.Iterable[_core.QgsPointXY], invertYAxis: bool = ...) -> bool: ...
    def clone(self) -> 'QgsGcpTransformerInterface': ...


class QgsVectorWarper(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, method: QgsGcpTransformerInterface.TransformMethod, points: typing.Iterable[QgsGcpPoint], destinationCrs: _core.QgsCoordinateReferenceSystem) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsVectorWarper') -> None: ...

    def error(self) -> str: ...
    def transformFeatures(self, iterator: _core.QgsFeatureIterator, sink: _core.QgsFeatureSink, context: _core.QgsCoordinateTransformContext, feedback: typing.Optional[_core.QgsFeedback] = ...) -> bool: ...


class QgsVectorWarperTask(_core.QgsTask):

    class Result(int):
        Success = ... # type: QgsVectorWarperTask.Result
        Canceled = ... # type: QgsVectorWarperTask.Result
        Error = ... # type: QgsVectorWarperTask.Result

    def __init__(self, method: QgsGcpTransformerInterface.TransformMethod, points: typing.Iterable[QgsGcpPoint], destinationCrs: _core.QgsCoordinateReferenceSystem, layer: _core.QgsVectorLayer, fileName: str) -> None: ...

    def run(self) -> bool: ...
    def errorMessage(self) -> str: ...
    def result(self) -> 'QgsVectorWarperTask.Result': ...
    def cancel(self) -> None: ...


class QgsGridFileWriter(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, interpolator: 'QgsInterpolator', outputPath: str, extent: _core.QgsRectangle, nCols: int, nRows: int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGridFileWriter') -> None: ...

    def writeFile(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> int: ...


class QgsInterpolator(PyQt5.sip.wrapper):

    class Result(int):
        Success = ... # type: QgsInterpolator.Result
        Canceled = ... # type: QgsInterpolator.Result
        InvalidSource = ... # type: QgsInterpolator.Result
        FeatureGeometryError = ... # type: QgsInterpolator.Result

    class ValueSource(int):
        ValueAttribute = ... # type: QgsInterpolator.ValueSource
        ValueZ = ... # type: QgsInterpolator.ValueSource
        ValueM = ... # type: QgsInterpolator.ValueSource

    class SourceType(int):
        SourcePoints = ... # type: QgsInterpolator.SourceType
        SourceStructureLines = ... # type: QgsInterpolator.SourceType
        SourceBreakLines = ... # type: QgsInterpolator.SourceType

    class LayerData(PyQt5.sip.wrapper):

        interpolationAttribute = ... # type: int
        source = ... # type: _core.QgsFeatureSource
        sourceType = ... # type: 'QgsInterpolator.SourceType'
        transformContext = ... # type: _core.QgsCoordinateTransformContext
        valueSource = ... # type: 'QgsInterpolator.ValueSource'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsInterpolator.LayerData') -> None: ...

    @typing.overload
    def __init__(self, layerData: typing.Iterable['QgsInterpolator.LayerData']) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsInterpolator') -> None: ...

    def cacheBaseData(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> 'QgsInterpolator.Result': ...
    def interpolatePoint(self, x: float, y: float, feedback: typing.Optional[_core.QgsFeedback] = ...) -> typing.Tuple[int, float]: ...


class QgsIDWInterpolator(QgsInterpolator):

    @typing.overload
    def __init__(self, layerData: typing.Iterable[QgsInterpolator.LayerData]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsIDWInterpolator') -> None: ...

    def distanceCoefficient(self) -> float: ...
    def setDistanceCoefficient(self, coefficient: float) -> None: ...
    def interpolatePoint(self, x: float, y: float, feedback: typing.Optional[_core.QgsFeedback] = ...) -> typing.Tuple[int, float]: ...


class QgsInterpolatorVertexData(PyQt5.sip.wrapper):

    x = ... # type: float
    y = ... # type: float
    z = ... # type: float

    @typing.overload
    def __init__(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsInterpolatorVertexData') -> None: ...


class QgsTinInterpolator(QgsInterpolator):

    class TinInterpolation(int):
        Linear = ... # type: QgsTinInterpolator.TinInterpolation
        CloughTocher = ... # type: QgsTinInterpolator.TinInterpolation

    @typing.overload
    def __init__(self, inputData: typing.Iterable[QgsInterpolator.LayerData], interpolation: 'QgsTinInterpolator.TinInterpolation' = ..., feedback: typing.Optional[_core.QgsFeedback] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTinInterpolator') -> None: ...

    def setTriangulationSink(self, sink: _core.QgsFeatureSink) -> None: ...
    @staticmethod
    def triangulationFields() -> _core.QgsFields: ...
    def interpolatePoint(self, x: float, y: float, feedback: _core.QgsFeedback) -> typing.Tuple[int, float]: ...


class QgsMeshContours(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, layer: _core.QgsMeshLayer) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMeshContours') -> None: ...

    def exportPolygons(self, index: _core.QgsMeshDatasetIndex, min_value: float, max_value: float, method: _core.QgsMeshRendererScalarSettings.DataResamplingMethod, feedback: typing.Optional[_core.QgsFeedback] = ...) -> _core.QgsGeometry: ...
    def exportLines(self, index: _core.QgsMeshDatasetIndex, value: float, method: _core.QgsMeshRendererScalarSettings.DataResamplingMethod, feedback: typing.Optional[_core.QgsFeedback] = ...) -> _core.QgsGeometry: ...


class QgsMeshTriangulation(QtCore.QObject):

    def __init__(self) -> None: ...

    def setCrs(self, crs: _core.QgsCoordinateReferenceSystem) -> None: ...
    def triangulatedMesh(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> _core.QgsMesh: ...
    def addVertex(self, vertex: _core.QgsPoint) -> int: ...
    def addBreakLines(self, lineFeatureIterator: _core.QgsFeatureIterator, valueAttribute: int, transformContext: _core.QgsCoordinateTransform, feedback: typing.Optional[_core.QgsFeedback] = ..., featureCount: int = ...) -> bool: ...
    def addVertices(self, vertexFeatureIterator: _core.QgsFeatureIterator, valueAttribute: int, transform: _core.QgsCoordinateTransform, feedback: typing.Optional[_core.QgsFeedback] = ..., featureCount: int = ...) -> bool: ...


class QgsMeshZValueDatasetGroup(_core.QgsMeshDatasetGroup):

    def __init__(self, datasetGroupName: str, mesh: _core.QgsMesh) -> None: ...

    def writeXml(self, doc: QtXml.QDomDocument, context: _core.QgsReadWriteContext) -> QtXml.QDomElement: ...
    def type(self) -> _core.QgsMeshDatasetGroup.Type: ...
    def dataset(self, index: int) -> _core.QgsMeshDataset: ...
    def datasetCount(self) -> int: ...
    def datasetMetadata(self, datasetIndex: int) -> _core.QgsMeshDatasetMetadata: ...
    def initialize(self) -> None: ...


class QgsMeshEditingDelaunayTriangulation(_core.QgsMeshAdvancedEditing):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsMeshEditingDelaunayTriangulation') -> None: ...

    def text(self) -> str: ...


class QgsGraphEdge(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraphEdge') -> None: ...

    def fromVertex(self) -> int: ...
    def toVertex(self) -> int: ...
    def strategies(self) -> typing.List[typing.Any]: ...
    def cost(self, strategyIndex: int) -> typing.Any: ...


class QgsGraphVertex(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, point: _core.QgsPointXY) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraphVertex') -> None: ...

    def point(self) -> _core.QgsPointXY: ...
    def outgoingEdges(self) -> typing.List[int]: ...
    def incomingEdges(self) -> typing.List[int]: ...


class QgsGraph(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraph') -> None: ...

    def hasVertex(self, index: int) -> bool: ...
    def hasEdge(self, index: int) -> bool: ...
    def findOppositeEdge(self, index: int) -> int: ...
    def findVertex(self, pt: _core.QgsPointXY) -> int: ...
    def removeEdge(self, index: int) -> None: ...
    def edge(self, idx: int) -> QgsGraphEdge: ...
    def edgeCount(self) -> int: ...
    def removeVertex(self, index: int) -> None: ...
    def vertex(self, idx: int) -> QgsGraphVertex: ...
    def vertexCount(self) -> int: ...
    def addEdge(self, fromVertexIdx: int, toVertexIdx: int, strategies: typing.Iterable[typing.Any]) -> int: ...
    def addVertex(self, pt: _core.QgsPointXY) -> int: ...


class QgsGraphAnalyzer(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraphAnalyzer') -> None: ...

    @staticmethod
    def shortestTree(source: QgsGraph, startVertexIdx: int, criterionNum: int) -> QgsGraph: ...
    @staticmethod
    def dijkstra(source: QgsGraph, startVertexIdx: int, criterionNum: int, resultTree: typing.Optional[typing.Iterable[int]] = ..., resultCost: typing.Optional[typing.Iterable[float]] = ...) -> typing.List: ...


class QgsGraphBuilderInterface(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, crs: _core.QgsCoordinateReferenceSystem, ctfEnabled: bool = ..., topologyTolerance: float = ..., ellipsoidID: str = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGraphBuilderInterface') -> None: ...

    def addEdge(self, pt1id: int, pt1: _core.QgsPointXY, pt2id: int, pt2: _core.QgsPointXY, strategies: typing.Iterable[typing.Any]) -> None: ...
    def addVertex(self, id: int, pt: _core.QgsPointXY) -> None: ...
    def distanceArea(self) -> _core.QgsDistanceArea: ...
    def topologyTolerance(self) -> float: ...
    def coordinateTransformationEnabled(self) -> bool: ...
    def destinationCrs(self) -> _core.QgsCoordinateReferenceSystem: ...


class QgsGraphBuilder(QgsGraphBuilderInterface):

    def __init__(self, crs: _core.QgsCoordinateReferenceSystem, otfEnabled: bool = ..., topologyTolerance: float = ..., ellipsoidID: str = ...) -> None: ...

    def takeGraph(self) -> QgsGraph: ...
    def graph(self) -> QgsGraph: ...
    def addEdge(self, pt1id: int, pt1: _core.QgsPointXY, pt2id: int, pt2: _core.QgsPointXY, prop: typing.Iterable[typing.Any]) -> None: ...
    def addVertex(self, id: int, pt: _core.QgsPointXY) -> None: ...


class QgsGraphDirector(QtCore.QObject):

    def __init__(self) -> None: ...

    def name(self) -> str: ...
    def addStrategy(self, prop: 'QgsNetworkStrategy') -> None: ...
    def makeGraph(self, builder: QgsGraphBuilderInterface, additionalPoints: typing.Iterable[_core.QgsPointXY], feedback: typing.Optional[_core.QgsFeedback] = ...) -> typing.List[_core.QgsPointXY]: ...


class QgsNetworkStrategy(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNetworkStrategy') -> None: ...

    def cost(self, distance: float, f: _core.QgsFeature) -> typing.Any: ...
    def requiredAttributes(self) -> typing.Any: ...


class QgsNetworkDistanceStrategy(QgsNetworkStrategy):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNetworkDistanceStrategy') -> None: ...

    def cost(self, distance: float, a1: _core.QgsFeature) -> typing.Any: ...


class QgsNetworkSpeedStrategy(QgsNetworkStrategy):

    @typing.overload
    def __init__(self, attributeId: int, defaultValue: float, toMetricFactor: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNetworkSpeedStrategy') -> None: ...

    def requiredAttributes(self) -> typing.Any: ...
    def cost(self, distance: float, f: _core.QgsFeature) -> typing.Any: ...


class QgsVectorLayerDirector(QgsGraphDirector):

    class Direction(int):
        DirectionForward = ... # type: QgsVectorLayerDirector.Direction
        DirectionBackward = ... # type: QgsVectorLayerDirector.Direction
        DirectionBoth = ... # type: QgsVectorLayerDirector.Direction

    def __init__(self, source: _core.QgsFeatureSource, directionFieldId: int, directDirectionValue: str, reverseDirectionValue: str, bothDirectionValue: str, defaultDirection: 'QgsVectorLayerDirector.Direction') -> None: ...

    def name(self) -> str: ...
    def makeGraph(self, builder: QgsGraphBuilderInterface, additionalPoints: typing.Iterable[_core.QgsPointXY], feedback: typing.Optional[_core.QgsFeedback] = ...) -> typing.List[_core.QgsPointXY]: ...


class QgsBatchGeocodeAlgorithm(_core.QgsProcessingFeatureBasedAlgorithm):

    def __init__(self, geocoder: _core.QgsGeocoderInterface) -> None: ...

    def outputWkbType(self, inputWkbType: _core.Qgis.WkbType) -> _core.Qgis.WkbType: ...
    def outputFields(self, inputFields: _core.QgsFields) -> _core.QgsFields: ...
    def outputCrs(self, inputCrs: _core.QgsCoordinateReferenceSystem) -> _core.QgsCoordinateReferenceSystem: ...
    def processFeature(self, feature: _core.QgsFeature, a1: _core.QgsProcessingContext, feedback: _core.QgsProcessingFeedback) -> typing.List[_core.QgsFeature]: ...
    def prepareAlgorithm(self, parameters: typing.Dict[str, typing.Any], context: _core.QgsProcessingContext, feedback: _core.QgsProcessingFeedback) -> bool: ...
    def outputName(self) -> str: ...
    def supportInPlaceEdit(self, layer: _core.QgsMapLayer) -> bool: ...
    def inputLayerTypes(self) -> typing.List[int]: ...
    def groupId(self) -> str: ...
    def group(self) -> str: ...
    def tags(self) -> typing.List[str]: ...
    def initParameters(self, configuration: typing.Dict[str, typing.Any] = ...) -> None: ...


class QgsNativeAlgorithms(_core.QgsProcessingProvider):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def loadAlgorithms(self) -> None: ...
    def supportsNonFileBasedOutput(self) -> bool: ...
    def name(self) -> str: ...
    def helpId(self) -> str: ...
    def id(self) -> str: ...
    def svgIconPath(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...


class QgsAlignRaster(PyQt5.sip.wrapper):

    class ResampleAlg(int):
        RA_NearestNeighbour = ... # type: QgsAlignRaster.ResampleAlg
        RA_Bilinear = ... # type: QgsAlignRaster.ResampleAlg
        RA_Cubic = ... # type: QgsAlignRaster.ResampleAlg
        RA_CubicSpline = ... # type: QgsAlignRaster.ResampleAlg
        RA_Lanczos = ... # type: QgsAlignRaster.ResampleAlg
        RA_Average = ... # type: QgsAlignRaster.ResampleAlg
        RA_Mode = ... # type: QgsAlignRaster.ResampleAlg
        RA_Max = ... # type: QgsAlignRaster.ResampleAlg
        RA_Min = ... # type: QgsAlignRaster.ResampleAlg
        RA_Median = ... # type: QgsAlignRaster.ResampleAlg
        RA_Q1 = ... # type: QgsAlignRaster.ResampleAlg
        RA_Q3 = ... # type: QgsAlignRaster.ResampleAlg

    class RasterInfo(PyQt5.sip.wrapper):

        def __init__(self, layerpath: str) -> None: ...

        def identify(self, mx: float, my: float) -> float: ...
        def dump(self) -> None: ...
        def origin(self) -> QtCore.QPointF: ...
        def extent(self) -> _core.QgsRectangle: ...
        def gridOffset(self) -> QtCore.QPointF: ...
        def cellSize(self) -> QtCore.QSizeF: ...
        def bandCount(self) -> int: ...
        def rasterSize(self) -> QtCore.QSize: ...
        def crs(self) -> str: ...
        def isValid(self) -> bool: ...

    class Item(PyQt5.sip.wrapper):

        inputFilename = ... # type: str
        outputFilename = ... # type: str
        resampleMethod = ... # type: 'QgsAlignRaster.ResampleAlg'
        rescaleValues = ... # type: bool
        srcCellSizeInDestCRS = ... # type: float

        @typing.overload
        def __init__(self, input: str, output: str) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAlignRaster.Item') -> None: ...

    class ProgressHandler(PyQt5.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAlignRaster.ProgressHandler') -> None: ...

        def progress(self, complete: float) -> bool: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAlignRaster') -> None: ...

    @staticmethod
    def suggestedWarpOutput(info: 'QgsAlignRaster.RasterInfo', destWkt: str, cellSize: typing.Optional[QtCore.QSizeF] = ..., gridOffset: typing.Optional[typing.Union[QtCore.QPointF, QtCore.QPoint]] = ..., rect: typing.Optional[_core.QgsRectangle] = ...) -> bool: ...
    def createAndWarp(self, raster: 'QgsAlignRaster.Item') -> bool: ...
    def suggestedReferenceLayer(self) -> int: ...
    def dump(self) -> None: ...
    def errorMessage(self) -> str: ...
    def run(self) -> bool: ...
    def alignedRasterExtent(self) -> _core.QgsRectangle: ...
    def alignedRasterSize(self) -> QtCore.QSize: ...
    def checkInputParameters(self) -> bool: ...
    @typing.overload
    def setParametersFromRaster(self, rasterInfo: 'QgsAlignRaster.RasterInfo', customCRSWkt: str = ..., customCellSize: QtCore.QSizeF = ..., customGridOffset: typing.Union[QtCore.QPointF, QtCore.QPoint] = ...) -> bool: ...
    @typing.overload
    def setParametersFromRaster(self, filename: str, customCRSWkt: str = ..., customCellSize: QtCore.QSizeF = ..., customGridOffset: typing.Union[QtCore.QPointF, QtCore.QPoint] = ...) -> bool: ...
    def clipExtent(self) -> _core.QgsRectangle: ...
    @typing.overload
    def setClipExtent(self, xmin: float, ymin: float, xmax: float, ymax: float) -> None: ...
    @typing.overload
    def setClipExtent(self, extent: _core.QgsRectangle) -> None: ...
    def destinationCrs(self) -> str: ...
    def setDestinationCrs(self, crsWkt: str) -> None: ...
    def cellSize(self) -> QtCore.QSizeF: ...
    @typing.overload
    def setCellSize(self, x: float, y: float) -> None: ...
    @typing.overload
    def setCellSize(self, size: QtCore.QSizeF) -> None: ...
    def gridOffset(self) -> QtCore.QPointF: ...
    def setGridOffset(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def rasters(self) -> typing.List['QgsAlignRaster.Item']: ...
    def setRasters(self, list: typing.Iterable['QgsAlignRaster.Item']) -> None: ...
    def progressHandler(self) -> 'QgsAlignRaster.ProgressHandler': ...
    def setProgressHandler(self, progressHandler: 'QgsAlignRaster.ProgressHandler') -> None: ...


class QgsNineCellFilter(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsNineCellFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def setOutputNodataValue(self, value: float) -> None: ...
    def outputNodataValue(self) -> float: ...
    def setInputNodataValue(self, value: float) -> None: ...
    def inputNodataValue(self) -> float: ...
    def setZFactor(self, factor: float) -> None: ...
    def zFactor(self) -> float: ...
    def setCellSizeY(self, size: float) -> None: ...
    def cellSizeY(self) -> float: ...
    def setCellSizeX(self, size: float) -> None: ...
    def cellSizeX(self) -> float: ...
    def processRaster(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> int: ...


class QgsDerivativeFilter(QgsNineCellFilter):

    @typing.overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsDerivativeFilter') -> None: ...

    def calcFirstDerY(self) -> typing.Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def calcFirstDerX(self) -> typing.Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def processNineCellWindow(self) -> typing.Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsAspectFilter(QgsDerivativeFilter):

    @typing.overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAspectFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsHillshadeFilter(QgsDerivativeFilter):

    @typing.overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str, lightAzimuth: float = ..., lightAngle: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsHillshadeFilter') -> None: ...

    def setLightAngle(self, angle: float) -> None: ...
    def lightAngle(self) -> float: ...
    def setLightAzimuth(self, azimuth: float) -> None: ...
    def lightAzimuth(self) -> float: ...
    def processNineCellWindow(self) -> typing.Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsKernelDensityEstimation(PyQt5.sip.wrapper):

    class Result(int):
        Success = ... # type: QgsKernelDensityEstimation.Result
        DriverError = ... # type: QgsKernelDensityEstimation.Result
        InvalidParameters = ... # type: QgsKernelDensityEstimation.Result
        FileCreationError = ... # type: QgsKernelDensityEstimation.Result
        RasterIoError = ... # type: QgsKernelDensityEstimation.Result

    class OutputValues(int):
        OutputRaw = ... # type: QgsKernelDensityEstimation.OutputValues
        OutputScaled = ... # type: QgsKernelDensityEstimation.OutputValues

    class KernelShape(int):
        KernelQuartic = ... # type: QgsKernelDensityEstimation.KernelShape
        KernelTriangular = ... # type: QgsKernelDensityEstimation.KernelShape
        KernelUniform = ... # type: QgsKernelDensityEstimation.KernelShape
        KernelTriweight = ... # type: QgsKernelDensityEstimation.KernelShape
        KernelEpanechnikov = ... # type: QgsKernelDensityEstimation.KernelShape

    class Parameters(PyQt5.sip.wrapper):

        decayRatio = ... # type: float
        outputValues = ... # type: 'QgsKernelDensityEstimation.OutputValues'
        pixelSize = ... # type: float
        radius = ... # type: float
        radiusField = ... # type: str
        shape = ... # type: 'QgsKernelDensityEstimation.KernelShape'
        source = ... # type: _core.QgsFeatureSource
        weightField = ... # type: str

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsKernelDensityEstimation.Parameters') -> None: ...

    def __init__(self, parameters: 'QgsKernelDensityEstimation.Parameters', outputFile: str, outputFormat: str) -> None: ...

    def finalise(self) -> 'QgsKernelDensityEstimation.Result': ...
    def addFeature(self, feature: _core.QgsFeature) -> 'QgsKernelDensityEstimation.Result': ...
    def prepare(self) -> 'QgsKernelDensityEstimation.Result': ...
    def run(self) -> 'QgsKernelDensityEstimation.Result': ...


class QgsRasterCalcNode(PyQt5.sip.wrapper):

    class Operator(int):
        opPLUS = ... # type: QgsRasterCalcNode.Operator
        opMINUS = ... # type: QgsRasterCalcNode.Operator
        opMUL = ... # type: QgsRasterCalcNode.Operator
        opDIV = ... # type: QgsRasterCalcNode.Operator
        opPOW = ... # type: QgsRasterCalcNode.Operator
        opSQRT = ... # type: QgsRasterCalcNode.Operator
        opSIN = ... # type: QgsRasterCalcNode.Operator
        opCOS = ... # type: QgsRasterCalcNode.Operator
        opTAN = ... # type: QgsRasterCalcNode.Operator
        opASIN = ... # type: QgsRasterCalcNode.Operator
        opACOS = ... # type: QgsRasterCalcNode.Operator
        opATAN = ... # type: QgsRasterCalcNode.Operator
        opEQ = ... # type: QgsRasterCalcNode.Operator
        opNE = ... # type: QgsRasterCalcNode.Operator
        opGT = ... # type: QgsRasterCalcNode.Operator
        opLT = ... # type: QgsRasterCalcNode.Operator
        opGE = ... # type: QgsRasterCalcNode.Operator
        opLE = ... # type: QgsRasterCalcNode.Operator
        opAND = ... # type: QgsRasterCalcNode.Operator
        opOR = ... # type: QgsRasterCalcNode.Operator
        opSIGN = ... # type: QgsRasterCalcNode.Operator
        opLOG = ... # type: QgsRasterCalcNode.Operator
        opLOG10 = ... # type: QgsRasterCalcNode.Operator
        opABS = ... # type: QgsRasterCalcNode.Operator
        opMAX = ... # type: QgsRasterCalcNode.Operator
        opMIN = ... # type: QgsRasterCalcNode.Operator
        opNONE = ... # type: QgsRasterCalcNode.Operator

    class Type(int):
        tOperator = ... # type: QgsRasterCalcNode.Type
        tNumber = ... # type: QgsRasterCalcNode.Type
        tRasterRef = ... # type: QgsRasterCalcNode.Type
        tMatrix = ... # type: QgsRasterCalcNode.Type
        tFunction = ... # type: QgsRasterCalcNode.Type

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, number: float) -> None: ...
    @typing.overload
    def __init__(self, matrix: 'QgsRasterMatrix') -> None: ...
    @typing.overload
    def __init__(self, op: 'QgsRasterCalcNode.Operator', left: 'QgsRasterCalcNode', right: 'QgsRasterCalcNode') -> None: ...
    @typing.overload
    def __init__(self, functionName: str, functionArgs: typing.Iterable['QgsRasterCalcNode']) -> None: ...
    @typing.overload
    def __init__(self, rasterName: str) -> None: ...

    def cleanRasterReferences(self) -> typing.List[str]: ...
    def referencedLayerNames(self) -> typing.List[str]: ...
    @staticmethod
    def parseRasterCalcString(str: str, parserErrorMsg: str) -> 'QgsRasterCalcNode': ...
    def findNodes(self, type: 'QgsRasterCalcNode.Type') -> typing.List['QgsRasterCalcNode']: ...
    def toString(self, cStyle: bool = ...) -> str: ...
    def setRight(self, right: 'QgsRasterCalcNode') -> None: ...
    def setLeft(self, left: 'QgsRasterCalcNode') -> None: ...
    def type(self) -> 'QgsRasterCalcNode.Type': ...


class QgsRasterCalculatorEntry(PyQt5.sip.wrapper):

    bandNumber = ... # type: int
    raster = ... # type: _core.QgsRasterLayer
    ref = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRasterCalculatorEntry') -> None: ...

    @staticmethod
    def rasterEntries() -> typing.List['QgsRasterCalculatorEntry']: ...


class QgsRasterCalculator(PyQt5.sip.wrapper):

    class Result(int):
        Success = ... # type: QgsRasterCalculator.Result
        CreateOutputError = ... # type: QgsRasterCalculator.Result
        InputLayerError = ... # type: QgsRasterCalculator.Result
        Canceled = ... # type: QgsRasterCalculator.Result
        ParserError = ... # type: QgsRasterCalculator.Result
        MemoryError = ... # type: QgsRasterCalculator.Result
        BandError = ... # type: QgsRasterCalculator.Result
        CalculationError = ... # type: QgsRasterCalculator.Result

    @typing.overload
    def __init__(self, formulaString: str, outputFile: str, outputFormat: str, outputExtent: _core.QgsRectangle, nOutputColumns: int, nOutputRows: int, rasterEntries: typing.Iterable[QgsRasterCalculatorEntry], transformContext: _core.QgsCoordinateTransformContext) -> None: ...
    @typing.overload
    def __init__(self, formulaString: str, outputFile: str, outputFormat: str, outputExtent: _core.QgsRectangle, outputCrs: _core.QgsCoordinateReferenceSystem, nOutputColumns: int, nOutputRows: int, rasterEntries: typing.Iterable[QgsRasterCalculatorEntry], transformContext: _core.QgsCoordinateTransformContext) -> None: ...
    @typing.overload
    def __init__(self, formulaString: str, outputFile: str, outputFormat: str, outputExtent: _core.QgsRectangle, nOutputColumns: int, nOutputRows: int, rasterEntries: typing.Iterable[QgsRasterCalculatorEntry]) -> None: ...
    @typing.overload
    def __init__(self, formulaString: str, outputFile: str, outputFormat: str, outputExtent: _core.QgsRectangle, outputCrs: _core.QgsCoordinateReferenceSystem, nOutputColumns: int, nOutputRows: int, rasterEntries: typing.Iterable[QgsRasterCalculatorEntry]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRasterCalculator') -> None: ...

    def lastError(self) -> str: ...
    def processCalculation(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> 'QgsRasterCalculator.Result': ...


class QgsRasterMatrix(PyQt5.sip.wrapper):

    class OneArgOperator(int):
        opSQRT = ... # type: QgsRasterMatrix.OneArgOperator
        opSIN = ... # type: QgsRasterMatrix.OneArgOperator
        opCOS = ... # type: QgsRasterMatrix.OneArgOperator
        opTAN = ... # type: QgsRasterMatrix.OneArgOperator
        opASIN = ... # type: QgsRasterMatrix.OneArgOperator
        opACOS = ... # type: QgsRasterMatrix.OneArgOperator
        opATAN = ... # type: QgsRasterMatrix.OneArgOperator
        opSIGN = ... # type: QgsRasterMatrix.OneArgOperator
        opLOG = ... # type: QgsRasterMatrix.OneArgOperator
        opLOG10 = ... # type: QgsRasterMatrix.OneArgOperator
        opABS = ... # type: QgsRasterMatrix.OneArgOperator

    class TwoArgOperator(int):
        opPLUS = ... # type: QgsRasterMatrix.TwoArgOperator
        opMINUS = ... # type: QgsRasterMatrix.TwoArgOperator
        opMUL = ... # type: QgsRasterMatrix.TwoArgOperator
        opDIV = ... # type: QgsRasterMatrix.TwoArgOperator
        opPOW = ... # type: QgsRasterMatrix.TwoArgOperator
        opEQ = ... # type: QgsRasterMatrix.TwoArgOperator
        opNE = ... # type: QgsRasterMatrix.TwoArgOperator
        opGT = ... # type: QgsRasterMatrix.TwoArgOperator
        opLT = ... # type: QgsRasterMatrix.TwoArgOperator
        opGE = ... # type: QgsRasterMatrix.TwoArgOperator
        opLE = ... # type: QgsRasterMatrix.TwoArgOperator
        opAND = ... # type: QgsRasterMatrix.TwoArgOperator
        opOR = ... # type: QgsRasterMatrix.TwoArgOperator
        opMIN = ... # type: QgsRasterMatrix.TwoArgOperator
        opMAX = ... # type: QgsRasterMatrix.TwoArgOperator

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, m: 'QgsRasterMatrix') -> None: ...

    def absoluteValue(self) -> bool: ...
    def log10(self) -> bool: ...
    def log(self) -> bool: ...
    def changeSign(self) -> bool: ...
    def atangens(self) -> bool: ...
    def tangens(self) -> bool: ...
    def acosinus(self) -> bool: ...
    def cosinus(self) -> bool: ...
    def asinus(self) -> bool: ...
    def sinus(self) -> bool: ...
    def squareRoot(self) -> bool: ...
    def min(self, other: 'QgsRasterMatrix') -> bool: ...
    def max(self, other: 'QgsRasterMatrix') -> bool: ...
    def logicalOr(self, other: 'QgsRasterMatrix') -> bool: ...
    def logicalAnd(self, other: 'QgsRasterMatrix') -> bool: ...
    def lesserEqual(self, other: 'QgsRasterMatrix') -> bool: ...
    def greaterEqual(self, other: 'QgsRasterMatrix') -> bool: ...
    def lesserThan(self, other: 'QgsRasterMatrix') -> bool: ...
    def greaterThan(self, other: 'QgsRasterMatrix') -> bool: ...
    def notEqual(self, other: 'QgsRasterMatrix') -> bool: ...
    def equal(self, other: 'QgsRasterMatrix') -> bool: ...
    def power(self, other: 'QgsRasterMatrix') -> bool: ...
    def divide(self, other: 'QgsRasterMatrix') -> bool: ...
    def multiply(self, other: 'QgsRasterMatrix') -> bool: ...
    def subtract(self, other: 'QgsRasterMatrix') -> bool: ...
    def add(self, other: 'QgsRasterMatrix') -> bool: ...
    def setNodataValue(self, d: float) -> None: ...
    def nodataValue(self) -> float: ...
    def nRows(self) -> int: ...
    def nColumns(self) -> int: ...
    def setData(self, cols: int, rows: int, nodataValue: float) -> float: ...
    def number(self) -> float: ...
    def isNumber(self) -> bool: ...


class QgsRelief(PyQt5.sip.wrapper):

    class ReliefColor(PyQt5.sip.wrapper):

        color = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
        maxElevation = ... # type: float
        minElevation = ... # type: float

        @typing.overload
        def __init__(self, c: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], min: float, max: float) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsRelief.ReliefColor') -> None: ...

    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...

    def exportFrequencyDistributionToCsv(self, file: str) -> bool: ...
    def calculateOptimizedReliefClasses(self) -> typing.List['QgsRelief.ReliefColor']: ...
    def setReliefColors(self, c: typing.Iterable['QgsRelief.ReliefColor']) -> None: ...
    def reliefColors(self) -> typing.List['QgsRelief.ReliefColor']: ...
    def addReliefColorClass(self, color: 'QgsRelief.ReliefColor') -> None: ...
    def clearReliefColors(self) -> None: ...
    def setZFactor(self, factor: float) -> None: ...
    def zFactor(self) -> float: ...
    def processRaster(self, feedback: typing.Optional[_core.QgsFeedback] = ...) -> int: ...


class QgsRuggednessFilter(QgsNineCellFilter):

    @typing.overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRuggednessFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsSlopeFilter(QgsDerivativeFilter):

    @typing.overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSlopeFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsTotalCurvatureFilter(QgsNineCellFilter):

    @typing.overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsTotalCurvatureFilter') -> None: ...

    def processNineCellWindow(self) -> typing.Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsFeaturePool(_core.QgsFeatureSink):

    def __init__(self, layer: _core.QgsVectorLayer) -> None: ...

    def removeFeature(self, featureId: int) -> None: ...
    def refreshCache(self, feature: _core.QgsFeature) -> None: ...
    def insertFeature(self, feature: _core.QgsFeature, skipLock: bool = ...) -> None: ...
    def layerName(self) -> str: ...
    def crs(self) -> _core.QgsCoordinateReferenceSystem: ...
    def geometryType(self) -> _core.Qgis.GeometryType: ...
    def layerId(self) -> str: ...
    def layer(self) -> _core.QgsVectorLayer: ...
    def deleteFeature(self, fid: int) -> None: ...
    def updateFeature(self, feature: _core.QgsFeature) -> None: ...
    def getFeature(self, id: int, feature: _core.QgsFeature) -> bool: ...


class QgsGeometryCheck(PyQt5.sip.wrapper):

    class Flag(int):
        AvailableInValidation = ... # type: QgsGeometryCheck.Flag

    class CheckType(int):
        FeatureNodeCheck = ... # type: QgsGeometryCheck.CheckType
        FeatureCheck = ... # type: QgsGeometryCheck.CheckType
        LayerCheck = ... # type: QgsGeometryCheck.CheckType

    class ChangeType(int):
        ChangeAdded = ... # type: QgsGeometryCheck.ChangeType
        ChangeRemoved = ... # type: QgsGeometryCheck.ChangeType
        ChangeChanged = ... # type: QgsGeometryCheck.ChangeType

    class ChangeWhat(int):
        ChangeFeature = ... # type: QgsGeometryCheck.ChangeWhat
        ChangePart = ... # type: QgsGeometryCheck.ChangeWhat
        ChangeRing = ... # type: QgsGeometryCheck.ChangeWhat
        ChangeNode = ... # type: QgsGeometryCheck.ChangeWhat

    class LayerFeatureIds(PyQt5.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsGeometryCheck.LayerFeatureIds') -> None: ...

    class Flags(PyQt5.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QgsGeometryCheck.Flags', 'QgsGeometryCheck.Flag']) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def __ixor__(self, f: typing.Union['QgsGeometryCheck.Flags', 'QgsGeometryCheck.Flag']) -> 'QgsGeometryCheck.Flags': ...
        def __xor__(self, f: typing.Union['QgsGeometryCheck.Flags', 'QgsGeometryCheck.Flag']) -> 'QgsGeometryCheck.Flags': ...
        def __ior__(self, f: typing.Union['QgsGeometryCheck.Flags', 'QgsGeometryCheck.Flag']) -> 'QgsGeometryCheck.Flags': ...
        def __or__(self, f: typing.Union['QgsGeometryCheck.Flags', 'QgsGeometryCheck.Flag']) -> 'QgsGeometryCheck.Flags': ...
        def __iand__(self, f: typing.Union['QgsGeometryCheck.Flags', 'QgsGeometryCheck.Flag']) -> 'QgsGeometryCheck.Flags': ...
        def __and__(self, f: typing.Union['QgsGeometryCheck.Flags', 'QgsGeometryCheck.Flag']) -> 'QgsGeometryCheck.Flags': ...
        def __invert__(self) -> 'QgsGeometryCheck.Flags': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    class Change(PyQt5.sip.wrapper):

        type = ... # type: 'QgsGeometryCheck.ChangeType'
        vidx = ... # type: _core.QgsVertexId
        what = ... # type: 'QgsGeometryCheck.ChangeWhat'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, _what: 'QgsGeometryCheck.ChangeWhat', _type: 'QgsGeometryCheck.ChangeType', _vidx: _core.QgsVertexId = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsGeometryCheck.Change') -> None: ...

        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, context: 'QgsGeometryCheckContext', configuration: typing.Dict[str, typing.Any]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheck') -> None: ...

    def context(self) -> 'QgsGeometryCheckContext': ...
    def checkType(self) -> 'QgsGeometryCheck.CheckType': ...
    def id(self) -> str: ...
    def description(self) -> str: ...
    def resolutionMethods(self) -> typing.List[str]: ...
    def availableResolutionMethods(self) -> typing.List['QgsGeometryCheckResolutionMethod']: ...
    def collectErrors(self, featurePools: typing.Any, errors: typing.Iterable['QgsGeometryCheckError'], messages: typing.Iterable[str], feedback: _core.QgsFeedback, ids: 'QgsGeometryCheck.LayerFeatureIds' = ...) -> typing.Tuple[typing.List['QgsGeometryCheckError'], typing.List[str]]: ...
    def flags(self) -> 'QgsGeometryCheck.Flags': ...
    def compatibleGeometryTypes(self) -> typing.List[_core.Qgis.GeometryType]: ...
    def isCompatible(self, layer: _core.QgsVectorLayer) -> bool: ...
    def prepare(self, context: 'QgsGeometryCheckContext', configuration: typing.Dict[str, typing.Any]) -> None: ...


class QgsGeometryCheckResolutionMethod(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, id: int, name: str, description: str, isStable: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckResolutionMethod') -> None: ...

    def description(self) -> str: ...
    def name(self) -> str: ...
    def isStable(self) -> bool: ...
    def id(self) -> int: ...


class QgsGeometryCheckContext(PyQt5.sip.wrapper):

    mapCrs = ... # type: _core.QgsCoordinateReferenceSystem
    reducedTolerance = ... # type: float
    tolerance = ... # type: float
    transformContext = ... # type: _core.QgsCoordinateTransformContext

    def __init__(self, precision: int, mapCrs: _core.QgsCoordinateReferenceSystem, transformContext: _core.QgsCoordinateTransformContext, mProject: _core.QgsProject) -> None: ...

    def project(self) -> _core.QgsProject: ...


class QgsGeometryCheckError(PyQt5.sip.wrapper):

    class ValueType(int):
        ValueLength = ... # type: QgsGeometryCheckError.ValueType
        ValueArea = ... # type: QgsGeometryCheckError.ValueType
        ValueOther = ... # type: QgsGeometryCheckError.ValueType

    class Status(int):
        StatusPending = ... # type: QgsGeometryCheckError.Status
        StatusFixFailed = ... # type: QgsGeometryCheckError.Status
        StatusFixed = ... # type: QgsGeometryCheckError.Status
        StatusObsolete = ... # type: QgsGeometryCheckError.Status

    @typing.overload
    def __init__(self, check: QgsGeometryCheck, layerFeature: 'QgsGeometryCheckerUtils.LayerFeature', errorLocation: _core.QgsPointXY, vidx: _core.QgsVertexId = ..., value: typing.Any = ..., valueType: 'QgsGeometryCheckError.ValueType' = ...) -> None: ...
    @typing.overload
    def __init__(self, check: QgsGeometryCheck, layerId: str, featureId: int, geometry: _core.QgsGeometry, errorLocation: _core.QgsPointXY, vidx: _core.QgsVertexId = ..., value: typing.Any = ..., valueType: 'QgsGeometryCheckError.ValueType' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckError') -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def update(self, other: 'QgsGeometryCheckError') -> None: ...
    def closeMatch(self, a0: 'QgsGeometryCheckError') -> bool: ...
    def isEqual(self, other: 'QgsGeometryCheckError') -> bool: ...
    def setObsolete(self) -> None: ...
    def setFixFailed(self, reason: str) -> None: ...
    def setFixed(self, method: int) -> None: ...
    def resolutionMessage(self) -> str: ...
    def status(self) -> 'QgsGeometryCheckError.Status': ...
    def vidx(self) -> _core.QgsVertexId: ...
    def valueType(self) -> 'QgsGeometryCheckError.ValueType': ...
    def value(self) -> typing.Any: ...
    def location(self) -> _core.QgsPointXY: ...
    def description(self) -> str: ...
    def affectedAreaBBox(self) -> _core.QgsRectangle: ...
    def contextBoundingBox(self) -> _core.QgsRectangle: ...
    def geometry(self) -> _core.QgsGeometry: ...
    def featureId(self) -> int: ...
    def layerId(self) -> str: ...
    def check(self) -> QgsGeometryCheck: ...


class QgsGeometryCheckerUtils(PyQt5.sip.wrapper):

    class LayerFeature(PyQt5.sip.wrapper):

        @typing.overload
        def __init__(self, pool: QgsFeaturePool, feature: _core.QgsFeature, context: QgsGeometryCheckContext, useMapCrs: bool) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsGeometryCheckerUtils.LayerFeature') -> None: ...

        def useMapCrs(self) -> bool: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def id(self) -> str: ...
        def geometry(self) -> _core.QgsGeometry: ...
        def layerId(self) -> str: ...
        def feature(self) -> _core.QgsFeature: ...

    class LayerFeatures(PyQt5.sip.wrapper):

        def __init__(self, a0: 'QgsGeometryCheckerUtils.LayerFeatures') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckerUtils') -> None: ...


class QgsGeometryCheckFactory(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckFactory') -> None: ...

    def checkType(self) -> QgsGeometryCheck.CheckType: ...
    def flags(self) -> QgsGeometryCheck.Flags: ...
    def isCompatible(self, layer: _core.QgsVectorLayer) -> bool: ...
    def description(self) -> str: ...
    def id(self) -> str: ...
    def createGeometryCheck(self, context: QgsGeometryCheckContext, configuration: typing.Dict[str, typing.Any]) -> QgsGeometryCheck: ...


class QgsGeometryCheckRegistry(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckRegistry') -> None: ...

    def registerGeometryCheck(self, checkFactory: QgsGeometryCheckFactory) -> None: ...
    def geometryCheckFactories(self, layer: _core.QgsVectorLayer, type: QgsGeometryCheck.CheckType, flags: typing.Union[QgsGeometryCheck.Flags, QgsGeometryCheck.Flag] = ...) -> typing.List[QgsGeometryCheckFactory]: ...
    def geometryCheck(self, checkId: str, context: QgsGeometryCheckContext, geometryCheckConfig: typing.Dict[str, typing.Any]) -> QgsGeometryCheck: ...


class QgsSingleGeometryCheckError(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, check: 'QgsSingleGeometryCheck', geometry: _core.QgsGeometry, errorLocation: _core.QgsGeometry, vertexId: _core.QgsVertexId = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSingleGeometryCheckError') -> None: ...

    def vertexId(self) -> _core.QgsVertexId: ...
    def errorLocation(self) -> _core.QgsGeometry: ...
    def check(self) -> 'QgsSingleGeometryCheck': ...
    def description(self) -> str: ...
    def isEqual(self, other: 'QgsSingleGeometryCheckError') -> bool: ...
    def update(self, other: 'QgsSingleGeometryCheckError') -> None: ...


class QgsGeometryCheckErrorSingle(QgsGeometryCheckError):

    @typing.overload
    def __init__(self, singleError: QgsSingleGeometryCheckError, layerFeature: QgsGeometryCheckerUtils.LayerFeature) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometryCheckErrorSingle') -> None: ...

    def singleError(self) -> QgsSingleGeometryCheckError: ...


class QgsSingleGeometryCheck(QgsGeometryCheck):

    @typing.overload
    def __init__(self, context: QgsGeometryCheckContext, configuration: typing.Dict[str, typing.Any]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsSingleGeometryCheck') -> None: ...

    def processGeometry(self, geometry: _core.QgsGeometry) -> typing.List[QgsSingleGeometryCheckError]: ...
    def collectErrors(self, featurePools: typing.Any, errors: typing.Iterable[QgsGeometryCheckError], messages: typing.Iterable[str], feedback: typing.Optional[_core.QgsFeedback] = ..., ids: QgsGeometryCheck.LayerFeatureIds = ...) -> None: ...


class QgsGeometrySnapper(QtCore.QObject):

    class SnapMode(int):
        PreferNodes = ... # type: QgsGeometrySnapper.SnapMode
        PreferClosest = ... # type: QgsGeometrySnapper.SnapMode
        PreferNodesNoExtraVertices = ... # type: QgsGeometrySnapper.SnapMode
        PreferClosestNoExtraVertices = ... # type: QgsGeometrySnapper.SnapMode
        EndPointPreferNodes = ... # type: QgsGeometrySnapper.SnapMode
        EndPointPreferClosest = ... # type: QgsGeometrySnapper.SnapMode
        EndPointToEndPoint = ... # type: QgsGeometrySnapper.SnapMode

    def __init__(self, referenceSource: _core.QgsFeatureSource) -> None: ...

    featureSnapped: typing.ClassVar[QtCore.pyqtSignal]
    def snapFeatures(self, features: typing.Iterable[_core.QgsFeature], snapTolerance: float, mode: 'QgsGeometrySnapper.SnapMode' = ...) -> typing.List[_core.QgsFeature]: ...
    @typing.overload
    def snapGeometry(self, geometry: _core.QgsGeometry, snapTolerance: float, mode: 'QgsGeometrySnapper.SnapMode' = ...) -> _core.QgsGeometry: ...
    @typing.overload
    @staticmethod
    def snapGeometry(geometry: _core.QgsGeometry, snapTolerance: float, referenceGeometries: typing.Iterable[_core.QgsGeometry], mode: 'QgsGeometrySnapper.SnapMode' = ...) -> _core.QgsGeometry: ...


class QgsInternalGeometrySnapper(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, snapTolerance: float, mode: QgsGeometrySnapper.SnapMode = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsInternalGeometrySnapper') -> None: ...

    def snappedGeometries(self) -> typing.Any: ...
    def snapFeature(self, feature: _core.QgsFeature) -> _core.QgsGeometry: ...


class QgsGeometrySnapperSingleSource(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsGeometrySnapperSingleSource') -> None: ...

    @staticmethod
    def run(source: _core.QgsFeatureSource, sink: _core.QgsFeatureSink, thresh: float, feedback: _core.QgsFeedback) -> int: ...


class QgsZonalStatistics(PyQt5.sip.wrapper):

    class Result(int):
        Success = ... # type: QgsZonalStatistics.Result
        LayerTypeWrong = ... # type: QgsZonalStatistics.Result
        LayerInvalid = ... # type: QgsZonalStatistics.Result
        RasterInvalid = ... # type: QgsZonalStatistics.Result
        RasterBandInvalid = ... # type: QgsZonalStatistics.Result
        FailedToCreateField = ... # type: QgsZonalStatistics.Result
        Canceled = ... # type: QgsZonalStatistics.Result

    class Statistic(int):
        Count = ... # type: QgsZonalStatistics.Statistic
        Sum = ... # type: QgsZonalStatistics.Statistic
        Mean = ... # type: QgsZonalStatistics.Statistic
        Median = ... # type: QgsZonalStatistics.Statistic
        StDev = ... # type: QgsZonalStatistics.Statistic
        Min = ... # type: QgsZonalStatistics.Statistic
        Max = ... # type: QgsZonalStatistics.Statistic
        Range = ... # type: QgsZonalStatistics.Statistic
        Minority = ... # type: QgsZonalStatistics.Statistic
        Majority = ... # type: QgsZonalStatistics.Statistic
        Variety = ... # type: QgsZonalStatistics.Statistic
        Variance = ... # type: QgsZonalStatistics.Statistic
        All = ... # type: QgsZonalStatistics.Statistic

    class Statistics(PyQt5.sip.wrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic']) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def __ixor__(self, f: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic']) -> 'QgsZonalStatistics.Statistics': ...
        def __xor__(self, f: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic']) -> 'QgsZonalStatistics.Statistics': ...
        def __ior__(self, f: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic']) -> 'QgsZonalStatistics.Statistics': ...
        def __or__(self, f: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic']) -> 'QgsZonalStatistics.Statistics': ...
        def __iand__(self, f: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic']) -> 'QgsZonalStatistics.Statistics': ...
        def __and__(self, f: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic']) -> 'QgsZonalStatistics.Statistics': ...
        def __invert__(self) -> 'QgsZonalStatistics.Statistics': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, polygonLayer: _core.QgsVectorLayer, rasterLayer: _core.QgsRasterLayer, attributePrefix: str = ..., rasterBand: int = ..., stats: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic'] = ...) -> None: ...
    @typing.overload
    def __init__(self, polygonLayer: _core.QgsVectorLayer, rasterInterface: _core.QgsRasterInterface, rasterCrs: _core.QgsCoordinateReferenceSystem, rasterUnitsPerPixelX: float, rasterUnitsPerPixelY: float, attributePrefix: str = ..., rasterBand: int = ..., stats: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic'] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsZonalStatistics') -> None: ...

    @staticmethod
    def shortName(statistic: 'QgsZonalStatistics.Statistic') -> str: ...
    @staticmethod
    def displayName(statistic: 'QgsZonalStatistics.Statistic') -> str: ...
    @typing.overload
    def calculateStatistics(self, feedback: _core.QgsFeedback) -> 'QgsZonalStatistics.Result': ...
    @typing.overload
    @staticmethod
    def calculateStatistics(rasterInterface: _core.QgsRasterInterface, geometry: _core.QgsGeometry, cellSizeX: float, cellSizeY: float, rasterBand: int, statistics: typing.Union['QgsZonalStatistics.Statistics', 'QgsZonalStatistics.Statistic']) -> typing.Dict[int, typing.Any]: ...
