/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspEngineInfo;
import jakarta.servlet.jsp.JspFactory;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.jasper.Constants;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.PageContextImpl;

public class JspFactoryImpl
extends JspFactory {
    private final ThreadLocal<PageContextPool> localPool = new ThreadLocal();
    private int poolSize = -1;

    public PageContext getPageContext(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedGetPageContext privilegedGetPageContext = new PrivilegedGetPageContext(this, servlet, servletRequest, servletResponse, string, bl, n, bl2);
            return AccessController.doPrivileged(privilegedGetPageContext);
        }
        return this.internalGetPageContext(servlet, servletRequest, servletResponse, string, bl, n, bl2);
    }

    public void releasePageContext(PageContext pageContext) {
        if (pageContext == null) {
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedReleasePageContext privilegedReleasePageContext = new PrivilegedReleasePageContext(this, pageContext);
            AccessController.doPrivileged(privilegedReleasePageContext);
        } else {
            this.internalReleasePageContext(pageContext);
        }
    }

    public JspEngineInfo getEngineInfo() {
        return new JspEngineInfo(){

            public String getSpecificationVersion() {
                return "3.1";
            }
        };
    }

    public void setPoolSize(int n) {
        this.poolSize = n;
    }

    private PageContext internalGetPageContext(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
        PageContextImpl pageContextImpl;
        if (this.poolSize > 0) {
            PageContextPool pageContextPool = this.localPool.get();
            if (pageContextPool == null) {
                pageContextPool = new PageContextPool(this.poolSize);
                this.localPool.set(pageContextPool);
            }
            if ((pageContextImpl = pageContextPool.get()) == null) {
                pageContextImpl = new PageContextImpl();
            }
        } else {
            pageContextImpl = new PageContextImpl();
        }
        try {
            pageContextImpl.initialize(servlet, servletRequest, servletResponse, string, bl, n, bl2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pageContextImpl;
    }

    private void internalReleasePageContext(PageContext pageContext) {
        pageContext.release();
        if (this.poolSize > 0 && pageContext instanceof PageContextImpl) {
            this.localPool.get().put(pageContext);
        }
    }

    public JspApplicationContext getJspApplicationContext(ServletContext servletContext) {
        if (Constants.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(() -> JspApplicationContextImpl.getInstance(servletContext));
        }
        return JspApplicationContextImpl.getInstance(servletContext);
    }

    private static final class PageContextPool {
        private final PageContext[] pool;
        private int current = -1;

        PageContextPool(int n) {
            this.pool = new PageContext[n];
        }

        public void put(PageContext pageContext) {
            if (this.current < this.pool.length - 1) {
                ++this.current;
                this.pool[this.current] = pageContext;
            }
        }

        public PageContext get() {
            PageContext pageContext = null;
            if (this.current >= 0) {
                pageContext = this.pool[this.current];
                --this.current;
            }
            return pageContext;
        }
    }

    private static class PrivilegedReleasePageContext
    implements PrivilegedAction<Void> {
        private JspFactoryImpl factory;
        private PageContext pageContext;

        PrivilegedReleasePageContext(JspFactoryImpl jspFactoryImpl, PageContext pageContext) {
            this.factory = jspFactoryImpl;
            this.pageContext = pageContext;
        }

        @Override
        public Void run() {
            this.factory.internalReleasePageContext(this.pageContext);
            return null;
        }
    }

    private static class PrivilegedGetPageContext
    implements PrivilegedAction<PageContext> {
        private JspFactoryImpl factory;
        private Servlet servlet;
        private ServletRequest request;
        private ServletResponse response;
        private String errorPageURL;
        private boolean needsSession;
        private int bufferSize;
        private boolean autoflush;

        PrivilegedGetPageContext(JspFactoryImpl jspFactoryImpl, Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
            this.factory = jspFactoryImpl;
            this.servlet = servlet;
            this.request = servletRequest;
            this.response = servletResponse;
            this.errorPageURL = string;
            this.needsSession = bl;
            this.bufferSize = n;
            this.autoflush = bl2;
        }

        @Override
        public PageContext run() {
            return this.factory.internalGetPageContext(this.servlet, this.request, this.response, this.errorPageURL, this.needsSession, this.bufferSize, this.autoflush);
        }
    }
}

