/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.disk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tomcat.util.http.fileupload.DeferredFileOutputStream;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemHeaders;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.apache.tomcat.util.http.fileupload.ParameterParser;
import org.apache.tomcat.util.http.fileupload.util.Streams;

public class DiskFileItem
implements FileItem {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String UID = UUID.randomUUID().toString().replace('-', '_');
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private String fieldName;
    private final String contentType;
    private boolean isFormField;
    private final String fileName;
    private long size = -1L;
    private final int sizeThreshold;
    private final File repository;
    private byte[] cachedContent;
    private transient DeferredFileOutputStream dfos;
    private transient File tempFile;
    private FileItemHeaders headers;
    private String defaultCharset = "ISO-8859-1";

    public DiskFileItem(String string, String string2, boolean bl, String string3, int n, File file) {
        this.fieldName = string;
        this.contentType = string2;
        this.isFormField = bl;
        this.fileName = string3;
        this.sizeThreshold = n;
        this.repository = file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public String getCharSet() {
        ParameterParser parameterParser = new ParameterParser();
        parameterParser.setLowerCaseNames(true);
        Map<String, String> map = parameterParser.parse(this.getContentType(), ';');
        return map.get("charset");
    }

    @Override
    public String getName() {
        return Streams.checkFileName(this.fileName);
    }

    @Override
    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    @Override
    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    @Override
    public byte[] get() throws UncheckedIOException {
        if (this.isInMemory()) {
            if (this.cachedContent == null && this.dfos != null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent != null ? (byte[])this.cachedContent.clone() : new byte[]{};
        }
        byte[] byArray = new byte[(int)this.getSize()];
        try (InputStream inputStream = Files.newInputStream(this.dfos.getFile().toPath(), new OpenOption[0]);){
            IOUtils.readFully(inputStream, byArray);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return byArray;
    }

    @Override
    public String getString(String string) throws UnsupportedEncodingException, IOException {
        return new String(this.get(), string);
    }

    @Override
    public String getString() {
        try {
            byte[] byArray = this.get();
            String string = this.getCharSet();
            if (string == null) {
                string = this.defaultCharset;
            }
            return new String(byArray, string);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file) throws Exception {
        block20: {
            if (this.isInMemory()) {
                try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                    outputStream.write(this.get());
                    break block20;
                }
                catch (IOException iOException) {
                    throw new IOException("Unexpected output data");
                }
            }
            File file2 = this.getStoreLocation();
            if (file2 == null) {
                throw new FileUploadException("Cannot write uploaded file to disk!");
            }
            this.size = file2.length();
            if (file.exists() && !file.delete()) {
                throw new FileUploadException("Cannot write uploaded file to disk!");
            }
            if (!file2.renameTo(file)) {
                BufferedInputStream bufferedInputStream = null;
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    IOUtils.copy(bufferedInputStream, bufferedOutputStream);
                    bufferedOutputStream.close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedInputStream);
                    IOUtils.closeQuietly(bufferedOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly(bufferedInputStream);
                IOUtils.closeQuietly(bufferedOutputStream);
            }
        }
    }

    @Override
    public void delete() {
        this.cachedContent = null;
        File file = this.getStoreLocation();
        if (file != null && !this.isInMemory() && file.exists() && !file.delete()) {
            String string = "Cannot delete " + file.toString();
            throw new UncheckedIOException(string, new IOException(string));
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setFieldName(String string) {
        this.fieldName = string;
    }

    @Override
    public boolean isFormField() {
        return this.isFormField;
    }

    @Override
    public void setFormField(boolean bl) {
        this.isFormField = bl;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.dfos == null) {
            File file = this.getTempFile();
            this.dfos = new DeferredFileOutputStream(this.sizeThreshold, file);
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        if (this.dfos == null) {
            return null;
        }
        if (this.isInMemory()) {
            return null;
        }
        return this.dfos.getFile();
    }

    protected File getTempFile() {
        if (this.tempFile == null) {
            File file = this.repository;
            if (file == null) {
                file = new File(System.getProperty("java.io.tmpdir"));
            }
            String string = String.format("upload_%s_%s.tmp", UID, DiskFileItem.getUniqueId());
            this.tempFile = new File(file, string);
        }
        return this.tempFile;
    }

    private static String getUniqueId() {
        int n = COUNTER.getAndIncrement();
        String string = Integer.toString(n);
        if (n < 100000000) {
            string = ("00000000" + string).substring(string.length());
        }
        return string;
    }

    public String toString() {
        return String.format("name=%s, StoreLocation=%s, size=%s bytes, isFormField=%s, FieldName=%s", this.getName(), this.getStoreLocation(), this.getSize(), this.isFormField(), this.getFieldName());
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(FileItemHeaders fileItemHeaders) {
        this.headers = fileItemHeaders;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(String string) {
        this.defaultCharset = string;
    }
}

